/*
 * Decompiled with CFR 0.152.
 */
package org.eclipselabs.p2.rcpupdate.utils;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipselabs.p2.rcpupdate.utils.AccumulatingProgressMonitor;
import org.eclipselabs.p2.rcpupdate.utils.plugin.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import pk.com.softech.tradingterminal.core.Resources;

public class P2Util {
    private static Log logger = LogFactory.getLog((String)P2Util.class.getName());

    public static void checkForUpdates() {
        try {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(null);
            logger.info((Object)"Check For Updates");
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    P2Util.doCheckForUpdates((IProgressMonitor)new AccumulatingProgressMonitor(monitor, Display.getDefault()));
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
    }

    private static void doCheckForUpdates(final IProgressMonitor monitor) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (reference == null) {
            Activator.log((IStatus)new Status(4, "org.eclipselabs.p2.rcpupdate.utils", "No provisioning agent found.  This application is not set up for updates."));
            return;
        }
        final IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(reference);
        logger.info((Object)"Do Check For Updates");
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IStatus updateStatus = P2Util.checkForUpdates(agent, monitor);
                    Activator.log(updateStatus);
                    if (updateStatus.getCode() == 10000) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Information", (String)"No updates were found.");
                        return;
                    }
                    if (updateStatus.getSeverity() != 4) {
                        logger.info((Object)"Successful Updation");
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Information", (String)"Your terminal updated successfully and a restart is required.");
                        PlatformUI.getWorkbench().restart();
                    }
                }
            });
        }
        finally {
            bundleContext.ungetService(reference);
        }
    }

    static IStatus checkForUpdates(IProvisioningAgent agent, IProgressMonitor monitor) throws OperationCanceledException {
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"Checking for application updates...", (int)200);
        IStatus status = operation.resolveModal((IProgressMonitor)sub.newChild(100));
        if (status.getCode() == 10000) {
            return status;
        }
        if (status.getSeverity() == 8) {
            throw new OperationCanceledException();
        }
        if (status.getSeverity() != 4) {
            ProvisioningJob job = operation.getProvisioningJob(monitor);
            if (job == null) {
                return new Status(4, "org.eclipselabs.p2.rcpupdate.utils", "ProvisioningJob could not be created - does this application support p2 software installation?");
            }
            status = job.runModal((IProgressMonitor)sub.newChild(100));
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
        }
        logger.info((Object)"Check For Updates return Status");
        return status;
    }

    public static void setRepositories() throws InvocationTargetException {
        try {
            if (!Resources.ignoreAutoUpdateUrl) {
                String pattern = "([\\w\\d\\.-]+,[(\\w)+/.:/]+;?)+";
                if (Resources.autoUpdateUrl != null && !Resources.autoUpdateUrl.trim().equals("")) {
                    if (Resources.autoUpdateUrl.matches(pattern)) {
                        Object[] links = Resources.autoUpdateUrl.split("\\;");
                        logger.info((Object)("UpdateSite Total Links : " + Arrays.toString(links)));
                        MetadataRepositoryElement[] element = new MetadataRepositoryElement[links.length];
                        int i = 0;
                        while (i < links.length) {
                            String[] lnk = ((String)links[i]).split("\\,");
                            logger.info((Object)(String.valueOf(i) + "-Set link : " + lnk[1]));
                            element[i] = new MetadataRepositoryElement(null, new URI(lnk[1]), true);
                            element[i].setNickname(lnk[0]);
                            ++i;
                        }
                        ElementUtils.updateRepositoryUsingElements(null, (MetadataRepositoryElement[])element, null);
                    } else {
                        logger.error((Object)(String.valueOf(pattern) + ", Invalid AutoUpdate URL pattern : " + Resources.autoUpdateUrl));
                    }
                }
            } else {
                logger.info((Object)"Ignore Autoupdate link : Using old link");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvocationTargetException(e);
        }
    }
}

