/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.news.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.NewsItem;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.views.WebBrowserView;
import pk.com.softech.tradingterminal.news.NewsPlugin;
import pk.com.softech.tradingterminal.news.views.Messages;
import pk.com.softech.tradingterminal.news.views.NewsLabelProvider;
import pk.com.softech.tradingterminal.news.views.NewsStartupJob;

public class NewsView
extends ViewPart {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.newslist";
    static final String TABLE_BACKGROUND = "NEWS_TABLE_BACKGROUND";
    static final String TABLE_FOREGROUND = "NEWS_TABLE_FOREGROUND";
    static final String TABLE_FONT = "NEWS_TABLE_FONT";
    static final String READED_ITEM_BACKGROUND = "NEWS_READED_ITEM_BACKGROUND";
    static final String READED_ITEM_FOREGROUND = "NEWS_READED_ITEM_FOREGROUND";
    static final String READED_ITEM_FONT = "NEWS_READED_ITEM_FONT";
    static final String NEW_ITEM_BACKGROUND = "NEWS_NEW_ITEM_BACKGROUND";
    static final String NEW_ITEM_FOREGROUND = "NEWS_NEW_ITEM_FOREGROUND";
    static final String NEW_ITEM_FONT = "NEWS_NEW_ITEM_FONT";
    IDialogSettings settings;
    Security security;
    ITheme theme;
    TableViewer viewer;
    NewsLabelProvider labelProvider = new NewsLabelProvider();
    List newsList = new ArrayList();
    IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                NewsView.this.setTheme((ITheme)event.getNewValue());
            } else if (event.getProperty().equals(NewsView.TABLE_BACKGROUND)) {
                NewsView.this.viewer.getControl().setBackground(NewsView.this.theme.getColorRegistry().get(NewsView.TABLE_BACKGROUND));
            } else if (event.getProperty().equals(NewsView.TABLE_FOREGROUND)) {
                NewsView.this.viewer.getControl().setForeground(NewsView.this.theme.getColorRegistry().get(NewsView.TABLE_FOREGROUND));
            } else if (event.getProperty().equals(NewsView.TABLE_FONT)) {
                NewsView.this.viewer.getControl().setFont(NewsView.this.theme.getFontRegistry().get(NewsView.TABLE_FONT));
            } else if (event.getProperty().equals(NewsView.NEW_ITEM_BACKGROUND)) {
                NewsView.this.labelProvider.setAddedBackground(NewsView.this.theme.getColorRegistry().get(NewsView.NEW_ITEM_BACKGROUND));
                NewsView.this.viewer.refresh();
            } else if (event.getProperty().equals(NewsView.NEW_ITEM_FOREGROUND)) {
                NewsView.this.labelProvider.setAddedForeground(NewsView.this.theme.getColorRegistry().get(NewsView.NEW_ITEM_FOREGROUND));
                NewsView.this.viewer.refresh();
            } else if (event.getProperty().equals(NewsView.NEW_ITEM_FONT)) {
                NewsView.this.labelProvider.setAddedFont(NewsView.this.theme.getFontRegistry().get(NewsView.NEW_ITEM_FONT));
                NewsView.this.viewer.refresh();
            } else if (event.getProperty().equals(NewsView.READED_ITEM_BACKGROUND)) {
                NewsView.this.labelProvider.setReadedBackground(NewsView.this.theme.getColorRegistry().get(NewsView.READED_ITEM_BACKGROUND));
                NewsView.this.viewer.refresh();
            } else if (event.getProperty().equals(NewsView.READED_ITEM_FOREGROUND)) {
                NewsView.this.labelProvider.setReadedForeground(NewsView.this.theme.getColorRegistry().get(NewsView.READED_ITEM_FOREGROUND));
                NewsView.this.viewer.refresh();
            } else if (event.getProperty().equals(NewsView.READED_ITEM_FONT)) {
                NewsView.this.labelProvider.setReadedFont(NewsView.this.theme.getFontRegistry().get(NewsView.READED_ITEM_FONT));
                NewsView.this.viewer.refresh();
            }
        }
    };
    ICollectionObserver collectionObserver = new ICollectionObserver(){

        public void itemAdded(Object o) {
            block3: {
                final NewsItem newsItem = (NewsItem)o;
                if (NewsView.this.security == null || newsItem.isSecurity(NewsView.this.security)) {
                    NewsView.this.newsList.add(newsItem);
                    try {
                        NewsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(this).NewsView.this.viewer.getControl().isDisposed()) {
                                    (this).NewsView.this.viewer.add((Object)newsItem);
                                    newsItem.addObserver((this).NewsView.this.newsItemObserver);
                                }
                            }
                        });
                    }
                    catch (SWTException e) {
                        if (e.code == 24) break block3;
                        throw e;
                    }
                }
            }
        }

        public void itemRemoved(Object o) {
            block3: {
                final NewsItem newsItem = (NewsItem)o;
                if (NewsView.this.security == null || newsItem.isSecurity(NewsView.this.security)) {
                    NewsView.this.newsList.remove(newsItem);
                    try {
                        NewsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(this).NewsView.this.viewer.getControl().isDisposed()) {
                                    (this).NewsView.this.viewer.remove((Object)newsItem);
                                    newsItem.deleteObserver((this).NewsView.this.newsItemObserver);
                                }
                            }
                        });
                    }
                    catch (SWTException e) {
                        if (e.code == 24) break block3;
                        throw e;
                    }
                }
            }
        }
    };
    Observer newsItemObserver = new Observer(){

        @Override
        public void update(final Observable o, Object arg) {
            block2: {
                try {
                    NewsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!(this).NewsView.this.viewer.getControl().isDisposed()) {
                                (this).NewsView.this.viewer.update((Object)o, null);
                            }
                        }
                    });
                }
                catch (SWTException e) {
                    if (e.code == 24) break block2;
                    throw e;
                }
            }
        }
    };
    ControlAdapter controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            TableColumn column = (TableColumn)e.widget;
            int index = NewsView.this.viewer.getTable().indexOf(column);
            NewsView.this.settings.put("column" + String.valueOf(index) + ".width", column.getWidth());
        }
    };
    Action refreshAction = new Action(Messages.NewsView_UpdateAction){

        public void run() {
            if (NewsView.this.security != null) {
                NewsPlugin.getDefault().startFeedSnapshot(NewsView.this.security);
            } else {
                NewsPlugin.getDefault().startFeedSnapshot();
            }
        }
    };
    Action showNextAction = new Action(Messages.NewsView_NextAction){

        public void run() {
            NewsView.this.showNext();
        }
    };
    Action showPreviousAction = new Action(Messages.NewsView_PreviousAction){

        public void run() {
            NewsView.this.showPrevious();
        }
    };

    public void init(IViewSite site) throws PartInitException {
        this.refreshAction.setImageDescriptor(NewsPlugin.getImageDescriptor("icons/elcl16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(NewsPlugin.getImageDescriptor("icons/dlcl16/refresh.gif"));
        this.showNextAction.setImageDescriptor(NewsPlugin.getImageDescriptor("icons/elcl16/next_nav.gif"));
        this.showNextAction.setDisabledImageDescriptor(NewsPlugin.getImageDescriptor("icons/dlcl16/next_nav.gif"));
        this.showPreviousAction.setImageDescriptor(NewsPlugin.getImageDescriptor("icons/elcl16/prev_nav.gif"));
        this.showPreviousAction.setDisabledImageDescriptor(NewsPlugin.getImageDescriptor("icons/dlcl16/prev_nav.gif"));
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IAction)this.refreshAction);
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator("group6"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("begin"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IAction)this.showPreviousAction);
        toolBarManager.add((IAction)this.showNextAction);
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("group6"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("end"));
        this.settings = NewsPlugin.getDefault().getDialogSettings().getSection(VIEW_ID);
        if (this.settings == null) {
            this.settings = NewsPlugin.getDefault().getDialogSettings().addNewSection(VIEW_ID);
        }
        if (site.getSecondaryId() != null) {
            this.security = CorePlugin.getRepository().getSecurity(site.getSecondaryId());
            if (this.security != null) {
                this.setPartName(String.valueOf(this.security.getDescription()) + " " + this.getPartName());
            }
            this.settings = this.settings.getSection(site.getSecondaryId()) != null ? this.settings.getSection(site.getSecondaryId()) : this.settings.addNewSection(site.getSecondaryId());
        }
        super.init(site);
    }

    protected void setTheme(ITheme theme) {
        if (theme != null) {
            this.theme = theme;
            this.viewer.getControl().setBackground(theme.getColorRegistry().get(TABLE_BACKGROUND));
            this.viewer.getControl().setForeground(theme.getColorRegistry().get(TABLE_FOREGROUND));
            this.viewer.getControl().setFont(theme.getFontRegistry().get(TABLE_FONT));
            this.labelProvider.setAddedBackground(theme.getColorRegistry().get(NEW_ITEM_BACKGROUND));
            this.viewer.refresh();
            this.labelProvider.setAddedForeground(theme.getColorRegistry().get(NEW_ITEM_FOREGROUND));
            this.viewer.refresh();
            this.labelProvider.setAddedFont(theme.getFontRegistry().get(NEW_ITEM_FONT));
            this.viewer.refresh();
            this.labelProvider.setReadedBackground(theme.getColorRegistry().get(READED_ITEM_BACKGROUND));
            this.viewer.refresh();
            this.labelProvider.setReadedForeground(theme.getColorRegistry().get(READED_ITEM_FOREGROUND));
            this.viewer.refresh();
            this.labelProvider.setReadedFont(theme.getFontRegistry().get(READED_ITEM_FONT));
            this.viewer.refresh();
        }
        theme.addPropertyChangeListener(this.themeChangeListener);
    }

    public void createPartControl(Composite parent) {
        final Table table = new Table(parent, 65538);
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (table.getItem(new Point(e.x, e.y)) == null) {
                    table.deselectAll();
                }
            }
        });
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.NewsView_Date);
        column.setWidth(this.settings.get("column0.width") == null ? 120 : this.settings.getInt("column0.width"));
        column.addControlListener((ControlListener)this.controlListener);
        column = new TableColumn(table, 0);
        column.setText(Messages.NewsView_Title);
        column.setWidth(this.settings.get("column1.width") == null ? 240 : this.settings.getInt("column1.width"));
        column.addControlListener((ControlListener)this.controlListener);
        column = new TableColumn(table, 0);
        column.setText(Messages.NewsView_Security);
        column.setWidth(this.settings.get("column2.width") == null ? 120 : this.settings.getInt("column2.width"));
        column.addControlListener((ControlListener)this.controlListener);
        column = new TableColumn(table, 0);
        column.setText(Messages.NewsView_Source);
        column.setWidth(this.settings.get("column3.width") == null ? 120 : this.settings.getInt("column3.width"));
        column.addControlListener((ControlListener)this.controlListener);
        this.viewer = new TableViewer(table);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((NewsItem)e2).getDate().compareTo(((NewsItem)e1).getDate());
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                NewsView.this.showSelected();
            }
        });
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        this.theme = themeManager.getCurrentTheme();
        if (this.theme != null) {
            table.setForeground(this.theme.getColorRegistry().get(TABLE_FOREGROUND));
            table.setBackground(this.theme.getColorRegistry().get(TABLE_BACKGROUND));
            table.setFont(this.theme.getFontRegistry().get(TABLE_FONT));
            this.labelProvider.setAddedBackground(this.theme.getColorRegistry().get(NEW_ITEM_BACKGROUND));
            this.labelProvider.setAddedForeground(this.theme.getColorRegistry().get(NEW_ITEM_FOREGROUND));
            this.labelProvider.setAddedFont(this.theme.getFontRegistry().get(NEW_ITEM_FONT));
            this.labelProvider.setReadedBackground(this.theme.getColorRegistry().get(READED_ITEM_BACKGROUND));
            this.labelProvider.setReadedForeground(this.theme.getColorRegistry().get(READED_ITEM_FOREGROUND));
            this.labelProvider.setReadedFont(this.theme.getFontRegistry().get(READED_ITEM_FONT));
            this.theme.addPropertyChangeListener(this.themeChangeListener);
        }
        this.viewer.setInput((Object)this.newsList);
        if (this.security != null) {
            CorePlugin.getRepository().allNews(this.security).addCollectionObserver(this.collectionObserver);
        } else {
            CorePlugin.getRepository().allNews().addCollectionObserver(this.collectionObserver);
        }
        NewsStartupJob job = new NewsStartupJob(this.security);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                block2: {
                    final NewsStartupJob job = (NewsStartupJob)event.getJob();
                    try {
                        NewsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(this).NewsView.this.viewer.getControl().isDisposed()) {
                                    (this).NewsView.this.newsList = job.getList();
                                    (this).NewsView.this.viewer.setInput((Object)(this).NewsView.this.newsList);
                                    Iterator iter = (this).NewsView.this.newsList.iterator();
                                    while (iter.hasNext()) {
                                        ((NewsItem)iter.next()).addObserver((this).NewsView.this.newsItemObserver);
                                    }
                                }
                            }
                        });
                    }
                    catch (SWTException e) {
                        if (e.code == 24) break block2;
                        throw e;
                    }
                }
            }
        });
        job.setUser(false);
        job.schedule();
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        this.setTheme(theme);
    }

    public void setFocus() {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        if (this.security != null) {
            CorePlugin.getRepository().allNews(this.security).removeCollectionObserver(this.collectionObserver);
        } else {
            CorePlugin.getRepository().allNews().removeCollectionObserver(this.collectionObserver);
        }
        Iterator iter = this.newsList.iterator();
        while (iter.hasNext()) {
            ((NewsItem)iter.next()).deleteObserver(this.newsItemObserver);
        }
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        if (theme != null) {
            theme.removePropertyChangeListener(this.themeChangeListener);
        }
        super.dispose();
    }

    public void showNext() {
        NewsItem news = this.getSelectedItem();
        TableItem[] items = this.viewer.getTable().getItems();
        if (news == null && items.length != 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(items[0].getData()));
            this.viewer.reveal(items[0].getData());
            this.showSelected();
            return;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == news && ++i < items.length) {
                this.viewer.setSelection((ISelection)new StructuredSelection(items[i].getData()));
                this.viewer.reveal(items[i].getData());
                this.showSelected();
                return;
            }
            ++i;
        }
    }

    public void showPrevious() {
        NewsItem news = this.getSelectedItem();
        TableItem[] items = this.viewer.getTable().getItems();
        if (news == null && items.length != 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection(items[items.length - 1].getData()));
            this.viewer.reveal(items[items.length - 1].getData());
            this.showSelected();
            return;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() == news && --i >= 0) {
                this.viewer.setSelection((ISelection)new StructuredSelection(items[i].getData()));
                this.viewer.reveal(items[i].getData());
                this.showSelected();
                return;
            }
            ++i;
        }
    }

    private void showSelected() {
        NewsItem news = this.getSelectedItem();
        if (news != null) {
            try {
                WebBrowserView browser = (WebBrowserView)this.getSite().getPage().showView("pk.com.softech.tradingterminal.webbrowser", "pk.com.softech.tradingterminal.news", 1);
                if (browser != null) {
                    browser.setUrl(news.getUrl());
                    news.setRecent(false);
                    news.setReaded(true);
                    CorePlugin.getRepository().save((PersistentObject)news);
                }
            }
            catch (PartInitException e1) {
                CorePlugin.logException((Exception)((Object)e1));
            }
        }
    }

    protected NewsItem getSelectedItem() {
        if (!this.viewer.getSelection().isEmpty()) {
            return (NewsItem)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        }
        return null;
    }
}

