/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.news.views;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.NewsItem;
import pk.com.softech.tradingterminal.core.db.TickerData;
import pk.com.softech.tradingterminal.core.ui.views.TickerView;
import pk.com.softech.tradingterminal.core.ui.views.WebBrowserView;
import pk.com.softech.tradingterminal.news.NewsPlugin;
import pk.com.softech.tradingterminal.news.views.Messages;

public class NewsTickerView
extends TickerView {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.newsTicker";
    Composite parent;
    IPreferenceStore prefs;
    Action refreshAction = new Action(Messages.NewsView_UpdateAction){

        public void run() {
            NewsPlugin.getDefault().startFeedSnapshot();
        }
    };
    Comparator<NewsItem> newsComparator = new Comparator<NewsItem>(){

        @Override
        public int compare(NewsItem e1, NewsItem e2) {
            return e2.getDate().compareTo(e1.getDate());
        }
    };
    MouseListener mouseClickListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(final MouseEvent e) {
            NewsTickerView.this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Label lbl;
                    TickerData data;
                    if (e.getSource() instanceof Label && (data = (TickerData)(lbl = (Label)e.getSource()).getData()) != null) {
                        try {
                            WebBrowserView browser = (WebBrowserView)NewsTickerView.this.getSite().getPage().showView("pk.com.softech.tradingterminal.webbrowser", "pk.com.softech.tradingterminal.news", 1);
                            if (browser != null) {
                                browser.setUrl(data.getTooltip());
                            }
                        }
                        catch (PartInitException e1) {
                            CorePlugin.logException((Exception)((Object)e1));
                        }
                    }
                }
            });
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    };

    public NewsTickerView() {
        super("NTV_", "news.NewsTicker");
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.refreshAction.setImageDescriptor(NewsPlugin.getImageDescriptor("icons/elcl16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(NewsPlugin.getImageDescriptor("icons/dlcl16/refresh.gif"));
        CorePlugin.getRepository().allNews().addCollectionObserver(new ICollectionObserver(){

            public void itemRemoved(Object o) {
                if (o instanceof NewsItem) {
                    NewsTickerView.this.removeFromList((NewsItem)o);
                }
            }

            public void itemAdded(Object o) {
                if (o instanceof NewsItem) {
                    NewsTickerView.this.addToList((NewsItem)o);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        super.createPartControl(parent);
        this.addMouseClickListener(this.mouseClickListener);
        this.createActions();
        ObservableList list = CorePlugin.getRepository().allNews();
        Collections.sort(list, this.newsComparator);
        int i = 0;
        while (i < list.size()) {
            this.addToList((NewsItem)list.get(i));
            ++i;
        }
    }

    private void addToList(NewsItem news) {
        TickerData data = new TickerData(news.getTitle(), news.getTitle(), news.getUrl());
        data.setColor("FG_COLOR_POSITIVE");
        if (this.tickerData.size() % 2 == 0) {
            data.setColor("FG_COLOR_NEGATIVE");
        }
        this.tickerData.add((Object)data);
    }

    private void removeFromList(NewsItem news) {
        int i = 0;
        while (i < this.tickerData.size()) {
            TickerData temp = (TickerData)this.tickerData.get(i);
            if (temp.getId().equals(news.getId())) {
                this.tickerData.remove((Object)temp);
            }
            ++i;
        }
    }

    private void createActions() {
        IMenuManager menuManager = super.getViewSite().getActionBars().getMenuManager();
        menuManager.appendToGroup("top", (IAction)this.refreshAction);
        IToolBarManager toolBarManager = super.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.appendToGroup("top", (IAction)this.refreshAction);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }
}

