/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.news.views;

import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.NewsItem;
import pk.com.softech.tradingterminal.core.db.Security;

public class NewsLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider,
IFontProvider {
    SimpleDateFormat dateTimeFormat = CorePlugin.getDateTimeFormat();
    Color addedBackground;
    Color addedForeground;
    Font addedFont;
    Color readedBackground;
    Color readedForeground;
    Font readedFont;

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        NewsItem newsItem = (NewsItem)element;
        switch (columnIndex) {
            case 0: {
                return this.dateTimeFormat.format(newsItem.getDate());
            }
            case 1: {
                String title = newsItem.getTitle();
                title = title.replaceAll("&agrave;", "\u00e0");
                title = title.replaceAll("&egrave;", "\u00e8");
                title = title.replaceAll("&eacute;", "\u00e9");
                title = title.replaceAll("&igrave;", "\u00ec");
                title = title.replaceAll("&ograve;", "\u00f2");
                title = title.replaceAll("&pgrave;", "\u00f9");
                return title;
            }
            case 2: {
                String text = "";
                Object[] o = newsItem.getSecurities().toArray();
                int i = 0;
                while (i < o.length) {
                    if (!text.equals("")) {
                        text = String.valueOf(text) + ", ";
                    }
                    text = String.valueOf(text) + ((Security)o[i]).getDescription();
                    ++i;
                }
                return text;
            }
            case 3: {
                return newsItem.getSource();
            }
        }
        return "";
    }

    public Color getBackground(Object element) {
        NewsItem newsItem = (NewsItem)element;
        if (newsItem.isReaded()) {
            return this.readedBackground;
        }
        if (newsItem.isRecent()) {
            return this.addedBackground;
        }
        return null;
    }

    public Color getForeground(Object element) {
        NewsItem newsItem = (NewsItem)element;
        if (newsItem.isReaded()) {
            return this.readedForeground;
        }
        if (newsItem.isRecent()) {
            return this.addedForeground;
        }
        return null;
    }

    public Font getFont(Object element) {
        NewsItem newsItem = (NewsItem)element;
        if (newsItem.isReaded()) {
            return this.readedFont;
        }
        if (newsItem.isRecent()) {
            return this.addedFont;
        }
        return null;
    }

    public void setAddedBackground(Color addedBackground) {
        this.addedBackground = addedBackground;
    }

    public void setAddedFont(Font addedFont) {
        this.addedFont = addedFont;
    }

    public void setAddedForeground(Color addedForeground) {
        this.addedForeground = addedForeground;
    }

    public void setReadedBackground(Color readedBackground) {
        this.readedBackground = readedBackground;
    }

    public void setReadedFont(Font readedFont) {
        this.readedFont = readedFont;
    }

    public void setReadedForeground(Color readedForeground) {
        this.readedForeground = readedForeground;
    }
}

