/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.news.providers;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpClientFeedFetcher;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.INewsProvider;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.NewsItem;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.news.NewsPlugin;
import pk.com.softech.tradingterminal.news.providers.Messages;

public class RSSNewsProvider
implements Runnable,
INewsProvider {
    private Thread thread;
    private boolean stopping = false;
    private FeedFetcherCache feedInfoCache = HashMapFeedInfoCache.getInstance();
    private HttpClientFeedFetcher fetcher = new HttpClientFeedFetcher(this.feedInfoCache);
    private Log log = LogFactory.getLog(this.getClass());
    private static List oldItems = new ArrayList();

    public void subscribe(Security security) {
    }

    public void unSubscribe(Security security) {
    }

    public void start() {
        if (!Resources.isDevelopment && this.thread == null) {
            this.stopping = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        this.stopping = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.thread = null;
        }
    }

    public void snapshot() {
        this.update();
    }

    public void snapshot(Security security) {
    }

    @Override
    public void run() {
        long nextRun = System.currentTimeMillis() + 2000L;
        while (!this.stopping) {
            if (System.currentTimeMillis() >= nextRun) {
                this.update();
                int interval = NewsPlugin.getDefault().getPreferenceStore().getInt("UPDATE_INTERVAL");
                nextRun = System.currentTimeMillis() + (long)(interval * 60 * 1000);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private void update() {
        Object[] o = oldItems.toArray();
        int i = 0;
        while (i < o.length) {
            ((NewsItem)o[i]).setRecent(false);
            CorePlugin.getRepository().save((PersistentObject)((NewsItem)o[i]));
            ++i;
        }
        oldItems.clear();
        Job job = new Job(Messages.RSSNewsProvider_JobName){

            protected IStatus run(IProgressMonitor monitor) {
                File file = new File(Platform.getLocation().toFile(), "rss.xml");
                if (file.exists()) {
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document document = builder.parse(file);
                        Node firstNode = document.getFirstChild();
                        NodeList childNodes = firstNode.getChildNodes();
                        monitor.beginTask(Messages.RSSNewsProvider_TaskName, childNodes.getLength());
                        RSSNewsProvider.this.log.info((Object)"Start fetching RSS News");
                        int i = 0;
                        while (i < childNodes.getLength()) {
                            Node item = childNodes.item(i);
                            String nodeName = item.getNodeName();
                            if (nodeName.equalsIgnoreCase("source")) {
                                RSSNewsProvider.this.update(new URL(item.getFirstChild().getNodeValue()), item.getAttributes().getNamedItem("name").getNodeValue());
                            }
                            monitor.worked(1);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        RSSNewsProvider.this.log.error((Object)e, (Throwable)e);
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private void update(URL feedUrl, String source) {
        Calendar limit = Calendar.getInstance();
        limit.add(5, -CorePlugin.getDefault().getPreferenceStore().getInt("PREFS_NEWS_DATE_RANGE"));
        this.log.info((Object)("RSS To Request: " + feedUrl.toString()));
        try {
            String urlHost = feedUrl.toString();
            Enumeration e = Collections.enumeration(Resources.IGNORE_NEWS_PROVIDER_URL_SET);
            while (e.hasMoreElements()) {
                String element = (String)e.nextElement();
                String regex = ".*" + element + ".*";
                if (!Pattern.matches(regex, urlHost)) continue;
                this.log.debug((Object)("RSS Request Cancel: " + feedUrl.toString()));
                return;
            }
            SyndFeed feed = this.fetcher.retrieveFeed(feedUrl);
            if (feed != null) {
                for (SyndEntry entry : feed.getEntries()) {
                    NewsItem news = new NewsItem();
                    news.setRecent(true);
                    Date entryDate = entry.getPublishedDate();
                    if (entry.getUpdatedDate() != null) {
                        entryDate = entry.getUpdatedDate();
                    }
                    if (entryDate != null) {
                        Calendar date = Calendar.getInstance();
                        date.setTime(entryDate);
                        date.set(13, 0);
                        news.setDate(date.getTime());
                    }
                    news.setTitle(entry.getTitle());
                    news.setSource(source);
                    news.setUrl(entry.getLink());
                    if (news.getDate().before(limit.getTime()) || CorePlugin.getRepository().allNews().contains((Object)news)) continue;
                    CorePlugin.getRepository().save((PersistentObject)news);
                    oldItems.add(news);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("RSS Request Exception" + e.toString()), (Throwable)e);
        }
    }
}

