/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.news.preferences;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pk.com.softech.tradingterminal.news.NewsPlugin;
import pk.com.softech.tradingterminal.news.dialogs.RSSFeedDialog;
import pk.com.softech.tradingterminal.news.preferences.Messages;

public class RSSPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text interval;
    private Table table;
    private Button editButton;
    private Button removeButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        Composite group = new Composite(content, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label label = new Label(group, 0);
        label.setText(Messages.RSSPreferencesPage_AutoUpdate);
        this.interval = new Text(group, 2048);
        this.interval.setLayoutData((Object)new GridData(60, -1));
        label = new Label(group, 0);
        label.setText(Messages.RSSPreferencesPage_Minutes);
        this.table = new Table(content, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        gridData.widthHint = 250;
        this.table.setLayoutData((Object)gridData);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(Messages.RSSPreferencesPage_Source);
        column = new TableColumn(this.table, 0);
        column.setText(Messages.RSSPreferencesPage_URL);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RSSPreferencesPage.this.editButton.setEnabled(RSSPreferencesPage.this.table.getSelectionCount() == 1);
                RSSPreferencesPage.this.removeButton.setEnabled(RSSPreferencesPage.this.table.getSelectionCount() != 0);
            }
        });
        group = new Composite(content, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(1, 1, false, false));
        Button button = new Button(group, 8);
        button.setText(Messages.RSSPreferencesPage_Add);
        button.setLayoutData((Object)new GridData(80, -1));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RSSFeedDialog dlg = new RSSFeedDialog(RSSPreferencesPage.this.getShell());
                if (dlg.open() == 0) {
                    TableItem tableItem = new TableItem(RSSPreferencesPage.this.table, 0);
                    tableItem.setText(0, dlg.getSource());
                    tableItem.setText(1, dlg.getUrl());
                    int i = 0;
                    while (i < RSSPreferencesPage.this.table.getColumnCount()) {
                        RSSPreferencesPage.this.table.getColumn(i).pack();
                        ++i;
                    }
                }
            }
        });
        this.editButton = new Button(group, 8);
        this.editButton.setText(Messages.RSSPreferencesPage_Edit);
        this.editButton.setEnabled(false);
        this.editButton.setLayoutData((Object)new GridData(80, -1));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RSSPreferencesPage.this.table.getSelectionCount() == 1) {
                    TableItem item = RSSPreferencesPage.this.table.getSelection()[0];
                    RSSFeedDialog dlg = new RSSFeedDialog(RSSPreferencesPage.this.getShell());
                    dlg.setSource(item.getText(0));
                    dlg.setUrl(item.getText(1));
                    if (dlg.open() == 0) {
                        item.setText(0, dlg.getSource());
                        item.setText(1, dlg.getUrl());
                        int i = 0;
                        while (i < RSSPreferencesPage.this.table.getColumnCount()) {
                            RSSPreferencesPage.this.table.getColumn(i).pack();
                            ++i;
                        }
                    }
                }
            }
        });
        this.removeButton = new Button(group, 8);
        this.removeButton.setText(Messages.RSSPreferencesPage_Remove);
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(80, -1));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = RSSPreferencesPage.this.table.getSelection();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                i = 0;
                while (i < RSSPreferencesPage.this.table.getColumnCount()) {
                    RSSPreferencesPage.this.table.getColumn(i).pack();
                    ++i;
                }
            }
        });
        IPreferenceStore store = NewsPlugin.getDefault().getPreferenceStore();
        this.interval.setText(store.getString("UPDATE_INTERVAL"));
        File file = new File(Platform.getLocation().toFile(), "rss.xml");
        if (file.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(file);
                Node firstNode = document.getFirstChild();
                NodeList childNodes = firstNode.getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node item = childNodes.item(i);
                    String nodeName = item.getNodeName();
                    if (nodeName.equalsIgnoreCase("source")) {
                        TableItem tableItem = new TableItem(this.table, 0);
                        tableItem.setText(0, item.getAttributes().getNamedItem("name").getNodeValue());
                        tableItem.setText(1, item.getFirstChild().getNodeValue());
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        return content;
    }

    public boolean performOk() {
        IPreferenceStore store = NewsPlugin.getDefault().getPreferenceStore();
        store.setValue("UPDATE_INTERVAL", this.interval.getText());
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "data", null);
            Element root = document.getDocumentElement();
            TableItem[] items = this.table.getItems();
            int i = 0;
            while (i < items.length) {
                Element element = document.createElement("source");
                element.setAttribute("name", items[i].getText(0));
                element.appendChild(document.createTextNode(items[i].getText(1)));
                root.appendChild(element);
                ++i;
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("indent-number", new Integer(4));
            }
            catch (Exception exception) {}
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            BufferedWriter out = new BufferedWriter(new FileWriter(new File(Platform.getLocation().toFile(), "rss.xml")));
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.performOk();
    }
}

