/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.news.preferences;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.news.NewsPlugin;
import pk.com.softech.tradingterminal.news.preferences.Messages;

public class NewsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button updateStartup;
    private Button followQuoteFeed;
    private Spinner daysToKeep;
    private Table table;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.updateStartup = new Button(content, 32);
        this.updateStartup.setText(Messages.NewsPreferencesPage_StartupUpdate);
        this.updateStartup.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        this.followQuoteFeed = new Button(content, 32);
        this.followQuoteFeed.setText(Messages.NewsPreferencesPage_FollowQuoteFeed);
        this.followQuoteFeed.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
        Label label = new Label(content, 0);
        label.setText(Messages.NewsPreferencesPage_DaysToKeep);
        this.daysToKeep = new Spinner(content, 2048);
        this.daysToKeep.setMinimum(1);
        this.daysToKeep.setMaximum(9999);
        this.table = new Table(content, 65572);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 250;
        this.table.setLayoutData((Object)gridData);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(Messages.NewsPreferencesPage_Provider);
        IPreferenceStore store = NewsPlugin.getDefault().getPreferenceStore();
        this.updateStartup.setSelection(store.getBoolean("UPDATE_ON_STARTUP"));
        this.followQuoteFeed.setSelection(store.getBoolean("FOLLOW_QUOTE_FEED"));
        this.daysToKeep.setSelection(CorePlugin.getDefault().getPreferenceStore().getInt("PREFS_NEWS_DATE_RANGE"));
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("pk.com.softech.tradingterminal.core.news");
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(elements[i].getAttribute("name"));
                tableItem.setChecked(store.getBoolean(id));
                tableItem.setData((Object)id);
                ++i;
            }
        }
        this.table.getColumn(0).pack();
        return content;
    }

    public boolean performOk() {
        IPreferenceStore store = NewsPlugin.getDefault().getPreferenceStore();
        store.setValue("UPDATE_ON_STARTUP", this.updateStartup.getSelection());
        store.setValue("FOLLOW_QUOTE_FEED", this.followQuoteFeed.getSelection());
        CorePlugin.getDefault().getPreferenceStore().setValue("PREFS_NEWS_DATE_RANGE", this.daysToKeep.getSelection());
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            String id = (String)items[i].getData();
            store.setValue(id, items[i].getChecked());
            ++i;
        }
        return super.performOk();
    }
}

