/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.news;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.INewsProvider;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.news.Messages;

public class NewsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "pk.com.softech.tradingterminal.news";
    public static final String PROVIDER_EXTENSION_POINT = "pk.com.softech.tradingterminal.core.news";
    public static final String PREFS_UPDATE_ON_STARTUP = "UPDATE_ON_STARTUP";
    public static final String PREFS_FOLLOW_QUOTE_FEED = "FOLLOW_QUOTE_FEED";
    public static final String PREFS_UPDATE_INTERVAL = "UPDATE_INTERVAL";
    public static final String FEED_RUNNING = "NEWS_FEED_RUNNING";
    public static final String PREF_SOCIAL_BROWSER_COUNT = "PREF_SOCIAL_BROWSER_COUNT";
    private static NewsPlugin plugin;
    private IPropertyChangeListener feedPropertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("FEED_RUNNING")) {
                if (CorePlugin.getDefault().getPreferenceStore().getBoolean("FEED_RUNNING")) {
                    NewsPlugin.this.startFeed();
                } else {
                    NewsPlugin.this.stopFeed();
                }
            } else if (event.getProperty().equals(NewsPlugin.PREFS_FOLLOW_QUOTE_FEED)) {
                if (NewsPlugin.this.getPreferenceStore().getBoolean(NewsPlugin.PREFS_FOLLOW_QUOTE_FEED)) {
                    CorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(NewsPlugin.this.feedPropertyListener);
                } else {
                    CorePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(NewsPlugin.this.feedPropertyListener);
                }
            }
        }
    };

    public NewsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.copyWorkspaceFile("rss.xml");
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(PREFS_UPDATE_INTERVAL, 15);
        store.setValue(FEED_RUNNING, true);
        if (store.getBoolean(PREFS_UPDATE_ON_STARTUP)) {
            this.startFeed();
        }
        if (store.getBoolean(PREFS_FOLLOW_QUOTE_FEED)) {
            CorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.feedPropertyListener);
        }
        store.addPropertyChangeListener(this.feedPropertyListener);
        store.setDefault(PREF_SOCIAL_BROWSER_COUNT, 1);
        CorePlugin.getDefault().getPreferenceStore().setValue("pk.com.softech.tradingterminal.webbrowser:pk.com.softech.tradingterminal.news", Messages.NewsPlugin_BrowserTitle);
    }

    public void stop(BundleContext context) throws Exception {
        CorePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.feedPropertyListener);
        super.stop(context);
        plugin = null;
    }

    public static NewsPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void startFeed() {
        IPreferenceStore store = this.getPreferenceStore();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PROVIDER_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                if (store.getBoolean(id)) {
                    try {
                        INewsProvider provider = (INewsProvider)elements[i].createExecutableExtension("class");
                        provider.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        store.setValue(FEED_RUNNING, true);
    }

    public void startFeedSnapshot() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue(FEED_RUNNING, true);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PROVIDER_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                elements[i].getAttribute("id");
                if (store.getBoolean(FEED_RUNNING)) {
                    try {
                        INewsProvider provider = (INewsProvider)elements[i].createExecutableExtension("class");
                        provider.snapshot();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        } else {
            System.out.println("extensio point is null");
        }
        store.setValue(FEED_RUNNING, false);
    }

    public void startFeedSnapshot(Security security) {
        IPreferenceStore store = this.getPreferenceStore();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PROVIDER_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                if (store.getBoolean(id)) {
                    try {
                        INewsProvider provider = (INewsProvider)elements[i].createExecutableExtension("class");
                        provider.snapshot(security);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        store.setValue(FEED_RUNNING, true);
    }

    public void stopFeed() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PROVIDER_EXTENSION_POINT);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                try {
                    INewsProvider provider = (INewsProvider)elements[i].createExecutableExtension("class");
                    provider.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        this.getPreferenceStore().setValue(FEED_RUNNING, false);
    }

    private void copyWorkspaceFile(String file) {
        File f = new File(Platform.getLocation().toFile(), file);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
            try {
                byte[] buffer = new byte[10240];
                FileOutputStream os = new FileOutputStream(f);
                InputStream is = FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("data/" + file), (boolean)false);
                int readed = 0;
                do {
                    readed = is.read(buffer);
                    ((OutputStream)os).write(buffer, 0, readed);
                } while (readed == buffer.length);
                ((OutputStream)os).close();
                is.close();
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }
}

