/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VGridLayout;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VNative;
import org.eclipse.nebula.cwt.v.VPanelPainter;
import org.eclipse.nebula.cwt.v.VTracker;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class VPanel
extends VControl {
    Composite widget;
    List<VControl> children = new ArrayList<VControl>();
    private VLayout layout = null;
    private boolean isTopLevel = false;
    private Listener topLevelListener;

    public VPanel(Composite parent, int style) {
        this((VPanel)null, style & 0xFFFFF7FF);
        this.isTopLevel = true;
        this.composite = parent;
        this.topLevelListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        VPanel.this.dispose(false);
                        break;
                    }
                    case 9: {
                        VPanel.this.paintControl(event);
                    }
                }
            }
        };
        this.composite.addListener(12, this.topLevelListener);
        this.composite.addListener(15, this.topLevelListener);
        this.composite.addListener(9, this.topLevelListener);
        this.composite.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return VPanel.this.computeSize(wHint, hHint, flushCache);
            }

            protected void layout(Composite composite, boolean flushCache) {
                VPanel.this.setBounds(composite.getClientArea());
                VPanel.this.layout(flushCache);
            }
        });
        VTracker.addTopLevelPanel(this);
        this.composite.setData("cwt_vcontrol", (Object)this);
    }

    public VPanel(VPanel panel, int style) {
        super(panel, style);
        this.marginRight = 0;
        this.marginLeft = 0;
        this.marginBottom = 0;
        this.marginTop = 0;
        this.setLayout(new VGridLayout());
        this.setPainter(new VPanelPainter());
    }

    void addChild(VControl child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.layout.computeSize(this, wHint, hHint, changed);
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    private void dispose(boolean disposeComposite) {
        if (this.isTopLevel && this.composite != null && !this.composite.isDisposed()) {
            this.composite.removeListener(12, this.topLevelListener);
            this.composite.removeListener(15, this.topLevelListener);
            this.composite.removeListener(9, this.topLevelListener);
        }
        VControl[] vControlArray = this.children.toArray(new VControl[this.children.size()]);
        int n = vControlArray.length;
        int n2 = 0;
        while (n2 < n) {
            VControl child = vControlArray[n2];
            child.dispose();
            ++n2;
        }
        super.dispose();
        if (this.isTopLevel && disposeComposite && this.composite != null && !this.composite.isDisposed()) {
            this.composite.dispose();
        }
    }

    public int getBorderWidth() {
        if (this.isTopLevel) {
            return this.composite.getBorderWidth();
        }
        return 1;
    }

    public VControl[] getChildren() {
        return this.children.toArray(new VControl[this.children.size()]);
    }

    public VControl getControl(int x, int y) {
        return this.getControl(x, y, false);
    }

    public VControl getControl(int x, int y, boolean includePanels) {
        if (this.bounds.contains(x, y)) {
            ListIterator<VControl> iter = this.children.listIterator(this.children.size());
            while (iter.hasPrevious()) {
                VControl child = iter.previous();
                if (!child.getVisible() || !child.getBounds().contains(x, y)) continue;
                if (includePanels && child instanceof VPanel) {
                    return ((VPanel)child).getControl(x, y, true);
                }
                return child;
            }
            return this;
        }
        return null;
    }

    public VLayout getLayout() {
        return this.layout;
    }

    public <T extends VLayout> T getLayout(Class<T> clazz) {
        return (T)this.layout;
    }

    @Override
    public VControl.Type getType() {
        return VControl.Type.Panel;
    }

    @Override
    public Composite getWidget() {
        if (this.widget != null) {
            return this.widget;
        }
        if (this.parent != null) {
            return this.parent.getWidget();
        }
        return this.composite;
    }

    public void layout() {
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.layout.layout(this, changed);
        this.redraw();
    }

    void move(VControl above, VControl below) {
        if (above == null) {
            this.children.remove(below);
            this.children.add(below);
        } else if (below == null) {
            this.children.remove(above);
            this.children.add(0, above);
        } else {
            int ix = this.children.indexOf(below);
            this.children.remove(above);
            this.children.add(ix, above);
        }
    }

    @Override
    protected boolean redrawOnActivate() {
        return false;
    }

    @Override
    protected boolean redrawOnDeactivate() {
        return false;
    }

    void removeChild(VControl child) {
        this.children.remove(child);
    }

    void removeVChild(VControl vchild) {
        this.children.remove(vchild);
    }

    @Override
    public void setActivatable(boolean activatable) {
        super.setActivatable(activatable);
        for (VControl child : this.children) {
            child.setActivatable(activatable);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.layout();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (VControl child : this.children) {
            child.setEnabled(enabled);
        }
    }

    @Override
    protected boolean setFocus(boolean focus) {
        if (focus) {
            for (VControl child : this.children) {
                if (!VTracker.instance().setFocusControl(child)) continue;
                return true;
            }
            return false;
        }
        for (VControl child : this.children) {
            child.setFocus(false);
        }
        return true;
    }

    public void setLayout(VLayout layout) {
        this.layout = layout;
    }

    @Override
    public void setLayoutData(GridData data) {
        if (this.isTopLevel) {
            this.composite.setLayoutData((Object)data);
        } else {
            super.setLayoutData(data);
        }
    }

    @Override
    public void setSize(Point size) {
        super.setSize(size);
        this.layout();
    }

    @Override
    public void setVisibility(int visibility) {
        for (VControl child : this.children) {
            child.setVisibility(visibility);
        }
        super.setVisibility(visibility);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        for (VControl child : this.children) {
            if (!(child instanceof VNative)) continue;
            child.setVisible(visible);
        }
    }

    public void setWidget(Composite widget) {
        this.widget = widget;
        this.widget.addListener(1, new Listener(){

            public void handleEvent(Event event) {
            }
        });
    }

    public void sort(Comparator<VControl> comparator) {
        Collections.sort(this.children, comparator);
    }
}

