/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.v;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.nebula.cwt.v.VControl;
import org.eclipse.nebula.cwt.v.VLayout;
import org.eclipse.nebula.cwt.v.VPanel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;

public class VGridLayout
extends VLayout {
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int marginLeft = 0;
    public int marginTop = 0;
    public int marginRight = 0;
    public int marginBottom = 0;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    private Map<Object, Point> sizes;

    public VGridLayout() {
    }

    public VGridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        this.numColumns = numColumns;
        this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    }

    @Override
    protected Point computeSize(VPanel panel, int wHint, int hHint, boolean flushCache) {
        VControl[] children = this.getChildren(panel);
        if (flushCache || this.sizes == null) {
            this.loadChildSizes(children);
        }
        Point size = new Point(0, 0);
        int col = 0;
        int row = 0;
        int rowWidth = 0;
        int rowHeight = 0;
        HashSet<Integer> taken = new HashSet<Integer>(children.length);
        VControl[] vControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            VControl child = vControlArray[n2];
            while (taken.contains(row * this.numColumns + col)) {
                ++col;
            }
            Point p = this.sizes.get(child);
            GridData data = child.getLayoutData();
            int w = data.widthHint != -1 ? data.widthHint : p.x + data.horizontalIndent;
            int h = data.heightHint != -1 ? data.heightHint : p.y + data.verticalIndent;
            rowWidth += w;
            rowHeight = Math.max(rowHeight, h);
            int i = 1;
            while (i < data.verticalSpan) {
                taken.add((row + i) * this.numColumns + col);
                ++i;
            }
            if ((col += data.horizontalSpan) >= this.numColumns) {
                size.x = Math.max(size.x, rowWidth);
                size.y += rowHeight;
                col = 0;
                ++row;
                rowWidth = 0;
                rowHeight = 0;
            }
            ++n2;
        }
        if (col != 0) {
            size.x = Math.max(size.x, rowWidth);
            size.y += rowHeight;
        }
        int numRows = this.getNumRows(children);
        size.x += this.marginLeft + 2 * this.marginWidth + this.marginRight + this.horizontalSpacing * (this.numColumns - 1);
        size.y += this.marginTop + 2 * this.marginHeight + this.marginBottom + this.verticalSpacing * (numRows - 1);
        return size;
    }

    private void doLayout(VPanel parent, VControl[] children) {
        int initX;
        int i;
        Point size = parent.getClientSize();
        int border = 0;
        if (size.x == 0 || size.y == 0) {
            return;
        }
        int[] widths = new int[this.numColumns];
        int[] heights = new int[this.getNumRows(children)];
        Arrays.fill(widths, 0);
        Arrays.fill(heights, 0);
        int col = 0;
        int row = 0;
        HashSet<Integer> takenSet = new HashSet<Integer>(children.length);
        VControl[] vControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            VControl child = vControlArray[n2];
            while (takenSet.contains(row * this.numColumns + col)) {
                ++col;
            }
            Point p = this.sizes.get(child);
            GridData data = child.getLayoutData();
            if (widths[col] > -1) {
                if (this.makeColumnsEqualWidth || data.grabExcessHorizontalSpace) {
                    widths[col] = -1;
                } else {
                    int w = (data.widthHint != -1 ? data.widthHint : p.x) + data.horizontalIndent;
                    widths[col] = Math.max(widths[col], w);
                }
            }
            if (heights[row] > -1) {
                if (data.grabExcessVerticalSpace) {
                    heights[row] = -1;
                } else {
                    int h = (data.heightHint != -1 ? data.heightHint : p.y) + data.verticalIndent;
                    heights[row] = Math.max(heights[row], h);
                }
            }
            i = 1;
            while (i < data.verticalSpan) {
                takenSet.add((row + i) * this.numColumns + col);
                ++i;
            }
            if ((col += data.horizontalSpan) >= this.numColumns) {
                col = 0;
                ++row;
            }
            ++n2;
        }
        int xconsumed = this.marginLeft + 2 * this.marginWidth + this.marginRight + this.horizontalSpacing * (widths.length - 1);
        int yconsumed = this.marginTop + 2 * this.marginHeight + this.marginBottom + this.verticalSpacing * (heights.length - 1);
        int xgrabbers = 0;
        int ygrabbers = 0;
        int[] nArray = widths;
        i = widths.length;
        int data = 0;
        while (data < i) {
            int i2 = nArray[data];
            if (i2 == -1) {
                ++xgrabbers;
            } else {
                xconsumed += i2;
            }
            ++data;
        }
        nArray = heights;
        i = heights.length;
        data = 0;
        while (data < i) {
            int i3 = nArray[data];
            if (i3 == -1) {
                ++ygrabbers;
            } else {
                yconsumed += i3;
            }
            ++data;
        }
        int grabWidth = xgrabbers > 0 ? (size.x - xconsumed) / xgrabbers : 0;
        int grabHeight = ygrabbers > 0 ? (size.y - yconsumed) / ygrabbers : 0;
        col = 0;
        row = 0;
        int xslop = this.makeColumnsEqualWidth ? (int)Math.ceil((size.x - border - xconsumed - grabWidth * xgrabbers) / 2) + 1 : 0;
        int xoffset = parent instanceof VPanel ? parent.getBounds().x : 0;
        int yoffset = parent instanceof VPanel ? parent.getBounds().y : 0;
        int cellX = initX = this.marginLeft + this.marginWidth;
        int cellY = this.marginTop + this.marginHeight;
        int cellWidth = 0;
        int cellHeight = 0;
        int[] taken = new int[heights.length * widths.length + 1];
        Arrays.fill(taken, -1);
        VControl[] vControlArray2 = children;
        int n3 = children.length;
        int n4 = 0;
        while (n4 < n3) {
            VControl child = vControlArray2[n4];
            while (taken[row * this.numColumns + col] > 0) {
                cellX += taken[row * this.numColumns + col] + this.horizontalSpacing;
                ++col;
            }
            Point p = this.sizes.get(child);
            GridData data2 = child.getLayoutData();
            cellWidth = 0;
            int i4 = 0;
            while (i4 < data2.horizontalSpan && col + i4 < widths.length) {
                if (col + i4 == 0) {
                    cellWidth += xslop;
                } else if (col + i4 == widths.length - 1) {
                    cellWidth = size.x - border - cellX - this.marginWidth - this.marginRight - 1;
                    break;
                }
                cellWidth += widths[col + i4] == -1 ? grabWidth : widths[col + i4];
                ++i4;
            }
            cellHeight = 0;
            i4 = 0;
            while (i4 < data2.verticalSpan && row + i4 < heights.length) {
                cellHeight = row + i4 == heights.length - 1 ? size.y - border - cellY - this.marginTop - this.marginBottom - 1 : (cellHeight += heights[row + i4] == -1 ? grabHeight : heights[row + i4]);
                if (i4 > 0) {
                    taken[(row + i4) * this.numColumns + col] = cellWidth;
                }
                ++i4;
            }
            int w1 = 4 == data2.horizontalAlignment ? cellWidth - data2.horizontalIndent : p.x;
            int h1 = 4 == data2.verticalAlignment ? cellHeight - data2.verticalIndent : p.y;
            child.setBounds(xoffset + this.getX(data2, cellX, cellWidth, w1), yoffset + this.getY(data2, cellY, cellHeight, h1), w1, h1);
            if ((col += data2.horizontalSpan) >= this.numColumns) {
                ++row;
                col = 0;
                cellX = initX;
                cellY += cellHeight + this.verticalSpacing;
            } else {
                cellX += cellWidth + this.horizontalSpacing;
            }
            ++n4;
        }
    }

    private VControl[] getChildren(VPanel parent) {
        VControl[] ca = parent.getChildren();
        if (ca != null) {
            ArrayList<VControl> children = new ArrayList<VControl>();
            VControl[] vControlArray = ca;
            int n = ca.length;
            int n2 = 0;
            while (n2 < n) {
                VControl child = vControlArray[n2];
                GridData data = child.getLayoutData();
                if (data != null && !data.exclude) {
                    children.add(child);
                }
                ++n2;
            }
            return children.toArray(new VControl[children.size()]);
        }
        return new VControl[0];
    }

    private int getNumRows(VControl[] children) {
        int c = 0;
        int r = 0;
        int xc = 0;
        HashSet<Integer> taken = new HashSet<Integer>(children.length);
        VControl[] vControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            VControl child = vControlArray[n2];
            while (taken.contains(r * this.numColumns + c)) {
                ++c;
            }
            GridData data = child.getLayoutData();
            xc = data.horizontalSpan;
            int i = 1;
            while (i < data.verticalSpan) {
                taken.add((r + i) * this.numColumns + c);
                ++i;
            }
            if ((c += xc) >= this.numColumns) {
                c = 0;
                ++r;
            }
            ++n2;
        }
        if (c != 0) {
            ++r;
        }
        return r;
    }

    private int getX(GridData data, int cellStart, int cellSpan, int controlSpan) {
        switch (data.horizontalAlignment) {
            case 1: 
            case 4: 
            case 16384: {
                return cellStart + data.horizontalIndent;
            }
            case 131072: 
            case 0x1000008: {
                return cellStart + cellSpan - controlSpan;
            }
        }
        return cellStart + (cellSpan - controlSpan) / 2;
    }

    private int getY(GridData data, int cellStart, int cellSpan, int controlSpan) {
        switch (data.verticalAlignment) {
            case 1: 
            case 4: 
            case 128: {
                return cellStart + data.verticalIndent;
            }
            case 1024: 
            case 0x1000008: {
                return cellStart + cellSpan - controlSpan;
            }
        }
        return cellStart + (cellSpan - controlSpan) / 2;
    }

    @Override
    protected void layout(VPanel panel, boolean flushCache) {
        VControl[] children = this.getChildren(panel);
        if (flushCache || this.sizes == null) {
            this.loadChildSizes(children);
        }
        if (children.length > 0) {
            this.doLayout(panel, children);
            panel.redraw();
        }
    }

    private void loadChildSizes(VControl[] children) {
        if (this.sizes != null) {
            this.sizes.clear();
        }
        this.sizes = new HashMap<Object, Point>();
        VControl[] vControlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            VControl child = vControlArray[n2];
            this.sizes.put(child, child.computeSize(-1, -1));
            ++n2;
        }
    }
}

