/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards.systems;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystemGroup;
import pk.com.softech.tradingterminal.trading.internal.wizards.IDynamicWizard;
import pk.com.softech.tradingterminal.trading.wizards.CommonWizardPage;
import pk.com.softech.tradingterminal.trading.wizards.PluginParametersPage;
import pk.com.softech.tradingterminal.trading.wizards.systems.BaseParametersPage;
import pk.com.softech.tradingterminal.trading.wizards.systems.SystemSelectionPage;

public class TradingSystemWizard
extends Wizard
implements IDynamicWizard {
    private TradingSystemGroup group;
    private SystemSelectionPage systemSelection = new SystemSelectionPage();
    private BaseParametersPage baseParameters = new BaseParametersPage();
    private List additionalPages = new ArrayList();

    public TradingSystemWizard() {
        this.setWindowTitle("New Trading System Wizard");
    }

    public void open() {
        WizardDialog dlg = this.create();
        dlg.open();
    }

    public WizardDialog create() {
        this.setWindowTitle("New Watchlist Wizard");
        this.addPage((IWizardPage)this.systemSelection);
        this.addPage((IWizardPage)new CommonWizardPage(this.baseParameters){

            public IWizardPage getNextPage() {
                if (TradingSystemWizard.this.additionalPages.size() != 0) {
                    IWizardPage page = (IWizardPage)TradingSystemWizard.this.additionalPages.get(0);
                    page.setWizard(this.getWizard());
                    return page;
                }
                return null;
            }
        });
        WizardDialog dlg = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this);
        dlg.create();
        return dlg;
    }

    public TradingSystemGroup getGroup() {
        return this.group;
    }

    public void setGroup(TradingSystemGroup group) {
        this.group = group;
    }

    public boolean performFinish() {
        TradingSystem system = new TradingSystem();
        system.setPluginId(this.systemSelection.getPluginId());
        system.setAccount(this.baseParameters.getAccount());
        system.setSecurity(this.baseParameters.getSecurity());
        system.setMaxExposure(this.baseParameters.getMaxExposure());
        system.setMaxAmount(this.baseParameters.getMaxAmount());
        system.setMinAmount(this.baseParameters.getMinAmount());
        system.setGroup(this.group);
        Iterator iter = this.additionalPages.iterator();
        while (iter.hasNext()) {
            PluginParametersPage page = (PluginParametersPage)((CommonWizardPage)((Object)iter.next())).getPreferencePage();
            page.performFinish();
            system.getParameters().putAll(page.getParameters());
        }
        CorePlugin.getRepository().save((PersistentObject)system);
        return true;
    }

    @Override
    public List getAdditionalPages() {
        return this.additionalPages;
    }

    Security getSecurity() {
        return this.baseParameters.getSecurity();
    }
}

