/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards.systems;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.TradingSystemPluginPreferencePage;
import pk.com.softech.tradingterminal.trading.wizards.CommonDialogPage;
import pk.com.softech.tradingterminal.trading.wizards.systems.BaseParametersPage;

public class TradingSystemSettingsDialog
extends PreferenceDialog {
    private TradingSystem system;
    private BaseParametersPage baseParameters;

    public TradingSystemSettingsDialog(TradingSystem system, Shell parentShell) {
        super(parentShell, new PreferenceManager());
        this.system = system;
        this.baseParameters = new BaseParametersPage(){

            @Override
            public void createControl(Composite parent) {
                super.createControl(parent);
                this.setAccount(TradingSystemSettingsDialog.this.system.getAccount());
                this.setSecurity(TradingSystemSettingsDialog.this.system.getSecurity());
                this.setMaxExposure(TradingSystemSettingsDialog.this.system.getMaxExposure());
                this.setMaxAmount(TradingSystemSettingsDialog.this.system.getMaxAmount());
                this.setMinAmount(TradingSystemSettingsDialog.this.system.getMinAmount());
            }

            @Override
            public void performFinish() {
                TradingSystemSettingsDialog.this.system.setAccount(TradingSystemSettingsDialog.this.baseParameters.getAccount());
                TradingSystemSettingsDialog.this.system.setSecurity(TradingSystemSettingsDialog.this.baseParameters.getSecurity());
                TradingSystemSettingsDialog.this.system.setMaxExposure(TradingSystemSettingsDialog.this.baseParameters.getMaxExposure());
                TradingSystemSettingsDialog.this.system.setMaxAmount(TradingSystemSettingsDialog.this.baseParameters.getMaxAmount());
                TradingSystemSettingsDialog.this.system.setMinAmount(TradingSystemSettingsDialog.this.baseParameters.getMinAmount());
            }
        };
        this.baseParameters.setPageComplete(true);
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("base", (IPreferencePage)new CommonDialogPage(this.baseParameters){

            @Override
            protected Control createContents(Composite parent) {
                Control control = super.createContents(parent);
                return control;
            }
        }));
        IConfigurationElement[] members = TradingPlugin.getTradingSystemPluginPreferencePages(system.getPluginId());
        try {
            int i = 0;
            while (i < members.length) {
                final TradingSystemPluginPreferencePage preferencePage = (TradingSystemPluginPreferencePage)members[i].createExecutableExtension("class");
                preferencePage.init(system.getSecurity(), system.getParameters());
                PreferencePage page = new PreferencePage(){

                    protected Control createContents(Composite parent) {
                        this.noDefaultAndApplyButton();
                        Control control = preferencePage.createContents(parent);
                        return control;
                    }

                    public boolean performOk() {
                        preferencePage.performOk();
                        TradingSystemSettingsDialog.this.system.getParameters().putAll(preferencePage.getParameters());
                        return super.performOk();
                    }
                };
                page.setTitle(members[i].getAttribute("name"));
                this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("plugin" + String.valueOf(i), (IPreferencePage)page));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Trading System Settings");
    }

    protected void okPressed() {
        super.okPressed();
        CorePlugin.getRepository().save((PersistentObject)this.system);
    }
}

