/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards.systems;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.TradingSystemPluginPreferencePage;
import pk.com.softech.tradingterminal.trading.internal.wizards.IDynamicWizard;
import pk.com.softech.tradingterminal.trading.wizards.CommonWizardPage;
import pk.com.softech.tradingterminal.trading.wizards.PluginParametersPage;
import pk.com.softech.tradingterminal.trading.wizards.systems.TradingSystemWizard;

public class SystemSelectionPage
extends WizardPage {
    private org.eclipse.swt.widgets.List list;

    public SystemSelectionPage() {
        super("");
        this.setTitle("Trading System");
        this.setDescription("Select the trading system to use");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)content);
        this.list = new org.eclipse.swt.widgets.List(content, 2564);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.list.getItemHeight() * 15;
        this.list.setLayoutData((Object)gridData);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SystemSelectionPage.this.setPages();
                SystemSelectionPage.this.setPageComplete(SystemSelectionPage.this.list.getSelectionIndex() != -1);
            }
        });
        for (IConfigurationElement element : TradingPlugin.getTradingSystemPlugins()) {
            this.list.add(element.getAttribute("name"));
            this.list.setData(element.getAttribute("name"), (Object)element.getAttribute("id"));
        }
    }

    private void setPages() {
        List pages = ((TradingSystemWizard)this.getWizard()).getAdditionalPages();
        Iterator iter = pages.iterator();
        while (iter.hasNext()) {
            ((IWizardPage)iter.next()).dispose();
        }
        pages.clear();
        IConfigurationElement[] members = TradingPlugin.getTradingSystemPluginPreferencePages(this.getPluginId());
        try {
            int i = 0;
            while (i < members.length) {
                TradingSystemPluginPreferencePage preferencePage = (TradingSystemPluginPreferencePage)members[i].createExecutableExtension("class");
                preferencePage.init(((TradingSystemWizard)this.getWizard()).getSecurity(), new HashMap());
                CommonWizardPage page = new CommonWizardPage(new PluginParametersPage(preferencePage)){

                    public IWizardPage getNextPage() {
                        List pages = ((IDynamicWizard)this.getWizard()).getAdditionalPages();
                        int index = pages.indexOf((Object)this);
                        if (index < pages.size() - 1) {
                            IWizardPage page = (IWizardPage)pages.get(index + 1);
                            page.setWizard(this.getWizard());
                            return page;
                        }
                        return null;
                    }
                };
                if (members[i].getAttribute("name") != null) {
                    page.setTitle(members[i].getAttribute("name"));
                }
                if (members[i].getAttribute("description") != null) {
                    page.setDescription(members[i].getAttribute("description"));
                }
                ((TradingSystemWizard)this.getWizard()).getAdditionalPages().add(page);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPluginId() {
        return (String)this.list.getData(this.list.getItem(this.list.getSelectionIndex()));
    }

    public String getPluginName() {
        return this.list.getItem(this.list.getSelectionIndex());
    }
}

