/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards.systems;

import java.util.Collections;
import java.util.Comparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.trading.wizards.CommonPreferencePage;

public class BaseParametersPage
extends CommonPreferencePage {
    private Combo account;
    private Combo security;
    private Spinner maxExposure;
    private Spinner maxAmount;
    private Spinner minAmount;

    public BaseParametersPage() {
        this.setTitle("General");
        this.setDescription("Set the account, security and trading parameters");
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)content);
        Label label = new Label(content, 0);
        label.setText("Account");
        label.setLayoutData((Object)new GridData(125, -1));
        this.account = new Combo(content, 8);
        this.account.setLayoutData((Object)new GridData(4, 1, true, false));
        this.account.setVisibleItemCount(25);
        this.account.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseParametersPage.this.account.getSelectionIndex() != -1 && BaseParametersPage.this.security.getSelectionIndex() != -1) {
                    BaseParametersPage.this.setPageComplete(true);
                } else {
                    BaseParametersPage.this.setPageComplete(false);
                }
            }
        });
        label = new Label(content, 0);
        label.setText("Security");
        label.setLayoutData((Object)new GridData(125, -1));
        this.security = new Combo(content, 8);
        this.security.setLayoutData((Object)new GridData(4, 1, true, false));
        this.security.setVisibleItemCount(25);
        this.security.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BaseParametersPage.this.account.getSelectionIndex() != -1 && BaseParametersPage.this.security.getSelectionIndex() != -1) {
                    BaseParametersPage.this.setPageComplete(true);
                } else {
                    BaseParametersPage.this.setPageComplete(false);
                }
            }
        });
        label = new Label(content, 0);
        label.setText("Max. Exposure");
        label.setLayoutData((Object)new GridData(125, -1));
        this.maxExposure = new Spinner(content, 2048);
        this.maxExposure.setMinimum(0);
        this.maxExposure.setMaximum(999999999);
        this.maxExposure.setDigits(2);
        this.maxExposure.setIncrement(100);
        this.maxExposure.setSelection(0);
        this.maxExposure.setLayoutData((Object)new GridData(60, -1));
        label = new Label(content, 0);
        label.setText("Min. Trade Amount");
        label.setLayoutData((Object)new GridData(125, -1));
        this.minAmount = new Spinner(content, 2048);
        this.minAmount.setMinimum(0);
        this.minAmount.setMaximum(999999999);
        this.minAmount.setDigits(2);
        this.minAmount.setIncrement(100);
        this.minAmount.setSelection(0);
        this.minAmount.setLayoutData((Object)new GridData(60, -1));
        label = new Label(content, 0);
        label.setText("Max. Trade Amount");
        label.setLayoutData((Object)new GridData(125, -1));
        this.maxAmount = new Spinner(content, 2048);
        this.maxAmount.setMinimum(0);
        this.maxAmount.setMaximum(999999999);
        this.maxAmount.setDigits(2);
        this.maxAmount.setIncrement(100);
        this.maxAmount.setSelection(0);
        this.maxAmount.setLayoutData((Object)new GridData(60, -1));
        ObservableList list = CorePlugin.getRepository().allAccounts();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Account)arg0).getDescription().compareTo(((Account)arg1).getDescription());
            }
        });
        for (Account s : list) {
            this.account.add(s.getDescription());
            this.account.setData(s.getDescription(), (Object)s);
        }
        list = CorePlugin.getRepository().allSecurities();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((Security)arg0).getDescription().compareTo(((Security)arg1).getDescription());
            }
        });
        for (Account s : list) {
            this.security.add(s.getDescription());
            this.security.setData(s.getDescription(), (Object)s);
        }
    }

    @Override
    public void performFinish() {
    }

    public Account getAccount() {
        if (this.account == null || this.account.getSelectionIndex() == -1) {
            return null;
        }
        return (Account)this.account.getData(this.account.getItem(this.account.getSelectionIndex()));
    }

    public void setAccount(Account account) {
        this.account.setText(account.getDescription());
    }

    public Security getSecurity() {
        if (this.security == null || this.security.getSelectionIndex() == -1) {
            return null;
        }
        return (Security)this.security.getData(this.security.getItem(this.security.getSelectionIndex()));
    }

    public void setSecurity(Security security) {
        this.security.setText(security.getDescription());
    }

    public double getMaxExposure() {
        return (double)this.maxExposure.getSelection() / Math.pow(10.0, this.maxExposure.getDigits());
    }

    public void setMaxExposure(double maxExposure) {
        this.maxExposure.setSelection((int)Math.round(maxExposure * Math.pow(10.0, this.maxExposure.getDigits())));
    }

    public double getMaxAmount() {
        return (double)this.maxAmount.getSelection() / Math.pow(10.0, this.maxAmount.getDigits());
    }

    public void setMaxAmount(double maxAmount) {
        this.maxAmount.setSelection((int)Math.round(maxAmount * Math.pow(10.0, this.maxAmount.getDigits())));
    }

    public double getMinAmount() {
        return (double)this.minAmount.getSelection() / Math.pow(10.0, this.minAmount.getDigits());
    }

    public void setMinAmount(double minAmount) {
        this.minAmount.setSelection((int)Math.round(minAmount * Math.pow(10.0, this.minAmount.getDigits())));
    }
}

