/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistColumn;
import pk.com.softech.tradingterminal.trading.wizards.ColumnsPage;
import pk.com.softech.tradingterminal.trading.wizards.CommonWizardPage;
import pk.com.softech.tradingterminal.trading.wizards.GeneralPage;
import pk.com.softech.tradingterminal.trading.wizards.ItemsPage;

public class WatchlistWizard
extends Wizard
implements INewWizard {
    private Watchlist watchlist;
    private GeneralPage generalPage = new GeneralPage();
    private ColumnsPage columnsPage = new ColumnsPage();
    private ItemsPage itemsPage = new ItemsPage();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Watchlist Wizard");
        this.addPage((IWizardPage)new CommonWizardPage(this.generalPage));
        this.addPage((IWizardPage)new CommonWizardPage(this.columnsPage));
        this.addPage((IWizardPage)new CommonWizardPage(this.itemsPage));
    }

    public Watchlist open() {
        WizardDialog dlg = this.create();
        dlg.open();
        return this.watchlist;
    }

    public WizardDialog create() {
        this.setWindowTitle("New Watchlist Wizard");
        this.addPage((IWizardPage)new CommonWizardPage(this.generalPage));
        this.addPage((IWizardPage)new CommonWizardPage(this.columnsPage));
        this.addPage((IWizardPage)new CommonWizardPage(this.itemsPage));
        Resources.checkWatchType = true;
        WizardDialog dlg = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this);
        dlg.setPageSize(600, 500);
        dlg.create();
        ArrayList<WatchlistColumn> columns = new ArrayList<WatchlistColumn>();
        columns.add(new WatchlistColumn("watchlist.exchange"));
        columns.add(new WatchlistColumn("watchlist.market"));
        columns.add(new WatchlistColumn("watchlist.symbol"));
        columns.add(new WatchlistColumn("watchlist.openPrice"));
        columns.add(new WatchlistColumn("watchlist.lastPrice"));
        columns.add(new WatchlistColumn("watchlist.change"));
        columns.add(new WatchlistColumn("watchlist.bidSize"));
        columns.add(new WatchlistColumn("watchlist.bidPrice"));
        columns.add(new WatchlistColumn("watchlist.askPrice"));
        columns.add(new WatchlistColumn("watchlist.askSize"));
        columns.add(new WatchlistColumn("watchlist.totalTurnover"));
        columns.add(new WatchlistColumn("watchlist.volume"));
        columns.add(new WatchlistColumn("watchlist.totalTrades"));
        columns.add(new WatchlistColumn("watchlist.time"));
        columns.add(new WatchlistColumn("watchlist.highPrice"));
        columns.add(new WatchlistColumn("watchlist.lowPrice"));
        this.columnsPage.setColumns(columns);
        return dlg;
    }

    public boolean performFinish() {
        this.watchlist = new Watchlist();
        this.watchlist.setDescription(this.generalPage.getText());
        this.watchlist.setCurrency(this.generalPage.getCurrency());
        this.watchlist.setUseDefaultCurrency(this.generalPage.isUseDefaultCurrency());
        this.watchlist.setColumns(this.columnsPage.getColumns());
        this.watchlist.setItems(this.itemsPage.getItems());
        CorePlugin.getRepository().save((PersistentObject)this.watchlist);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView("pk.com.softech.tradingterminal.trading.watchlist", String.valueOf(this.watchlist.getId()), 1);
        }
        catch (PartInitException e) {
            CorePlugin.logException((Exception)((Object)e));
        }
        return true;
    }
}

