/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.trading.wizards.ColumnsPage;
import pk.com.softech.tradingterminal.trading.wizards.CommonDialogPage;
import pk.com.softech.tradingterminal.trading.wizards.GeneralPage;
import pk.com.softech.tradingterminal.trading.wizards.ItemsPage;

public class WatchlistSettingsDialog
extends PreferenceDialog {
    private Watchlist watchlist;
    private GeneralPage generalPage;
    private ColumnsPage columnsPage;
    private ItemsPage itemsPage;

    public WatchlistSettingsDialog(Watchlist watchlist, Shell parentShell) {
        super(parentShell, new PreferenceManager());
        this.watchlist = watchlist;
        this.generalPage = new GeneralPage(watchlist){

            @Override
            public void performFinish() {
                WatchlistSettingsDialog.this.watchlist.setDescription(this.getText());
                WatchlistSettingsDialog.this.watchlist.setCurrency(this.getCurrency());
                WatchlistSettingsDialog.this.watchlist.setUseDefaultCurrency(this.isUseDefaultCurrency());
                super.performFinish();
            }
        };
        this.columnsPage = new ColumnsPage(){

            @Override
            public void performFinish() {
                WatchlistSettingsDialog.this.watchlist.setColumns(this.getColumns());
                super.performFinish();
            }
        };
        this.itemsPage = new ItemsPage(){

            @Override
            public void performFinish() {
                WatchlistSettingsDialog.this.watchlist.setItems(this.getItems());
                super.performFinish();
            }
        };
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new CommonDialogPage(this.generalPage){

            @Override
            protected Control createContents(Composite parent) {
                Control control = super.createContents(parent);
                WatchlistSettingsDialog.this.generalPage.setText(WatchlistSettingsDialog.this.watchlist.getDescription());
                WatchlistSettingsDialog.this.generalPage.setCurrency(WatchlistSettingsDialog.this.watchlist.getCurrency());
                WatchlistSettingsDialog.this.generalPage.setUseDefaultCurrency(WatchlistSettingsDialog.this.watchlist.isUseDefaultCurrency());
                return control;
            }
        }));
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("columns", (IPreferencePage)new CommonDialogPage(this.columnsPage){

            @Override
            protected Control createContents(Composite parent) {
                Control control = super.createContents(parent);
                WatchlistSettingsDialog.this.columnsPage.setColumns(WatchlistSettingsDialog.this.watchlist.getColumns());
                return control;
            }
        }));
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("items", (IPreferencePage)new CommonDialogPage(this.itemsPage){

            @Override
            protected Control createContents(Composite parent) {
                Control control = super.createContents(parent);
                WatchlistSettingsDialog.this.itemsPage.setItems((List)WatchlistSettingsDialog.this.watchlist.getItems());
                return control;
            }
        }));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Watchlist Settings");
    }

    protected void okPressed() {
        super.okPressed();
        CorePlugin.getRepository().save((PersistentObject)this.watchlist);
    }
}

