/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.util.NumberVerifyListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;
import pk.com.softech.tradingterminal.trading.AlertPlugin;
import pk.com.softech.tradingterminal.trading.AlertPluginPreferencePage;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.wizards.NewAlertWizard;

public class WatchlistItemPropertiesDialog
extends PreferenceDialog {
    WatchlistItem watchlistItem;
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();

    public WatchlistItemPropertiesDialog(WatchlistItem watchlistItem, Shell parentShell) {
        super(parentShell, new PreferenceManager());
        this.watchlistItem = watchlistItem;
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new GeneralPage()));
        this.getPreferenceManager().addToRoot((IPreferenceNode)new PreferenceNode("alerts", (IPreferencePage)new AlertsPage()));
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(this.watchlistItem.getSecurity().getDescription()) + " Properties");
    }

    protected void handleSave() {
        this.watchlistItem.notifyObservers();
        super.handleSave();
    }

    private class AlertsPage
    extends PreferencePage {
        private Table table;
        private Button add;
        private Button delete;
        private Button reset;
        private Composite group;
        private Button popup;
        private Button hilight;

        public AlertsPage() {
            super("");
            this.setTitle("Alerts");
            this.setValid(false);
            this.noDefaultAndApplyButton();
        }

        protected Control createContents(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            content.setLayoutData((Object)new GridData(4, 4, true, true));
            this.table = new Table(content, 65540);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = 250;
            gridData.heightHint = this.table.getItemHeight() * 5;
            this.table.setLayoutData((Object)gridData);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(false);
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AlertsPage.this.table.getSelectionIndex() != -1) {
                        CTabFolder folder = (CTabFolder)AlertsPage.this.group.getChildren()[AlertsPage.this.table.getSelectionIndex()];
                        ((StackLayout)((AlertsPage)AlertsPage.this).group.getLayout()).topControl = folder;
                        AlertsPage.this.reset.setEnabled(((CTabFolder)AlertsPage.this.table.getItem(AlertsPage.this.table.getSelectionIndex()).getData("folder")).getData("last") != null);
                        AlertsPage.this.popup.setEnabled(true);
                        AlertsPage.this.popup.setSelection(((Boolean)folder.getData("popup")).booleanValue());
                        AlertsPage.this.hilight.setEnabled(true);
                        AlertsPage.this.hilight.setSelection(((Boolean)folder.getData("hilight")).booleanValue());
                    } else {
                        AlertsPage.this.reset.setEnabled(false);
                        AlertsPage.this.popup.setEnabled(false);
                        AlertsPage.this.popup.setSelection(false);
                        AlertsPage.this.hilight.setEnabled(false);
                        AlertsPage.this.hilight.setSelection(false);
                    }
                    AlertsPage.this.delete.setEnabled(AlertsPage.this.table.getSelectionIndex() != -1);
                    AlertsPage.this.group.layout();
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (AlertsPage.this.table.getItem(new Point(e.x, e.y)) == null) {
                        AlertsPage.this.table.deselectAll();
                        ((StackLayout)((AlertsPage)AlertsPage.this).group.getLayout()).topControl = null;
                        AlertsPage.this.group.layout();
                        AlertsPage.this.delete.setEnabled(false);
                        AlertsPage.this.reset.setEnabled(false);
                        AlertsPage.this.popup.setEnabled(false);
                        AlertsPage.this.popup.setSelection(false);
                        AlertsPage.this.hilight.setEnabled(false);
                        AlertsPage.this.hilight.setSelection(false);
                    }
                }
            });
            TableColumn column = new TableColumn(this.table, 0);
            column.setText("Description");
            column = new TableColumn(this.table, 0);
            column.setText("Last");
            Composite buttons = new Composite(content, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttons.setLayout((Layout)gridLayout);
            buttons.setLayoutData((Object)new GridData(1, 4, false, false));
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.add = new Button(buttons, 8);
            this.add.setImage(images.getImageDescriptor("IMG_TOOL_NEW_WIZARD").createImage());
            this.add.setToolTipText("Add new alert");
            this.add.setEnabled(true);
            this.add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewAlertWizard wizard = new NewAlertWizard();
                    Alert alert = wizard.open(((AlertsPage)AlertsPage.this).WatchlistItemPropertiesDialog.this.watchlistItem);
                    if (alert != null) {
                        AlertsPage.this.itemAdded(alert);
                        int i = 0;
                        while (i < AlertsPage.this.table.getColumnCount()) {
                            AlertsPage.this.table.getColumn(i).pack();
                            ++i;
                        }
                    }
                }
            });
            this.delete = new Button(buttons, 8);
            this.delete.setImage(images.getImageDescriptor("IMG_TOOL_DELETE").createImage());
            this.delete.setToolTipText("Delete selected alert");
            this.delete.setEnabled(false);
            this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AlertsPage.this.table.getSelectionIndex() != -1) {
                        int index = AlertsPage.this.table.getSelectionIndex();
                        ((CTabFolder)AlertsPage.this.table.getItem(index).getData("folder")).dispose();
                        AlertsPage.this.table.getItem(index).dispose();
                    }
                    ((StackLayout)((AlertsPage)AlertsPage.this).group.getLayout()).topControl = null;
                    AlertsPage.this.group.layout();
                    AlertsPage.this.delete.setEnabled(false);
                }
            });
            this.reset = new Button(buttons, 8);
            this.reset.setImage(images.getImageDescriptor("IMG_TOOL_UNDO").createImage());
            this.reset.setToolTipText("Reset last seen");
            this.reset.setEnabled(false);
            this.reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AlertsPage.this.table.getSelectionIndex() != -1) {
                        int index = AlertsPage.this.table.getSelectionIndex();
                        ((CTabFolder)AlertsPage.this.table.getItem(index).getData("folder")).setData("last", null);
                        AlertsPage.this.table.getItem(index).setText(1, "");
                    }
                    AlertsPage.this.reset.setEnabled(false);
                }
            });
            this.group = new Composite(content, 0);
            this.group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            this.group.setLayout((Layout)new StackLayout());
            for (Alert alert : WatchlistItemPropertiesDialog.this.watchlistItem.getAlerts()) {
                this.itemAdded(alert);
            }
            this.popup = new Button(content, 32);
            this.popup.setText("Pop-up a message");
            this.popup.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.popup.setEnabled(false);
            this.popup.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTabFolder folder = (CTabFolder)((StackLayout)((AlertsPage)AlertsPage.this).group.getLayout()).topControl;
                    folder.setData("popup", (Object)new Boolean(AlertsPage.this.popup.getSelection()));
                }
            });
            this.hilight = new Button(content, 32);
            this.hilight.setText("Hilight watchlist row");
            this.hilight.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            this.hilight.setEnabled(false);
            this.hilight.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CTabFolder folder = (CTabFolder)((StackLayout)((AlertsPage)AlertsPage.this).group.getLayout()).topControl;
                    folder.setData("hilight", (Object)new Boolean(AlertsPage.this.hilight.getSelection()));
                }
            });
            int i = 0;
            while (i < this.table.getColumnCount()) {
                this.table.getColumn(i).pack();
                ++i;
            }
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                WatchlistItemPropertiesDialog.this.watchlistItem.getAlerts().clear();
                Control[] childs = this.group.getChildren();
                int i = 0;
                while (i < childs.length) {
                    HashMap parameters = new HashMap();
                    CTabItem[] items = ((CTabFolder)childs[i]).getItems();
                    int p = 0;
                    while (p < items.length) {
                        AlertPluginPreferencePage page = (AlertPluginPreferencePage)items[p].getData();
                        page.performOk();
                        parameters.putAll(page.getParameters());
                        ++p;
                    }
                    Alert alert = (Alert)childs[i].getData();
                    alert.setParameters(parameters);
                    alert.setLastSeen((Date)((CTabFolder)this.table.getItem(i).getData("folder")).getData("last"));
                    alert.setPopup(((Boolean)childs[i].getData("popup")).booleanValue());
                    alert.setHilight(((Boolean)childs[i].getData("hilight")).booleanValue());
                    ((AlertPlugin)alert.getData()).init(parameters);
                    ((AlertPlugin)alert.getData()).setLastSeen(alert.getLastSeen());
                    WatchlistItemPropertiesDialog.this.watchlistItem.getAlerts().add(alert);
                    WatchlistItemPropertiesDialog.this.watchlistItem.setChanged();
                    ++i;
                }
            }
            return super.performOk();
        }

        private void itemAdded(Alert alert) {
            AlertPlugin plugin = (AlertPlugin)alert.getData();
            if (plugin == null) {
                plugin = TradingPlugin.createAlertPlugin(alert.getPluginId());
                plugin.init(WatchlistItemPropertiesDialog.this.watchlistItem.getSecurity(), alert.getParameters());
                alert.setData((Object)plugin);
            }
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, String.valueOf(plugin.getDescription()) + " (" + TradingPlugin.getAlertPluginName(alert.getPluginId()) + ")");
            if (alert.getLastSeen() != null) {
                tableItem.setText(1, CorePlugin.getDateTimeFormatLong().format(alert.getLastSeen()));
            }
            tableItem.setData((Object)alert);
            CTabFolder folder = new CTabFolder(this.group, 0x800880);
            folder.setMaximizeVisible(false);
            folder.setMinimizeVisible(false);
            folder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
            folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            folder.setData((Object)alert);
            folder.setData("last", (Object)plugin.getLastSeen());
            folder.setData("popup", (Object)new Boolean(alert.isPopup()));
            folder.setData("hilight", (Object)new Boolean(alert.isHilight()));
            tableItem.setData("folder", (Object)folder);
            IConfigurationElement[] pages = TradingPlugin.getAlertPluginPreferencePages(alert.getPluginId());
            int i = 0;
            while (i < pages.length) {
                CTabItem tabItem = new CTabItem(folder, 0);
                Composite itemContent = new Composite((Composite)folder, 0);
                itemContent.setLayout((Layout)new GridLayout());
                tabItem.setControl((Control)itemContent);
                tabItem.setText(pages[i].getAttribute("name"));
                if (pages[i].getAttribute("description") != null) {
                    tabItem.setToolTipText(pages[i].getAttribute("description"));
                }
                try {
                    AlertPluginPreferencePage page = (AlertPluginPreferencePage)pages[i].createExecutableExtension("class");
                    page.init(WatchlistItemPropertiesDialog.this.watchlistItem.getSecurity(), alert.getParameters());
                    Control control = page.createContents(itemContent);
                    if (control instanceof Composite) {
                        ((Composite)control).setLayoutData((Object)new GridData(4, 4, true, true));
                    }
                    tabItem.setData((Object)page);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                folder.setSelection(0);
                ++i;
            }
        }
    }

    private class GeneralPage
    extends PreferencePage {
        private Text position;
        private Text price;

        public GeneralPage() {
            super("");
            this.setTitle("General");
            this.setValid(false);
            this.noDefaultAndApplyButton();
        }

        protected Control createContents(Composite parent) {
            Composite content = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            content.setLayout((Layout)gridLayout);
            content.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(content, 0);
            label.setText("Position");
            label.setLayoutData((Object)new GridData(125, -1));
            this.position = new Text(content, 2048);
            this.position.setLayoutData((Object)new GridData(80, -1));
            this.position.addVerifyListener((VerifyListener)new NumberVerifyListener());
            if (WatchlistItemPropertiesDialog.this.watchlistItem.getPosition() != null) {
                this.position.setText(String.valueOf(WatchlistItemPropertiesDialog.this.watchlistItem.getPosition()));
            }
            label = new Label(content, 0);
            label.setText("Price");
            label.setLayoutData((Object)new GridData(125, -1));
            this.price = new Text(content, 2048);
            this.price.setLayoutData((Object)new GridData(80, -1));
            this.price.addVerifyListener((VerifyListener)new PriceVerifyListener());
            this.price.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (GeneralPage.this.price.getText().length() != 0) {
                        try {
                            double value = WatchlistItemPropertiesDialog.this.priceFormatter.parse(GeneralPage.this.price.getText().replaceAll(",", "")).doubleValue();
                            GeneralPage.this.price.setText(WatchlistItemPropertiesDialog.this.priceFormatter.format(value));
                        }
                        catch (Exception e1) {
                            CorePlugin.logException((Exception)e1);
                        }
                    }
                }
            });
            if (WatchlistItemPropertiesDialog.this.watchlistItem.getPurchasePrice() != null) {
                this.price.setText(WatchlistItemPropertiesDialog.this.priceFormatter.format(WatchlistItemPropertiesDialog.this.watchlistItem.getPurchasePrice()));
            }
            this.setValid(true);
            return content;
        }

        public boolean performOk() {
            if (this.isValid()) {
                if (this.position.getText().length() != 0) {
                    WatchlistItemPropertiesDialog.this.watchlistItem.setPosition(Integer.parseInt(this.position.getText()));
                } else {
                    WatchlistItemPropertiesDialog.this.watchlistItem.setPaidPrice(null);
                }
                if (this.price.getText().length() != 0) {
                    try {
                        WatchlistItemPropertiesDialog.this.watchlistItem.setPaidPrice(WatchlistItemPropertiesDialog.this.priceFormatter.parse(this.price.getText()).doubleValue());
                    }
                    catch (Exception e1) {
                        CorePlugin.logException((Exception)e1);
                    }
                } else {
                    WatchlistItemPropertiesDialog.this.watchlistItem.setPaidPrice(null);
                }
            }
            return super.performOk();
        }
    }
}

