/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.messages.MarketData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;

public class SymbolSelectionPage
extends WizardPage {
    private Security security;
    private Combo cmbExchange;
    private Combo cmbMarket;
    private Text txtSymbol;

    protected SymbolSelectionPage() {
        super("");
        this.setTitle("Symbol Selection");
        this.setDescription("Select the symbol to add alert");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        int i;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)new GridLayout(2, true));
        this.setControl((Control)composite);
        GridData cmbGridData = new GridData(90, 15);
        Label lbl = new Label(composite, 0);
        lbl.setText("Exchange");
        this.cmbExchange = new Combo(composite, 8);
        this.cmbExchange.setLayoutData((Object)cmbGridData);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        lbl = new Label(composite, 0);
        lbl.setText("Market");
        this.cmbMarket = new Combo(composite, 8);
        this.cmbMarket.setLayoutData((Object)cmbGridData);
        if (Resources.marketTypes != null) {
            this.cmbMarket.removeAll();
            i = 0;
            while (i < Resources.marketTypes.size()) {
                this.cmbMarket.add((String)Resources.marketTypes.get(i));
                ++i;
            }
            try {
                this.cmbMarket.setText(MarketData.marketNames[MarketData.REGULAR]);
            }
            catch (Exception exception) {
                this.cmbMarket.select(0);
            }
        }
        lbl = new Label(composite, 0);
        lbl.setText("Symbol");
        this.txtSymbol = new Text(composite, 2048);
        this.txtSymbol.setLayoutData((Object)cmbGridData);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SymbolSelectionPage.this.createSecurity();
            }
        });
        this.cmbMarket.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SymbolSelectionPage.this.createSecurity();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmbExchange.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SymbolSelectionPage.this.createSecurity();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createSecurity() {
        String exchange = this.cmbExchange.getText();
        String market = this.cmbMarket.getText();
        String symbol = this.txtSymbol.getText();
        this.security = CorePlugin.getRepository().getSecurity(exchange, market, symbol);
        if (this.security != null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public Security getSecurity() {
        return this.security;
    }
}

