/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.trading.internal.wizards.IDynamicWizard;
import pk.com.softech.tradingterminal.trading.wizards.AlertActionsPage;
import pk.com.softech.tradingterminal.trading.wizards.AlertSelectionPage;
import pk.com.softech.tradingterminal.trading.wizards.CommonWizardPage;
import pk.com.softech.tradingterminal.trading.wizards.PluginParametersPage;
import pk.com.softech.tradingterminal.trading.wizards.SymbolSelectionPage;

public class NewAlertWizard
extends Wizard
implements IDynamicWizard {
    private SymbolSelectionPage symbolSelectionPage = new SymbolSelectionPage();
    private AlertSelectionPage alertSelectionPage = new AlertSelectionPage();
    private AlertActionsPage alertActionsPage = new AlertActionsPage();
    private List additionalPages = new ArrayList();
    private Alert alert;
    private Security security;

    public Alert open(WatchlistItem watchlistItem) {
        WizardDialog dlg = this.create(watchlistItem);
        return dlg.open() == 0 ? this.alert : null;
    }

    public Alert open() {
        WizardDialog dlg = this.create();
        return dlg.open() == 0 ? this.alert : null;
    }

    public Alert open(Alert alert) {
        WizardDialog dlg = this.create(alert);
        return dlg.open() == 0 ? alert : null;
    }

    private WizardDialog create(WatchlistItem watchlistItem) {
        this.setWindowTitle("New Alert Wizard");
        this.security = watchlistItem.getSecurity();
        this.setForcePreviousAndNextButtons(true);
        this.addPage((IWizardPage)this.alertSelectionPage);
        this.addPage((IWizardPage)this.alertActionsPage);
        WizardDialog dlg = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this);
        dlg.create();
        return dlg;
    }

    public WizardDialog create(Alert alert) {
        this.setWindowTitle("New Alert Wizard");
        this.alert = alert;
        this.security = alert.getSecurity();
        this.setForcePreviousAndNextButtons(true);
        this.addPage((IWizardPage)this.alertSelectionPage);
        this.addPage((IWizardPage)this.alertActionsPage);
        WizardDialog dlg = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this);
        dlg.create();
        return dlg;
    }

    public WizardDialog create() {
        this.setWindowTitle("New Alert Wizard");
        this.setForcePreviousAndNextButtons(true);
        this.addPage((IWizardPage)this.symbolSelectionPage);
        this.addPage((IWizardPage)this.alertSelectionPage);
        this.addPage((IWizardPage)this.alertActionsPage);
        WizardDialog dlg = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this);
        dlg.create();
        return dlg;
    }

    public boolean performFinish() {
        this.alert = new Alert();
        this.alert.setPluginId(this.alertSelectionPage.getIndicator());
        this.alert.setSecurity(this.security);
        this.alert.setPopup(this.alertActionsPage.getPopupSelection());
        this.alert.setHilight(this.alertActionsPage.getHilightSelection());
        Iterator iter = this.additionalPages.iterator();
        while (iter.hasNext()) {
            PluginParametersPage page = (PluginParametersPage)((CommonWizardPage)((Object)iter.next())).getPreferencePage();
            page.performFinish();
            this.alert.getParameters().putAll(page.getParameters());
        }
        CorePlugin.getRepository().save((PersistentObject)this.alert);
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object nextPage = null;
        if (page == this.symbolSelectionPage) {
            this.security = this.symbolSelectionPage.getSecurity();
            nextPage = this.alertSelectionPage;
        } else if (page == this.alertSelectionPage) {
            if (this.additionalPages.size() != 0) {
                nextPage = (IWizardPage)this.additionalPages.get(0);
            }
        } else {
            int index = this.additionalPages.indexOf(page);
            if (index != -1) {
                nextPage = ++index < this.additionalPages.size() ? (IWizardPage)this.additionalPages.get(index) : this.alertActionsPage;
            }
        }
        if (nextPage != null) {
            nextPage.setWizard((IWizard)this);
        }
        return nextPage;
    }

    @Override
    public List getAdditionalPages() {
        return this.additionalPages;
    }

    public Security getSecurity() {
        return this.security;
    }
}

