/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.wizards.CommonPreferencePage;

public class ItemsPage
extends CommonPreferencePage {
    private Table available;
    private Table shown;
    private int size = 200;

    public ItemsPage() {
        this.setTitle("Securities");
        this.setDescription("Manage the securities shown in the watchlist");
    }

    @Override
    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)content);
        Label label = new Label(content, 0);
        label.setText("Available securities");
        label.setLayoutData((Object)new GridData(this.size, -1));
        label = new Label(content, 0);
        label.setText("Shown securities");
        label.setLayoutData((Object)new GridData(this.size, -1));
        Composite column = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        column.setLayoutData((Object)new GridData(4, 4, true, true));
        this.available = new Table(column, 65538);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.heightHint = this.available.getItemHeight() * 15;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.available.setLayoutData((Object)gridData);
        this.available.setHeaderVisible(false);
        this.available.setLinesVisible(false);
        new TableColumn(this.available, 0);
        Composite buttons = new Composite(column, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Button button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/right.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsPage.this.moveSelectedItems(ItemsPage.this.available, ItemsPage.this.shown, false);
            }
        });
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/all-right.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsPage.this.available.setSelection(ItemsPage.this.available.getItems());
                ItemsPage.this.moveSelectedItems(ItemsPage.this.available, ItemsPage.this.shown, false);
            }
        });
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/all-left.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsPage.this.shown.setSelection(ItemsPage.this.shown.getItems());
                ItemsPage.this.moveSelectedItems(ItemsPage.this.shown, ItemsPage.this.available, true);
            }
        });
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/left.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsPage.this.moveSelectedItems(ItemsPage.this.shown, ItemsPage.this.available, true);
            }
        });
        column = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        column.setLayoutData((Object)new GridData(4, 4, true, true));
        this.shown = new Table(column, 65538);
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.heightHint = this.available.getItemHeight() * 15;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.shown.setLayoutData((Object)gridData);
        this.shown.setHeaderVisible(false);
        this.shown.setLinesVisible(false);
        new TableColumn(this.shown, 0);
        buttons = new Composite(column, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/up.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsPage.this.moveUp();
            }
        });
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/down.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsPage.this.moveDown();
            }
        });
        ObservableList securities = CorePlugin.getRepository().allSecurities();
        Collections.sort(securities, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Security)o1).getId().compareTo(((Security)o2).getId());
            }
        });
        for (Security c : securities) {
            TableItem item = new TableItem(this.available, 0);
            item.setText(0, String.valueOf(c.getSymbol()) + "(" + c.getMarket() + ")");
            WatchlistItem w = new WatchlistItem();
            w.setSecurity(c);
            item.setData((Object)w);
        }
        int i = 0;
        while (i < this.available.getColumnCount()) {
            this.available.getColumn(i).pack();
            ++i;
        }
    }

    @Override
    public void performFinish() {
    }

    public void setItems(List securities) {
        for (WatchlistItem item : securities) {
            TableItem tableItem = new TableItem(this.shown, 0);
            tableItem.setText(0, String.valueOf(item.getSecurity().getSymbol()) + "(" + item.getSecurity().getMarket() + ")");
            tableItem.setData((Object)item);
            TableItem[] items = this.available.getItems();
            int i = 0;
            while (i < items.length) {
                if (item.getSecurity().equals((Object)((WatchlistItem)items[i].getData()).getSecurity())) {
                    items[i].dispose();
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.available.getColumnCount()) {
            this.available.getColumn(i).pack();
            ++i;
        }
        i = 0;
        while (i < this.shown.getColumnCount()) {
            this.shown.getColumn(i).pack();
            ++i;
        }
    }

    public List getItems() {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < this.shown.getItemCount()) {
            list.add(this.shown.getItem(i).getData());
            ++i;
        }
        return list;
    }

    private void moveUp() {
        if (this.shown.getSelectionCount() == 1) {
            TableItem[] selection = this.shown.getSelection();
            int i = 0;
            while (i < selection.length) {
                int index = this.shown.indexOf(selection[i]);
                if (index != 0) {
                    TableItem item = new TableItem(this.shown, 0, index - 1);
                    item.setText(0, selection[i].getText(0));
                    item.setData(selection[i].getData());
                    this.shown.select(index - 1);
                    selection[i].dispose();
                }
                ++i;
            }
        }
    }

    private void moveDown() {
        if (this.shown.getSelectionCount() == 1) {
            TableItem[] selection = this.shown.getSelection();
            int i = 0;
            while (i < selection.length) {
                int index = this.shown.indexOf(selection[i]);
                if (index < this.shown.getItemCount() - 1) {
                    TableItem item = new TableItem(this.shown, 0, index + 2);
                    item.setText(0, selection[i].getText(0));
                    item.setData(selection[i].getData());
                    this.shown.select(index + 2);
                    selection[i].dispose();
                }
                ++i;
            }
        }
    }

    private void moveSelectedItems(Table from, Table to, boolean ordered) {
        if (from.getSelectionCount() != 0) {
            TableItem[] selection = from.getSelection();
            int i = 0;
            while (i < selection.length) {
                TableItem item = null;
                if (ordered) {
                    int index = 0;
                    TableItem[] items = to.getItems();
                    index = 0;
                    while (index < items.length) {
                        if (selection[i].getText(0).compareToIgnoreCase(items[index].getText(0)) <= 0) break;
                        ++index;
                    }
                    item = new TableItem(to, 0, index);
                } else {
                    item = new TableItem(to, 0);
                }
                item.setText(0, selection[i].getText(0));
                item.setData(selection[i].getData());
                selection[i].dispose();
                ++i;
            }
            i = 0;
            while (i < from.getColumnCount()) {
                from.getColumn(i).pack();
                ++i;
            }
            i = 0;
            while (i < to.getColumnCount()) {
                to.getColumn(i).pack();
                ++i;
            }
        }
    }
}

