/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.trading.AlertPlugin;
import pk.com.softech.tradingterminal.trading.AlertPluginPreferencePage;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class ItemPreferencePage
extends PreferencePage {
    private WatchlistItem watchlistItem;
    private Text position;
    private Text price;
    private Table alerts;
    private Button delete;
    private Button reset;
    private Composite group;
    private NumberFormat priceFormatter = NumberFormat.getInstance();

    public ItemPreferencePage(WatchlistItem watchlistItem) {
        super(watchlistItem.getSecurity().getDescription());
        this.watchlistItem = watchlistItem;
        this.priceFormatter.setGroupingUsed(true);
        this.priceFormatter.setMinimumIntegerDigits(1);
        this.priceFormatter.setMinimumFractionDigits(4);
        this.priceFormatter.setMaximumFractionDigits(4);
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(content, 0);
        label.setText("Position");
        label.setLayoutData((Object)new GridData(125, -1));
        this.position = new Text(content, 2048);
        this.position.setLayoutData((Object)new GridData(80, -1));
        if (this.watchlistItem.getPosition() != null) {
            this.position.setText(String.valueOf(this.watchlistItem.getPosition()));
        }
        label = new Label(content, 0);
        label.setText("Price");
        label.setLayoutData((Object)new GridData(125, -1));
        this.price = new Text(content, 2048);
        this.price.setLayoutData((Object)new GridData(80, -1));
        this.price.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ItemPreferencePage.this.price.getText().length() != 0) {
                    try {
                        double value = ItemPreferencePage.this.priceFormatter.parse(ItemPreferencePage.this.price.getText()).doubleValue();
                        ItemPreferencePage.this.price.setText(ItemPreferencePage.this.priceFormatter.format(value));
                    }
                    catch (Exception e1) {
                        CorePlugin.logException((Exception)e1);
                    }
                }
            }
        });
        if (this.watchlistItem.getPurchasePrice() != null) {
            this.price.setText(this.priceFormatter.format(this.watchlistItem.getPurchasePrice()));
        }
        Group section = new Group(content, 0);
        section.setText("Alerts");
        section.setLayout((Layout)new GridLayout(2, false));
        section.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.alerts = new Table((Composite)section, 65540);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.widthHint = 250;
        gridData.heightHint = this.alerts.getItemHeight() * 5;
        this.alerts.setLayoutData((Object)gridData);
        this.alerts.setHeaderVisible(true);
        this.alerts.setLinesVisible(false);
        this.alerts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ItemPreferencePage.this.alerts.getSelectionIndex() != -1) {
                    ((StackLayout)((ItemPreferencePage)ItemPreferencePage.this).group.getLayout()).topControl = ItemPreferencePage.this.group.getChildren()[ItemPreferencePage.this.alerts.getSelectionIndex()];
                    ItemPreferencePage.this.reset.setEnabled(((CTabFolder)ItemPreferencePage.this.alerts.getItem(ItemPreferencePage.this.alerts.getSelectionIndex()).getData("folder")).getData("last") != null);
                } else {
                    ItemPreferencePage.this.reset.setEnabled(false);
                }
                ItemPreferencePage.this.delete.setEnabled(ItemPreferencePage.this.alerts.getSelectionIndex() != -1);
                ItemPreferencePage.this.group.layout();
            }
        });
        this.alerts.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ItemPreferencePage.this.alerts.getItem(new Point(e.x, e.y)) == null) {
                    ItemPreferencePage.this.alerts.deselectAll();
                    ((StackLayout)((ItemPreferencePage)ItemPreferencePage.this).group.getLayout()).topControl = null;
                    ItemPreferencePage.this.group.layout();
                    ItemPreferencePage.this.delete.setEnabled(false);
                }
            }
        });
        TableColumn column = new TableColumn(this.alerts, 0);
        column.setText("Description");
        column = new TableColumn(this.alerts, 0);
        column.setText("Last");
        Composite buttons = new Composite((Composite)section, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(1, 4, false, false));
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.delete = new Button(buttons, 8);
        this.delete.setImage(images.getImageDescriptor("IMG_TOOL_DELETE").createImage());
        this.delete.setToolTipText("Delete selected alert");
        this.delete.setEnabled(false);
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ItemPreferencePage.this.alerts.getSelectionIndex() != -1) {
                    int index = ItemPreferencePage.this.alerts.getSelectionIndex();
                    ((CTabFolder)ItemPreferencePage.this.alerts.getItem(index).getData("folder")).dispose();
                    ItemPreferencePage.this.alerts.getItem(index).dispose();
                }
                ((StackLayout)((ItemPreferencePage)ItemPreferencePage.this).group.getLayout()).topControl = null;
                ItemPreferencePage.this.group.layout();
                ItemPreferencePage.this.delete.setEnabled(false);
            }
        });
        this.reset = new Button(buttons, 8);
        this.reset.setImage(images.getImageDescriptor("IMG_TOOL_UNDO").createImage());
        this.reset.setToolTipText("Reset last seen");
        this.reset.setEnabled(false);
        this.reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ItemPreferencePage.this.alerts.getSelectionIndex() != -1) {
                    int index = ItemPreferencePage.this.alerts.getSelectionIndex();
                    ((CTabFolder)ItemPreferencePage.this.alerts.getItem(index).getData("folder")).setData("last", null);
                    ItemPreferencePage.this.alerts.getItem(index).setText(1, "");
                }
                ItemPreferencePage.this.reset.setEnabled(false);
            }
        });
        this.group = new Composite((Composite)section, 0);
        this.group.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.group.setLayout((Layout)new StackLayout());
        for (Alert alert : this.watchlistItem.getAlerts()) {
            AlertPlugin plugin = (AlertPlugin)alert.getData();
            if (plugin == null) {
                plugin = TradingPlugin.createAlertPlugin(alert.getPluginId());
                plugin.init(this.watchlistItem.getSecurity(), alert.getParameters());
                alert.setData((Object)plugin);
            }
            TableItem tableItem = new TableItem(this.alerts, 0);
            tableItem.setText(0, String.valueOf(plugin.getDescription()) + " (" + TradingPlugin.getAlertPluginName(alert.getPluginId()) + ")");
            if (alert.getLastSeen() != null) {
                tableItem.setText(1, CorePlugin.getDateTimeFormatLong().format(alert.getLastSeen()));
            }
            tableItem.setData((Object)alert);
            CTabFolder folder = new CTabFolder(this.group, 0x800880);
            folder.setMaximizeVisible(false);
            folder.setMinimizeVisible(false);
            folder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
            folder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            folder.setData((Object)alert);
            folder.setData("last", (Object)plugin.getLastSeen());
            tableItem.setData("folder", (Object)folder);
            IConfigurationElement[] pages = TradingPlugin.getAlertPluginPreferencePages(alert.getPluginId());
            int i = 0;
            while (i < pages.length) {
                CTabItem tabItem = new CTabItem(folder, 0);
                Composite itemContent = new Composite((Composite)folder, 0);
                itemContent.setLayout((Layout)new GridLayout());
                tabItem.setControl((Control)itemContent);
                tabItem.setText(pages[i].getAttribute("name"));
                if (pages[i].getAttribute("description") != null) {
                    tabItem.setToolTipText(pages[i].getAttribute("description"));
                }
                try {
                    AlertPluginPreferencePage page = (AlertPluginPreferencePage)pages[i].createExecutableExtension("class");
                    page.init(this.watchlistItem.getSecurity(), alert.getParameters());
                    page.createContents(itemContent);
                    tabItem.setData((Object)page);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                folder.setSelection(0);
                ++i;
            }
        }
        int i = 0;
        while (i < this.alerts.getColumnCount()) {
            this.alerts.getColumn(i).pack();
            ++i;
        }
        return content;
    }

    public boolean performOk() {
        if (this.group != null) {
            if (this.position.getText().length() != 0) {
                this.watchlistItem.setPosition(Integer.parseInt(this.position.getText()));
            } else {
                this.watchlistItem.setPaidPrice(null);
            }
            if (this.price.getText().length() != 0) {
                try {
                    this.watchlistItem.setPaidPrice(this.priceFormatter.parse(this.price.getText()).doubleValue());
                }
                catch (Exception e1) {
                    CorePlugin.logException((Exception)e1);
                }
            } else {
                this.watchlistItem.setPaidPrice(null);
            }
            this.watchlistItem.getAlerts().clear();
            Control[] childs = this.group.getChildren();
            int i = 0;
            while (i < childs.length) {
                HashMap parameters = new HashMap();
                CTabItem[] items = ((CTabFolder)childs[i]).getItems();
                int p = 0;
                while (p < items.length) {
                    AlertPluginPreferencePage page = (AlertPluginPreferencePage)items[p].getData();
                    page.performOk();
                    parameters.putAll(page.getParameters());
                    ++p;
                }
                Alert alert = (Alert)childs[i].getData();
                alert.setParameters(parameters);
                alert.setLastSeen((Date)((CTabFolder)this.alerts.getItem(i).getData("folder")).getData("last"));
                ((AlertPlugin)alert.getData()).init(parameters);
                ((AlertPlugin)alert.getData()).setLastSeen(alert.getLastSeen());
                this.watchlistItem.getAlerts().add(alert);
                this.watchlistItem.setChanged();
                ++i;
            }
            this.watchlistItem.notifyObservers();
        }
        return super.performOk();
    }
}

