/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.CurrencyConverter;
import pk.com.softech.tradingterminal.core.ObservableList;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.trading.wizards.CommonPreferencePage;

public class GeneralPage
extends CommonPreferencePage {
    private Watchlist watchlist;
    private Text text;
    private Combo currency;
    private Button btnUseDefaultCurrency;

    public GeneralPage() {
        this(null);
    }

    public GeneralPage(Watchlist watchlist) {
        this.setTitle("General");
        this.setDescription("Set the name of the watchlist");
        this.watchlist = watchlist;
    }

    @Override
    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)content);
        Label label = new Label(content, 0);
        label.setText("Name");
        label.setLayoutData((Object)new GridData(125, -1));
        this.text = new Text(content, 2048);
        this.text.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        if (this.watchlist != null) {
            if (this.watchlist.getWatchlistType() == 0) {
                this.text.setEnabled(true);
                this.setPageComplete(this.text.getText().length() != 0);
            } else {
                this.text.setEnabled(false);
                this.setPageComplete(true);
            }
        } else {
            this.setPageComplete(false);
        }
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ObservableList systemWatchlist = CorePlugin.getRepository().allSystemWatchlists();
                ObservableList customWatchlist = CorePlugin.getRepository().allWatchlists();
                boolean duplicate = false;
                int i = 0;
                while (i < systemWatchlist.size()) {
                    if (((Watchlist)systemWatchlist.get(i)).getDescription().equalsIgnoreCase(GeneralPage.this.text.getText())) {
                        duplicate = true;
                        break;
                    }
                    ++i;
                }
                int j = 0;
                while (j < customWatchlist.size()) {
                    if (((Watchlist)customWatchlist.get(j)).getDescription().equalsIgnoreCase(GeneralPage.this.text.getText())) {
                        duplicate = true;
                        break;
                    }
                    ++j;
                }
                if (duplicate) {
                    GeneralPage.this.setErrorMessage("Watchlist name already exists !");
                } else if (GeneralPage.this.text.getText().length() == 0) {
                    GeneralPage.this.setErrorMessage("Set the name of the watchlist");
                } else {
                    GeneralPage.this.setErrorMessage(null);
                }
                GeneralPage.this.setPageComplete(GeneralPage.this.text.getText().length() != 0 && !duplicate && GeneralPage.this.text.isEnabled());
            }
        });
        label = new Label(content, 0);
        label.setText("Currency");
        label.setLayoutData((Object)new GridData(125, -1));
        this.currency = new Combo(content, 12);
        this.currency.setVisibleItemCount(10);
        List list = CurrencyConverter.getInstance().getCurrencies();
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((String)arg0).compareTo((String)arg1);
            }
        });
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.currency.add((String)iter.next());
        }
        if (this.watchlist != null) {
            if (this.watchlist.getCurrency() != null) {
                this.currency.setText(this.watchlist.getCurrency().getCurrencyCode());
            } else {
                this.currency.setText("PKR");
            }
            this.currency.setEnabled(!this.watchlist.isUseDefaultCurrency());
        } else {
            this.currency.setText("PKR");
            this.currency.setEnabled(false);
        }
        this.btnUseDefaultCurrency = new Button(content, 32);
        this.btnUseDefaultCurrency.setText("Use default currency of security");
        this.btnUseDefaultCurrency.setSelection(this.watchlist != null ? this.watchlist.isUseDefaultCurrency() : true);
        this.btnUseDefaultCurrency.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralPage.this.currency.setEnabled(!GeneralPage.this.btnUseDefaultCurrency.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GeneralPage.this.currency.setEnabled(!GeneralPage.this.btnUseDefaultCurrency.getSelection());
            }
        });
        this.text.setFocus();
    }

    @Override
    public void performFinish() {
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String text) {
        this.text.setText(text);
        this.setPageComplete(true);
    }

    public Currency setCurrency(Currency currency) {
        if (currency != null) {
            this.currency.setText(currency.getCurrencyCode());
        }
        return null;
    }

    public Currency getCurrency() {
        if (this.currency.getText().length() != 0) {
            return Currency.getInstance(this.currency.getText());
        }
        return null;
    }

    public boolean isUseDefaultCurrency() {
        return this.btnUseDefaultCurrency.getSelection();
    }

    public void setUseDefaultCurrency(boolean flag) {
        this.btnUseDefaultCurrency.setSelection(flag);
    }
}

