/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import pk.com.softech.tradingterminal.core.db.WatchlistColumn;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.internal.watchlist.ColumnRegistry;
import pk.com.softech.tradingterminal.trading.wizards.CommonPreferencePage;

public class ColumnsPage
extends CommonPreferencePage {
    private Table available;
    private Table shown;
    private TableViewer viewerShown;
    private TableViewer viewerAvailable;
    private List<IConfigurationElement> availableList;
    private List<IConfigurationElement> selectedList;
    private Button buttonUp;
    private Button buttonDown;

    public ColumnsPage() {
        this.setTitle("Columns");
        this.setDescription("Select the watchlist columns to show");
    }

    @Override
    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)content);
        this.availableList = new ArrayList<IConfigurationElement>();
        this.selectedList = new ArrayList<IConfigurationElement>();
        Label label = new Label(content, 0);
        label.setText("Available columns");
        label = new Label(content, 0);
        label.setText("Shown columns");
        Composite column = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        column.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createViewerAvailable(column);
        Composite buttons = new Composite(column, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Button button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/right.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnsPage.this.viewerAvailable.getSelection();
                ColumnsPage.this.selectedList.addAll(selection.toList());
                ColumnsPage.this.viewerShown.refresh();
                ColumnsPage.this.availableList.removeAll(selection.toList());
                ColumnsPage.this.viewerAvailable.refresh();
            }
        });
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/all-right.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsPage.this.selectedList.addAll(ColumnsPage.this.availableList);
                ColumnsPage.this.viewerShown.refresh();
                ColumnsPage.this.availableList.clear();
                ColumnsPage.this.viewerAvailable.refresh();
            }
        });
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/all-left.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnsPage.this.availableList.addAll(ColumnsPage.this.selectedList);
                ColumnsPage.this.viewerAvailable.refresh();
                ColumnsPage.this.selectedList.clear();
                ColumnsPage.this.viewerShown.refresh();
            }
        });
        button = new Button(buttons, 8);
        button.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/left.gif").createImage());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ColumnsPage.this.viewerShown.getSelection();
                ColumnsPage.this.selectedList.removeAll(selection.toList());
                ColumnsPage.this.viewerShown.refresh();
                ColumnsPage.this.availableList.addAll(selection.toList());
                ColumnsPage.this.viewerAvailable.refresh();
            }
        });
        column = new Composite(content, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        column.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createViewerShown(column);
        buttons = new Composite(column, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttons.setLayout((Layout)gridLayout);
        buttons.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.buttonUp = new Button(buttons, 8);
        this.buttonUp.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/up.gif").createImage());
        this.buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnsPage.this.viewerShown.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)ColumnsPage.this.viewerShown.getSelection()).toArray();
                    ColumnsPage.this.moveSelectionUp(s);
                    ColumnsPage.this.updateControlsEnablement();
                }
            }
        });
        this.buttonDown = new Button(buttons, 8);
        this.buttonDown.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/down.gif").createImage());
        this.buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ColumnsPage.this.viewerShown.getSelection().isEmpty()) {
                    Object[] s = ((IStructuredSelection)ColumnsPage.this.viewerShown.getSelection()).toArray();
                    ColumnsPage.this.moveSelectionDown(s);
                    ColumnsPage.this.updateControlsEnablement();
                }
            }
        });
        IConfigurationElement[] providers = ColumnRegistry.getProviders();
        int i = 0;
        while (i < providers.length) {
            this.availableList.add(providers[i]);
            ++i;
        }
        this.available.getColumn(0).pack();
        this.viewerShown.setInput(this.selectedList);
        this.viewerAvailable.setInput(this.availableList);
        this.updateControlsEnablement();
    }

    private void createViewerAvailable(Composite parent) {
        this.viewerAvailable = new TableViewer(parent, 65538);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.available = this.viewerAvailable.getTable();
        this.viewerAvailable.getControl().setLayoutData((Object)gridData);
        this.available.setHeaderVisible(false);
        this.available.setLinesVisible(false);
        this.createColumnsAvailable(parent, this.viewerAvailable);
        this.viewerAvailable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerAvailable.setComparator((ViewerComparator)new SymbolComparator());
        this.viewerAvailable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationElement)element).getAttribute("name");
            }
        });
        this.viewerAvailable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnsPage.this.updateControlsEnablement();
            }
        });
    }

    private void createViewerShown(Composite parent) {
        this.viewerShown = new TableViewer(parent, 65538);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        gridData.heightHint = this.available.getItemHeight() * 15;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.shown = this.viewerShown.getTable();
        this.viewerShown.getControl().setLayoutData((Object)gridData);
        this.shown.setHeaderVisible(false);
        this.shown.setLinesVisible(false);
        this.createColumns(parent, this.viewerShown);
        this.viewerShown.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerShown.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IConfigurationElement)element).getAttribute("name");
            }
        });
        this.viewerShown.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ColumnsPage.this.updateControlsEnablement();
            }
        });
    }

    private void createColumnsAvailable(Composite parent, TableViewer viewerAvailable) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewerAvailable, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setResizable(false);
        column.setMoveable(false);
        column.setText("Available");
        this.available.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width = ((ColumnsPage)ColumnsPage.this).available.getSize().x;
                ColumnsPage.this.available.getColumn(0).setWidth(width);
            }
        });
    }

    private void createColumns(Composite parent, TableViewer viewerShown) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewerShown, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setResizable(false);
        column.setMoveable(false);
        column.setText("Shown");
        this.shown.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width = ((ColumnsPage)ColumnsPage.this).shown.getSize().x;
                ColumnsPage.this.shown.getColumn(0).setWidth(width);
            }
        });
    }

    protected void updateControlsEnablement() {
        int upperIndex = -1;
        int lowerIndex = 999999;
        Object[] s = ((IStructuredSelection)this.viewerShown.getSelection()).toArray();
        int i = 0;
        while (i < s.length) {
            upperIndex = Math.max(upperIndex, this.selectedList.indexOf(s[i]));
            lowerIndex = Math.min(lowerIndex, this.selectedList.indexOf(s[i]));
            ++i;
        }
        this.buttonUp.setEnabled(!this.viewerShown.getSelection().isEmpty() && upperIndex > 0);
        this.buttonDown.setEnabled(!this.viewerShown.getSelection().isEmpty() && lowerIndex < this.selectedList.size() - 1);
    }

    protected void moveSelectionUp(Object[] s) {
        ArrayList<IConfigurationElement> l = new ArrayList<IConfigurationElement>();
        int index = 999999;
        int i = 0;
        while (i < s.length) {
            index = Math.min(index, this.selectedList.indexOf((IConfigurationElement)s[i]));
            l.add((IConfigurationElement)s[i]);
            ++i;
        }
        if (index > 0) {
            this.selectedList.removeAll(l);
            this.selectedList.addAll(--index, l);
            this.viewerShown.refresh();
        }
    }

    protected void moveSelectionDown(Object[] s) {
        ArrayList<IConfigurationElement> l = new ArrayList<IConfigurationElement>();
        int index = -1;
        int i = 0;
        while (i < s.length) {
            index = Math.max(index, this.selectedList.indexOf((IConfigurationElement)s[i]));
            l.add((IConfigurationElement)s[i]);
            ++i;
        }
        if (index < this.selectedList.size() - 1) {
            ++index;
            this.selectedList.removeAll(l);
            this.selectedList.addAll(index -= l.size() - 1, l);
            this.viewerShown.refresh();
        }
    }

    @Override
    public void performFinish() {
    }

    public List getColumns() {
        ArrayList<WatchlistColumn> list = new ArrayList<WatchlistColumn>();
        ArrayList items = (ArrayList)this.viewerShown.getInput();
        int i = 0;
        while (i < items.size()) {
            WatchlistColumn column = new WatchlistColumn();
            column.setId(((IConfigurationElement)items.get(i)).getAttribute("id"));
            list.add(column);
            ++i;
        }
        return list;
    }

    public void setColumns(List list) {
        ArrayList<IConfigurationElement> temp = new ArrayList<IConfigurationElement>();
        block0: for (WatchlistColumn column : list) {
            ArrayList totalList = (ArrayList)this.viewerAvailable.getInput();
            int i = 0;
            while (i < totalList.size()) {
                IConfigurationElement provider = (IConfigurationElement)totalList.get(i);
                if (column.getId().equals(provider.getAttribute("id"))) {
                    this.selectedList.add(provider);
                    temp.add(provider);
                    continue block0;
                }
                ++i;
            }
        }
        this.availableList.removeAll(temp);
        this.viewerShown.refresh();
        this.viewerAvailable.refresh();
    }

    class SymbolComparator
    extends ViewerComparator {
        SymbolComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return ((IConfigurationElement)e1).getAttribute("name").compareTo(((IConfigurationElement)e2).getAttribute("name"));
        }
    }
}

