/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import pk.com.softech.messages.SquareUpStdPositionRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.trading.dialogs.PinCodeVerificationDialog;
import pk.com.softech.tradingterminal.trading.wizards.ClientSquarePositionPage;

public class ClientSquarePositionWizard
extends Wizard {
    private ClientSquarePositionPage page;
    private static boolean finish = false;

    public ClientSquarePositionWizard() {
        this.setWindowTitle("Client Square Position");
    }

    public void addPages() {
        this.page = new ClientSquarePositionPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean pinCodeValidation(String message, String[] values) {
        PinCodeVerificationDialog dlg = new PinCodeVerificationDialog(Display.getCurrent().getActiveShell(), message, values);
        return dlg.open() == 0;
    }

    public boolean performFinish() {
        this.sendSquareClientPositionRequest();
        return finish;
    }

    private String getEmployeeCode(String program) {
        String traderCode = "";
        int i = 0;
        while (i < Resources.progResponse.length) {
            String program1 = Resources.progResponse[i].getProgramName();
            if (program1.equals(program)) {
                traderCode = Resources.progResponse[i].getEmployeeCode();
                break;
            }
            ++i;
        }
        return traderCode;
    }

    public void sendSquareClientPositionRequest() {
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            String programName = this.page.cmbProgram.getText();
            if (programName == null || programName.length() == 0) {
                MessageDialog.openError(null, (String)"Invalid Program", (String)"Please select program");
                return;
            }
            String employeeCode = this.getEmployeeCode(programName);
            SquareUpStdPositionRequest req = new SquareUpStdPositionRequest(Resources.userId, employeeCode);
            try {
                if (Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)req)) {
                    Resources.respSquareUpStdPositionResponse = null;
                    finish = false;
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            while (Resources.respSquareUpStdPositionResponse == null) {
                                try {
                                    Thread.sleep(200L);
                                }
                                catch (Exception exception) {}
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (Resources.respSquareUpStdPositionResponse.getResult() == 1) {
                                        finish = true;
                                        MessageDialog.openInformation(null, (String)"Client Square Position Response", (String)"Square Position of all Students is done successfullly!");
                                    } else {
                                        MessageDialog.openInformation(null, (String)"Client Square Position Response", (String)Resources.respSquareUpStdPositionResponse.getRemarks());
                                    }
                                }
                            });
                        }
                    });
                }
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    public boolean performCancel() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }
}

