/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.core.Resources;

class ChangePinCodePage
extends WizardPage {
    public static final String PAGE_NAME = "Change Pin Code";
    public Label lblOldPinCode;
    public Label lblNewPinCode;
    public Label lblConfirmPinCode;
    public Text txtOldPinCode;
    public Text txtNewPinCode;
    public Text txtConfirmPinCode;

    public ChangePinCodePage() {
        super(PAGE_NAME, PAGE_NAME, null);
    }

    public void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).equalWidth(true).applyTo(parent);
        this.lblOldPinCode = new Label(parent, 0x1000000);
        this.lblOldPinCode.setText("Old Pin Code :");
        this.txtOldPinCode = new Text(parent, 0x400800);
        this.txtOldPinCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtOldPinCode.setTextLimit(Resources.pinCodeLength);
        this.txtOldPinCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangePinCodePage.this.validatePage();
            }
        });
        this.lblNewPinCode = new Label(parent, 0x1000000);
        this.lblNewPinCode.setText("New Pin Code :");
        this.txtNewPinCode = new Text(parent, 0x400800);
        this.txtNewPinCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtNewPinCode.setTextLimit(Resources.pinCodeLength);
        this.txtNewPinCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangePinCodePage.this.validatePage();
            }
        });
        this.lblConfirmPinCode = new Label(parent, 0x1000000);
        this.lblConfirmPinCode.setText("Confirm New Pin Code :");
        this.txtConfirmPinCode = new Text(parent, 0x400800);
        this.txtConfirmPinCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtConfirmPinCode.setTextLimit(Resources.pinCodeLength);
        this.txtConfirmPinCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangePinCodePage.this.validatePage();
            }
        });
        Display display = Display.getCurrent();
        Color blue = display.getSystemColor(9);
        Label note = new Label(parent, 0x1000000);
        note.setText("Note: PIN Code length must be four(4) digits only.");
        note.setForeground(blue);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)note);
        this.setControl((Control)parent);
        this.setPageComplete(false);
        this.validatePage();
    }

    private void validatePage() {
        if (this.txtOldPinCode.getText().equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter old pin code");
        } else if (!this.isDigit(this.txtOldPinCode.getText())) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter only digits (0-9).");
        } else if (this.txtOldPinCode.getText().length() != 4) {
            this.setPageComplete(false);
            this.setErrorMessage("Pin code should be 4 digits.");
        } else if (this.txtNewPinCode.getText().equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter new pin code");
        } else if (!this.isDigit(this.txtNewPinCode.getText())) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter only digits (0-9).");
        } else if (this.txtNewPinCode.getText().length() != 4) {
            this.setPageComplete(false);
            this.setErrorMessage("Pin code should be 4 digits.");
        } else if (this.txtOldPinCode.getText().equals(this.txtNewPinCode.getText())) {
            this.setPageComplete(false);
            this.setErrorMessage("New pin code must be different from old pin code.");
        } else if (this.txtConfirmPinCode.getText().equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter confirm pin code");
        } else if (!this.isDigit(this.txtConfirmPinCode.getText())) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter only digits (0-9).");
        } else if (this.txtConfirmPinCode.getText().length() != 4) {
            this.setPageComplete(false);
            this.setErrorMessage("Pin code should be 4 digits.");
        } else if (!this.txtNewPinCode.getText().equals(this.txtConfirmPinCode.getText())) {
            this.setPageComplete(false);
            this.setErrorMessage("New pin code mismatch");
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private boolean isDigit(String txt) {
        try {
            Integer.parseInt(txt);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public String getOldPinCode() {
        return this.txtOldPinCode.getText();
    }

    public String getNewPinCode() {
        return this.txtNewPinCode.getText();
    }

    public String getConfirmPinCode() {
        return this.txtConfirmPinCode.getText();
    }
}

