/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class ChangePasswordPage
extends WizardPage {
    public static final String PAGE_NAME = "Change Password";
    public Label lblOldPassword;
    public Label lblNewPassword;
    public Label lblConfirmPassword;
    public Label lblNote;
    public Text txtOldPassword;
    public Text txtNewPassword;
    public Text txtConfirmPassword;

    public ChangePasswordPage() {
        super(PAGE_NAME, PAGE_NAME, null);
    }

    public void createControl(Composite parent) {
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).equalWidth(true).applyTo(parent);
        this.lblOldPassword = new Label(parent, 0x1000000);
        this.lblOldPassword.setText("Old Password :");
        this.txtOldPassword = new Text(parent, 0x400800);
        this.txtOldPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtOldPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangePasswordPage.this.validatePage();
            }
        });
        this.lblNewPassword = new Label(parent, 0x1000000);
        this.lblNewPassword.setText("New Password :");
        this.txtNewPassword = new Text(parent, 0x400800);
        this.txtNewPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtNewPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangePasswordPage.this.validatePage();
            }
        });
        this.lblConfirmPassword = new Label(parent, 0x1000000);
        this.lblConfirmPassword.setText("Confirm New Password :");
        this.txtConfirmPassword = new Text(parent, 0x400800);
        this.txtConfirmPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtConfirmPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangePasswordPage.this.validatePage();
            }
        });
        Display display = Display.getCurrent();
        Color blue = display.getSystemColor(9);
        this.lblNote = new Label(parent, 64);
        this.lblNote.setText("Password Policy:\n1. Passwords shall be at least 10 characters in length.\n2. Passwords shall include a mixture of the following:\n   a. Uppercase characters (A, B, C \u2026)\n   b. Lowercase characters (a, b, c \u2026)\n   c. Numbers (0, 1, 2 \u2026)\n   d. Special Characters (!, @, # \u2026).");
        this.lblNote.setForeground(blue);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, false).applyTo((Control)this.lblNote);
        this.setControl((Control)parent);
        this.setPageComplete(false);
        this.validatePage();
    }

    private void validatePage() {
        if (this.txtOldPassword.getText().equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter old password");
        } else if (this.txtNewPassword.getText().equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter new password");
        } else if (!(this.txtNewPassword.getText().equals("") || this.txtNewPassword.getText().length() >= 6 && this.txtNewPassword.getText().length() <= 15)) {
            this.setPageComplete(false);
            this.setErrorMessage("Password length must be between 6 to 15 characters.");
        } else if (this.txtConfirmPassword.getText().equals("")) {
            this.setPageComplete(false);
            this.setErrorMessage("Please enter confirm password");
        } else if (!(this.txtConfirmPassword.getText().equals("") || this.txtConfirmPassword.getText().length() >= 6 && this.txtConfirmPassword.getText().length() <= 15)) {
            this.setPageComplete(false);
            this.setErrorMessage("Confirm password length must be between 6 to 15 characters.");
        } else if (!this.txtNewPassword.getText().equals(this.txtConfirmPassword.getText())) {
            this.setPageComplete(false);
            this.setErrorMessage("New password mismatch");
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public String getOldPassword() {
        return this.txtOldPassword.getText();
    }

    public String getNewPassword() {
        return this.txtNewPassword.getText();
    }

    public String getConfirmPassword() {
        return this.txtConfirmPassword.getText();
    }
}

