/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.WatchlistMenuRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Alert;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.Watchlist;
import pk.com.softech.tradingterminal.core.db.WatchlistItem;
import pk.com.softech.tradingterminal.core.internal.XMLRepository;
import pk.com.softech.tradingterminal.core.transfers.SecurityTransfer;
import pk.com.softech.tradingterminal.core.transfers.WatchlistItemTransfer;
import pk.com.softech.tradingterminal.core.ui.SelectionProvider;
import pk.com.softech.tradingterminal.core.ui.actions.ColorAndFontAction;
import pk.com.softech.tradingterminal.trading.AlertPlugin;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.actions.CopyWatchlistItemAction;
import pk.com.softech.tradingterminal.trading.actions.CutWatchlistItemAction;
import pk.com.softech.tradingterminal.trading.actions.DeleteWatchlistItemAction;
import pk.com.softech.tradingterminal.trading.actions.PasteWatchlistItemAction;
import pk.com.softech.tradingterminal.trading.actions.SetRibbonLayoutAction;
import pk.com.softech.tradingterminal.trading.actions.SetTableLayoutAction;
import pk.com.softech.tradingterminal.trading.actions.ShowMBOAction;
import pk.com.softech.tradingterminal.trading.actions.ShowMBPAction;
import pk.com.softech.tradingterminal.trading.actions.SymbolSummaryAction;
import pk.com.softech.tradingterminal.trading.actions.WatchlistSettingsAction;
import pk.com.softech.tradingterminal.trading.internal.AbstractLayout;
import pk.com.softech.tradingterminal.trading.internal.WatchlistBoxViewer;
import pk.com.softech.tradingterminal.trading.internal.WatchlistTableViewer;
import pk.com.softech.tradingterminal.trading.views.OrderFormView;

public class WatchlistView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.watchlist";
    public static final String PREFS_SHOW_TOTALS = "SHOW_TOTALS";
    public static final String PREFS_SORTING = "SORT";
    public static final int TABLE = 0;
    public static final int RIBBON = 1;
    Watchlist watchlist;
    PreferenceStore preferenceStore = new PreferenceStore();
    Composite parent;
    Action qouteRequest;
    AbstractLayout layout;
    Action tableLayout = new SetTableLayoutAction(this);
    Action ribbonLayout = new SetRibbonLayoutAction(this);
    Action cutAction = new CutWatchlistItemAction(this);
    Action copyAction = new CopyWatchlistItemAction(this);
    Action pasteAction = new PasteWatchlistItemAction(this);
    Action deleteAction = new DeleteWatchlistItemAction(this);
    Action settingAction = new WatchlistSettingsAction((IViewPart)this);
    Action refreshWatch;
    Action mboAction;
    Action mbpAction;
    Action buyAction;
    Action sellAction;
    Action securitiesAction;
    private Action colorsAndFonts;
    DropTargetListener dropTargetListener = new DropTargetListener(){

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 1;
            }
            event.currentDataType = null;
            TransferData[] data = event.dataTypes;
            int i = 0;
            while (i < data.length) {
                if (WatchlistItemTransfer.getInstance().isSupportedType(data[i])) {
                    event.currentDataType = data[i];
                    break;
                }
                ++i;
            }
            if (event.currentDataType == null) {
                i = 0;
                while (i < data.length) {
                    if (SecurityTransfer.getInstance().isSupportedType(data[i])) {
                        event.currentDataType = data[i];
                        break;
                    }
                    ++i;
                }
            }
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 9;
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (SecurityTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Security[] securities = (Security[])event.data;
                WatchlistView.this.itemsDropped(securities, new Point(event.x, event.y));
            } else if (WatchlistItemTransfer.getInstance().isSupportedType(event.currentDataType)) {
                WatchlistItem[] items = (WatchlistItem[])event.data;
                WatchlistView.this.itemsDropped(items, new Point(event.x, event.y));
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        this.preferenceStore = new PreferenceStore(TradingPlugin.getDefault().getStateLocation().append("watchlist." + site.getSecondaryId() + ".prefs").toOSString());
        this.preferenceStore.setDefault(PREFS_SORTING, "watchlist.description");
        if (Resources.checkWatchType) {
            this.preferenceStore.setDefault(PREFS_SHOW_TOTALS, true);
        } else {
            this.preferenceStore.setDefault(PREFS_SHOW_TOTALS, false);
        }
        Resources.checkWatchType = false;
        try {
            this.preferenceStore.load();
        }
        catch (Exception exception) {}
        this.mboAction = new ShowMBOAction(this);
        this.mbpAction = new ShowMBPAction(this);
        this.qouteRequest = new SymbolSummaryAction(this);
        this.buyAction = new Action(){

            public void run() {
                Security security = null;
                try {
                    WatchlistItem[] watchItem = WatchlistView.this.getSelection();
                    if (watchItem != null && watchItem.length > 0) {
                        security = watchItem[0].getSecurity();
                    }
                    OrderFormView view = (OrderFormView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.buytrade");
                    view.setFormTitle("Buy Order Form");
                    if (security != null) {
                        view.setSecurity(security);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.buyAction.setText("Buy Order");
        this.sellAction = new Action(){

            public void run() {
                Security security = null;
                try {
                    WatchlistItem[] watchItem = WatchlistView.this.getSelection();
                    if (watchItem != null && watchItem.length > 0) {
                        security = watchItem[0].getSecurity();
                    }
                    OrderFormView view = (OrderFormView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.buytrade");
                    view.setFormTitle("Sell Order Form");
                    if (security != null) {
                        view.setSecurity(security);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.sellAction.setText("Sell Order");
        this.securitiesAction = new Action(){

            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.securityView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.securitiesAction.setText("Symbol List");
        this.refreshWatch = new Action(){

            public void run() {
                WatchlistMenuRequest req = new WatchlistMenuRequest(WatchlistView.this.getViewSite().getSecondaryId());
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)req);
                }
            }
        };
        this.refreshWatch.setText("Refresh Symbols");
        this.refreshWatch.setToolTipText("Refresh Symbols");
        this.refreshWatch.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("/icons/dtool16/refresh.gif"));
        this.refreshWatch.setImageDescriptor(TradingPlugin.getImageDescriptor("/icons/etool16/refresh.gif"));
        this.colorsAndFonts = new ColorAndFontAction(new String[]{"pk.com.softech.tradingterminal.watchlist"});
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator("news"));
        menuManager.add((IContributionItem)new GroupMarker("layout"));
        MenuManager layoutMenu = new MenuManager("Layout", "layout");
        layoutMenu.add((IAction)this.tableLayout);
        layoutMenu.add((IAction)this.ribbonLayout);
        menuManager.add((IContributionItem)layoutMenu);
        menuManager.add((IContributionItem)new Separator("toggles"));
        menuManager.add((IContributionItem)new Separator("search"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.add((IAction)this.settingAction);
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
        toolBarManager.add((IAction)this.refreshWatch);
        toolBarManager.add((IAction)this.colorsAndFonts);
        site.getActionBars().updateActionBars();
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.getSite().setSelectionProvider((ISelectionProvider)new SelectionProvider());
        DropTarget target = new DropTarget((Control)parent, 3);
        target.setTransfer(new Transfer[]{SecurityTransfer.getInstance(), WatchlistItemTransfer.getInstance()});
        target.addDropListener(this.dropTargetListener);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(this.cutAction.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(this.copyAction.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(this.pasteAction.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(this.settingAction.getId(), (IAction)this.settingAction);
        this.watchlist = (Watchlist)CorePlugin.getRepository().load(Watchlist.class, this.getViewSite().getSecondaryId());
        if (this.watchlist != null && this.watchlist.getDescription().length() != 0) {
            this.setLayout(this.watchlist.getStyle());
            if (Resources.sectorKeys.contains(this.watchlist.getId())) {
                this.setPartName("Sector Watch");
            } else {
                this.setTitleToolTip(this.watchlist.getDescription());
                this.setPartName(this.watchlist.getDescription());
            }
            this.refreshWatch.setEnabled(this.watchlist.getWatchlistType() == 1);
        }
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (WatchlistView.this.watchlist != null) {
                    for (WatchlistItem watchlistItem : WatchlistView.this.watchlist.getItems()) {
                        for (Alert alert : watchlistItem.getAlerts()) {
                            AlertPlugin plugin = (AlertPlugin)alert.getData();
                            if (plugin != null) continue;
                            plugin = TradingPlugin.createAlertPlugin(alert.getPluginId());
                            plugin.init(watchlistItem.getSecurity(), alert);
                            plugin.setLastSeen(alert.getLastSeen());
                            alert.setData((Object)plugin);
                        }
                        watchlistItem.addObserver((Observer)WatchlistView.this);
                        Security security = watchlistItem.getSecurity();
                        if (security == null || security.getQuoteFeed() == null) continue;
                        FeedMonitor.monitor((Security)security);
                    }
                    WatchlistView.this.watchlist.getItems().addCollectionObserver((ICollectionObserver)WatchlistView.this);
                    CorePlugin.getRepository().allSecurities().addCollectionObserver((ICollectionObserver)WatchlistView.this);
                    WatchlistView.this.watchlist.addObserver((Observer)WatchlistView.this);
                }
            }
        });
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void dispose() {
        if (this.watchlist != null) {
            this.watchlist.deleteObserver((Observer)this);
            this.watchlist.getItems().removeCollectionObserver((ICollectionObserver)this);
            CorePlugin.getRepository().allSecurities().removeCollectionObserver((ICollectionObserver)this);
            for (WatchlistItem watchlistItem : this.watchlist.getItems()) {
                Security security = watchlistItem.getSecurity();
                if (security == null || security.getQuoteFeed() == null) continue;
                FeedMonitor.cancelMonitor((Security)security);
            }
            ((XMLRepository)CorePlugin.getRepository()).save((PersistentObject)this.watchlist);
        }
        try {
            this.layout.dispose();
            this.preferenceStore.save();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).warn((Object)e);
        }
        super.dispose();
    }

    public void fillMenuBars(IMenuManager mgr) {
        if (mgr != null) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.qouteRequest);
            mgr.add((IContributionItem)new Separator("top"));
            mgr.add((IContributionItem)new Separator("group0"));
            mgr.add((IContributionItem)new Separator("group1"));
            mgr.appendToGroup("group1", (IAction)this.securitiesAction);
            mgr.add((IContributionItem)new Separator("group2"));
            if (Resources.mboAllow) {
                mgr.appendToGroup("group2", (IAction)this.mboAction);
            }
            if (Resources.mbpAllow) {
                mgr.appendToGroup("group2", (IAction)this.mbpAction);
            }
            mgr.add((IContributionItem)new Separator("group3"));
            if (Resources.buyOrderOption) {
                mgr.appendToGroup("group3", (IAction)this.buyAction);
            }
            if (Resources.sellOrderOption) {
                mgr.appendToGroup("group3", (IAction)this.sellAction);
            }
            mgr.add((IContributionItem)new Separator("news"));
            mgr.add((IContributionItem)new Separator("group4"));
            mgr.add((IContributionItem)new Separator("group5"));
            mgr.add((IContributionItem)new Separator("group6"));
            mgr.add((IContributionItem)new Separator("group7"));
            mgr.add((IContributionItem)new Separator("additions"));
            mgr.add((IContributionItem)new Separator("bottom"));
            mgr.add((IContributionItem)new Separator());
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.deleteAction);
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.colorsAndFonts);
        }
        this.updateMenuEnablement();
    }

    public void updateMenuEnablement() {
        this.qouteRequest.setEnabled(this.getSelection().length == 1);
        this.mboAction.setEnabled(this.getSelection().length == 1);
        this.mbpAction.setEnabled(this.getSelection().length == 1);
        this.buyAction.setEnabled(this.getSelection().length == 1);
        this.sellAction.setEnabled(this.getSelection().length == 1);
    }

    public PreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void setLayout(int style) {
        if (this.layout != null) {
            this.layout.dispose();
        }
        switch (style) {
            case 0: {
                this.layout = new WatchlistTableViewer(this);
                break;
            }
            case 1: {
                this.layout = new WatchlistBoxViewer(this);
            }
        }
        this.tableLayout.setChecked(style == 0);
        this.ribbonLayout.setChecked(style == 1);
        this.watchlist.setStyle(style);
        CorePlugin.getRepository().save((PersistentObject)this.watchlist);
        this.layout.createPartControl(this.parent);
        this.layout.updateView(false);
        this.parent.layout();
    }

    public AbstractLayout getLayout() {
        return this.layout;
    }

    public Watchlist getWatchlist() {
        return this.watchlist;
    }

    public void setWatchlist(Watchlist watchlist) {
        this.watchlist = watchlist;
        this.setPartName("Sector Watch");
        this.layout.updateView(false);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.watchlist) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (WatchlistView.this.watchlist.getDescription().length() != 0 && !WatchlistView.this.watchlist.getDescription().equals(WatchlistView.this.getPartName())) {
                        WatchlistView.this.setPartName(WatchlistView.this.watchlist.getDescription());
                    }
                    WatchlistView.this.layout.updateView(false);
                    if (Resources.loginStatus && WatchlistView.this.watchlist.getWatchlistType() == 1) {
                        try {
                            WatchlistView.this.layout.populateSectorWatch();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        if (o instanceof WatchlistItem) {
            final WatchlistItem watchlistItem = (WatchlistItem)o;
            for (Alert alert : watchlistItem.getAlerts()) {
                AlertPlugin plugin = (AlertPlugin)alert.getData();
                if (plugin == null) {
                    plugin = TradingPlugin.createAlertPlugin(alert.getPluginId());
                    plugin.init(watchlistItem.getSecurity(), alert);
                    plugin.setLastSeen(alert.getLastSeen());
                    alert.setData((Object)plugin);
                }
                if (plugin == null || plugin.isSeenToday() || !plugin.apply()) continue;
                System.out.println("watch list alert $$$$$$$$$$%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                plugin.setLastSeen(Calendar.getInstance().getTime());
                alert.setLastSeen(plugin.getLastSeen());
                if (!alert.isHilight()) continue;
                final RGB foreground = plugin.getHilightForeground();
                final RGB background = plugin.getHilightBackground();
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WatchlistView.this.layout.tickAlert(watchlistItem, foreground, background);
                    }
                });
            }
        }
    }

    public void itemAdded(Object o) {
        if (o instanceof WatchlistItem) {
            WatchlistItem watchlistItem = (WatchlistItem)o;
            this.layout.itemAdded(o);
            Security security = watchlistItem.getSecurity();
            if (security != null && security.getQuoteFeed() != null) {
                FeedMonitor.monitor((Security)security);
            }
            for (Alert alert : watchlistItem.getAlerts()) {
                AlertPlugin plugin = (AlertPlugin)alert.getData();
                if (plugin != null) continue;
                plugin = TradingPlugin.createAlertPlugin(alert.getPluginId());
                plugin.init(watchlistItem.getSecurity(), alert);
                plugin.setLastSeen(alert.getLastSeen());
                alert.setData((Object)plugin);
            }
            watchlistItem.addObserver((Observer)this);
        }
    }

    public void itemRemoved(Object o) {
        if (o instanceof Security) {
            for (WatchlistItem type : this.watchlist.getItems()) {
                if (!type.getSecurity().equals((Object)((Security)o))) continue;
                this.itemRemoved(type);
            }
        }
        if (o instanceof WatchlistItem) {
            WatchlistItem watchlistItem = (WatchlistItem)o;
            watchlistItem.deleteObserver((Observer)this);
            this.layout.itemRemoved(o);
            Security security = watchlistItem.getSecurity();
            if (security != null && security.getQuoteFeed() != null) {
                FeedMonitor.cancelMonitor((Security)security);
            }
        }
    }

    void itemsDropped(Security[] securities, Point point) {
        int index = this.layout.getItemIndex(point);
        if (index == -1) {
            index = this.watchlist.getItems().size();
        }
        if (this.watchlist != null) {
            int i = 0;
            while (i < securities.length) {
                if (!this.isExist(securities[i])) {
                    WatchlistItem item = new WatchlistItem();
                    item.setParent(this.watchlist);
                    item.setSecurity(securities[i]);
                    this.watchlist.getItems().add(index++, (Object)item);
                }
                ++i;
            }
            CorePlugin.getRepository().save((PersistentObject)this.watchlist);
        }
    }

    void itemsDropped(WatchlistItem[] items, Point point) {
        int index = this.layout.getItemIndex(point);
        if (index == -1) {
            index = this.watchlist.getItems().size();
        }
        if (this.watchlist != null && items != null) {
            int i = 0;
            while (i < items.length) {
                if (!this.isExist(items[i].getSecurity())) {
                    items[i].setParent(this.watchlist);
                    this.watchlist.getItems().add(index++, (Object)items[i]);
                }
                ++i;
            }
            CorePlugin.getRepository().save((PersistentObject)this.watchlist);
        }
    }

    public boolean isExist(Security security) {
        return this.watchlist.isExists(security);
    }

    public WatchlistItem[] getSelection() {
        return this.layout.getSelection();
    }
}

