/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystemGroup;
import pk.com.softech.tradingterminal.core.ui.NullSelection;
import pk.com.softech.tradingterminal.core.ui.SelectionProvider;
import pk.com.softech.tradingterminal.core.ui.actions.DeleteAction;
import pk.com.softech.tradingterminal.core.ui.actions.PropertiesAction;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.TradingSystemGroupSelection;
import pk.com.softech.tradingterminal.trading.TradingSystemPlugin;
import pk.com.softech.tradingterminal.trading.TradingSystemSelection;
import pk.com.softech.tradingterminal.trading.dialogs.TestPeriodDialog;
import pk.com.softech.tradingterminal.trading.internal.TreeLayout;
import pk.com.softech.tradingterminal.trading.views.TestRunnerView;
import pk.com.softech.tradingterminal.trading.wizards.systems.TradingSystemSettingsDialog;
import pk.com.softech.tradingterminal.trading.wizards.systems.TradingSystemWizard;

public class TradingSystemView
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.views.system";
    private Tree tree;
    private NumberFormat amountFormat = NumberFormat.getInstance();
    private NumberFormat priceFormat = NumberFormat.getInstance();
    private SimpleDateFormat dateFormat = CorePlugin.getDateFormat();
    private Color evenForeground = new Color(null, 0, 0, 0);
    private Color evenBackground = new Color(null, 255, 255, 255);
    private Color oddForeground = new Color(null, 0, 0, 0);
    private Color oddBackground = new Color(null, 224, 224, 255);
    private Action createGroupAction;
    private Action createSystemAction;
    private Action deleteAction;
    private Action propertiesAction;
    private Action runTestAction;
    private Map expandMap = new HashMap();
    private TradingSystemTreeItemTransfer _tradingSystemTreeItemTransfer = new TradingSystemTreeItemTransfer();

    public TradingSystemView() {
        this.amountFormat.setGroupingUsed(true);
        this.amountFormat.setMinimumIntegerDigits(1);
        this.amountFormat.setMinimumFractionDigits(2);
        this.amountFormat.setMaximumFractionDigits(2);
        this.priceFormat.setGroupingUsed(true);
        this.priceFormat.setMinimumIntegerDigits(1);
        this.priceFormat.setMinimumFractionDigits(4);
        this.priceFormat.setMaximumFractionDigits(4);
    }

    public void init(IViewSite site) throws PartInitException {
        this.createGroupAction = new Action(){

            public void run() {
                InputDialog dlg = new InputDialog(TradingSystemView.this.getViewSite().getShell(), this.getText(), "Enter the name of the group to create:", null, null);
                if (dlg.open() == 0 && dlg.getValue() != null) {
                    TradingSystemGroup group = new TradingSystemGroup();
                    group.setDescription(dlg.getValue());
                    ISelection selection = TradingSystemView.this.getViewSite().getSelectionProvider().getSelection();
                    if (selection instanceof TradingSystemGroupSelection) {
                        group.setParent(((TradingSystemGroupSelection)selection).getGroup());
                    }
                    CorePlugin.getRepository().save((PersistentObject)group);
                }
            }
        };
        this.createGroupAction.setText("Create Group");
        this.createSystemAction = new Action(){

            public void run() {
                TradingSystemWizard wizard = new TradingSystemWizard();
                ISelection selection = TradingSystemView.this.getViewSite().getSelectionProvider().getSelection();
                if (selection instanceof TradingSystemGroupSelection) {
                    wizard.setGroup(((TradingSystemGroupSelection)selection).getGroup());
                }
                wizard.open();
            }
        };
        this.createSystemAction.setText("Create Trading System");
        this.createSystemAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/eview16/server_database.png"));
        this.deleteAction = new DeleteAction(){

            public void run() {
                TreeItem[] selection = TradingSystemView.this.tree.getSelection();
                if (selection.length != 0 && MessageDialog.openConfirm((Shell)TradingSystemView.this.getViewSite().getShell(), (String)TradingSystemView.this.getPartName(), (String)"Do you really want to delete the selected item(s) ?")) {
                    int i = 0;
                    while (i < selection.length) {
                        if (selection[i] instanceof TradingSystemItem) {
                            CorePlugin.getRepository().delete((PersistentObject)((TradingSystemItem)selection[i]).getSystem());
                        } else if (selection[i] instanceof GroupTreeItem) {
                            CorePlugin.getRepository().delete((PersistentObject)((GroupTreeItem)selection[i]).getGroup());
                        }
                        ++i;
                    }
                }
            }
        };
        this.propertiesAction = new PropertiesAction(){

            public void run() {
                TreeItem[] selection = TradingSystemView.this.tree.getSelection();
                if (selection.length == 1) {
                    if (selection[0] instanceof TradingSystemItem) {
                        TradingSystem system = ((TradingSystemItem)selection[0]).getSystem();
                        TradingSystemSettingsDialog dlg = new TradingSystemSettingsDialog(system, TradingSystemView.this.getViewSite().getShell());
                        dlg.open();
                    } else if (selection[0] instanceof GroupTreeItem) {
                        TradingSystemGroup group = ((GroupTreeItem)selection[0]).getGroup();
                        InputDialog dlg = new InputDialog(TradingSystemView.this.getViewSite().getShell(), "Edit Group", "Enter the name of the group to edit:", group.getDescription(), null);
                        if (dlg.open() == 0 && dlg.getValue() != null) {
                            group.setDescription(dlg.getValue());
                            CorePlugin.getRepository().save((PersistentObject)group);
                        }
                    }
                }
            }
        };
        this.runTestAction = new Action(){

            public void run() {
                TreeItem[] selection = TradingSystemView.this.tree.getSelection();
                if (selection.length == 1 && selection[0] instanceof TradingSystemItem) {
                    TradingSystem system = ((TradingSystemItem)selection[0]).getSystem();
                    TestPeriodDialog dlg = new TestPeriodDialog(TradingSystemView.this.getViewSite().getShell(), system.getSecurity().getHistory());
                    if (dlg.open() == 0) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            TestRunnerView view = (TestRunnerView)page.showView("pk.com.softech.tradingterminal.trading.test");
                            view.runTradingSystem(system, dlg.getBeginDate(), dlg.getEndDate());
                        }
                        catch (PartInitException e1) {
                            CorePlugin.logException((Exception)((Object)e1));
                        }
                    }
                }
            }
        };
        this.runTestAction.setText("Run Test");
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("internal.top"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("clipboard.top"));
        menuManager.add((IContributionItem)new Separator("clipboard.bottom"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.add((IContributionItem)new Separator("internal.bottom"));
        menuManager.appendToGroup("internal.top", (IAction)this.createGroupAction);
        menuManager.appendToGroup("internal.top", (IAction)this.createSystemAction);
        menuManager.appendToGroup("additions", (IAction)this.runTestAction);
        menuManager.appendToGroup("clipboard.bottom", (IAction)this.deleteAction);
        menuManager.appendToGroup("internal.bottom", (IAction)this.propertiesAction);
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("begin"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("group6"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("end"));
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        this.tree = new Tree(content, 65538);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(false);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TradingSystemView.this.updateSelection();
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TradingSystemView.this.tree.getItem(new Point(e.x, e.y)) == null) {
                    TradingSystemView.this.tree.deselectAll();
                    TradingSystemView.this.updateSelection();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                if (e.item instanceof GroupTreeItem) {
                    TradingSystemGroup group = ((GroupTreeItem)e.item).getGroup();
                    TradingSystemView.this.expandMap.remove(String.valueOf(group.getId()));
                }
                TradingSystemView.this.updateItemColors();
            }

            public void treeExpanded(TreeEvent e) {
                if (e.item instanceof GroupTreeItem) {
                    TradingSystemGroup group = ((GroupTreeItem)e.item).getGroup();
                    TradingSystemView.this.expandMap.put(String.valueOf(group.getId()), new Boolean(true));
                }
                TradingSystemView.this.updateItemColors();
            }
        });
        TreeLayout layout = new TreeLayout();
        this.tree.setLayout((Layout)layout);
        TreeColumn column = new TreeColumn(this.tree, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200, true, false));
        column = new TreeColumn(this.tree, 16384);
        column.setText("Account");
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true, false));
        column = new TreeColumn(this.tree, 131072);
        column.setText("Position");
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(60, true, false));
        column = new TreeColumn(this.tree, 16384);
        column.setText("Signal");
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(60, true, false));
        column = new TreeColumn(this.tree, 131072);
        column.setText("Date");
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(60, true, true));
        this.getSite().setSelectionProvider((ISelectionProvider)new SelectionProvider());
        DragSource dragSource = new DragSource((Control)this.tree, 3);
        dragSource.setTransfer(new Transfer[]{this._tradingSystemTreeItemTransfer});
        dragSource.addDragListener(new DragSourceListener(){
            private TreeItem[] selection;

            public void dragStart(DragSourceEvent event) {
                this.selection = TradingSystemView.this.tree.getSelection();
                if (this.selection.length == 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                int count = 0;
                int i = 0;
                while (i < this.selection.length) {
                    if (this.selection[i] instanceof TradingSystemItem) {
                        ++count;
                    }
                    ++i;
                }
                TradingSystemItem[] items = new TradingSystemItem[count];
                count = 0;
                int i2 = 0;
                while (i2 < this.selection.length) {
                    if (this.selection[i2] instanceof TradingSystemItem) {
                        items[count++] = (TradingSystemItem)this.selection[i2];
                    }
                    ++i2;
                }
                event.data = items;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        DropTarget target = new DropTarget((Control)parent, 3);
        target.setTransfer(new Transfer[]{this._tradingSystemTreeItemTransfer});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 1;
                }
                event.currentDataType = null;
                TransferData[] data = event.dataTypes;
                int i = 0;
                while (i < data.length) {
                    if (TradingSystemView.this._tradingSystemTreeItemTransfer.isSupportedType(data[i])) {
                        event.currentDataType = data[i];
                        break;
                    }
                    ++i;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
                TreeItem treeItem = TradingSystemView.this.tree.getItem(TradingSystemView.this.tree.toControl(event.x, event.y));
                if (treeItem != null) {
                    TreeItem[] selection = new TreeItem[]{treeItem};
                    TradingSystemView.this.tree.setSelection(selection);
                }
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                Integer[] items;
                if (TradingSystemView.this._tradingSystemTreeItemTransfer.isSupportedType(event.currentDataType) && (items = (Integer[])event.data) != null) {
                    TradingSystemGroup group = null;
                    TreeItem treeItem = TradingSystemView.this.tree.getItem(TradingSystemView.this.tree.toControl(event.x, event.y));
                    if (treeItem != null) {
                        if (treeItem instanceof GroupTreeItem) {
                            group = ((GroupTreeItem)treeItem).getGroup();
                        } else if (treeItem instanceof TradingSystemItem) {
                            group = ((TradingSystemItem)treeItem).getSystem().getGroup();
                        }
                    }
                    int i = 0;
                    while (i < items.length) {
                        TradingSystem system = (TradingSystem)CorePlugin.getRepository().load(TradingSystem.class, "" + items[i]);
                        CorePlugin.getRepository().delete((PersistentObject)system);
                        system.setGroup(group);
                        CorePlugin.getRepository().save((PersistentObject)system);
                        ++i;
                    }
                }
            }
        });
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("top"));
                menuManager.add((IContributionItem)new Separator("internal.top"));
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IContributionItem)new Separator("clipboard.top"));
                menuManager.add((IContributionItem)new Separator("clipboard.bottom"));
                menuManager.add((IContributionItem)new Separator("bottom"));
                menuManager.add((IContributionItem)new Separator("internal.bottom"));
                menuManager.appendToGroup("internal.top", (IAction)TradingSystemView.this.createGroupAction);
                menuManager.appendToGroup("internal.top", (IAction)TradingSystemView.this.createSystemAction);
                menuManager.appendToGroup("additions", (IAction)TradingSystemView.this.runTestAction);
                menuManager.appendToGroup("clipboard.bottom", (IAction)TradingSystemView.this.deleteAction);
                menuManager.appendToGroup("internal.bottom", (IAction)TradingSystemView.this.propertiesAction);
            }
        });
        this.tree.setMenu(menuMgr.createContextMenu((Control)this.tree));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(this.propertiesAction.getId(), (IAction)this.propertiesAction);
        IPreferenceStore preferenceStore = TradingPlugin.getDefault().getPreferenceStore();
        String[] values = preferenceStore.getString("TS_VIEW_EXPANDED_ITEMS").split(";");
        int i = 0;
        while (i < values.length) {
            this.expandMap.put(values[i], new Boolean(true));
            ++i;
        }
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TradingSystemView.this.updateView();
                TradingSystemView.this.updateSelection();
                CorePlugin.getRepository().getTradingSystemGroups().addCollectionObserver((ICollectionObserver)TradingSystemView.this);
                CorePlugin.getRepository().getTradingSystems().addCollectionObserver((ICollectionObserver)TradingSystemView.this);
            }
        });
    }

    public void setFocus() {
        this.tree.getParent().setFocus();
    }

    public void dispose() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.expandMap.keySet().iterator();
        while (iter.hasNext()) {
            if (sb.length() != 0) {
                sb.append(";");
            }
            sb.append((String)iter.next());
        }
        TradingPlugin.getDefault().getPreferenceStore().setValue("TS_VIEW_EXPANDED_ITEMS", sb.toString());
        CorePlugin.getRepository().getTradingSystemGroups().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().getTradingSystems().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    private void updateView() {
        this.tree.setRedraw(false);
        this.tree.removeAll();
        for (TradingSystemGroup group : CorePlugin.getRepository().getTradingSystemGroups()) {
            if (group.getParent() != null) continue;
            new GroupTreeItem(group, this.tree, 0);
        }
        for (TradingSystem system : CorePlugin.getRepository().getTradingSystems()) {
            if (system.getGroup() != null) continue;
            new TradingSystemItem(system, this.tree, 0);
        }
        this.tree.setRedraw(true);
        int index = 0;
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            index = this.updateItemColors(items[i], index);
            ++i;
        }
    }

    private void updateSelection() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection != null && selection.length == 1) {
            if (selection[0] instanceof TradingSystemItem) {
                this.getSite().getSelectionProvider().setSelection((ISelection)new TradingSystemSelection(((TradingSystemItem)selection[0]).getSystem()));
            } else if (selection[0] instanceof GroupTreeItem) {
                this.getSite().getSelectionProvider().setSelection((ISelection)new TradingSystemGroupSelection(((GroupTreeItem)selection[0]).getGroup()));
            } else {
                this.getSite().getSelectionProvider().setSelection((ISelection)new NullSelection());
            }
        } else {
            this.getSite().getSelectionProvider().setSelection((ISelection)new NullSelection());
        }
        this.deleteAction.setEnabled(selection.length != 0);
        this.runTestAction.setEnabled(selection.length == 1);
        this.propertiesAction.setEnabled(selection.length == 1);
    }

    public void itemAdded(Object o) {
        TradingSystemGroup group;
        if (o instanceof TradingSystem) {
            TradingSystem system = (TradingSystem)o;
            if (system.getGroup() == null) {
                new TradingSystemItem(system, this.tree, 0);
            }
        } else if (o instanceof TradingSystemGroup && (group = (TradingSystemGroup)o).getParent() == null) {
            new GroupTreeItem(group, this.tree, 0);
        }
        this.updateItemColors();
    }

    public void itemRemoved(Object o) {
        if (o instanceof TradingSystem) {
            TradingSystem object = (TradingSystem)o;
            TreeItem[] items = this.tree.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof TradingSystemItem && ((TradingSystemItem)items[i]).getSystem().equals((Object)object)) {
                    items[i].dispose();
                }
                ++i;
            }
        } else if (o instanceof TradingSystemGroup) {
            TradingSystemGroup object = (TradingSystemGroup)o;
            TreeItem[] items = this.tree.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i] instanceof GroupTreeItem && ((GroupTreeItem)items[i]).getGroup().equals((Object)object)) {
                    items[i].dispose();
                }
                ++i;
            }
        }
        this.updateItemColors();
    }

    private void updateItemColors() {
        this.tree.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TradingSystemView.this.tree.isDisposed()) {
                    int index = 0;
                    TreeItem[] items = TradingSystemView.this.tree.getItems();
                    int i = 0;
                    while (i < items.length) {
                        index = TradingSystemView.this.updateItemColors(items[i], index);
                        ++i;
                    }
                }
            }
        });
    }

    private int updateItemColors(TreeItem treeItem, int index) {
        treeItem.setBackground((index & 1) == 0 ? this.evenBackground : this.oddBackground);
        treeItem.setForeground((index & 1) == 0 ? this.evenForeground : this.oddForeground);
        ++index;
        if (treeItem instanceof GroupTreeItem && this.expandMap.get(String.valueOf(((GroupTreeItem)treeItem).getGroup().getId())) != null) {
            treeItem.setExpanded(true);
        }
        if (treeItem.getExpanded()) {
            TreeItem[] items = treeItem.getItems();
            int i = 0;
            while (i < items.length) {
                index = this.updateItemColors(items[i], index);
                ++i;
            }
        }
        return index;
    }

    public class GroupTreeItem
    extends TreeItem
    implements ICollectionObserver,
    Observer {
        TradingSystemGroup group;

        public GroupTreeItem(TradingSystemGroup group, Tree parent, int style, int index) {
            super(parent, style, index);
            this.init(group);
        }

        public GroupTreeItem(TradingSystemGroup group, Tree parent, int style) {
            super(parent, style);
            this.init(group);
        }

        public GroupTreeItem(TradingSystemGroup group, TreeItem parentItem, int style, int index) {
            super(parentItem, style, index);
            this.init(group);
        }

        public GroupTreeItem(TradingSystemGroup group, TreeItem parentItem, int style) {
            super(parentItem, style);
            this.init(group);
        }

        protected void init(TradingSystemGroup group) {
            this.group = group;
            this.group.addObserver((Observer)this);
            this.group.getGroups().addCollectionObserver((ICollectionObserver)this);
            this.group.getTradingSystems().addCollectionObserver((ICollectionObserver)this);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    GroupTreeItem.this.group.deleteObserver((Observer)GroupTreeItem.this);
                    GroupTreeItem.this.group.getGroups().removeCollectionObserver((ICollectionObserver)GroupTreeItem.this);
                    GroupTreeItem.this.group.getTradingSystems().removeCollectionObserver((ICollectionObserver)GroupTreeItem.this);
                }
            });
            FontData fd = this.getFont().getFontData()[0];
            Font font = new Font(null, fd.getName(), fd.getHeight(), 1);
            this.setFont(font);
            this.setText(0, group.getDescription());
            Iterator iter = this.group.getGroups().iterator();
            while (iter.hasNext()) {
                new GroupTreeItem((TradingSystemGroup)iter.next(), this, 0);
            }
            iter = this.group.getTradingSystems().iterator();
            while (iter.hasNext()) {
                new TradingSystemItem((TradingSystem)iter.next(), this, 0);
            }
        }

        protected void checkSubclass() {
        }

        public void itemAdded(Object o) {
            if (o instanceof TradingSystem) {
                new TradingSystemItem((TradingSystem)o, this, 0);
            } else if (o instanceof TradingSystemGroup) {
                new GroupTreeItem((TradingSystemGroup)o, this, 0);
            }
        }

        public void itemRemoved(Object o) {
            block5: {
                block4: {
                    if (!(o instanceof TradingSystem)) break block4;
                    TradingSystem object = (TradingSystem)o;
                    TreeItem[] items = this.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i] instanceof TradingSystemItem && ((TradingSystemItem)items[i]).getSystem().equals((Object)object)) {
                            items[i].dispose();
                        }
                        ++i;
                    }
                    break block5;
                }
                if (!(o instanceof TradingSystemGroup)) break block5;
                TradingSystemGroup object = (TradingSystemGroup)o;
                TreeItem[] items = this.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i] instanceof GroupTreeItem && ((GroupTreeItem)items[i]).getGroup().equals((Object)object)) {
                        items[i].dispose();
                    }
                    ++i;
                }
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!GroupTreeItem.this.isDisposed()) {
                        GroupTreeItem.this.setText(0, GroupTreeItem.this.group.getDescription());
                    }
                }
            });
        }

        public TradingSystemGroup getGroup() {
            return this.group;
        }
    }

    public class TradingSystemItem
    extends TreeItem
    implements Observer {
        TradingSystem system;
        TradingSystemPlugin plugin;

        public TradingSystemItem(TradingSystem system, Tree parent, int style, int index) {
            super(parent, style, index);
            this.init(system);
        }

        public TradingSystemItem(TradingSystem system, Tree parent, int style) {
            super(parent, style);
            this.init(system);
        }

        public TradingSystemItem(TradingSystem system, TreeItem parentItem, int style, int index) {
            super(parentItem, style, index);
            this.init(system);
        }

        public TradingSystemItem(TradingSystem system, TreeItem parentItem, int style) {
            super(parentItem, style);
            this.init(system);
        }

        protected void checkSubclass() {
        }

        private void init(TradingSystem system) {
            this.system = system;
            this.system.addObserver((Observer)this);
            this.plugin = TradingPlugin.createTradingSystemPlugin(system);
            this.plugin.addObserver(this);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TradingSystemItem.this.system.deleteObserver((Observer)TradingSystemItem.this);
                    TradingSystemItem.this.plugin.deleteObserver(TradingSystemItem.this);
                }
            });
            this.setText(0, system.getSecurity().getDescription());
            this.setText(1, system.getAccount().getDescription());
            this.setText(2, String.valueOf(system.getAccount().getPosition(system.getSecurity())));
            if (system.getSignal() == 1) {
                this.setText(3, "Buy");
            } else if (system.getSignal() == 2) {
                this.setText(3, "Sell");
            } else if (system.getSignal() == 3) {
                this.setText(3, "Hold");
            } else {
                this.setText(3, "");
            }
            this.setText(4, system.getDate() != null ? TradingSystemView.this.dateFormat.format(system.getDate()) : "");
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o == this.plugin) {
                this.system.setDate(Calendar.getInstance().getTime());
                this.system.setSignal(this.plugin.getSignal());
            }
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!TradingSystemItem.this.isDisposed()) {
                        TradingSystemItem.this.setText(0, TradingSystemItem.this.system.getSecurity().getDescription());
                        TradingSystemItem.this.setText(1, TradingSystemItem.this.system.getAccount().getDescription());
                        TradingSystemItem.this.setText(2, String.valueOf(TradingSystemItem.this.system.getAccount().getPosition(TradingSystemItem.this.system.getSecurity())));
                        if (TradingSystemItem.this.system.getSignal() == 1) {
                            TradingSystemItem.this.setText(3, "Buy");
                        } else if (TradingSystemItem.this.system.getSignal() == 2) {
                            TradingSystemItem.this.setText(3, "Sell");
                        } else if (TradingSystemItem.this.system.getSignal() == 3) {
                            TradingSystemItem.this.setText(3, "Hold");
                        } else {
                            TradingSystemItem.this.setText(3, "");
                        }
                        TradingSystemItem.this.setText(4, TradingSystemItem.this.system.getDate() != null ? TradingSystemView.this.dateFormat.format(TradingSystemItem.this.system.getDate()) : "");
                    }
                }
            });
        }

        public TradingSystem getSystem() {
            return this.system;
        }
    }

    public class TradingSystemTreeItemTransfer
    extends ByteArrayTransfer {
        private final String TYPENAME = TradingSystemItem.class.getName();
        private final int TYPEID = TradingSystemTreeItemTransfer.registerType((String)this.TYPENAME);

        private TradingSystemTreeItemTransfer() {
        }

        protected String[] getTypeNames() {
            return new String[]{this.TYPENAME};
        }

        protected int[] getTypeIds() {
            return new int[]{this.TYPEID};
        }

        protected void javaToNative(Object object, TransferData transferData) {
            if (!this.checkMyType(object) || !this.isSupportedType(transferData)) {
                DND.error((int)2003);
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream writeOut = new ObjectOutputStream(out);
                if (object instanceof TradingSystemItem) {
                    writeOut.writeInt(1);
                    writeOut.writeObject(((TradingSystemItem)object).getSystem().getId());
                } else if (object instanceof TradingSystemItem[]) {
                    TradingSystemItem[] array = (TradingSystemItem[])object;
                    writeOut.writeInt(array.length);
                    int i = 0;
                    while (i < array.length) {
                        writeOut.writeObject(array[i].getSystem().getId());
                        ++i;
                    }
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException e) {
                CorePlugin.logException((Exception)e);
            }
        }

        protected Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    ObjectInputStream readIn = new ObjectInputStream(in);
                    int length = readIn.readInt();
                    Integer[] security = new Integer[length];
                    int i = 0;
                    while (i < length) {
                        security[i] = (Integer)readIn.readObject();
                        ++i;
                    }
                    readIn.close();
                    return security;
                }
                catch (Exception e) {
                    CorePlugin.logException((Exception)e);
                }
            }
            return null;
        }

        private boolean checkMyType(Object object) {
            return object instanceof TradingSystemItem || object instanceof TradingSystemItem[];
        }
    }
}

