/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.TradeLogRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.db.OrderStatus;
import pk.com.softech.tradingterminal.core.db.Trade;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;
import pk.com.softech.tradingterminal.core.ui.actions.EditColumnsAction;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.ColumnsOptionDialog;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class TradesView
extends ViewPart
implements IPropertyChangeListener,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.trades";
    public static final String PREFS_TRADES_VIEW_COLUMNS = "TRADES_VIEW_COLUMNS";
    public static final String PREFS_TRADES_VIEW_COLUMNS_SIZE = "TRADES_VIEW_COLUMNS_SIZE";
    Composite parent;
    CTabFolder tabFolder;
    TradesTable all;
    IPreferenceStore preferences;
    String VIEW_NAME = "Trades";
    Action totalTradesAction;
    int tradeCount = 0;
    public static final String PREFS_FILLED_BUY_FG = "FILLED_TRD_BUY_FG";
    public static final String PREFS_FILLED_BUY_BG = "FILLED_TRD_BUY_BG";
    public static final String PREFS_FILLED_SELL_FG = "FILLED_TRD_SELL_FG";
    public static final String PREFS_FILLED_SELL_BG = "FILLED_TRD_SELL_BG";
    public static final String PREFS_TABLE_BG = "TABLE_TRD_BG";
    public static final String PREFS_TABLE_FONT = "TABLE_TRD_FONT";
    private Color filledBuyForegroundColor;
    private Color filledBuyBackgroundColor;
    private Color filledSellForegroundColor;
    private Color filledSellBackgroundColor;
    ITheme theme;
    Action refreshAction;
    Action editColumnsAction;
    LabelProvidersRegistry registry = new LabelProvidersRegistry("pk.com.softech.tradingterminal.trading.trades");
    private Log logger = LogFactory.getLog(this.getClass());
    IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            TradesTable trdTable = (TradesTable)TradesView.this.tabFolder.getSelection().getData();
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                TradesView.this.setTheme((ITheme)event.getNewValue());
            } else if (event.getProperty().equals(TradesView.PREFS_TABLE_BG)) {
                Control[] list = TradesView.this.tabFolder.getTabList();
                int i = 0;
                while (i < list.length) {
                    if (list[i] instanceof Table) {
                        Table t = (Table)list[i];
                        t.setBackground(TradesView.this.theme.getColorRegistry().get(TradesView.PREFS_TABLE_BG));
                    }
                    ++i;
                }
            } else if (event.getProperty().equals(TradesView.PREFS_TABLE_FONT)) {
                Control[] list = TradesView.this.tabFolder.getTabList();
                int i = 0;
                while (i < list.length) {
                    if (list[i] instanceof Table) {
                        Table t = (Table)list[i];
                        t.setFont(TradesView.this.theme.getFontRegistry().get(TradesView.PREFS_TABLE_FONT));
                    }
                    ++i;
                }
            } else if (event.getProperty().equals(TradesView.PREFS_FILLED_BUY_FG)) {
                TradesView.this.filledBuyForegroundColor = TradesView.this.theme.getColorRegistry().get(TradesView.PREFS_FILLED_BUY_FG);
                trdTable.updateTable();
            } else if (event.getProperty().equals(TradesView.PREFS_FILLED_BUY_BG)) {
                TradesView.this.filledBuyBackgroundColor = TradesView.this.theme.getColorRegistry().get(TradesView.PREFS_FILLED_BUY_BG);
                trdTable.updateTable();
            } else if (event.getProperty().equals(TradesView.PREFS_FILLED_SELL_FG)) {
                TradesView.this.filledSellForegroundColor = TradesView.this.theme.getColorRegistry().get(TradesView.PREFS_FILLED_SELL_FG);
                trdTable.updateTable();
            } else if (event.getProperty().equals(TradesView.PREFS_FILLED_SELL_BG)) {
                TradesView.this.filledSellBackgroundColor = TradesView.this.theme.getColorRegistry().get(TradesView.PREFS_FILLED_SELL_BG);
                trdTable.updateTable();
            }
        }
    };

    protected void setTheme(ITheme theme) {
        TradesTable trdTable = (TradesTable)this.tabFolder.getSelection().getData();
        if (theme != null) {
            Table t;
            this.theme = theme;
            Control[] list = this.tabFolder.getTabList();
            int i = 0;
            while (i < list.length) {
                if (list[i] instanceof Table) {
                    t = (Table)list[i];
                    t.setBackground(theme.getColorRegistry().get(PREFS_TABLE_BG));
                }
                ++i;
            }
            i = 0;
            while (i < list.length) {
                if (list[i] instanceof Table) {
                    t = (Table)list[i];
                    t.setFont(theme.getFontRegistry().get(PREFS_TABLE_FONT));
                }
                ++i;
            }
            this.filledBuyForegroundColor = theme.getColorRegistry().get(PREFS_FILLED_BUY_FG);
            this.filledBuyBackgroundColor = theme.getColorRegistry().get(PREFS_FILLED_BUY_BG);
            this.filledSellForegroundColor = theme.getColorRegistry().get(PREFS_FILLED_SELL_FG);
            this.filledSellBackgroundColor = theme.getColorRegistry().get(PREFS_FILLED_SELL_BG);
            trdTable.updateTable();
            theme.addPropertyChangeListener(this.themeChangeListener);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
        Resources.supportServerMessage.addObserver((Observer)this);
        this.VIEW_NAME = this.getPartName();
        super.init(site);
        this.totalTradesAction = new Action("Total Trades", 1){

            public void run() {
            }
        };
        this.totalTradesAction.setText("Total Orders : " + this.tradeCount);
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        ToolBarManager toolbarManager = (ToolBarManager)bars.getToolBarManager();
        toolbarManager.add((IAction)this.totalTradesAction);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.tabFolder = new CTabFolder(content, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText("All");
        this.all = new TradesTable((Composite)this.tabFolder, new ArrayList());
        tabItem.setControl((Control)this.all.getControl());
        tabItem.setData((Object)this.all);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder folder = (CTabFolder)e.getSource();
                CTabItem item = folder.getSelection();
                TradesTable tab = (TradesTable)item.getData();
                tab.updateTable();
                TradesView.this.updateActionsEnablement();
            }
        });
        this.tabFolder.setSelection(0);
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        this.setTheme(theme);
        this.all.updateTable();
        this.makeViewActions();
        this.contributeToActionBar();
        this.updateActionsEnablement();
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    TradesView.this.sendTradeLogRequest();
                } else {
                    TradesView.this.clearFields();
                }
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refreshh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
        this.editColumnsAction = new EditColumnsAction((Dialog)new ColumnsOptionDialog((IViewPart)this, PREFS_TRADES_VIEW_COLUMNS, PREFS_TRADES_VIEW_COLUMNS_SIZE, this.preferences));
    }

    private void sendTradeLogRequest() {
        this.updateActionsEnablement();
        this.logger.info((Object)("Sending tradeLog Request for exchange " + Utility.getClientExchanges((Vector)Resources.exchangeCodes)));
        TradeLogRequest trdLogRequest = new TradeLogRequest();
        trdLogRequest.setStExCode(Utility.getClientExchanges((Vector)Resources.exchangeCodes));
        Resources.sendToAllMS((Message)trdLogRequest);
        this.clearFields();
    }

    private void clearFields() {
        CorePlugin.getRepository().allTrades().clear();
    }

    private void contributeToActionBar() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.appendToGroup("top", (IAction)this.editColumnsAction);
        menuManager.appendToGroup("top", (IAction)new ResizeColumnsAction((Table)this.tabFolder.getSelection().getControl()));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
        toolBarManager.appendToGroup("bottom", (IAction)this.refreshAction);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.preferences.removePropertyChangeListener((IPropertyChangeListener)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        if (theme != null) {
            theme.removePropertyChangeListener(this.themeChangeListener);
        }
        super.dispose();
    }

    void updateActionsEnablement() {
    }

    Order[] getSelectedOrders() {
        ArrayList<Trade> orders = new ArrayList<Trade>();
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            Table table = (Table)item.getControl();
            int[] selection = table.getSelectionIndices();
            TradesTable ordersTable = (TradesTable)table.getData();
            int i = 0;
            while (i < selection.length) {
                orders.add(ordersTable.list.get(selection[i]));
                ++i;
            }
        }
        return orders.toArray(new Order[orders.size()]);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(PREFS_TRADES_VIEW_COLUMNS)) {
            this.all.updateTable();
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TradesView.this.sendTradeLogRequest();
                }
            });
        }
    }

    public class TradesTable
    implements ICollectionObserver,
    Observer {
        boolean columnMove = false;
        Table table;
        List<OrderStatus> filter = new ArrayList<OrderStatus>();
        List<Trade> list = new ArrayList<Trade>();
        int sortColumn = -1;
        int sortDirection = -1;
        private ControlListener columnControlListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                StringBuffer sizes = new StringBuffer();
                int i = 0;
                while (i < TradesTable.this.table.getColumnCount()) {
                    sizes.append(String.valueOf(String.valueOf(TradesTable.this.table.getColumn(i).getWidth())) + ";");
                    ++i;
                }
                ((TradesTable)TradesTable.this).TradesView.this.preferences.setValue(TradesView.PREFS_TRADES_VIEW_COLUMNS_SIZE, sizes.toString());
            }

            public void controlMoved(ControlEvent e) {
                if (!TradesTable.this.columnMove) {
                    return;
                }
                int[] ord = TradesTable.this.table.getColumnOrder();
                int[] newOrd = new int[ord.length];
                StringBuffer ids = new StringBuffer();
                int i = 0;
                while (i < TradesTable.this.table.getColumnCount()) {
                    newOrd[i] = i;
                    TableColumn col = TradesTable.this.table.getColumn(ord[i]);
                    ids.append(col.getData("columnId") + ";");
                    ++i;
                }
                TradesTable.this.table.setColumnOrder(newOrd);
                ((TradesTable)TradesTable.this).TradesView.this.preferences.setValue(TradesView.PREFS_TRADES_VIEW_COLUMNS, ids.toString());
            }
        };
        SelectionListener columnSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TradesTable.this.table.indexOf((TableColumn)e.widget);
                if (TradesTable.this.sortColumn == index) {
                    TradesTable.this.sortDirection = TradesTable.this.sortDirection == 0 ? 1 : 0;
                } else {
                    TradesTable.this.sortColumn = index;
                    TradesTable.this.sortDirection = 0;
                }
                TradesTable.this.updateTable();
            }
        };
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Object provider;
                if (TradesTable.this.sortColumn >= 0 && TradesTable.this.sortColumn < TradesTable.this.table.getColumnCount() && (provider = TradesTable.this.table.getColumn(TradesTable.this.sortColumn).getData("labelProvider")) instanceof Comparator) {
                    if (TradesTable.this.sortDirection == 0) {
                        return ((Comparator)provider).compare(arg0, arg1);
                    }
                    return ((Comparator)provider).compare(arg1, arg0);
                }
                return 0;
            }
        };

        public TradesTable(Composite parent, List filter) {
            CorePlugin.getRepository().allTrades().addCollectionObserver((ICollectionObserver)this);
            this.filter = filter;
            this.table = new Table(parent, 65538);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CorePlugin.getRepository().allTrades().removeCollectionObserver((ICollectionObserver)TradesTable.this);
                    for (Trade trade : TradesTable.this.list) {
                        trade.deleteObserver((Observer)TradesTable.this);
                    }
                }
            });
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TradesView.this.updateActionsEnablement();
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (TradesTable.this.table.getItem(new Point(e.x, e.y)) == null) {
                        TradesTable.this.table.deselectAll();
                    }
                }
            });
            this.table.addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    event.gc.setBackground(((TableItem)event.item).getBackground());
                    event.gc.fillRectangle(event.getBounds());
                }
            });
            this.table.setData((Object)this);
            MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager menuManager) {
                    menuManager.add((IContributionItem)new Separator("top"));
                }
            });
            this.table.setMenu(menuMgr.createContextMenu((Control)this.table));
            TradesView.this.getSite().registerContextMenu(menuMgr, TradesView.this.getSite().getSelectionProvider());
            Trade[] trade = (Trade[])CorePlugin.getRepository().allTrades().toArray((Object[])new Trade[0]);
            int i = 0;
            while (i < trade.length) {
                if (filter.size() == 0 || filter.contains(trade[i].getStatus())) {
                    this.list.add(trade[i]);
                }
                ++i;
            }
            this.updateTable();
        }

        public Table getControl() {
            return this.table;
        }

        public void updateTable() {
            TradesView.this.tradeCount = 0;
            this.columnMove = false;
            if (this.table != null && !this.table.isDisposed()) {
                int index = 0;
                String[] id = TradesView.this.preferences.getString(TradesView.PREFS_TRADES_VIEW_COLUMNS).split(";");
                int i = 0;
                while (i < id.length) {
                    TableColumn tableColumn;
                    String name = "";
                    int style = 16384;
                    Image image = null;
                    ILabelProvider provider = TradesView.this.registry.createLabelProvider(id[i]);
                    if (provider != null) {
                        name = TradesView.this.registry.getName(id[i]);
                        style = TradesView.this.registry.getOrientation(id[i]);
                        if (provider instanceof ITableLabelProvider) {
                            name = ((ITableLabelProvider)provider).getColumnText(null, i);
                            image = ((ITableLabelProvider)provider).getColumnImage(null, i);
                        }
                    } else {
                        LogFactory.getLog(this.getClass()).warn((Object)("Missing column [" + id[i] + "]"));
                    }
                    if (index < this.table.getColumnCount()) {
                        tableColumn = this.table.getColumn(index);
                        if (tableColumn.getData("labelProvider") != null) {
                            ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                        }
                    } else {
                        tableColumn = new TableColumn(this.table, style);
                        tableColumn.addControlListener(this.columnControlListener);
                        tableColumn.addSelectionListener(this.columnSelectionListener);
                        tableColumn.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (e.widget.getData("labelProvider") != null) {
                                    ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                                }
                            }
                        });
                    }
                    tableColumn.setText(name);
                    tableColumn.setAlignment(style);
                    tableColumn.setMoveable(true);
                    tableColumn.setImage(image);
                    tableColumn.setData("labelProvider", (Object)provider);
                    tableColumn.setData("columnId", (Object)id[i]);
                    ++index;
                    ++i;
                }
                while (index < this.table.getColumnCount()) {
                    this.table.getColumn(index).dispose();
                }
                if (this.sortColumn >= 0 && this.sortColumn < this.table.getColumnCount()) {
                    this.table.setSortColumn(this.table.getColumn(this.sortColumn));
                    this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                    Collections.sort(this.list, this.comparator);
                } else {
                    this.table.setSortColumn(null);
                    this.sortColumn = -1;
                    this.sortDirection = 0;
                }
                this.table.removeAll();
                Iterator<Trade> iter = this.list.iterator();
                while (iter.hasNext()) {
                    ++TradesView.this.tradeCount;
                    Trade trade = iter.next();
                    TableItem tableItem = new TableItem(this.table, 0);
                    this.update(tableItem, trade);
                    trade.addObserver((Observer)this);
                }
                TradesView.this.totalTradesAction.setText("Total Trades : " + TradesView.this.tradeCount);
                String[] sizes = TradesView.this.preferences.getString(TradesView.PREFS_TRADES_VIEW_COLUMNS_SIZE).split(";");
                int i2 = 0;
                while (i2 < this.table.getColumnCount()) {
                    if (i2 < sizes.length && sizes[i2].length() != 0) {
                        this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
                    } else {
                        this.table.getColumn(i2).setWidth(100);
                    }
                    ++i2;
                }
                if ("gtk".equals(SWT.getPlatform())) {
                    this.table.getColumn(this.table.getColumnCount() - 1).pack();
                }
            }
            this.columnMove = true;
        }

        void update(TableItem tableItem, Trade trade) {
            int i = 0;
            while (i < this.table.getColumnCount()) {
                TableColumn tableColumn = this.table.getColumn(i);
                ILabelProvider label = (ILabelProvider)tableColumn.getData("labelProvider");
                if (label != null) {
                    tableItem.setText(i, label.getText((Object)trade));
                    Image image = label.getImage((Object)trade);
                    if (image != tableItem.getImage(i)) {
                        tableItem.setImage(image);
                    }
                }
                ++i;
            }
            TradesView.this.totalTradesAction.setText("Total Orders : " + TradesView.this.tradeCount);
            if (trade.getSide().getValue() == 0) {
                tableItem.setBackground(TradesView.this.filledBuyBackgroundColor);
                tableItem.setForeground(TradesView.this.filledBuyForegroundColor);
            } else if (1 == trade.getSide().getValue()) {
                tableItem.setBackground(TradesView.this.filledSellBackgroundColor);
                tableItem.setForeground(TradesView.this.filledSellForegroundColor);
            } else {
                tableItem.setForeground(null);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            final Trade trade = (Trade)o;
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int index = TradesTable.this.list.indexOf(trade);
                    if (index != -1 && !TradesTable.this.table.isDisposed()) {
                        TableItem tableItem = TradesTable.this.table.getItem(index);
                        if (TradesTable.this.filter.size() != 0 && !TradesTable.this.filter.contains(trade.getStatus())) {
                            tableItem.dispose();
                            TradesTable.this.list.remove(trade);
                        } else {
                            TradesTable.this.update(tableItem, trade);
                        }
                    }
                    if ("gtk".equals(SWT.getPlatform())) {
                        TradesTable.this.table.getColumn(TradesTable.this.table.getColumnCount() - 1).pack();
                    }
                }
            });
        }

        public void itemAdded(Object o) {
            try {
                if (o instanceof Trade) {
                    final Trade trade = (Trade)o;
                    if (this.filter.size() == 0 || this.filter.contains(trade.getStatus())) {
                        this.list.add(trade);
                        TradesView.this.tradeCount = CorePlugin.getRepository().allTrades().size();
                        if (this.list.indexOf(trade) != -1) {
                            this.table.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (!TradesTable.this.table.isDisposed()) {
                                            TableItem tableItem = new TableItem(TradesTable.this.table, 0);
                                            TradesTable.this.table.showItem(tableItem);
                                            TradesTable.this.update(tableItem, trade);
                                            trade.addObserver((Observer)TradesTable.this);
                                            if ("gtk".equals(SWT.getPlatform())) {
                                                TradesTable.this.table.getColumn(TradesTable.this.table.getColumnCount() - 1).pack();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        TradesView.this.logger.error((Object)"", (Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void itemRemoved(Object o) {
            try {
                final Trade trade = (Trade)o;
                trade.deleteObserver((Observer)this);
                if (this.list.indexOf(trade) != -1) {
                    this.table.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            int index = TradesTable.this.list.indexOf(trade);
                            if (!TradesTable.this.table.isDisposed() && index != -1 && index < TradesTable.this.table.getItemCount()) {
                                TradesTable.this.table.getItem(index).dispose();
                                TradesTable.this.list.remove(index);
                                if ("gtk".equals(SWT.getPlatform())) {
                                    TradesTable.this.table.getColumn(TradesTable.this.table.getColumnCount() - 1).pack();
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

