/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.db.Account;
import pk.com.softech.tradingterminal.core.db.Bar;
import pk.com.softech.tradingterminal.core.db.DefaultAccount;
import pk.com.softech.tradingterminal.core.db.History;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.Transaction;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.core.db.trading.TradingSystem;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.TradingSystemPlugin;
import pk.com.softech.tradingterminal.trading.internal.TestProgressBar;
import pk.com.softech.tradingterminal.trading.views.CounterPanel;

public class TestRunnerView
extends ViewPart {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.test";
    protected TestProgressBar fProgressBar;
    protected CounterPanel fCounterPanel;
    protected Table fLog;
    protected Text fDetails;
    private SimpleDateFormat dateFormatter = CorePlugin.getDateFormat();
    private NumberFormat priceFormatter = NumberFormat.getInstance();
    private NumberFormat amountFormatter = NumberFormat.getInstance();
    private NumberFormat numberFormatter = NumberFormat.getInstance();
    private NumberFormat percentFormatter = NumberFormat.getInstance();

    public TestRunnerView() {
        this.priceFormatter.setGroupingUsed(true);
        this.priceFormatter.setMinimumIntegerDigits(1);
        this.priceFormatter.setMinimumFractionDigits(4);
        this.priceFormatter.setMaximumFractionDigits(4);
        this.amountFormatter.setGroupingUsed(true);
        this.amountFormatter.setMinimumIntegerDigits(1);
        this.amountFormatter.setMinimumFractionDigits(2);
        this.amountFormatter.setMaximumFractionDigits(2);
        this.numberFormatter.setGroupingUsed(true);
        this.numberFormatter.setMinimumIntegerDigits(1);
        this.numberFormatter.setMinimumFractionDigits(0);
        this.numberFormatter.setMaximumFractionDigits(0);
        this.percentFormatter.setGroupingUsed(true);
        this.percentFormatter.setMinimumIntegerDigits(1);
        this.percentFormatter.setMinimumFractionDigits(2);
        this.percentFormatter.setMaximumFractionDigits(2);
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        this.fCounterPanel = new CounterPanel(content);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new TestProgressBar(content);
        this.fProgressBar.setLayoutData(new GridData(768));
        SashForm sashForm = new SashForm(content, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ViewForm left = new ViewForm((Composite)sashForm, 0);
        CLabel label = new CLabel((Composite)left, 0);
        label.setText("Log");
        left.setTopLeft((Control)label);
        this.fLog = new Table((Composite)left, 65540);
        new TableColumn(this.fLog, 16384);
        new TableColumn(this.fLog, 16384);
        new TableColumn(this.fLog, 16384);
        this.fLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestRunnerView.this.updateDetails();
            }
        });
        left.setContent((Control)this.fLog);
        ViewForm right = new ViewForm((Composite)sashForm, 0);
        label = new CLabel((Composite)right, 0);
        label.setText("Details");
        right.setTopLeft((Control)label);
        this.fDetails = new Text((Composite)right, 2818);
        right.setContent((Control)this.fDetails);
        sashForm.setWeights(new int[]{50, 50});
    }

    public void setFocus() {
    }

    public void runTradingSystem(TradingSystem system, Date begin, Date end) {
        this.fProgressBar.reset();
        this.fCounterPanel.reset();
        this.fLog.removeAll();
        this.fDetails.setText("");
        SimulatorJob job = new SimulatorJob(system, begin, end);
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    private void updateDetails() {
        TableItem[] selection = this.fLog.getSelection();
        Transaction transaction = (Transaction)selection[0].getData();
        if (transaction != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(String.valueOf(this.dateFormatter.format(transaction.getDate())) + "\r\n");
            sb.append(transaction.getQuantity() > 0 ? "Buy\r\n" : "Sell\r\n");
            sb.append("Quantity: " + this.numberFormatter.format(Math.abs(transaction.getQuantity())) + "\r\n");
            sb.append("Expenses: " + this.amountFormatter.format(Math.abs(transaction.getExpenses())) + "\r\n");
            sb.append("Total: " + this.amountFormatter.format(Math.abs(transaction.getAmount())) + "\r\n");
            if (transaction.getData() != null) {
                Transaction ref = (Transaction)transaction.getData();
                sb.append("\r\nClosing position opened on " + this.dateFormatter.format(ref.getDate()) + "\r\n");
                sb.append("Gain: " + this.amountFormatter.format(Math.abs(transaction.getAmount()) - Math.abs(ref.getAmount())) + "\r\n");
            }
            this.fDetails.setText(sb.toString());
        } else {
            this.fDetails.setText("");
        }
    }

    private class SimulatorJob
    extends Job {
        private Account account;
        private Security security;
        private History original;
        private History history;
        private TradingSystemPlugin plugin;
        private int signals;
        private int successCount;
        private int failureCount;
        private boolean firstBuy;
        private double savedBalance;
        private Transaction lastBuyTransaction;

        public SimulatorJob(TradingSystem system, Date begin, Date end) {
            super("Trading System Simulator");
            this.original = new History();
            this.history = new History();
            this.signals = 0;
            this.successCount = 0;
            this.failureCount = 0;
            this.firstBuy = true;
            this.savedBalance = 0.0;
            this.lastBuyTransaction = null;
            this.original = system.getSecurity().getHistory();
            int first = -1;
            int last = -1;
            int i = 0;
            while (i < this.original.size() && (first == -1 || last == -1)) {
                Bar bar = this.original.get(i);
                if (first == -1 && (bar.getDate().equals(begin) || bar.getDate().after(begin))) {
                    first = i;
                }
                if (last == -1 && (bar.getDate().equals(end) || bar.getDate().after(end))) {
                    last = i;
                }
                ++i;
            }
            if (first != -1 && last != -1) {
                this.original = new History();
                this.original.addAll(system.getSecurity().getHistory().getList().subList(first, last));
            }
            this.security = new Security(system.getSecurity().getId()){

                public History getHistory() {
                    return SimulatorJob.this.history;
                }
            };
            this.security.setExchange(system.getSecurity().getExchange());
            this.security.setSymbol(system.getSecurity().getSymbol());
            this.security.setDescription(system.getSecurity().getDescription());
            try {
                this.account = (Account)system.getAccount().clone();
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
                this.account = new DefaultAccount(system.getAccount());
            }
            this.plugin = TradingPlugin.createTradingSystemPlugin(system.getPluginId());
            this.plugin.setAccount(this.account);
            this.plugin.setSecurity(this.security);
            this.plugin.setParameters(system.getParameters());
            this.plugin.setMaxExposure(system.getMaxExposure());
            this.plugin.setMinAmount(system.getMinAmount());
            this.plugin.setMaxAmount(system.getMaxAmount());
        }

        protected IStatus run(IProgressMonitor monitor) {
            TestRunnerView.this.fProgressBar.setMaximum(this.original.size());
            int i = 0;
            while (i < this.original.size()) {
                double expenses;
                Transaction transaction;
                final Bar quote = this.original.get(i);
                this.security.setQuote(new Quote(quote.getClose(), quote.getClose(), quote.getClose()));
                if (this.plugin.getSignal() == 1) {
                    if (this.firstBuy) {
                        this.savedBalance = this.account.getBalance();
                        this.firstBuy = false;
                    }
                    transaction = new Transaction(quote.getDate(), this.security, this.plugin.getQuantity(), quote.getOpen());
                    expenses = this.account.getExpenses(this.security, this.plugin.getQuantity(), quote.getOpen());
                    transaction.setExpenses(expenses);
                    this.account.getTransactions().add((Object)transaction);
                    this.lastBuyTransaction = transaction;
                    TestRunnerView.this.fLog.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TableItem tableItem = new TableItem(((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog, 0);
                            tableItem.setText(0, TestRunnerView.this.dateFormatter.format(transaction.getDate()));
                            tableItem.setText(1, "Buy");
                            tableItem.setText(2, String.valueOf(TestRunnerView.this.numberFormatter.format(SimulatorJob.this.plugin.getQuantity())) + " at " + TestRunnerView.this.priceFormatter.format(quote.getOpen()));
                            tableItem.setData((Object)transaction);
                            int i = 0;
                            while (i < ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumnCount()) {
                                ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumn(i).pack();
                                ++i;
                            }
                        }
                    });
                } else if (this.plugin.getSignal() == 2) {
                    transaction = new Transaction(quote.getDate(), this.security, -this.plugin.getQuantity(), quote.getOpen());
                    expenses = this.account.getExpenses(this.security, this.plugin.getQuantity(), quote.getOpen());
                    transaction.setExpenses(expenses);
                    this.account.getTransactions().add((Object)transaction);
                    transaction.setData((Object)this.lastBuyTransaction);
                    this.lastBuyTransaction = null;
                    TestRunnerView.this.fLog.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TableItem tableItem = new TableItem(((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog, 0);
                            tableItem.setText(0, TestRunnerView.this.dateFormatter.format(transaction.getDate()));
                            tableItem.setText(1, "Sell");
                            tableItem.setText(2, String.valueOf(TestRunnerView.this.numberFormatter.format(SimulatorJob.this.plugin.getQuantity())) + " at " + TestRunnerView.this.priceFormatter.format(quote.getOpen()));
                            tableItem.setData((Object)transaction);
                            int i = 0;
                            while (i < ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumnCount()) {
                                ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumn(i).pack();
                                ++i;
                            }
                        }
                    });
                    if (this.account.getBalance() > this.savedBalance) {
                        ++this.successCount;
                    } else {
                        ++this.failureCount;
                    }
                    this.firstBuy = true;
                }
                TestRunnerView.this.fProgressBar.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fCounterPanel.setRunValue(SimulatorJob.this.signals);
                        ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fCounterPanel.setGainsValue(SimulatorJob.this.successCount);
                        ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fCounterPanel.setLossesValue(SimulatorJob.this.failureCount);
                        ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fProgressBar.step(0);
                    }
                });
                this.history = new History();
                this.history.addAll(this.original.getList().subList(0, i));
                this.plugin.run();
                if (this.plugin.getSignal() != 0) {
                    TestRunnerView.this.fLog.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TableItem tableItem = new TableItem(((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog, 0);
                            tableItem.setText(0, TestRunnerView.this.dateFormatter.format(quote.getDate()));
                            tableItem.setText(1, "Signal");
                            switch (SimulatorJob.this.plugin.getSignal()) {
                                case 1: {
                                    tableItem.setText(2, "Buy");
                                    break;
                                }
                                case 2: {
                                    tableItem.setText(2, "Sell");
                                    break;
                                }
                                case 3: {
                                    tableItem.setText(2, "Hold");
                                    break;
                                }
                                case 4: {
                                    tableItem.setText(2, "Neutral");
                                }
                            }
                            int i = 0;
                            while (i < ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumnCount()) {
                                ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumn(i).pack();
                                ++i;
                            }
                        }
                    });
                    ++this.signals;
                }
                ++i;
            }
            TestRunnerView.this.fLog.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    double initial = SimulatorJob.this.account.getInitialBalance();
                    double current = SimulatorJob.this.account.getBalance() + SimulatorJob.this.account.getPortfolio(SimulatorJob.this.security).getMarketValue();
                    double gain = current - initial;
                    TableItem tableItem = new TableItem(((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog, 0);
                    tableItem.setText(0, "");
                    tableItem.setText(1, "Total");
                    tableItem.setText(2, String.valueOf(TestRunnerView.this.amountFormatter.format(gain)) + " (" + TestRunnerView.this.percentFormatter.format(gain / initial * 100.0) + "%)");
                    int i = 0;
                    while (i < ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumnCount()) {
                        ((SimulatorJob)SimulatorJob.this).TestRunnerView.this.fLog.getColumn(i).pack();
                        ++i;
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

