/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.feed.FeedSource;
import pk.com.softech.tradingterminal.core.db.feed.TradeSource;
import pk.com.softech.tradingterminal.core.internal.XMLRepository;
import pk.com.softech.tradingterminal.core.transfers.SecurityTransfer;
import pk.com.softech.tradingterminal.core.ui.NullSelection;
import pk.com.softech.tradingterminal.core.ui.SecuritySelection;
import pk.com.softech.tradingterminal.core.ui.SelectionProvider;
import pk.com.softech.tradingterminal.core.ui.actions.DeleteAction;
import pk.com.softech.tradingterminal.core.ui.actions.PropertiesAction;
import pk.com.softech.tradingterminal.core.ui.actions.SelectAllAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.SearchUtil;
import pk.com.softech.tradingterminal.trading.actions.ShowMBOAction;
import pk.com.softech.tradingterminal.trading.actions.ShowMBPAction;
import pk.com.softech.tradingterminal.trading.actions.SymbolSummaryAction;
import pk.com.softech.tradingterminal.trading.ui.dialogs.FeedSelectionDialog;
import pk.com.softech.tradingterminal.trading.ui.dialogs.SecurityPropertiesDialog;
import pk.com.softech.tradingterminal.trading.ui.dialogs.TradingOptionsDialog;
import pk.com.softech.tradingterminal.trading.views.SecurityComparator;
import pk.com.softech.tradingterminal.trading.views.SecurityFilter;

public class SecuritiesView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.securityView";
    public static final String PREFS_SECURITY_VIEW_COLUMNS = "PREFS_SECURITY_VIEW_COLUMNS";
    public static final String PREFS_SECURITY_VIEW_COLUMNS_SIZE = "PREFS_SECURITY_VIEW_COLUMNS_SIZE";
    public static final String PREFS_SORT_COLUMN = "SECURITIES_SORT_COLUMN";
    public static final String PREFS_SORT_DIRECTION = "SECURITIES_SORT_DIRECTION";
    public static final String TABLE_BACKGROUND = "SECURITY_TABLE_BACKGROUND";
    public static final String TABLE_FOREGROUND = "SECURITY_TABLE_FOREGROUND";
    public static final String TABLE_FONT = "SECURITY_TABLE_FONT";
    public static final int NO_OF_COLUMNS = 5;
    private static String[] COLUMN_NAMES = new String[]{"Symbol", "Exchange", "Market", "Description", "Sector", "Currency"};
    public static final int SYMBOL = 0;
    public static final int EXCHANGE = 1;
    public static final int MARKET = 2;
    public static final int DESCRIPTION = 3;
    public static final int SECTOR = 4;
    public static final int CURRENCY = 5;
    private TableViewer viewer;
    private SecurityComparator comparator;
    private Text txtSymbolSearch;
    private Text txtDescriptionSearch;
    private Text txtSectorSearch;
    private Composite parent;
    private SecurityFilter filter;
    int sortColumn = 0;
    int sortDirection = 1;
    ITheme theme;
    Menu columnsMenu;
    Action deleteAction;
    Action selectAllAction;
    Action qouteRequest;
    Action propertiesAction;
    Action changeQuoteFeedAction;
    Action changeLevel2FeedAction;
    Action changeHistoryFeedAction;
    Action changeTradingOptionsAction;
    Action addSecurities;
    Action mboAction;
    Action mbpAction;
    Color colorYellow;
    Color gray;
    ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < SecuritiesView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(SecuritiesView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(SecuritiesView.PREFS_SECURITY_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = SecuritiesView.this.viewer.getTable().indexOf((TableColumn)e.widget);
            if (SecuritiesView.this.sortColumn == index) {
                SecuritiesView.this.sortDirection = SecuritiesView.this.sortDirection == 0 ? 1 : 0;
            } else {
                SecuritiesView.this.sortColumn = index;
                SecuritiesView.this.sortDirection = 0;
            }
            IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
            prefs.setValue(SecuritiesView.PREFS_SORT_COLUMN, SecuritiesView.this.sortColumn);
            prefs.setValue(SecuritiesView.PREFS_SORT_DIRECTION, SecuritiesView.this.sortDirection);
            SecuritiesView.this.viewer.getTable().setSortColumn(SecuritiesView.this.viewer.getTable().getColumn(SecuritiesView.this.sortColumn));
            SecuritiesView.this.viewer.getTable().setSortDirection(SecuritiesView.this.sortDirection == 0 ? 128 : 1024);
            SecuritiesView.this.comparator.setColumn(SecuritiesView.this.sortColumn);
            SecuritiesView.this.viewer.refresh();
        }
    };
    IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                SecuritiesView.this.setTheme((ITheme)event.getNewValue());
            } else if (event.getProperty().equals(SecuritiesView.TABLE_BACKGROUND)) {
                SecuritiesView.this.viewer.getTable().setBackground(SecuritiesView.this.theme.getColorRegistry().get(SecuritiesView.TABLE_BACKGROUND));
            } else if (event.getProperty().equals(SecuritiesView.TABLE_FOREGROUND)) {
                SecuritiesView.this.viewer.getTable().setForeground(SecuritiesView.this.theme.getColorRegistry().get(SecuritiesView.TABLE_FOREGROUND));
            } else if (event.getProperty().equals(SecuritiesView.TABLE_FONT)) {
                SecuritiesView.this.viewer.getTable().setFont(SecuritiesView.this.theme.getFontRegistry().get(SecuritiesView.TABLE_FONT));
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        this.mboAction = new ShowMBOAction(this);
        this.mbpAction = new ShowMBPAction(this);
        this.qouteRequest = new SymbolSummaryAction(this);
        this.deleteAction = new DeleteAction(){

            public void run() {
                if (MessageDialog.openConfirm((Shell)SecuritiesView.this.getViewSite().getShell(), (String)"Security", (String)"Do you really want to delete the selected securities ?")) {
                    Security[] securities = SecuritiesView.this.getSelection();
                    int i = 0;
                    while (i < securities.length) {
                        CorePlugin.getRepository().delete((PersistentObject)securities[i]);
                        ++i;
                    }
                }
            }
        };
        this.selectAllAction = new SelectAllAction(){

            public void run() {
                SecuritiesView.this.viewer.getTable().selectAll();
            }
        };
        this.propertiesAction = new PropertiesAction(){

            public void run() {
                Security[] security = SecuritiesView.this.getSelection();
                if (security.length == 1) {
                    SecurityPropertiesDialog dlg = new SecurityPropertiesDialog(security[0], SecuritiesView.this.getSite().getShell());
                    dlg.open();
                }
            }
        };
        this.changeQuoteFeedAction = new Action(){

            public void run() {
                Security[] selection = SecuritiesView.this.getSelection();
                FeedSelectionDialog dlg = new FeedSelectionDialog(SecuritiesView.this.viewer.getTable().getShell(), "quote");
                if (dlg.open() == 0) {
                    FeedSource source = dlg.getFeedSource();
                    int i = 0;
                    while (i < selection.length) {
                        if (source != null) {
                            FeedSource newSource = new FeedSource();
                            newSource.setId(source.getId());
                            newSource.setExchange(source.getExchange());
                            newSource.setSymbol(selection[i].getQuoteFeed() != null ? selection[i].getQuoteFeed().getSymbol() : "");
                            selection[i].setQuoteFeed(newSource);
                        } else {
                            selection[i].setQuoteFeed(null);
                        }
                        CorePlugin.getRepository().save((PersistentObject)selection[i]);
                        ++i;
                    }
                }
            }
        };
        this.changeQuoteFeedAction.setText("Quote Feed");
        this.changeLevel2FeedAction = new Action(){

            public void run() {
                Security[] selection = SecuritiesView.this.getSelection();
                FeedSelectionDialog dlg = new FeedSelectionDialog(SecuritiesView.this.viewer.getTable().getShell(), "level2");
                if (dlg.open() == 0) {
                    FeedSource source = dlg.getFeedSource();
                    int i = 0;
                    while (i < selection.length) {
                        if (source != null) {
                            FeedSource newSource = new FeedSource();
                            newSource.setId(source.getId());
                            newSource.setExchange(source.getExchange());
                            newSource.setSymbol(selection[i].getLevel2Feed() != null ? selection[i].getLevel2Feed().getSymbol() : "");
                            selection[i].setLevel2Feed(newSource);
                        } else {
                            selection[i].setLevel2Feed(null);
                        }
                        CorePlugin.getRepository().save((PersistentObject)selection[i]);
                        ++i;
                    }
                }
            }
        };
        this.changeLevel2FeedAction.setText("Level2 Feed");
        this.changeHistoryFeedAction = new Action(){

            public void run() {
                Security[] selection = SecuritiesView.this.getSelection();
                FeedSelectionDialog dlg = new FeedSelectionDialog(SecuritiesView.this.viewer.getTable().getShell(), "history");
                if (dlg.open() == 0) {
                    FeedSource source = dlg.getFeedSource();
                    int i = 0;
                    while (i < selection.length) {
                        if (source != null) {
                            FeedSource newSource = new FeedSource();
                            newSource.setId(source.getId());
                            newSource.setExchange(source.getExchange());
                            newSource.setSymbol(selection[i].getHistoryFeed() != null ? selection[i].getHistoryFeed().getSymbol() : "");
                            selection[i].setHistoryFeed(newSource);
                        } else {
                            selection[i].setHistoryFeed(null);
                        }
                        CorePlugin.getRepository().save((PersistentObject)selection[i]);
                        ++i;
                    }
                }
            }
        };
        this.changeHistoryFeedAction.setText("History Feed");
        this.changeTradingOptionsAction = new Action(){

            public void run() {
                TradingOptionsDialog dlg = new TradingOptionsDialog(SecuritiesView.this.viewer.getTable().getShell()){

                    protected void okPressed() {
                        Security[] selection = SecuritiesView.this.getSelection();
                        int i = 0;
                        while (i < selection.length) {
                            TradeSource source = this.options.getSource();
                            TradeSource oldSource = selection[i].getTradeSource();
                            if (oldSource != null) {
                                source.setSymbol(oldSource.getSymbol());
                            }
                            selection[i].setTradeSource(source);
                            CorePlugin.getRepository().save((PersistentObject)selection[i]);
                            ++i;
                        }
                        super.okPressed();
                    }
                };
                dlg.open();
            }
        };
        this.changeTradingOptionsAction.setText("Trading Options");
        this.addSecurities = new Action("Add new Securities automatically", 2){

            public void run() {
                CorePlugin.getDefault().getPreferenceStore().setValue("ADD_NEW_SECURITIES_AUTOMATIC", this.isChecked());
            }
        };
        this.addSecurities.setToolTipText("Automatically add new securities");
        this.addSecurities.setChecked(CorePlugin.getDefault().getPreferenceStore().getBoolean("ADD_NEW_SECURITIES_AUTOMATIC"));
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator());
        MenuManager updateChartsMenu = new MenuManager("Update All Charts", "updateChart");
        updateChartsMenu.add((IContributionItem)new Separator("group0"));
        updateChartsMenu.add((IContributionItem)new Separator("group1"));
        updateChartsMenu.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)updateChartsMenu);
        menuManager.add((IAction)this.addSecurities);
        menuManager.add((IContributionItem)new Separator("search"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        if (themeManager != null) {
            this.theme = themeManager.getCurrentTheme();
            if (this.theme != null) {
                this.theme.addPropertyChangeListener(this.themeChangeListener);
            }
        }
        super.init(site);
    }

    protected void setTheme(ITheme theme) {
        if (theme != null) {
            this.theme = theme;
            this.viewer.getTable().setBackground(theme.getColorRegistry().get(TABLE_BACKGROUND));
            this.viewer.getTable().setForeground(theme.getColorRegistry().get(TABLE_FOREGROUND));
            this.viewer.getTable().setFont(theme.getFontRegistry().get(TABLE_FONT));
            theme.addPropertyChangeListener(this.themeChangeListener);
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        Display display = this.getViewSite().getShell().getDisplay();
        this.gray = display.getSystemColor(15);
        this.colorYellow = new Color((Device)display, 170, 170, 170);
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        Label searchLabel = new Label(content, 0);
        searchLabel.setText(" Symbol Search: ");
        this.txtSymbolSearch = new Text(content, 2176);
        this.txtSymbolSearch.setLayoutData((Object)new GridData(768));
        this.txtSymbolSearch.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbolSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SecuritiesView.this.filter.setSearchText(SecuritiesView.this.txtSymbolSearch.getText(), SecuritiesView.this.txtDescriptionSearch.getText(), SecuritiesView.this.txtSectorSearch.getText());
                SecuritiesView.this.viewer.refresh();
            }
        });
        searchLabel = new Label(content, 0);
        searchLabel.setText(" Description Search: ");
        this.txtDescriptionSearch = new Text(content, 2176);
        this.txtDescriptionSearch.setLayoutData((Object)new GridData(768));
        this.txtDescriptionSearch.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtDescriptionSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SecuritiesView.this.filter.setSearchText(SecuritiesView.this.txtSymbolSearch.getText(), SecuritiesView.this.txtDescriptionSearch.getText(), SecuritiesView.this.txtSectorSearch.getText());
                SecuritiesView.this.viewer.refresh();
            }
        });
        searchLabel = new Label(content, 0);
        searchLabel.setText(" Sector Search: ");
        this.txtSectorSearch = new Text(content, 2176);
        this.txtSectorSearch.setLayoutData((Object)new GridData(768));
        this.txtSectorSearch.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSectorSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                SecuritiesView.this.filter.setSearchText(SecuritiesView.this.txtSymbolSearch.getText(), SecuritiesView.this.txtDescriptionSearch.getText(), SecuritiesView.this.txtSectorSearch.getText());
                SecuritiesView.this.viewer.refresh();
            }
        });
        this.createViewer(content);
        this.comparator = new SecurityComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.filter = new SecurityFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        if (this.theme != null) {
            this.viewer.getTable().setForeground(this.theme.getColorRegistry().get(TABLE_FOREGROUND));
            this.viewer.getTable().setBackground(this.theme.getColorRegistry().get(TABLE_BACKGROUND));
            this.viewer.getTable().setFont(this.theme.getFontRegistry().get(TABLE_FONT));
        }
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SecuritiesView.this.updateSelection();
            }
        });
        this.viewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (SecuritiesView.this.viewer.getTable().getItem(new Point(e.x, e.y)) == null) {
                    SecuritiesView.this.viewer.getTable().deselectAll();
                    SecuritiesView.this.getSite().getSelectionProvider().setSelection((ISelection)new NullSelection());
                    SecuritiesView.this.updateSelection();
                }
            }
        });
        this.viewer.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFDF;
                if ((event.detail & 2) == 0) {
                    return;
                }
                int clientWidth = ((SecuritiesView)SecuritiesView.this).viewer.getTable().getClientArea().width;
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                gc.setForeground(SecuritiesView.this.gray);
                gc.setBackground(SecuritiesView.this.gray);
                gc.fillGradientRectangle(0, event.y, clientWidth, event.height, false);
                gc.setForeground(oldForeground);
                event.detail &= 0xFFFFFFFD;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)new SelectionProvider());
        IPreferenceStore prefs = CorePlugin.getDefault().getPreferenceStore();
        prefs.setDefault(PREFS_SORT_COLUMN, this.sortColumn);
        prefs.setDefault(PREFS_SORT_DIRECTION, this.sortDirection);
        this.sortColumn = prefs.getInt(PREFS_SORT_COLUMN);
        this.sortDirection = prefs.getInt(PREFS_SORT_DIRECTION);
        this.viewer.getTable().setSortColumn(this.viewer.getTable().getColumn(this.sortColumn));
        this.viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        this.comparator.setColumn(this.sortColumn);
        DragSource dragSource = new DragSource((Control)this.viewer.getTable(), 3);
        dragSource.setTransfer(new Transfer[]{SecurityTransfer.getInstance()});
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (SecuritiesView.this.viewer.getTable().getSelectionCount() == 0) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                TableItem[] selection = SecuritiesView.this.viewer.getTable().getSelection();
                Security[] securities = new Security[selection.length];
                int i = 0;
                while (i < selection.length) {
                    securities[i] = (Security)selection[i].getData();
                    ++i;
                }
                event.data = securities;
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(this.deleteAction.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(this.propertiesAction.getId(), (IAction)this.propertiesAction);
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                MenuManager mgrColumns = new MenuManager("Columns");
                SecuritiesView.this.createMenuItem(mgrColumns);
                menuManager.add((IContributionItem)mgrColumns);
                menuManager.add((IAction)SecuritiesView.this.qouteRequest);
                menuManager.add((IContributionItem)new Separator("top"));
                menuManager.add((IContributionItem)new Separator("group0"));
                menuManager.add((IContributionItem)new Separator("group1"));
                if (Resources.mboAllow) {
                    menuManager.appendToGroup("group1", (IAction)SecuritiesView.this.mboAction);
                }
                if (Resources.mbpAllow) {
                    menuManager.appendToGroup("group1", (IAction)SecuritiesView.this.mbpAction);
                }
                menuManager.add((IContributionItem)new Separator("news"));
                menuManager.add((IContributionItem)new Separator("group2"));
                menuManager.add((IContributionItem)new Separator("group3"));
                menuManager.add((IContributionItem)new Separator("group4"));
                menuManager.add((IContributionItem)new Separator("group5"));
                MenuManager changeMenu = new MenuManager("Change", "change");
                changeMenu.add((IAction)SecuritiesView.this.changeQuoteFeedAction);
                changeMenu.add((IAction)SecuritiesView.this.changeLevel2FeedAction);
                changeMenu.add((IAction)SecuritiesView.this.changeHistoryFeedAction);
                changeMenu.add((IContributionItem)new Separator());
                changeMenu.add((IAction)SecuritiesView.this.changeTradingOptionsAction);
                changeMenu.add((IContributionItem)new Separator());
                menuManager.add((IContributionItem)new Separator("additions"));
                menuManager.add((IAction)SecuritiesView.this.deleteAction);
                menuManager.add((IContributionItem)new Separator("search"));
                menuManager.add((IContributionItem)new Separator("bottom"));
                menuManager.add((IAction)SecuritiesView.this.propertiesAction);
            }
        });
        Menu tableMenu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(tableMenu);
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SecuritiesView.this.viewer.refresh();
                CorePlugin.getRepository().allSecurities().addCollectionObserver((ICollectionObserver)SecuritiesView.this);
            }
        });
        for (Security sec : CorePlugin.getRepository().allSecurities()) {
            sec.addObserver((Observer)this);
        }
        this.viewer.setInput((Object)CorePlugin.getRepository().allSecurities());
        this.updateSelection();
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        this.setTheme(theme);
    }

    private void createMenuItem(MenuManager mgr) {
        TableColumn[] columns = this.viewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            final TableColumn column = columns[i];
            Action action = new Action(column.getText(), 32){

                public void run() {
                    if (column.getWidth() == 0) {
                        column.setWidth(100);
                        column.setResizable(true);
                    } else {
                        column.setWidth(0);
                        column.setResizable(false);
                    }
                }
            };
            mgr.add((IAction)action);
            action.setChecked(column.getWidth() != 0);
            ++i;
        }
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 67586);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.getHorizontalBar().setEnabled(true);
        table.getVerticalBar().setEnabled(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn col = this.createTableViewerColumn(0);
        col.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public String getToolTipText(Object element) {
                Security sec = (Security)element;
                return sec.getDescription();
            }

            public void update(ViewerCell cell) {
                String search = SecuritiesView.this.txtSymbolSearch.getText();
                Security security = (Security)cell.getElement();
                String cellText = security.getSymbol();
                cell.setText(cellText);
                if (search != null && search.length() > 0) {
                    int[] intRangesCorrectSize = SearchUtil.getSearchTermOccurrences((String)search, (String)cellText);
                    ArrayList<StyleRange> styleRange = new ArrayList<StyleRange>();
                    int i = 0;
                    while (i < intRangesCorrectSize.length / 2) {
                        int start = intRangesCorrectSize[i];
                        int length = intRangesCorrectSize[++i];
                        StyleRange myStyledRange = new StyleRange(start, length, null, SecuritiesView.this.colorYellow);
                        styleRange.add(myStyledRange);
                        ++i;
                    }
                    cell.setStyleRanges(styleRange.toArray(new StyleRange[styleRange.size()]));
                } else {
                    cell.setStyleRanges(null);
                }
                super.update(cell);
            }
        });
        col = this.createTableViewerColumn(1);
        col = this.createTableViewerColumn(2);
        col = this.createTableViewerColumn(3);
        col.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public String getToolTipText(Object element) {
                Security sec = (Security)element;
                return sec.getDescription();
            }

            public void update(ViewerCell cell) {
                String search = SecuritiesView.this.txtDescriptionSearch.getText();
                Security security = (Security)cell.getElement();
                String cellText = security.getDescription();
                cell.setText(cellText);
                if (search != null && search.length() > 0) {
                    int[] intRangesCorrectSize = SearchUtil.getSearchTermOccurrences((String)search, (String)cellText);
                    ArrayList<StyleRange> styleRange = new ArrayList<StyleRange>();
                    int i = 0;
                    while (i < intRangesCorrectSize.length / 2) {
                        int start = intRangesCorrectSize[i];
                        int length = intRangesCorrectSize[++i];
                        StyleRange myStyledRange = new StyleRange(start, length, null, SecuritiesView.this.colorYellow);
                        styleRange.add(myStyledRange);
                        ++i;
                    }
                    cell.setStyleRanges(styleRange.toArray(new StyleRange[styleRange.size()]));
                } else {
                    cell.setStyleRanges(null);
                }
                super.update(cell);
            }
        });
        col = this.createTableViewerColumn(4);
        col.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public String getToolTipText(Object element) {
                Security sec = (Security)element;
                return sec.getDescription();
            }

            public void update(ViewerCell cell) {
                String search = SecuritiesView.this.txtSectorSearch.getText();
                Security security = (Security)cell.getElement();
                String cellText = security.getSector();
                cell.setText(cellText);
                if (search != null && search.length() > 0) {
                    int[] intRangesCorrectSize = SearchUtil.getSearchTermOccurrences((String)search, (String)cellText);
                    ArrayList<StyleRange> styleRange = new ArrayList<StyleRange>();
                    int i = 0;
                    while (i < intRangesCorrectSize.length / 2) {
                        int start = intRangesCorrectSize[i];
                        int length = intRangesCorrectSize[++i];
                        StyleRange myStyledRange = new StyleRange(start, length, null, SecuritiesView.this.colorYellow);
                        styleRange.add(myStyledRange);
                        ++i;
                    }
                    cell.setStyleRanges(styleRange.toArray(new StyleRange[styleRange.size()]));
                } else {
                    cell.setStyleRanges(null);
                }
                super.update(cell);
            }
        });
        col = this.createTableViewerColumn(5);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_SECURITY_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
        if (this.sortColumn >= 0 && this.sortColumn < viewer.getTable().getColumnCount()) {
            viewer.getTable().setSortColumn(viewer.getTable().getColumn(this.sortColumn));
            viewer.getTable().setSortDirection(this.sortDirection == 0 ? 128 : 1024);
        } else {
            viewer.getTable().setSortColumn(null);
            this.sortColumn = -1;
            this.sortDirection = 0;
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener(this.columnSelectionListener);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText(((Security)cell.getElement()).getSymbol());
                        break;
                    }
                    case 1: {
                        cell.setText(((Security)cell.getElement()).getExchange());
                        break;
                    }
                    case 2: {
                        cell.setText(((Security)cell.getElement()).getMarket());
                        break;
                    }
                    case 3: {
                        cell.setText(((Security)cell.getElement()).getDescription());
                        break;
                    }
                    case 4: {
                        cell.setText(((Security)cell.getElement()).getSector());
                        break;
                    }
                    case 5: {
                        cell.setText(((Security)cell.getElement()).getCurrency().getCurrencyCode());
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                Security sec = (Security)element;
                return sec.getDescription();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getTable().getParent().setFocus();
    }

    public void dispose() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        if (this.theme != null) {
            this.theme.removePropertyChangeListener(this.themeChangeListener);
        }
        if (this.colorYellow != null) {
            this.colorYellow.dispose();
        }
        if (Resources.isMapDbEnabled) {
            ((XMLRepository)CorePlugin.getRepository()).saveSecuritiesMapDb();
        } else {
            ((XMLRepository)CorePlugin.getRepository()).saveSecurities();
        }
        super.dispose();
    }

    public void itemAdded(Object o) {
        final Security security = (Security)o;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        security.addObserver((Observer)SecuritiesView.this);
                        SecuritiesView.this.viewer.add((Object)security);
                        SecuritiesView.this.updateSelection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
        final Security security = (Security)o;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!SecuritiesView.this.viewer.getTable().isDisposed()) {
                        SecuritiesView.this.viewer.remove((Object)security);
                        security.deleteObserver((Observer)SecuritiesView.this);
                        SecuritiesView.this.updateSelection();
                    }
                }
            });
        }
    }

    public Security[] getSelection() {
        TableItem[] selection = this.viewer.getTable().getSelection();
        Security[] securities = new Security[selection.length];
        int i = 0;
        while (i < selection.length) {
            securities[i] = (Security)selection[i].getData();
            ++i;
        }
        return securities;
    }

    private void updateSelection() {
        Security[] security = this.getSelection();
        if (security.length == 1) {
            this.getSite().getSelectionProvider().setSelection((ISelection)new SecuritySelection(security[0]));
        } else {
            this.getSite().getSelectionProvider().setSelection((ISelection)new NullSelection());
        }
        this.deleteAction.setEnabled(security.length != 0);
        this.qouteRequest.setEnabled(security.length == 1);
        this.propertiesAction.setEnabled(security.length == 1);
        this.changeQuoteFeedAction.setEnabled(security.length != 0);
        this.changeLevel2FeedAction.setEnabled(security.length != 0);
        this.changeHistoryFeedAction.setEnabled(security.length != 0);
        this.changeTradingOptionsAction.setEnabled(security.length != 0);
        this.mboAction.setEnabled(security.length == 1);
        this.mbpAction.setEnabled(security.length == 1);
    }

    @Override
    public void update(final Observable o, Object arg) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof Security) {
                        Security sec = (Security)o;
                        SecuritiesView.this.viewer.refresh((Object)sec, true);
                    }
                }
            });
        }
    }
}

