/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.MarketResponse;
import pk.com.softech.messages.SymbolStatisticsData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.FinnacialDataCommon;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.db.feed.Quote;
import pk.com.softech.tradingterminal.core.transfers.SecurityTransfer;
import pk.com.softech.tradingterminal.core.ui.SecuritySelection;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class QuoteRequestView
extends ViewPart
implements ICollectionObserver,
Observer,
ISelectionListener {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.quoteRequest";
    private static final int COMBO_WIDTH = 100;
    private static final int COMBO_HEIGHT = 25;
    GridData lblGridData80 = GridDataFactory.swtDefaults().hint(85, -1).create();
    GridData lblGridData120 = GridDataFactory.swtDefaults().grab(true, false).hint(128, -1).create();
    GridData txtGridData = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create();
    SimpleDateFormat timeFormat = CorePlugin.getTimeFormat();
    private static final int VIEW_WIDTH = 600;
    private static final int VIEW_HIGHT = 350;
    private TabFolder tabFolder;
    private Combo cmbExchange;
    private Text txtSymbol;
    private Combo cmbMarket;
    private Button btnResearchPortal;
    private Text txtDescription;
    private Text txtCurrency;
    private Text txtOpenFirst;
    private Text txtLastTrade;
    private Text txtChange;
    private Text txtYersterdayTrd;
    private Text txtDailyHigh;
    private Text txtDailyLow;
    private Text txtTotalTrades;
    private Text txtTurnover;
    private Text txtMarketValue;
    private Text txtLowerPrice;
    private Text txtUpperPrice;
    private Text txtMaxVolume;
    private Text txtMaxValue;
    private Text txtLotSize;
    private Text txtLastTradeTime;
    private Text txtMarketRange;
    private Text txtSector;
    private Text txtVolume;
    private Text txtFromDate;
    private Text txtToDate;
    private Text txtSpot;
    private Text txtBuyPrice;
    private Text txtBuyQty;
    private Text txtSellPrice;
    private Text txtSellQty;
    private Text txtLastPriceToday;
    private Text txtLastPricePrevDate;
    private Text txtChangeToday;
    private Text txtChangePrevDate;
    private Text txtTurnOverToday;
    private Text txtTurnOverPrevDate;
    private Text txtMarketValueToday;
    private Text txtMarketValuePrevDate;
    private Text txtPriceRange30D;
    private Text txtPriceAvg30D;
    private Text txtPriceVol30D;
    private Text txtPriceRange90D;
    private Text txtPriceAvg90D;
    private Text txtPriceVol90D;
    private Text txtPriceRange180D;
    private Text txtPriceAvg180D;
    private Text txtPriceVol180D;
    private Text txtPriceRange52W;
    private Text txtPriceAvg52W;
    private Text txtPriceVol52W;
    private Text txtDaysRangeToday;
    private Text txtDaysRangePrevDate;
    private Text txtFaceValue;
    private Text txtDividend;
    private Text txtBonusShare;
    private Text txtRightShare;
    private Text txtPremium;
    Composite cmpNorth;
    Composite parent;
    Composite content;
    Security security = null;
    Group grpPrevSession;
    Group grpCurrentSession;
    Group researchPortalGroup;
    Action followSecuritySelectionAction;
    boolean followSelection = false;
    private NumberFormat nf = CorePlugin.getNumberFormatter();
    private SimpleDateFormat df = CorePlugin.getDateFormat();
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    private NumberFormat percentFormatter = CorePlugin.getPercentageFormatter();
    Font font = WidgetFactory.font_registry.get("FONT_9_NORMAL");
    Font fontBold = WidgetFactory.font_registry.get("FONT_9_BOLD");
    DropTargetListener dropTargetListener = new DropTargetListener(){

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
            event.currentDataType = null;
            TransferData[] data = event.dataTypes;
            if (event.currentDataType == null) {
                int i = 0;
                while (i < data.length) {
                    if (SecurityTransfer.getInstance().isSupportedType(data[i])) {
                        event.currentDataType = data[i];
                        break;
                    }
                    ++i;
                }
            }
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 9;
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (SecurityTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Security[] securities = (Security[])event.data;
                QuoteRequestView.this.setSecurity(securities[0]);
            }
        }
    };
    private Composite cmpQuoteDetail;
    private Composite cmpNorth2;
    private Composite cmpStatistics;

    public void init(IViewSite site) throws PartInitException {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().addCollectionObserver((ICollectionObserver)this);
        super.init(site);
        this.followSecuritySelectionAction = new Action("Follow Security Selection", 2){

            public void run() {
                QuoteRequestView.this.followSelection = QuoteRequestView.this.followSecuritySelectionAction.isChecked();
                TradingPlugin.getDefault().getPreferenceStore().setValue("PREFS_FOLLOW_SECURITY_SELECTION_QUOTE", QuoteRequestView.this.followSelection);
            }
        };
        this.followSelection = TradingPlugin.getDefault().getPreferenceStore().getBoolean("PREFS_FOLLOW_SECURITY_SELECTION_QUOTE");
        this.followSecuritySelectionAction.setChecked(this.followSelection);
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager = bars.getMenuManager();
        manager.add((IAction)this.followSecuritySelectionAction);
    }

    public void createPartControl(Composite parent) {
        int i;
        this.parent = parent;
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)sc, 0);
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo(this.content);
        GridDataFactory.fillDefaults().hint(600, -1);
        this.cmpNorth = new Composite(this.content, 0);
        GridLayoutFactory.fillDefaults().spacing(2, 2).margins(5, 5).numColumns(6).equalWidth(true).applyTo(this.cmpNorth);
        GridDataFactory.fillDefaults().hint(600, -1).applyTo((Control)this.cmpNorth);
        this.createLabel(this.cmpNorth, "Symbol");
        this.txtSymbol = new Text(this.cmpNorth, 2176);
        this.txtSymbol.setLayoutData((Object)this.txtGridData);
        this.txtSymbol.setFont(this.font);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                QuoteRequestView.this.securitySelection(true);
                QuoteRequestView.this.cmbMarket.forceFocus();
            }

            public void focusGained(FocusEvent e) {
                QuoteRequestView.this.txtSymbol.selectAll();
            }
        });
        this.txtSymbol.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    QuoteRequestView.this.securitySelection(true);
                    QuoteRequestView.this.txtSymbol.selectAll();
                }
            }
        });
        this.createLabel(this.cmpNorth, "Exchange");
        this.cmbExchange = new Combo(this.cmpNorth, 8);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, 25).applyTo((Control)this.cmbExchange);
        this.cmbExchange.setFont(this.font);
        this.cmbExchange.select(0);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.cmbExchange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuoteRequestView.this.securitySelection(false);
                QuoteRequestView.this.cmbExchange.forceFocus();
            }
        });
        this.createLabel(this.cmpNorth, "Market");
        this.cmbMarket = new Combo(this.cmpNorth, 8);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, 25).applyTo((Control)this.cmbMarket);
        this.cmbMarket.setFont(this.font);
        this.cmbMarket.select(0);
        if (Resources.marketTypes != null) {
            this.cmbMarket.removeAll();
            i = 0;
            while (i < Resources.marketTypes.size()) {
                this.cmbMarket.add((String)Resources.marketTypes.get(i));
                ++i;
            }
            try {
                this.cmbMarket.setText(MarketData.marketNames[MarketData.REGULAR]);
            }
            catch (Exception exception) {
                this.cmbMarket.select(0);
            }
        }
        this.cmbMarket.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuoteRequestView.this.securitySelection(false);
                QuoteRequestView.this.cmbMarket.forceFocus();
            }
        });
        if (Resources.PRODUCT_NAME == ProductNames.BIPL_DIRECT) {
            this.researchPortalGroup = new Group(this.content, 131072);
            this.researchPortalGroup.setText("");
            GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)this.researchPortalGroup);
            GridDataFactory.fillDefaults().align(131072, 4).minSize(80, -1).grab(true, false).applyTo((Control)this.researchPortalGroup);
            this.btnResearchPortal = new Button((Composite)this.researchPortalGroup, 0);
            this.btnResearchPortal.setImage(TradingPlugin.getImageDescriptor("icons/buttons16/Research_Portal_logo.gif").createImage());
            this.btnResearchPortal.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String response;
                    if ((Resources.systemClient == 9 || Resources.systemClient == 29 || Resources.systemClient == 12 || Resources.systemClient == 16 || Resources.systemClient == 32 || Resources.systemClient == 3 || Resources.systemClient == 1) && (response = FinnacialDataCommon.getFinnancialDataUrl((String)Resources.finDataUserName, (String)Resources.finDataPassword, (String)Resources.finDataIP, (String)Resources.finDataClient, (String)Resources.finDataUrl, (boolean)false)) != null) {
                        try {
                            System.out.println("text sysmboel : " + QuoteRequestView.this.txtSymbol.getText());
                            if (QuoteRequestView.this.txtSymbol.getText() != "") {
                                response = String.valueOf(response) + "&symbol=" + QuoteRequestView.this.txtSymbol.getText();
                            }
                            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(response));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.tabFolder = new TabFolder(this.content, 0);
        GridData gd = new GridData(4, 0, true, true, 1, 6);
        this.tabFolder.setLayoutData((Object)gd);
        TabItem tabQuoteDetail = new TabItem(this.tabFolder, 0);
        TabItem tabStatistics = new TabItem(this.tabFolder, 0);
        tabQuoteDetail.setText("Quote Detail");
        tabStatistics.setText("Symbol Statistics");
        this.cmpQuoteDetail = new Composite((Composite)this.tabFolder, 0);
        this.cmpQuoteDetail.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().margins(2, 2).applyTo(this.cmpQuoteDetail);
        GridDataFactory.fillDefaults().hint(600, -1);
        this.cmpNorth2 = new Composite(this.cmpQuoteDetail, 0);
        GridLayoutFactory.fillDefaults().spacing(5, 2).margins(5, 5).numColumns(6).equalWidth(true).applyTo(this.cmpNorth2);
        GridDataFactory.fillDefaults().hint(600, -1).applyTo((Control)this.cmpNorth2);
        sc.setContent((Control)this.cmpNorth2);
        this.createLabel(this.cmpNorth2, "Description");
        this.txtDescription = this.createText(this.cmpNorth2, false, 16384);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.txtDescription);
        this.createLabel(this.cmpNorth2, "Currency");
        this.txtCurrency = this.createText(this.cmpNorth2, false, 16384);
        this.createLabel(this.cmpNorth2, "Sector");
        this.txtSector = this.createText(this.cmpNorth2, false, 16384);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.txtSector);
        this.createLabel(this.cmpNorth2, "Lot Size");
        this.txtLotSize = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Previous Close");
        this.txtYersterdayTrd = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Open");
        this.txtOpenFirst = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Change");
        this.txtChange = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Last Trade");
        this.txtLastTrade = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Last Volume");
        this.txtVolume = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Last Trd Time");
        this.txtLastTradeTime = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "High");
        this.txtDailyHigh = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Low");
        this.txtDailyLow = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Market Range");
        this.txtMarketRange = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Total Trades");
        this.txtTotalTrades = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Turnover");
        this.txtTurnover = this.createText(this.cmpNorth2, false, 131072);
        this.createLabel(this.cmpNorth2, "Market Value");
        this.txtMarketValue = this.createText(this.cmpNorth2, false, 131072);
        Group cmpCenter = this.createGroup(this.cmpQuoteDetail, "Announcement Schedule");
        GridLayoutFactory.fillDefaults().spacing(5, 2).margins(5, 5).numColumns(6).equalWidth(true).applyTo((Composite)cmpCenter);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(600, -1).applyTo((Control)cmpCenter);
        this.createLabel((Composite)cmpCenter, "From Date");
        this.txtFromDate = this.createText((Composite)cmpCenter, false, 131072);
        this.createLabel((Composite)cmpCenter, "To Date");
        this.txtToDate = this.createText((Composite)cmpCenter, false, 131072);
        this.createLabel((Composite)cmpCenter, "Spot");
        this.txtSpot = this.createText((Composite)cmpCenter, false, 131072);
        this.createLabel((Composite)cmpCenter, "Face Value");
        this.txtFaceValue = this.createText((Composite)cmpCenter, false, 131072);
        this.createLabel((Composite)cmpCenter, "Dividend");
        this.txtDividend = this.createText((Composite)cmpCenter, false, 131072);
        this.createLabel((Composite)cmpCenter, "Bonus Share");
        this.txtBonusShare = this.createText((Composite)cmpCenter, false, 131072);
        this.createLabel((Composite)cmpCenter, "Right Share");
        this.txtRightShare = this.createText((Composite)cmpCenter, false, 131072);
        this.createLabel((Composite)cmpCenter, "Premium");
        this.txtPremium = this.createText((Composite)cmpCenter, false, 131072);
        Composite cmpSouth = new Composite(this.cmpQuoteDetail, 0);
        GridLayoutFactory.fillDefaults().spacing(5, 5).margins(0, 0).numColumns(2).applyTo(cmpSouth);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).hint(600, -1).applyTo((Control)cmpSouth);
        Group cmpSouthWest = this.createGroup(cmpSouth, "Order Limits");
        GridLayoutFactory.fillDefaults().spacing(5, 2).margins(5, 5).numColumns(4).applyTo((Composite)cmpSouthWest);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)cmpSouthWest);
        this.createLabel((Composite)cmpSouthWest, "Lower Limit");
        this.txtLowerPrice = this.createText((Composite)cmpSouthWest, false, 131072);
        this.createLabel((Composite)cmpSouthWest, "Upper Limit");
        this.txtUpperPrice = this.createText((Composite)cmpSouthWest, false, 131072);
        this.createLabel((Composite)cmpSouthWest, "Max Volume");
        this.txtMaxVolume = this.createText((Composite)cmpSouthWest, false, 131072);
        this.createLabel((Composite)cmpSouthWest, "Max Value");
        this.txtMaxValue = this.createText((Composite)cmpSouthWest, false, 131072);
        Group cmpSouthEast = this.createGroup(cmpSouth, "Buy and Sell");
        GridLayoutFactory.fillDefaults().spacing(2, 2).margins(5, 5).numColumns(2).applyTo((Composite)cmpSouthEast);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)cmpSouthEast);
        this.txtBuyPrice = this.createText((Composite)cmpSouthEast, false, 131072);
        this.txtBuyQty = this.createText((Composite)cmpSouthEast, false, 131072);
        this.txtSellPrice = this.createText((Composite)cmpSouthEast, false, 131072);
        this.txtSellQty = this.createText((Composite)cmpSouthEast, false, 131072);
        DropTarget target = new DropTarget((Control)this.cmpNorth, 1);
        DropTarget target2 = new DropTarget((Control)this.cmpQuoteDetail, 1);
        target.setTransfer(new Transfer[]{SecurityTransfer.getInstance()});
        target2.setTransfer(new Transfer[]{SecurityTransfer.getInstance()});
        target.addDropListener(this.dropTargetListener);
        target2.addDropListener(this.dropTargetListener);
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        this.cmpStatistics = new Composite((Composite)this.tabFolder, 0);
        this.cmpStatistics.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().spacing(2, 2).margins(5, 5).numColumns(2).equalWidth(true).applyTo(this.cmpStatistics);
        DropTarget target3 = new DropTarget((Control)this.cmpStatistics, 1);
        target3.setTransfer(new Transfer[]{SecurityTransfer.getInstance()});
        target3.addDropListener(this.dropTargetListener);
        this.grpCurrentSession = this.createGroup(this.cmpStatistics, "Current Session");
        GridLayoutFactory.fillDefaults().spacing(2, 2).margins(5, 5).numColumns(2).equalWidth(true).applyTo((Composite)this.grpCurrentSession);
        this.grpCurrentSession.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createLabel120((Composite)this.grpCurrentSession, "Last Price");
        this.txtLastPriceToday = this.createText((Composite)this.grpCurrentSession, false, 131072);
        this.createLabel120((Composite)this.grpCurrentSession, "Change");
        this.txtChangeToday = this.createText((Composite)this.grpCurrentSession, false, 131072);
        this.createLabel120((Composite)this.grpCurrentSession, "Price Range");
        this.txtDaysRangeToday = this.createText((Composite)this.grpCurrentSession, false, 131072);
        this.createLabel120((Composite)this.grpCurrentSession, "Turnover");
        this.txtTurnOverToday = this.createText((Composite)this.grpCurrentSession, false, 131072);
        this.createLabel120((Composite)this.grpCurrentSession, "Market Value");
        this.txtMarketValueToday = this.createText((Composite)this.grpCurrentSession, false, 131072);
        this.grpPrevSession = this.createGroup(this.cmpStatistics, "Previous Session");
        GridLayoutFactory.fillDefaults().spacing(2, 2).margins(5, 5).numColumns(2).equalWidth(true).applyTo((Composite)this.grpPrevSession);
        this.grpPrevSession.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createLabel120((Composite)this.grpPrevSession, "Last Price");
        this.txtLastPricePrevDate = this.createText((Composite)this.grpPrevSession, false, 131072);
        this.createLabel120((Composite)this.grpPrevSession, "Change");
        this.txtChangePrevDate = this.createText((Composite)this.grpPrevSession, false, 131072);
        this.createLabel120((Composite)this.grpPrevSession, "Price Range");
        this.txtDaysRangePrevDate = this.createText((Composite)this.grpPrevSession, false, 131072);
        this.createLabel120((Composite)this.grpPrevSession, "Turnover");
        this.txtTurnOverPrevDate = this.createText((Composite)this.grpPrevSession, false, 131072);
        this.createLabel120((Composite)this.grpPrevSession, "Market Value");
        this.txtMarketValuePrevDate = this.createText((Composite)this.grpPrevSession, false, 131072);
        Group grpHistory = this.createGroup(this.cmpStatistics, "Symbol History");
        GridLayoutFactory.fillDefaults().spacing(2, 2).margins(5, 5).numColumns(4).equalWidth(true).applyTo((Composite)grpHistory);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).hint(600, -1).applyTo((Control)grpHistory);
        Label lbl = this.createLabel120((Composite)grpHistory, " ");
        lbl = this.createLabel120((Composite)grpHistory, "Price Range");
        lbl.setFont(this.fontBold);
        lbl = this.createLabel120((Composite)grpHistory, "Price (Average)");
        lbl.setFont(this.fontBold);
        lbl = this.createLabel120((Composite)grpHistory, "Volume (Average)");
        lbl.setFont(this.fontBold);
        this.createLabel120((Composite)grpHistory, "30 Days");
        this.txtPriceRange30D = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceAvg30D = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceVol30D = this.createText((Composite)grpHistory, false, 131072);
        this.createLabel120((Composite)grpHistory, "90 Days");
        this.txtPriceRange90D = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceAvg90D = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceVol90D = this.createText((Composite)grpHistory, false, 131072);
        this.createLabel120((Composite)grpHistory, "180 Days");
        this.txtPriceRange180D = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceAvg180D = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceVol180D = this.createText((Composite)grpHistory, false, 131072);
        this.createLabel120((Composite)grpHistory, "52 Weeks");
        this.txtPriceRange52W = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceAvg52W = this.createText((Composite)grpHistory, false, 131072);
        this.txtPriceVol52W = this.createText((Composite)grpHistory, false, 131072);
        tabQuoteDetail.setControl((Control)this.cmpQuoteDetail);
        tabStatistics.setControl((Control)this.cmpStatistics);
        sc.setContent((Control)this.content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(this.content.computeSize(-1, -1));
    }

    private Label createLabel(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        return lbl;
    }

    private Label createLabel120(Composite parent, String label) {
        Label lbl = new Label(parent, 0);
        lbl.setText(label);
        return lbl;
    }

    private Text createText(Composite parent, boolean enabled, int allign) {
        Text txt = new Text(parent, 0x800 | allign | 8 | 0x10 | 0x80000);
        txt.setLayoutData((Object)this.txtGridData);
        txt.setEnabled(false);
        txt.setEditable(false);
        txt.setFont(this.font);
        return txt;
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 16);
        group.setText(text);
        group.setFont(this.fontBold);
        return group;
    }

    public void setFocus() {
    }

    public void setSecurity(Security newSecurity) {
        if (this.security != null) {
            this.security.getQuoteMonitor().deleteObserver((Observer)this);
            FeedMonitor.cancelMonitor((Security)this.security);
        }
        if (newSecurity != null) {
            newSecurity.getQuoteMonitor().addObserver((Observer)this);
            FeedMonitor.monitor((Security)newSecurity);
        }
        this.setSecurity(newSecurity, true);
    }

    public void setSecurity(final Security newSecurity, final boolean flag) {
        this.security = newSecurity;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Quote quote = null;
                    if (newSecurity != null) {
                        quote = newSecurity.getQuote();
                        try {
                            if (quote != null) {
                                String changeStr = "";
                                double change = newSecurity.getChange();
                                double percentage = newSecurity.getChangePerc();
                                if (change > 0.0) {
                                    changeStr = "+" + QuoteRequestView.this.pf.format(change) + " (+" + QuoteRequestView.this.percentFormatter.format(percentage) + ")";
                                }
                                changeStr = Double.isNaN(percentage) ? String.valueOf(QuoteRequestView.this.pf.format(change)) + " (0.00%)" : String.valueOf(QuoteRequestView.this.pf.format(change)) + " (" + QuoteRequestView.this.percentFormatter.format(percentage) + ")";
                                if (flag) {
                                    QuoteRequestView.this.cmbExchange.setText(newSecurity.getExchange());
                                    QuoteRequestView.this.txtSymbol.setText(newSecurity.getSymbol());
                                    QuoteRequestView.this.cmbMarket.setText(newSecurity.getMarket());
                                }
                                QuoteRequestView.this.txtDescription.setText(newSecurity.getDescription());
                                QuoteRequestView.this.txtCurrency.setText(newSecurity.getCurrency().getSymbol());
                                QuoteRequestView.this.txtOpenFirst.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getOpen())));
                                QuoteRequestView.this.txtLastTrade.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getQuote().getLast())));
                                QuoteRequestView.this.txtChange.setText(changeStr);
                                QuoteRequestView.this.txtYersterdayTrd.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getClose())));
                                QuoteRequestView.this.txtDailyHigh.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getHigh())));
                                QuoteRequestView.this.txtDailyLow.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getLow())));
                                QuoteRequestView.this.txtTotalTrades.setText(String.valueOf(QuoteRequestView.this.nf.format(newSecurity.getTotalTrades())));
                                QuoteRequestView.this.txtMarketRange.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getHigh() - newSecurity.getLow())));
                                QuoteRequestView.this.txtTurnover.setText(String.valueOf(QuoteRequestView.this.nf.format(newSecurity.getTotalTurnover())));
                                QuoteRequestView.this.txtMarketValue.setText(Utility.getMillionString((double)(newSecurity.getQuote().getLast() * (double)newSecurity.getTotalTurnover()), (NumberFormat)QuoteRequestView.this.pf));
                                if (QuoteRequestView.this.security.getQuote().getDate() != null) {
                                    QuoteRequestView.this.txtLastTradeTime.setText(QuoteRequestView.this.timeFormat.format(QuoteRequestView.this.security.getQuote().getDate()));
                                } else {
                                    QuoteRequestView.this.txtLastTradeTime.setText("");
                                }
                                QuoteRequestView.this.txtVolume.setText(String.valueOf(QuoteRequestView.this.nf.format(quote.getVolume())));
                                QuoteRequestView.this.txtSector.setText(QuoteRequestView.this.security.getSector());
                                QuoteRequestView.this.txtLotSize.setText(QuoteRequestView.this.nf.format(QuoteRequestView.this.security.getLotSize()));
                                if (newSecurity.getSpotFrom() != null) {
                                    QuoteRequestView.this.txtFromDate.setText(QuoteRequestView.this.df.format(newSecurity.getSpotFrom()));
                                } else {
                                    QuoteRequestView.this.txtFromDate.setText("");
                                }
                                if (newSecurity.getSpotTo() != null) {
                                    QuoteRequestView.this.txtToDate.setText(QuoteRequestView.this.df.format(newSecurity.getSpotTo()));
                                } else {
                                    QuoteRequestView.this.txtToDate.setText("");
                                }
                                QuoteRequestView.this.txtSpot.setText(newSecurity.getSpot());
                                QuoteRequestView.this.txtLowerPrice.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getLowerLimit())));
                                QuoteRequestView.this.txtUpperPrice.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getUpperLimit())));
                                QuoteRequestView.this.txtMaxValue.setText(String.valueOf(QuoteRequestView.this.pf.format(newSecurity.getMaximumValue())));
                                QuoteRequestView.this.txtMaxVolume.setText(String.valueOf(QuoteRequestView.this.nf.format(newSecurity.getMaximumVolume())));
                                QuoteRequestView.this.txtBuyPrice.setText(String.valueOf(QuoteRequestView.this.pf.format(quote.getBid())));
                                QuoteRequestView.this.txtBuyQty.setText(String.valueOf(QuoteRequestView.this.nf.format(quote.getBidSize())));
                                QuoteRequestView.this.txtSellPrice.setText(String.valueOf(QuoteRequestView.this.pf.format(quote.getAsk())));
                                QuoteRequestView.this.txtSellQty.setText(String.valueOf(QuoteRequestView.this.nf.format(quote.getAskSize())));
                                QuoteRequestView.this.txtFaceValue.setText(QuoteRequestView.this.nf.format(newSecurity.getFaceValue()));
                                QuoteRequestView.this.txtDividend.setText(QuoteRequestView.this.pf.format(newSecurity.getDividend()));
                                QuoteRequestView.this.txtBonusShare.setText(QuoteRequestView.this.pf.format(newSecurity.getBonusShare()));
                                QuoteRequestView.this.txtRightShare.setText(QuoteRequestView.this.pf.format(newSecurity.getRightShare()));
                                QuoteRequestView.this.txtPremium.setText(QuoteRequestView.this.pf.format(newSecurity.getPremium()));
                                QuoteRequestView.this.setSymbolStatistics(newSecurity);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        QuoteRequestView.this.clearFields();
                        QuoteRequestView.this.clearStatistics();
                    }
                }
            });
        }
    }

    private void setSymbolStatistics(Security newSecurity) {
        SymbolStatisticsData stats = newSecurity.getSymbolStatistics();
        this.txtDaysRangeToday.setText(String.valueOf(this.pf.format(this.security.getLow())) + " - " + this.pf.format(this.security.getHigh()));
        this.txtLastPriceToday.setText(this.pf.format(this.security.getQuote().getLast()));
        this.txtChangeToday.setText(this.pf.format(this.security.getChange()));
        this.txtTurnOverToday.setText(String.valueOf(this.nf.format(newSecurity.getTotalTurnover())));
        this.txtMarketValueToday.setText(Utility.getMillionString((double)(newSecurity.getQuote().getLast() * (double)newSecurity.getTotalTurnover()), (NumberFormat)this.pf));
        if (stats != null) {
            if (stats.getPrevDate() != null) {
                this.grpPrevSession.setText("Previous Session (" + this.df.format(stats.getPrevDate()) + ")");
            } else {
                this.grpPrevSession.setText("Previous Session");
            }
            if (newSecurity.getQuote().getDate() != null) {
                this.grpCurrentSession.setText("Current Session (" + this.df.format(newSecurity.getQuote().getDate()) + ")");
            } else {
                this.grpCurrentSession.setText("Current Session");
            }
            this.txtLastPricePrevDate.setText(String.valueOf(this.pf.format(stats.getPrevClose())));
            this.txtChangePrevDate.setText(String.valueOf(this.pf.format(stats.getPrevChange())));
            this.txtTurnOverPrevDate.setText(String.valueOf(this.nf.format(stats.getPrevTurnover())));
            this.txtMarketValuePrevDate.setText(Utility.getMillionString((double)(stats.getPrevClose() * (double)stats.getPrevTurnover()), (NumberFormat)this.pf));
            this.txtDaysRangePrevDate.setText(String.valueOf(this.pf.format(stats.getPrevLow())) + " - " + String.valueOf(this.pf.format(stats.getPrevHigh())));
            this.txtPriceRange30D.setText(String.valueOf(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getLow1Month()))) + " - " + String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getHigh1Month())));
            this.txtPriceRange90D.setText(String.valueOf(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getLow3Month()))) + " - " + String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getHigh3Month())));
            this.txtPriceRange180D.setText(String.valueOf(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getLow6Month()))) + " - " + String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getHigh6Month())));
            this.txtPriceRange52W.setText(String.valueOf(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getLow12Month()))) + " - " + String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getHigh12Month())));
            this.txtPriceAvg30D.setText(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getAvgPrice1Month())));
            this.txtPriceAvg90D.setText(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getAvgPrice3Month())));
            this.txtPriceAvg180D.setText(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getAvgPrice6Month())));
            this.txtPriceAvg52W.setText(String.valueOf(this.pf.format(newSecurity.getSymbolStatistics().getAvgPrice12Month())));
            this.txtPriceVol30D.setText(String.valueOf(this.nf.format(newSecurity.getSymbolStatistics().getAvgVol1Month())));
            this.txtPriceVol90D.setText(String.valueOf(this.nf.format(newSecurity.getSymbolStatistics().getAvgVol3Month())));
            this.txtPriceVol180D.setText(String.valueOf(this.nf.format(newSecurity.getSymbolStatistics().getAvgVol6Month())));
            this.txtPriceVol52W.setText(String.valueOf(this.nf.format(newSecurity.getSymbolStatistics().getAvgVol12Month())));
        } else {
            this.clearStatistics();
        }
    }

    private void clearFields() {
        try {
            if (this.parent != null && !this.parent.isDisposed()) {
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        QuoteRequestView.this.txtDescription.setText("");
                        QuoteRequestView.this.txtCurrency.setText("");
                        QuoteRequestView.this.txtOpenFirst.setText("");
                        QuoteRequestView.this.txtLastTrade.setText("");
                        QuoteRequestView.this.txtChange.setText("");
                        QuoteRequestView.this.txtYersterdayTrd.setText("");
                        QuoteRequestView.this.txtDailyHigh.setText("");
                        QuoteRequestView.this.txtDailyLow.setText("");
                        QuoteRequestView.this.txtTotalTrades.setText("");
                        QuoteRequestView.this.txtTurnover.setText("");
                        QuoteRequestView.this.txtMarketValue.setText("");
                        QuoteRequestView.this.txtVolume.setText("");
                        QuoteRequestView.this.txtSector.setText("");
                        QuoteRequestView.this.txtLotSize.setText("");
                        QuoteRequestView.this.txtFromDate.setText("");
                        QuoteRequestView.this.txtToDate.setText("");
                        QuoteRequestView.this.txtSpot.setText("");
                        QuoteRequestView.this.txtLowerPrice.setText("");
                        QuoteRequestView.this.txtUpperPrice.setText("");
                        QuoteRequestView.this.txtMaxVolume.setText("");
                        QuoteRequestView.this.txtMaxValue.setText("");
                        QuoteRequestView.this.txtBuyPrice.setText("");
                        QuoteRequestView.this.txtSellPrice.setText("");
                        QuoteRequestView.this.txtBuyQty.setText("");
                        QuoteRequestView.this.txtSellQty.setText("");
                        QuoteRequestView.this.txtFaceValue.setText("");
                        QuoteRequestView.this.txtDividend.setText("");
                        QuoteRequestView.this.txtBonusShare.setText("");
                        QuoteRequestView.this.txtRightShare.setText("");
                        QuoteRequestView.this.txtPremium.setText("");
                        if (QuoteRequestView.this.security != null) {
                            QuoteRequestView.this.security.getQuoteMonitor().deleteObserver((Observer)QuoteRequestView.this);
                            FeedMonitor.cancelMonitor((Security)QuoteRequestView.this.security);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {}
    }

    private void clearStatistics() {
        this.txtChangePrevDate.setText("0");
        this.txtTurnOverPrevDate.setText(String.valueOf(this.nf.format(0L)));
        this.txtMarketValuePrevDate.setText(String.valueOf(this.nf.format(0L)));
        this.txtDaysRangePrevDate.setText(String.valueOf(this.nf.format(0L)) + " - " + String.valueOf(this.nf.format(0L)));
        this.txtLastPricePrevDate.setText(String.valueOf(this.pf.format(0L)));
        this.txtPriceRange30D.setText(String.valueOf(String.valueOf(this.pf.format(0L))) + " - " + String.valueOf(this.pf.format(0L)));
        this.txtPriceRange90D.setText(String.valueOf(String.valueOf(this.pf.format(0L))) + " - " + String.valueOf(this.pf.format(0L)));
        this.txtPriceRange180D.setText(String.valueOf(String.valueOf(this.pf.format(0L))) + " - " + String.valueOf(this.pf.format(0L)));
        this.txtPriceRange52W.setText(String.valueOf(String.valueOf(this.pf.format(0L))) + " - " + String.valueOf(this.pf.format(0L)));
        this.txtPriceAvg30D.setText(String.valueOf(this.pf.format(0L)));
        this.txtPriceAvg90D.setText(String.valueOf(this.pf.format(0L)));
        this.txtPriceAvg180D.setText(String.valueOf(this.pf.format(0L)));
        this.txtPriceAvg52W.setText(String.valueOf(this.pf.format(0L)));
        this.txtPriceVol30D.setText(String.valueOf(this.nf.format(0L)));
        this.txtPriceVol90D.setText(String.valueOf(this.nf.format(0L)));
        this.txtPriceVol180D.setText(String.valueOf(this.nf.format(0L)));
        this.txtPriceVol52W.setText(String.valueOf(this.nf.format(0L)));
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        if (Resources.exchangeNames != null) {
                            QuoteRequestView.this.cmbExchange.removeAll();
                            int i = 0;
                            while (i < Resources.exchangeNames.size()) {
                                QuoteRequestView.this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                                ++i;
                            }
                            QuoteRequestView.this.cmbExchange.select(0);
                        }
                    } else if (o instanceof MarketResponse && Resources.marketTypes != null) {
                        QuoteRequestView.this.cmbMarket.removeAll();
                        int i = 0;
                        while (i < Resources.marketTypes.size()) {
                            QuoteRequestView.this.cmbMarket.add((String)Resources.marketTypes.get(i));
                            ++i;
                        }
                        try {
                            QuoteRequestView.this.cmbMarket.setText(MarketData.marketNames[MarketData.REGULAR]);
                        }
                        catch (Exception exception) {
                            QuoteRequestView.this.cmbMarket.select(0);
                        }
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private void securitySelection(boolean selectDefault) {
        Security security = CorePlugin.getRepository().getSecurity(this.cmbExchange.getText(), this.cmbMarket.getText(), this.txtSymbol.getText());
        if (selectDefault && security == null) {
            security = CorePlugin.getRepository().getSecurity(this.txtSymbol.getText());
        }
        this.setSecurity(security);
    }

    @Override
    public void update(Observable arg0, Object obj) {
        if (obj instanceof Security) {
            final Security temp = (Security)obj;
            if (this.parent != null && !this.parent.isDisposed()) {
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (QuoteRequestView.this.security != null && temp.getId().equals(QuoteRequestView.this.security.getId())) {
                            QuoteRequestView.this.setSecurity(temp, false);
                        }
                    }
                });
            }
        }
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().removeCollectionObserver((ICollectionObserver)this);
        if (this.security != null) {
            this.security.getQuoteMonitor().deleteObserver((Observer)this);
            FeedMonitor.cancelMonitor((Security)this.security);
        }
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.followSelection && selection instanceof SecuritySelection && this.parent != null && !this.parent.isDisposed()) {
            try {
                Security temp = ((SecuritySelection)selection).getSecurity();
                this.setSecurity(temp);
            }
            catch (Exception exception) {}
        }
    }
}

