/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ClientAccountRequest;
import pk.com.softech.messages.ClientAccountResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.PaymentRequest;
import pk.com.softech.messages.PaymentResponse;
import pk.com.softech.messages.WithdrawalSummaryRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.dialogs.BrowserDialog;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;
import pk.com.softech.tradingterminal.core.util.ProductNames;

public class PaymentRequestView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.paymentRequest";
    NumberFormat nf = CorePlugin.getNumberFormatter();
    NumberFormat pf = CorePlugin.getPriceFormatter();
    DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
    DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private Text txtClientCode;
    private Text txtCashAmnt;
    private Text txtAccountNo;
    private Text txtAccountTitle;
    private Label lblClientCode;
    private Label lblCashAmnt;
    private Label lblAccountNo;
    private Label lblAccountTitle;
    private Button btnSubmit;
    private Button btnSelf;
    private Button btnChequeDelivery;
    private Button btnBankTransfer;
    Composite parent;
    FontMetrics fontMetrics;
    Log logger = LogFactory.getLog(this.getClass());
    final PriceVerifyListener numberVerifyListener = new PriceVerifyListener();

    public PaymentRequestView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Color clr = new Color((Device)parent.getDisplay(), 0, 0, 0);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Group mainGroup = new Group(composite, 16);
        mainGroup.setText("");
        mainGroup.setLayout((Layout)new GridLayout(2, true));
        mainGroup.setLayoutData((Object)new GridData(768, 2, false, false, 2, 1));
        Group clientDetails = new Group((Composite)mainGroup, 16);
        clientDetails.setText("Client Details");
        clientDetails.setLayout((Layout)new GridLayout(2, true));
        clientDetails.setLayoutData((Object)new GridData(768, 1, false, false, 2, 1));
        clientDetails.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        this.lblClientCode = new Label((Composite)clientDetails, 1);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text((Composite)clientDetails, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaymentRequestView.this.buttonEnablement();
            }
        });
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    PaymentRequestView.this.sendClientDetailRequest();
                    if (Resources.systemClient == 1 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                        PaymentRequestView.this.sendWithdrawalSummaryRequest();
                    }
                }
            }
        });
        this.txtClientCode.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                PaymentRequestView.this.sendClientDetailRequest();
                if (Resources.systemClient == 1 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24) {
                    PaymentRequestView.this.sendWithdrawalSummaryRequest();
                }
            }

            public void focusGained(FocusEvent e) {
                PaymentRequestView.this.txtClientCode.selectAll();
            }
        });
        this.lblAccountTitle = new Label((Composite)clientDetails, 1);
        this.lblAccountTitle.setText("Account Title");
        this.txtAccountTitle = new Text((Composite)clientDetails, 2048);
        this.txtAccountTitle.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)25), -1));
        if (Resources.isClientType()) {
            this.txtAccountTitle.setText(Resources.clientAccTitle);
        } else {
            this.txtAccountTitle.setText("N/A");
        }
        this.txtAccountTitle.setForeground(clr);
        this.txtAccountTitle.setEnabled(false);
        this.txtAccountTitle.setEditable(false);
        this.lblAccountNo = new Label((Composite)clientDetails, 1);
        this.lblAccountNo.setText("Account #");
        this.txtAccountNo = new Text((Composite)clientDetails, 2048);
        this.txtAccountNo.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)25), -1));
        if (Resources.isClientType()) {
            this.txtAccountNo.setText(Resources.clientAccCode);
        } else {
            this.txtAccountNo.setText("N/A");
        }
        this.txtAccountNo.setSize(164, 132);
        this.txtAccountNo.setForeground(clr);
        this.txtAccountNo.setEnabled(false);
        this.txtAccountNo.setEditable(false);
        this.lblCashAmnt = new Label((Composite)clientDetails, 1);
        this.lblCashAmnt.setText("Cash Amount");
        this.txtCashAmnt = new Text((Composite)clientDetails, 2048);
        this.txtCashAmnt.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)25), -1));
        this.txtCashAmnt.addVerifyListener((VerifyListener)this.numberVerifyListener);
        this.txtCashAmnt.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r' && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    PaymentRequestView.this.sendPaymentRequest();
                }
            }
        });
        this.txtCashAmnt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaymentRequestView.this.buttonEnablement();
            }
        });
        Group selectionOper = new Group((Composite)mainGroup, 16);
        selectionOper.setText("Select Operation");
        selectionOper.setLayout((Layout)new GridLayout(3, true));
        selectionOper.setLayoutData((Object)new GridData(768, 2, false, false, 2, 1));
        selectionOper.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        if (Resources.PRODUCT_NAME == ProductNames.ZAFFAR) {
            this.btnChequeDelivery = new Button((Composite)selectionOper, 16);
            this.btnChequeDelivery.setText("Cheque Delivery");
            this.btnChequeDelivery.setSelection(true);
            this.btnChequeDelivery.setToolTipText("Please dispatch cheque through courier");
        } else if (Resources.PRODUCT_NAME == ProductNames.FOUNDATION) {
            this.btnBankTransfer = new Button((Composite)selectionOper, 16);
            this.btnBankTransfer.setText("Bank Transfer");
            this.btnBankTransfer.setSelection(true);
            this.btnBankTransfer.setToolTipText("Transfer to my registered bank account number");
        } else {
            this.btnSelf = new Button((Composite)selectionOper, 16);
            this.btnSelf.setText("Self");
            this.btnSelf.setToolTipText("I will collect cheque by myself");
            this.btnChequeDelivery = new Button((Composite)selectionOper, 16);
            this.btnChequeDelivery.setText("Cheque Delivery");
            this.btnChequeDelivery.setSelection(true);
            this.btnChequeDelivery.setToolTipText("Please dispatch cheque through courier");
            this.btnBankTransfer = new Button((Composite)selectionOper, 16);
            this.btnBankTransfer.setText("Bank Transfer");
            this.btnBankTransfer.setToolTipText("Transfer to my registered bank account number");
        }
        Group btngrp = new Group((Composite)mainGroup, 131072);
        btngrp.setText("");
        btngrp.setLayout((Layout)new GridLayout(1, true));
        btngrp.setLayoutData((Object)new GridData(3, 3, false, false, 2, 1));
        this.btnSubmit = new Button((Composite)btngrp, 8);
        this.btnSubmit.setText("Submit");
        this.btnSubmit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    PaymentRequestView.this.sendPaymentRequest();
                }
            }
        });
        this.buttonEnablement();
    }

    private void sendClientDetailRequest() {
        if (!this.txtClientCode.getText().equals("")) {
            if (Resources.isServerConnected((String)this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)new ClientAccountRequest(this.txtClientCode.getText()));
                if (Resources.systemClient == 1 || Resources.systemClient == 33 || Resources.systemClient == 31 || Resources.systemClient == 9 || Resources.systemClient == 24 || Resources.systemClient == 16) {
                    this.txtCashAmnt.setFocus();
                } else {
                    this.txtCashAmnt.forceFocus();
                }
            } else {
                this.txtClientCode.setText("");
            }
        } else {
            this.txtAccountNo.setText("");
            this.txtAccountTitle.setText("");
        }
    }

    public void sendWithdrawalSummaryRequest() {
        if (!this.txtClientCode.getText().equals("")) {
            if (Resources.isServerConnected((String)this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)new WithdrawalSummaryRequest(this.txtClientCode.getText(), Boolean.valueOf(Resources.userType == 3)));
                this.txtCashAmnt.forceFocus();
            } else {
                this.txtClientCode.setText("");
            }
        }
    }

    private void recieveClientDetailResponse(final ClientAccountResponse resp) {
        if (resp != null && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (resp.getAccount() != null && resp.getTitle() != null) {
                        PaymentRequestView.this.txtAccountNo.setText(resp.getAccount());
                        PaymentRequestView.this.txtAccountTitle.setText(resp.getTitle());
                    }
                }
            });
        }
    }

    public void itemAdded(final Object o) {
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        this.updateFields();
                    } else if (o instanceof ClientAccountResponse) {
                        PaymentRequestView.this.recieveClientDetailResponse((ClientAccountResponse)o);
                    }
                }

                private void updateFields() {
                    PaymentRequestView.this.txtClientCode.setText(Resources.clientId);
                    PaymentRequestView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    if (Resources.isClientType() || Resources.isClientTypeAbbasiSupport()) {
                        PaymentRequestView.this.txtAccountTitle.setText(Resources.clientAccTitle);
                        PaymentRequestView.this.txtAccountNo.setText(Resources.clientAccCode);
                    } else {
                        PaymentRequestView.this.txtAccountTitle.setText("");
                        PaymentRequestView.this.txtAccountNo.setText("");
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private void sendPaymentRequest() {
        block18: {
            try {
                if (!this.txtClientCode.getText().trim().equals("")) {
                    int amount = 0;
                    try {
                        amount = Integer.parseInt(this.txtCashAmnt.getText());
                        if (amount == 0) {
                            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Payment Request", (String)"Invalid Request: Invalid cash amount.");
                        } else {
                            if (Resources.PRODUCT_NAME != ProductNames.ZAFFAR && Resources.PRODUCT_NAME != ProductNames.FOUNDATION && this.btnBankTransfer.getSelection() && (this.txtAccountNo.getText() == null || this.txtAccountNo.getText().trim().equals("") || this.txtAccountTitle.getText() == null || this.txtAccountTitle.getText().trim().equals(""))) {
                                MessageDialog.openWarning(null, (String)"Payment Request", (String)"Dear Client your Bank details are not configured pls. contact our Support to avail the bank transfer facility");
                                return;
                            }
                            if (Resources.payReqMsgText != null && !Resources.payReqMsgText.equals("")) {
                                String messageText = new String(Resources.payReqMsgText);
                                messageText = messageText.replaceAll("<#client_code#>", this.txtClientCode.getText().trim());
                                messageText = messageText.replaceAll("<#request_date#>", this.dateFormat.format(Resources.systemDate));
                                messageText = messageText.replaceAll("<#request_time#>", this.timeFormat.format(new Date()));
                                messageText = messageText.replaceAll("<#payment_amount#>", this.txtCashAmnt.getText());
                                messageText = messageText.replaceAll("<#client_name#>", Resources.userId);
                                BrowserDialog dlg = new BrowserDialog(this.getViewSite().getShell(), "Payment Reqest", messageText);
                                if (dlg.open() == 0) {
                                    Resources.respPayemnt = null;
                                    PaymentRequest pr = null;
                                    if (Resources.PRODUCT_NAME == ProductNames.ZAFFAR || Resources.PRODUCT_NAME == ProductNames.FOUNDATION) {
                                        pr = new PaymentRequest(this.txtClientCode.getText().trim(), this.txtAccountNo.getText(), this.txtAccountTitle.getText(), amount, "CHEQUE DELIVERY");
                                    } else if (this.btnSelf.getSelection()) {
                                        pr = new PaymentRequest(this.txtClientCode.getText().trim(), this.txtAccountNo.getText(), this.txtAccountTitle.getText(), amount, "CHEQUE PICKUP");
                                    } else if (this.btnChequeDelivery.getSelection()) {
                                        pr = new PaymentRequest(this.txtClientCode.getText().trim(), this.txtAccountNo.getText(), this.txtAccountTitle.getText(), amount, "CHEQUE DELIVERY");
                                    } else if (this.btnBankTransfer.getSelection()) {
                                        pr = new PaymentRequest(this.txtClientCode.getText().trim(), this.txtAccountNo.getText(), this.txtAccountTitle.getText(), amount, "BANK TRANSFER");
                                    }
                                    if (Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)pr)) {
                                        this.logger.info((Object)("Payment request sent for " + this.txtClientCode.getText()));
                                        this.txtCashAmnt.setText("");
                                        this.btnSubmit.setEnabled(false);
                                        BusyIndicator.showWhile((Display)this.parent.getDisplay(), (Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                while (Resources.respPayemnt == null) {
                                                    try {
                                                        Thread.sleep(200L);
                                                    }
                                                    catch (Exception exception) {}
                                                }
                                            }
                                        });
                                        this.receiveResponse(Resources.respPayemnt);
                                    }
                                }
                            }
                        }
                        break block18;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Payment Request", (String)("Invalid Request: Invalid Cash Amount " + e.getMessage()));
                    }
                    break block18;
                }
                MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Transfer", (String)"Invalid Request: Please enter client code.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Transfer", (String)"Invalid Data");
            }
        }
    }

    protected void receiveResponse(final PaymentResponse response) {
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        int action = response.getAction();
                        if (action == 1) {
                            MessageDialog.openInformation((Shell)PaymentRequestView.this.getViewSite().getShell(), (String)"Payment Request", (String)response.getRemarks());
                        } else if (action == 2) {
                            MessageDialog.openError((Shell)PaymentRequestView.this.getViewSite().getShell(), (String)"Payment Request", (String)response.getRemarks());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void buttonEnablement() {
        this.btnSubmit.setEnabled(!this.txtClientCode.getText().trim().equals("") && this.numberVerifyListener.isValid());
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    PaymentRequestView.this.txtClientCode.setText(Resources.clientId);
                }
            });
        }
    }
}

