/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.dialogs.SearchPageSelectionDialog;
import pk.com.softech.tradingterminal.trading.views.IPatternSearchPage;
import pk.com.softech.tradingterminal.trading.views.PatternSearchItem;

public class PatternSearchView
extends ViewPart
implements SelectionListener {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.patternSearch";
    private Table table;
    private Color evenForeground = new Color(null, 0, 0, 0);
    private Color evenBackground = new Color(null, 255, 255, 255);
    private Color oddForeground = new Color(null, 0, 0, 0);
    private Color oddBackground = new Color(null, 240, 240, 240);
    private Color negativeForeground = new Color(null, 240, 0, 0);
    private Color positiveForeground = new Color(null, 0, 192, 0);
    private SimpleDateFormat dateFormat = CorePlugin.getDateTimeFormat();
    private NumberFormat priceFormat = CorePlugin.getPriceFormatter();
    private List pages = new ArrayList();
    private IPatternSearchPage currentPage;
    private Action historyMenu;
    private Action refreshAction;
    private Action removeCurrentAction;
    private Action removeAllAction;
    private IMenuCreator menuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            for (IPatternSearchPage page : PatternSearchView.this.pages) {
                MenuItem item = new MenuItem(this.menu, 32);
                item.setText(page.getShortDescription());
                item.setData((Object)page);
                item.addSelectionListener((SelectionListener)PatternSearchView.this);
                if (page != PatternSearchView.this.currentPage) continue;
                item.setSelection(true);
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };

    public void init(IViewSite site) throws PartInitException {
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("begin"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("group6"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("end"));
        this.removeCurrentAction = new Action(){

            public void run() {
                if (PatternSearchView.this.currentPage != null) {
                    int index = PatternSearchView.this.pages.indexOf(PatternSearchView.this.currentPage);
                    PatternSearchView.this.pages.remove(PatternSearchView.this.currentPage);
                    index = index > 0 ? --index : 0;
                    PatternSearchView.this.currentPage = PatternSearchView.this.pages.size() > 0 ? (IPatternSearchPage)PatternSearchView.this.pages.get(index) : null;
                    PatternSearchView.this.updateView();
                }
            }
        };
        this.removeCurrentAction.setToolTipText("Remove Current Search");
        this.removeCurrentAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/elcl16/search_rem.gif"));
        this.removeCurrentAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dlcl16/search_rem.gif"));
        this.removeCurrentAction.setEnabled(false);
        toolBarManager.appendToGroup("group5", (IAction)this.removeCurrentAction);
        this.removeAllAction = new Action(){

            public void run() {
                PatternSearchView.this.pages.clear();
                PatternSearchView.this.currentPage = null;
                PatternSearchView.this.updateView();
            }
        };
        this.removeAllAction.setToolTipText("Remove All Searches");
        this.removeAllAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/elcl16/search_remall.gif"));
        this.removeAllAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dlcl16/search_remall.gif"));
        this.removeAllAction.setEnabled(false);
        toolBarManager.appendToGroup("group5", (IAction)this.removeAllAction);
        this.refreshAction = new Action(){

            public void run() {
                if (PatternSearchView.this.currentPage != null) {
                    Job job = new Job("Search pattern"){

                        protected IStatus run(IProgressMonitor monitor) {
                            PatternSearchView.this.currentPage.run(monitor);
                            PatternSearchView.this.table.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PatternSearchView.this.updateView();
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            }
        };
        this.refreshAction.setToolTipText("Search Again");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(false);
        toolBarManager.appendToGroup("end", (IAction)this.refreshAction);
        this.historyMenu = new Action("History", 4){

            public void run() {
                SearchPageSelectionDialog dlg = new SearchPageSelectionDialog(PatternSearchView.this.getViewSite().getShell(), PatternSearchView.this.pages, PatternSearchView.this.currentPage);
                if (dlg.open() == 0) {
                    PatternSearchView.this.currentPage = dlg.getSelectedPage();
                    PatternSearchView.this.updateView();
                }
            }
        };
        this.historyMenu.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/elcl16/search_history.gif"));
        this.historyMenu.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dlcl16/search_history.gif"));
        this.historyMenu.setToolTipText("Search History");
        this.historyMenu.setMenuCreator(this.menuCreator);
        toolBarManager.appendToGroup("end", (IAction)this.historyMenu);
        site.getActionBars().updateActionBars();
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.table = new Table(content, 65540);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumn column = new TableColumn(this.table, 0);
        column.setWidth(0);
        column.setResizable(false);
        column = new TableColumn(this.table, 16384);
        column.setText("Code");
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = PatternSearchView.this.currentPage.getResults();
                Collections.sort(list, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        return ((PatternSearchItem)arg0).getCode().compareTo(((PatternSearchItem)arg1).getCode());
                    }
                });
                PatternSearchView.this.updateView();
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setText("Name");
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = PatternSearchView.this.currentPage.getResults();
                Collections.sort(list, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        return ((PatternSearchItem)arg0).getDescription().compareTo(((PatternSearchItem)arg1).getDescription());
                    }
                });
                PatternSearchView.this.updateView();
            }
        });
        column = new TableColumn(this.table, 131072);
        column.setText("Date");
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = PatternSearchView.this.currentPage.getResults();
                Collections.sort(list, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        return ((PatternSearchItem)arg0).getDate().compareTo(((PatternSearchItem)arg1).getDate());
                    }
                });
                PatternSearchView.this.updateView();
            }
        });
        column = new TableColumn(this.table, 131072);
        column.setText("Price");
        column = new TableColumn(this.table, 16384);
        column.setText("Pattern");
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = PatternSearchView.this.currentPage.getResults();
                Collections.sort(list, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        return ((PatternSearchItem)arg0).getPattern().compareTo(((PatternSearchItem)arg1).getPattern());
                    }
                });
                PatternSearchView.this.updateView();
            }
        });
        column = new TableColumn(this.table, 16384);
        column.setText("Bullish / Bearish");
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List list = PatternSearchView.this.currentPage.getResults();
                Collections.sort(list, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        return ((PatternSearchItem)arg0).getOpportunity().compareTo(((PatternSearchItem)arg1).getOpportunity());
                    }
                });
                PatternSearchView.this.updateView();
            }
        });
        int i = 1;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.setContentDescription(" ");
    }

    public void setFocus() {
    }

    public void addPage(final IPatternSearchPage page) {
        Job job = new Job("Search pattern"){

            protected IStatus run(IProgressMonitor monitor) {
                page.run(monitor);
                PatternSearchView.this.pages.add(page);
                PatternSearchView.this.currentPage = page;
                PatternSearchView.this.table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PatternSearchView.this.updateView();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void updateView() {
        this.table.setRedraw(false);
        this.table.removeAll();
        if (this.currentPage != null) {
            this.setContentDescription(this.currentPage.getDescription());
            int index = 0;
            for (PatternSearchItem item : this.currentPage.getResults()) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setBackground(!(index & true) ? this.evenBackground : this.oddBackground);
                tableItem.setForeground(!(index & true) ? this.evenForeground : this.oddForeground);
                tableItem.setText(1, item.getCode());
                tableItem.setText(2, item.getDescription());
                tableItem.setText(3, item.getDate() != null ? this.dateFormat.format(item.getDate()) : "");
                tableItem.setText(4, item.getPrice() != null ? this.priceFormat.format(item.getPrice()) : "");
                tableItem.setText(5, item.getPattern());
                tableItem.setText(6, item.getOpportunity());
                tableItem.setForeground(6, item.getOpportunity().equals("Bullish") ? this.positiveForeground : this.negativeForeground);
                ++index;
            }
        } else {
            this.setContentDescription(" ");
        }
        this.table.setRedraw(true);
        int i = 1;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.removeCurrentAction.setEnabled(this.currentPage != null);
        this.removeAllAction.setEnabled(this.currentPage != null);
        this.refreshAction.setEnabled(this.currentPage != null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.currentPage = (IPatternSearchPage)e.widget.getData();
        this.updateView();
    }

    public void dispose() {
        try {
            this.evenForeground.dispose();
            this.evenBackground.dispose();
            this.oddForeground.dispose();
            this.oddBackground.dispose();
            this.negativeForeground.dispose();
            this.positiveForeground.dispose();
        }
        catch (Exception exception) {}
        super.dispose();
    }
}

