/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.messages.Message;
import pk.com.softech.messages.PendingOrderRequest;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.db.OrderStatus;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;
import pk.com.softech.tradingterminal.core.ui.actions.EditColumnsAction;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.ColumnsOptionDialog;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.views.OrderFormView;

public class OrdersView
extends ViewPart
implements IPropertyChangeListener,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.orders";
    public static final String PREFS_ORDERS_VIEW_COLUMNS = "ORDERS_VIEW_COLUMNS";
    public static final String PREFS_ORDERS_VIEW_COLUMNS_SIZE = "ORDERS_VIEW_COLUMNS_SIZE";
    String VIEW_NAME = "Orders";
    public static final String PREFS_PENDING_BUY_FG = "PENDING_BUY_FG";
    public static final String PREFS_PENDING_BUY_BG = "PENDING_BUY_BG";
    public static final String PREFS_PENDING_SELL_FG = "PENDING_SELL_FG";
    public static final String PREFS_PENDING_SELL_BG = "PENDING_SELL_BG";
    public static final String PREFS_FILLED_BUY_FG = "FILLED_BUY_FG";
    public static final String PREFS_FILLED_BUY_BG = "FILLED_BUY_BG";
    public static final String PREFS_FILLED_SELL_FG = "FILLED_SELL_FG";
    public static final String PREFS_FILLED_SELL_BG = "FILLED_SELL_BG";
    public static final String PREFS_CANCELLED_BUY_FG = "CANCELLED_BUY_FG";
    public static final String PREFS_CANCELLED_BUY_BG = "CANCELLED_BUY_BG";
    public static final String PREFS_CANCELLED_SELL_FG = "CANCELLED_SELL_FG";
    public static final String PREFS_CANCELLED_SELL_BG = "CANCELLED_SELL_BG";
    public static final String PREFS_REJECTED_BUY_FG = "REJECTED_BUY_FG";
    public static final String PREFS_REJECTED_BUY_BG = "REJECTED_BUY_BG";
    public static final String PREFS_REJECTED_SELL_FG = "REJECTED_SELL_FG";
    public static final String PREFS_REJECTED_SELL_BG = "REJECTED_SELL_BG";
    public static final String PREFS_TABLE_BG = "TABLE_BG";
    public static final String PREFS_TABLE_FONT = "TABLE_FONT";
    ITheme theme;
    Composite parent;
    CTabFolder tabFolder;
    OrdersTable all;
    OrdersTable pending;
    OrdersTable filled;
    OrdersTable canceled;
    OrdersTable rejected;
    IPreferenceStore preferences;
    Action searchClientAction;
    Text txtOrderCount = null;
    int orderCount = 0;
    private Color queuedBuyForegroundColor = null;
    private Color queuedBuyBackgroundColor = null;
    private Color queuedSellForegroundColor = null;
    private Color queuedSellBackgroundColor = null;
    private Color filledBuyForegroundColor = null;
    private Color filledBuyBackgroundColor = null;
    private Color filledSellForegroundColor = null;
    private Color filledSellBackgroundColor = null;
    private Color canceledBuyForegroundColor = null;
    private Color canceledBuyBackgroundColor = null;
    private Color canceledSellForegroundColor = null;
    private Color canceledSellBackgroundColor = null;
    private Color rejectedBuyForegroundColor = null;
    private Color rejectedBuyBackgroundColor = null;
    private Color rejectedSellForegroundColor = null;
    private Color rejectedSellBackgroundColor = null;
    IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            OrdersTable ordTable = (OrdersTable)OrdersView.this.tabFolder.getSelection().getData();
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                OrdersView.this.setTheme((ITheme)event.getNewValue());
            }
            if (event.getProperty().equals(OrdersView.PREFS_TABLE_BG)) {
                Control[] list = OrdersView.this.tabFolder.getTabList();
                int i = 0;
                while (i < list.length) {
                    if (list[i] instanceof Table) {
                        Table t = (Table)list[i];
                        t.setBackground(OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_TABLE_BG));
                    }
                    ++i;
                }
            } else if (event.getProperty().equals(OrdersView.PREFS_TABLE_FONT)) {
                Control[] list = OrdersView.this.tabFolder.getTabList();
                int i = 0;
                while (i < list.length) {
                    if (list[i] instanceof Table) {
                        Table t = (Table)list[i];
                        t.setFont(OrdersView.this.theme.getFontRegistry().get(OrdersView.PREFS_TABLE_FONT));
                    }
                    ++i;
                }
            } else if (event.getProperty().equals(OrdersView.PREFS_PENDING_BUY_BG)) {
                OrdersView.this.queuedBuyBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_PENDING_BUY_BG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_PENDING_BUY_FG)) {
                OrdersView.this.queuedBuyForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_PENDING_BUY_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_PENDING_SELL_FG)) {
                OrdersView.this.queuedSellForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_PENDING_SELL_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_PENDING_SELL_BG)) {
                OrdersView.this.queuedSellBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_PENDING_SELL_BG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_FILLED_BUY_FG)) {
                OrdersView.this.filledBuyForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_FILLED_BUY_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_FILLED_BUY_BG)) {
                OrdersView.this.filledBuyBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_FILLED_BUY_BG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_FILLED_SELL_FG)) {
                OrdersView.this.filledSellForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_FILLED_SELL_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_FILLED_SELL_BG)) {
                OrdersView.this.filledSellBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_FILLED_SELL_BG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_CANCELLED_BUY_FG)) {
                OrdersView.this.canceledBuyForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_CANCELLED_BUY_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_CANCELLED_BUY_BG)) {
                OrdersView.this.canceledBuyBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_CANCELLED_BUY_BG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_CANCELLED_SELL_FG)) {
                OrdersView.this.canceledSellForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_CANCELLED_SELL_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_CANCELLED_SELL_BG)) {
                OrdersView.this.canceledSellBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_CANCELLED_SELL_BG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_REJECTED_BUY_FG)) {
                OrdersView.this.rejectedBuyForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_REJECTED_BUY_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_REJECTED_BUY_BG)) {
                OrdersView.this.rejectedBuyBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_REJECTED_BUY_BG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_REJECTED_SELL_FG)) {
                OrdersView.this.rejectedSellForegroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_REJECTED_SELL_FG);
                ordTable.updateTable();
            } else if (event.getProperty().equals(OrdersView.PREFS_REJECTED_SELL_BG)) {
                OrdersView.this.rejectedSellBackgroundColor = OrdersView.this.theme.getColorRegistry().get(OrdersView.PREFS_REJECTED_SELL_BG);
                ordTable.updateTable();
            }
        }
    };
    Action cancelRequest;
    Action modifyRequest;
    Action refreshAction;
    Action editColumnsAction;
    LabelProvidersRegistry registry = new LabelProvidersRegistry("pk.com.softech.tradingterminal.trading.orders");
    private Log logger = LogFactory.getLog(this.getClass());

    protected void setTheme(ITheme theme) {
        OrdersTable ordTable = (OrdersTable)this.tabFolder.getSelection().getData();
        if (theme != null) {
            Table t;
            this.theme = theme;
            Control[] list = this.tabFolder.getTabList();
            int i = 0;
            while (i < list.length) {
                if (list[i] instanceof Table) {
                    t = (Table)list[i];
                    t.setBackground(theme.getColorRegistry().get(PREFS_TABLE_BG));
                }
                ++i;
            }
            i = 0;
            while (i < list.length) {
                if (list[i] instanceof Table) {
                    t = (Table)list[i];
                    t.setFont(theme.getFontRegistry().get(PREFS_TABLE_FONT));
                }
                ++i;
            }
            this.queuedBuyBackgroundColor = theme.getColorRegistry().get(PREFS_PENDING_BUY_BG);
            this.queuedBuyForegroundColor = theme.getColorRegistry().get(PREFS_PENDING_BUY_FG);
            this.queuedSellForegroundColor = theme.getColorRegistry().get(PREFS_PENDING_SELL_FG);
            this.queuedSellBackgroundColor = theme.getColorRegistry().get(PREFS_PENDING_SELL_BG);
            this.filledBuyForegroundColor = theme.getColorRegistry().get(PREFS_FILLED_BUY_FG);
            this.filledBuyBackgroundColor = theme.getColorRegistry().get(PREFS_FILLED_BUY_BG);
            this.filledSellForegroundColor = theme.getColorRegistry().get(PREFS_FILLED_SELL_FG);
            this.filledSellBackgroundColor = theme.getColorRegistry().get(PREFS_FILLED_SELL_BG);
            this.canceledBuyForegroundColor = theme.getColorRegistry().get(PREFS_CANCELLED_BUY_FG);
            this.canceledBuyBackgroundColor = theme.getColorRegistry().get(PREFS_CANCELLED_BUY_BG);
            this.canceledSellForegroundColor = theme.getColorRegistry().get(PREFS_CANCELLED_SELL_FG);
            this.canceledSellBackgroundColor = theme.getColorRegistry().get(PREFS_CANCELLED_SELL_BG);
            this.rejectedBuyForegroundColor = theme.getColorRegistry().get(PREFS_REJECTED_BUY_FG);
            this.rejectedBuyBackgroundColor = theme.getColorRegistry().get(PREFS_REJECTED_BUY_BG);
            this.rejectedSellBackgroundColor = theme.getColorRegistry().get(PREFS_REJECTED_SELL_BG);
            this.rejectedSellForegroundColor = theme.getColorRegistry().get(PREFS_REJECTED_SELL_FG);
            ordTable.updateTable();
            theme.addPropertyChangeListener(this.themeChangeListener);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
        Resources.supportServerMessage.addObserver((Observer)this);
        this.VIEW_NAME = this.getPartName();
        super.init(site);
        this.searchClientAction = new Action("Total Orders", 1){

            public void run() {
            }
        };
        this.searchClientAction.setText("Total Orders : " + this.orderCount);
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        ToolBarManager toolbarManager = (ToolBarManager)bars.getToolBarManager();
        toolbarManager.add((IAction)this.searchClientAction);
    }

    public void createPartControl(Composite parent) {
        this.logger.info((Object)"*********************Orders View*********************");
        this.parent = parent;
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        this.tabFolder = new CTabFolder(content, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText("All");
        this.all = new OrdersTable((Composite)this.tabFolder, new ArrayList());
        tabItem.setControl((Control)this.all.getControl());
        tabItem.setData((Object)this.all);
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText("Pending");
        OrderStatus[] pendingFilter = new OrderStatus[]{OrderStatus.NEW, OrderStatus.PARTIAL, OrderStatus.PENDING_CANCEL, OrderStatus.PENDING_NEW, OrderStatus.QUEUED, OrderStatus.AFTER_HOUR};
        this.pending = new OrdersTable((Composite)this.tabFolder, Arrays.asList(pendingFilter));
        tabItem.setControl((Control)this.pending.getControl());
        tabItem.setData((Object)this.pending);
        if (Resources.PRODUCT_NAME != ProductNames.IMTRADE) {
            tabItem = new CTabItem(this.tabFolder, 0);
            tabItem.setText("Filled");
            OrderStatus[] filledFilter = new OrderStatus[]{OrderStatus.FILLED};
            this.filled = new OrdersTable((Composite)this.tabFolder, Arrays.asList(filledFilter));
            tabItem.setControl((Control)this.filled.getControl());
            tabItem.setData((Object)this.filled);
        }
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText("Cancelled");
        OrderStatus[] canceledFilter = new OrderStatus[]{OrderStatus.CANCELED};
        this.canceled = new OrdersTable((Composite)this.tabFolder, Arrays.asList(canceledFilter));
        tabItem.setControl((Control)this.canceled.getControl());
        tabItem.setData((Object)this.canceled);
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText("Rejected");
        OrderStatus[] rejectedFilter = new OrderStatus[]{OrderStatus.REJECTED};
        this.rejected = new OrdersTable((Composite)this.tabFolder, Arrays.asList(rejectedFilter));
        tabItem.setControl((Control)this.rejected.getControl());
        tabItem.setData((Object)this.rejected);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder folder = (CTabFolder)e.getSource();
                CTabItem item = folder.getSelection();
                OrdersTable tab = (OrdersTable)item.getData();
                tab.updateTable();
                OrdersView.this.updateActionsEnablement();
            }
        });
        this.tabFolder.setSelection(0);
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        this.setTheme(theme);
        this.all.updateTable();
        this.makeViewActions();
        this.contributeToActionbar();
        this.updateActionsEnablement();
    }

    private Label createLabel(CTabFolder tabFolder2, String label, String gridData) {
        Label temp = new Label(this.parent, 0);
        temp.setText(label);
        temp.setLayoutData((Object)gridData);
        return temp;
    }

    private void makeViewActions() {
        this.modifyRequest = new Action(){

            public void run() {
                OrdersView.this.logger.info((Object)"Modify Request Recieved");
                Order[] selection = OrdersView.this.getSelectedOrders();
                OrdersView.this.logger.info((Object)("Selection Length : " + selection.length));
                if (selection.length == 1) {
                    Order cfr_ignored_0 = selection[0];
                    try {
                        IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.buytrade");
                        if (viewPart != null) {
                            OrdersView.this.logger.info((Object)"Edit Order Form Request");
                            OrderFormView view = (OrderFormView)viewPart;
                            view.setFormTitle("Modify Order Form");
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.modifyRequest.setText("Modify");
        this.modifyRequest.setToolTipText("Modify");
        this.modifyRequest.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/elcl16/defaultview_misc.gif"));
        this.modifyRequest.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dlcl16/defaultview_misc.gif"));
        this.modifyRequest.setEnabled(false);
        this.cancelRequest = new Action(){

            public void run() {
                OrdersView.this.logger.info((Object)"Cancel Request Recieved");
                try {
                    if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                        Order[] selection = OrdersView.this.getSelectedOrders();
                        OrdersView.this.logger.info((Object)("Selection Length : " + selection.length));
                        if (TradingPlugin.getDefault().pinCodeValidation("Are you sure you want to cancel selected " + selection.length + " order(s) ?", null)) {
                            try {
                                int i = 0;
                                while (i < selection.length) {
                                    OrdersView.this.logger.info((Object)"Orders Cancel Confirmation Recieved");
                                    selection[i].cancelRequest();
                                    --OrdersView.this.orderCount;
                                    ++i;
                                }
                                OrdersView.this.searchClientAction.setText("Total Orders : " + OrdersView.this.orderCount);
                            }
                            catch (RuntimeException e) {
                                MessageDialog.openError(null, (String)"Error in Order Cancellation", (String)e.getMessage());
                            }
                        }
                    } else {
                        OrdersView.this.clearFields();
                    }
                    OrdersView.this.updateActionsEnablement();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        };
        this.cancelRequest.setText("Cancel");
        this.cancelRequest.setToolTipText("Cancel");
        this.cancelRequest.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/elcl16/delete_edit.gif"));
        this.cancelRequest.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dlcl16/delete_edit.gif"));
        this.cancelRequest.setEnabled(false);
        this.refreshAction = new Action(){

            public void run() {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    OrdersView.this.sendPendingOrderRequest();
                } else {
                    OrdersView.this.clearFields();
                }
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
        this.editColumnsAction = new EditColumnsAction((Dialog)new ColumnsOptionDialog((IViewPart)this, PREFS_ORDERS_VIEW_COLUMNS, PREFS_ORDERS_VIEW_COLUMNS_SIZE, this.preferences));
    }

    private void sendPendingOrderRequest() {
        this.logger.info((Object)"Send Pending Order Request");
        this.deselectAll();
        this.updateActionsEnablement();
        this.logger.info((Object)("Sending pendOrd Request for exchange " + Utility.getClientExchanges((Vector)Resources.exchangeCodes)));
        PendingOrderRequest pendOrdRequest = new PendingOrderRequest(2);
        pendOrdRequest.setStExCode(Utility.getClientExchanges((Vector)Resources.exchangeCodes));
        this.clearFields();
        Resources.sendToAllMS((Message)pendOrdRequest);
    }

    private void clearFields() {
        CorePlugin.getRepository().allOrders().clear();
    }

    private void contributeToActionbar() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("bottom"));
        menuManager.appendToGroup("top", (IAction)this.editColumnsAction);
        menuManager.appendToGroup("top", (IAction)new ResizeColumnsAction((Table)this.tabFolder.getSelection().getControl()));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
        toolBarManager.appendToGroup("bottom", (IAction)this.refreshAction);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.preferences.removePropertyChangeListener((IPropertyChangeListener)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        if (theme != null) {
            theme.removePropertyChangeListener(this.themeChangeListener);
        }
        super.dispose();
    }

    void updateActionsEnablement() {
        this.logger.info((Object)"Update Action Enablement");
        boolean cancelEnable = false;
        Order[] selection = this.getSelectedOrders();
        this.logger.info((Object)("No of Selected Orders : " + selection.length));
        int i = 0;
        while (i < selection.length) {
            this.logger.info((Object)("Selection Status " + selection[i].getStatus()));
            cancelEnable = !OrderStatus.CANCELED.equals((Object)selection[i].getStatus()) && !OrderStatus.FILLED.equals((Object)selection[i].getStatus()) && !OrderStatus.REJECTED.equals((Object)selection[i].getStatus()) && !"KATS".equalsIgnoreCase(selection[i].getOrderSource());
            ++i;
        }
        this.logger.info((Object)("Cancel Enable : " + cancelEnable));
        this.cancelRequest.setEnabled(cancelEnable);
        this.modifyRequest.setEnabled(false);
        if (selection.length == 1 && (OrderStatus.PARTIAL.equals((Object)selection[0].getStatus()) || OrderStatus.QUEUED.equals((Object)selection[0].getStatus()) || OrderStatus.AFTER_HOUR.equals((Object)selection[0].getStatus())) && !"KATS".equalsIgnoreCase(selection[0].getOrderSource())) {
            this.logger.info((Object)"Modify Enable : true ");
            this.modifyRequest.setEnabled(true);
        }
    }

    Order[] getSelectedOrders() {
        ArrayList orders = new ArrayList();
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            Table table = (Table)item.getControl();
            int[] selection = table.getSelectionIndices();
            OrdersTable ordersTable = (OrdersTable)table.getData();
            int i = 0;
            while (i < selection.length) {
                orders.add(ordersTable.list.get(selection[i]));
                ++i;
            }
        }
        this.logger.info((Object)("Get Selected Orders : " + orders.size()));
        return orders.toArray(new Order[orders.size()]);
    }

    private void deselectAll() {
        this.logger.info((Object)"Deselect All");
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            Table table = (Table)item.getControl();
            table.deselectAll();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(PREFS_ORDERS_VIEW_COLUMNS)) {
            this.all.updateTable();
            this.pending.updateTable();
            this.filled.updateTable();
            this.canceled.updateTable();
            this.rejected.updateTable();
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    OrdersView.this.sendPendingOrderRequest();
                }
            });
        }
    }

    public class OrdersTable
    implements ICollectionObserver,
    Observer {
        boolean columnMove = false;
        Table table;
        List filter = new ArrayList();
        List list = new ArrayList();
        int sortColumn = -1;
        int sortDirection = -1;
        private ControlListener columnControlListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                StringBuffer sizes = new StringBuffer();
                int i = 0;
                while (i < OrdersTable.this.table.getColumnCount()) {
                    System.out.println("table Columns : " + OrdersTable.this.table.getColumnCount());
                    sizes.append(String.valueOf(String.valueOf(OrdersTable.this.table.getColumn(i).getWidth())) + ";");
                    ++i;
                }
                ((OrdersTable)OrdersTable.this).OrdersView.this.preferences.setValue(OrdersView.PREFS_ORDERS_VIEW_COLUMNS_SIZE, sizes.toString());
            }

            public void controlMoved(ControlEvent e) {
                if (!OrdersTable.this.columnMove) {
                    return;
                }
                int[] ord = OrdersTable.this.table.getColumnOrder();
                int[] newOrd = new int[ord.length];
                StringBuffer ids = new StringBuffer();
                int i = 0;
                while (i < OrdersTable.this.table.getColumnCount()) {
                    newOrd[i] = i;
                    TableColumn col = OrdersTable.this.table.getColumn(ord[i]);
                    ids.append(col.getData("columnId") + ";");
                    ++i;
                }
                OrdersTable.this.table.setColumnOrder(newOrd);
                ((OrdersTable)OrdersTable.this).OrdersView.this.preferences.setValue(OrdersView.PREFS_ORDERS_VIEW_COLUMNS, ids.toString());
            }
        };
        SelectionListener columnSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = OrdersTable.this.table.indexOf((TableColumn)e.widget);
                if (OrdersTable.this.sortColumn == index) {
                    OrdersTable.this.sortDirection = OrdersTable.this.sortDirection == 0 ? 1 : 0;
                } else {
                    OrdersTable.this.sortColumn = index;
                    OrdersTable.this.sortDirection = 0;
                }
                OrdersTable.this.updateTable();
            }
        };
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Object provider;
                if (OrdersTable.this.sortColumn >= 0 && OrdersTable.this.sortColumn < OrdersTable.this.table.getColumnCount() && (provider = OrdersTable.this.table.getColumn(OrdersTable.this.sortColumn).getData("labelProvider")) instanceof Comparator) {
                    if (OrdersTable.this.sortDirection == 0) {
                        return ((Comparator)provider).compare(arg0, arg1);
                    }
                    return ((Comparator)provider).compare(arg1, arg0);
                }
                return 0;
            }
        };

        public OrdersTable(Composite parent, List filter) {
            CorePlugin.getRepository().allOrders().addCollectionObserver((ICollectionObserver)this);
            this.filter = filter;
            this.table = new Table(parent, 65538);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CorePlugin.getRepository().allOrders().removeCollectionObserver((ICollectionObserver)OrdersTable.this);
                    for (Order order : OrdersTable.this.list) {
                        order.deleteObserver((Observer)OrdersTable.this);
                    }
                }
            });
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OrdersView.this.logger.info((Object)"Table Selection Listener");
                    OrdersView.this.updateActionsEnablement();
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (OrdersTable.this.table.getItem(new Point(e.x, e.y)) == null) {
                        OrdersView.this.logger.info((Object)"Mouse Down Listener");
                        OrdersTable.this.table.deselectAll();
                        OrdersView.this.updateActionsEnablement();
                    }
                }
            });
            this.table.setData((Object)this);
            MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager menuManager) {
                    menuManager.add((IContributionItem)new Separator("top"));
                    if (Resources.cancelOrderOption) {
                        menuManager.add((IAction)((OrdersTable)OrdersTable.this).OrdersView.this.cancelRequest);
                    }
                    menuManager.add((IContributionItem)new Separator("additions"));
                    if (Resources.modifyOrderOption) {
                        menuManager.add((IAction)((OrdersTable)OrdersTable.this).OrdersView.this.modifyRequest);
                    }
                    menuManager.add((IContributionItem)new Separator("bottom"));
                }
            });
            this.table.setMenu(menuMgr.createContextMenu((Control)this.table));
            OrdersView.this.getSite().registerContextMenu(menuMgr, OrdersView.this.getSite().getSelectionProvider());
            Order[] orders = (Order[])CorePlugin.getRepository().allOrders().toArray((Object[])new Order[0]);
            int i = 0;
            while (i < orders.length) {
                if (filter.size() == 0 || filter.contains(orders[i].getStatus())) {
                    this.list.add(orders[i]);
                }
                ++i;
            }
            this.updateTable();
        }

        public Table getControl() {
            return this.table;
        }

        public void updateTable() {
            OrdersView.this.orderCount = 0;
            this.columnMove = false;
            if (this.table != null && !this.table.isDisposed()) {
                int index = 0;
                String[] id = OrdersView.this.preferences.getString(OrdersView.PREFS_ORDERS_VIEW_COLUMNS).split(";");
                int i = 0;
                while (i < id.length) {
                    TableColumn tableColumn;
                    String name = "";
                    int style = 16384;
                    Image image = null;
                    ILabelProvider provider = OrdersView.this.registry.createLabelProvider(id[i]);
                    if (provider != null) {
                        name = OrdersView.this.registry.getName(id[i]);
                        style = OrdersView.this.registry.getOrientation(id[i]);
                        if (provider instanceof ITableLabelProvider) {
                            name = ((ITableLabelProvider)provider).getColumnText(null, i);
                            image = ((ITableLabelProvider)provider).getColumnImage(null, i);
                        }
                    } else {
                        LogFactory.getLog(this.getClass()).warn((Object)("Missing column [" + id[i] + "]"));
                    }
                    if (index < this.table.getColumnCount()) {
                        tableColumn = this.table.getColumn(index);
                        if (tableColumn.getData("labelProvider") != null) {
                            ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                        }
                    } else {
                        tableColumn = new TableColumn(this.table, style);
                        tableColumn.addControlListener(this.columnControlListener);
                        tableColumn.addSelectionListener(this.columnSelectionListener);
                        tableColumn.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (e.widget.getData("labelProvider") != null) {
                                    ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                                }
                            }
                        });
                    }
                    tableColumn.setText(name);
                    tableColumn.setAlignment(style);
                    tableColumn.setMoveable(true);
                    tableColumn.setImage(image);
                    tableColumn.setData("labelProvider", (Object)provider);
                    tableColumn.setData("columnId", (Object)id[i]);
                    ++index;
                    ++i;
                }
                while (index < this.table.getColumnCount()) {
                    this.table.getColumn(index).dispose();
                }
                if (this.sortColumn >= 0 && this.sortColumn < this.table.getColumnCount()) {
                    this.table.setSortColumn(this.table.getColumn(this.sortColumn));
                    this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                    Collections.sort(this.list, this.comparator);
                } else {
                    this.table.setSortColumn(null);
                    this.sortColumn = -1;
                    this.sortDirection = 0;
                }
                this.table.removeAll();
                Iterator iter = this.list.iterator();
                while (iter.hasNext()) {
                    ++OrdersView.this.orderCount;
                    Order order = (Order)iter.next();
                    TableItem tableItem = new TableItem(this.table, 0);
                    this.update(tableItem, order);
                    order.addObserver((Observer)this);
                }
                OrdersView.this.searchClientAction.setText("Total Orders : " + OrdersView.this.orderCount);
                String[] sizes = OrdersView.this.preferences.getString(OrdersView.PREFS_ORDERS_VIEW_COLUMNS_SIZE).split(";");
                int i2 = 0;
                while (i2 < this.table.getColumnCount()) {
                    if (i2 < sizes.length && sizes[i2].length() != 0) {
                        this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
                    } else {
                        this.table.getColumn(i2).setWidth(100);
                    }
                    ++i2;
                }
                if ("gtk".equals(SWT.getPlatform())) {
                    this.table.getColumn(this.table.getColumnCount() - 1).pack();
                }
            }
            this.columnMove = true;
        }

        void update(TableItem tableItem, Order order) {
            int i = 0;
            i = 0;
            while (i < this.table.getColumnCount()) {
                TableColumn tableColumn = this.table.getColumn(i);
                ILabelProvider label = (ILabelProvider)tableColumn.getData("labelProvider");
                if (label != null) {
                    tableItem.setText(i, label.getText((Object)order));
                    Image image = label.getImage((Object)order);
                    if (image != tableItem.getImage(i)) {
                        tableItem.setImage(image);
                    }
                }
                ++i;
            }
            OrdersView.this.searchClientAction.setText("Total Orders : " + OrdersView.this.orderCount);
            if (OrderStatus.QUEUED.equals((Object)order.getStatus()) || OrderStatus.NEW.equals((Object)order.getStatus()) || OrderStatus.PENDING_CANCEL.equals((Object)order.getStatus()) || OrderStatus.PARTIAL.equals((Object)order.getStatus()) || OrderStatus.PENDING_NEW.equals((Object)order.getStatus()) || OrderStatus.AFTER_HOUR.equals((Object)order.getStatus())) {
                if (order.getSide().getValue() == 0) {
                    tableItem.setBackground(OrdersView.this.queuedBuyBackgroundColor);
                    tableItem.setForeground(OrdersView.this.queuedBuyForegroundColor);
                } else if (1 == order.getSide().getValue()) {
                    tableItem.setBackground(OrdersView.this.queuedSellBackgroundColor);
                    tableItem.setForeground(OrdersView.this.queuedSellForegroundColor);
                }
            } else if (OrderStatus.FILLED.equals((Object)order.getStatus())) {
                if (order.getSide().getValue() == 0) {
                    tableItem.setBackground(OrdersView.this.filledBuyBackgroundColor);
                    tableItem.setForeground(OrdersView.this.filledBuyForegroundColor);
                } else if (1 == order.getSide().getValue()) {
                    tableItem.setBackground(OrdersView.this.filledSellBackgroundColor);
                    tableItem.setForeground(OrdersView.this.filledSellForegroundColor);
                }
            } else if (OrderStatus.CANCELED.equals((Object)order.getStatus())) {
                if (order.getSide().getValue() == 0) {
                    tableItem.setBackground(OrdersView.this.canceledBuyBackgroundColor);
                    tableItem.setForeground(OrdersView.this.canceledBuyForegroundColor);
                } else if (1 == order.getSide().getValue()) {
                    tableItem.setBackground(OrdersView.this.canceledSellBackgroundColor);
                    tableItem.setForeground(OrdersView.this.canceledSellForegroundColor);
                }
            } else if (OrderStatus.REJECTED.equals((Object)order.getStatus())) {
                if (order.getSide().getValue() == 0) {
                    tableItem.setBackground(OrdersView.this.rejectedBuyBackgroundColor);
                    tableItem.setForeground(OrdersView.this.rejectedBuyForegroundColor);
                } else if (1 == order.getSide().getValue()) {
                    tableItem.setBackground(OrdersView.this.rejectedSellBackgroundColor);
                    tableItem.setForeground(OrdersView.this.rejectedSellForegroundColor);
                }
            } else {
                tableItem.setForeground(null);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            final Order order = (Order)o;
            if (this.table != null && !this.table.isDisposed()) {
                this.table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int index = OrdersTable.this.list.indexOf(order);
                        if (index != -1 && !OrdersTable.this.table.isDisposed()) {
                            TableItem tableItem = OrdersTable.this.table.getItem(index);
                            if (OrdersTable.this.filter.size() != 0 && !OrdersTable.this.filter.contains(order.getStatus())) {
                                tableItem.dispose();
                                OrdersTable.this.list.remove(order);
                            } else {
                                OrdersTable.this.update(tableItem, order);
                            }
                        }
                        if (OrdersTable.this.filter.size() == 0) {
                            if (OrderStatus.FILLED.equals((Object)order.getStatus())) {
                                if (((OrdersTable)OrdersTable.this).OrdersView.this.filled.list.indexOf(order) == -1) {
                                    ((OrdersTable)OrdersTable.this).OrdersView.this.filled.itemAdded(order);
                                }
                            } else if (OrderStatus.CANCELED.equals((Object)order.getStatus())) {
                                if (((OrdersTable)OrdersTable.this).OrdersView.this.canceled.list.indexOf(order) == -1) {
                                    ((OrdersTable)OrdersTable.this).OrdersView.this.canceled.itemAdded(order);
                                }
                            } else if (OrderStatus.REJECTED.equals((Object)order.getStatus())) {
                                if (((OrdersTable)OrdersTable.this).OrdersView.this.rejected.list.indexOf(order) == -1) {
                                    ((OrdersTable)OrdersTable.this).OrdersView.this.rejected.itemAdded(order);
                                }
                            } else if (((OrdersTable)OrdersTable.this).OrdersView.this.pending.list.indexOf(order) == -1) {
                                ((OrdersTable)OrdersTable.this).OrdersView.this.pending.itemAdded(order);
                            }
                        }
                        if ("gtk".equals(SWT.getPlatform())) {
                            OrdersTable.this.table.getColumn(OrdersTable.this.table.getColumnCount() - 1).pack();
                        }
                    }
                });
            }
        }

        public void itemAdded(Object o) {
            try {
                if (o instanceof Order) {
                    final Order order = (Order)o;
                    if (this.filter.size() == 0 || this.filter.contains(order.getStatus())) {
                        this.list.add(order);
                        OrdersView.this.orderCount = CorePlugin.getRepository().allOrders().size();
                        if (this.table != null && !this.table.isDisposed()) {
                            this.table.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (OrdersTable.this.list.indexOf(order) != -1) {
                                            TableItem tableItem = new TableItem(OrdersTable.this.table, 0);
                                            OrdersTable.this.update(tableItem, order);
                                            order.addObserver((Observer)OrdersTable.this);
                                            if ("gtk".equals(SWT.getPlatform())) {
                                                OrdersTable.this.table.getColumn(OrdersTable.this.table.getColumnCount() - 1).pack();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        OrdersView.this.logger.error((Object)"", (Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void itemRemoved(Object o) {
            try {
                final Order order = (Order)o;
                if (this.table != null && !this.table.isDisposed()) {
                    this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            int index = OrdersTable.this.list.indexOf(order);
                            if (index != -1 && index < OrdersTable.this.table.getItemCount()) {
                                OrdersTable.this.table.getItem(index).dispose();
                                OrdersTable.this.list.remove(index);
                                order.deleteObserver((Observer)OrdersTable.this);
                                if ("gtk".equals(SWT.getPlatform())) {
                                    OrdersTable.this.table.getColumn(OrdersTable.this.table.getColumnCount() - 1).pack();
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

