/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.OrderData;
import pk.com.softech.messages.OrderMessage;
import pk.com.softech.messages.PendingOrderRequest;
import pk.com.softech.messages.PendingOrderResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.db.Order;
import pk.com.softech.tradingterminal.core.db.OrderStatus;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.views.OrderFormView;

public class OrdersSummaryView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.ordersSummary";
    public static final String PREFS_ORDERS_SUMMARY_VIEW_COLUMNS_SIZE = "ORDERS_SUMMARY_VIEW_COLUMNS_SIZE";
    FontMetrics fontMetrics;
    private Combo cmbExchange;
    private Text txtClientCode;
    private Text txtSubCode;
    private Text txtSymbol;
    private Text txtReferenceNo;
    private Label lblExchange;
    private Label lblClientCode;
    private Label lblSubCode;
    private Label lblSymbol;
    private Label lblReferenceNo;
    private Button btnFetch;
    private Button btnCancelAll;
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    private NumberFormat nf = CorePlugin.getNumberFormatter();
    Action refreshAction;
    Action cancelRequest;
    Action modifyRequest;
    Table table = null;
    protected Log logger = LogFactory.getLog(this.getClass());
    Composite parent;
    String[] columns = new String[]{"Exchange", "Symbol", "Side", "Volume", "Unit Price", "Client", "Ref Number", "Sub Code", "Order Id", "Order Type", "User Id", "Order Nature"};
    static int EXCHANGE = 0;
    static int SYMBOL = 1;
    static int SIDE = 2;
    static int VOLUME = 3;
    static int UNIT_PRICE = 4;
    static int CLIENT = 5;
    static int REF_NO = 6;
    static int SUB_CODE = 7;
    static int ORDER_ID = 8;
    static int Order_Type = 9;
    static int User_Id = 10;
    static int Order_nature = 11;
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < OrdersSummaryView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(OrdersSummaryView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            TradingPlugin.getDefault().getPreferenceStore().setValue(OrdersSummaryView.PREFS_ORDERS_SUMMARY_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };

    public OrdersSummaryView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
        this.modifyRequest = new Action(){

            public void run() {
                OrdersSummaryView.this.logger.info((Object)"Modify Request Recieved");
                Order[] selection = OrdersSummaryView.this.getSelectedOrders();
                OrdersSummaryView.this.logger.info((Object)("Selection Length : " + selection.length));
                if (selection.length == 1) {
                    Order order = selection[0];
                    try {
                        IViewPart viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.buytrade");
                        if (viewPart != null) {
                            OrdersSummaryView.this.logger.info((Object)"Edit Order Form Request");
                            OrderFormView view = (OrderFormView)viewPart;
                            view.setFormTitle("Modify Order Form");
                            view.setOrder(order);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.modifyRequest.setText("Modify");
        this.modifyRequest.setToolTipText("Modify");
        this.modifyRequest.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/elcl16/defaultview_misc.gif"));
        this.modifyRequest.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dlcl16/defaultview_misc.gif"));
        this.modifyRequest.setEnabled(false);
        this.cancelRequest = new Action(){

            public void run() {
                OrdersSummaryView.this.logger.info((Object)"Cancel Request Recieved");
                try {
                    Order[] selection = OrdersSummaryView.this.getSelectedOrders();
                    OrdersSummaryView.this.logger.info((Object)("Selection Length : " + selection.length));
                    if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                        if (TradingPlugin.getDefault().pinCodeValidation("Are you sure you want to cancel selected " + selection.length + " order(s) ?", null)) {
                            try {
                                int i = 0;
                                while (i < selection.length) {
                                    OrdersSummaryView.this.logger.info((Object)"Orders Cancel Confirmation Recieved");
                                    selection[i].cancelRequest();
                                    ++i;
                                }
                            }
                            catch (RuntimeException e) {
                                MessageDialog.openError(null, (String)"Error in Order Cancellation", (String)e.getMessage());
                            }
                        }
                    } else {
                        OrdersSummaryView.this.clearFields();
                    }
                    OrdersSummaryView.this.updateActionsEnablement();
                }
                catch (NumberFormatException numberFormatException) {}
            }
        };
        this.cancelRequest.setText("Cancel");
        this.cancelRequest.setToolTipText("Cancel");
        this.cancelRequest.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/elcl16/delete_edit.gif"));
        this.cancelRequest.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dlcl16/delete_edit.gif"));
        this.cancelRequest.setEnabled(false);
        this.refreshAction = new Action(){

            public void run() {
                OrdersSummaryView.this.sendReportRequest();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
    }

    public void createPartControl(Composite parent) {
        this.logger.info((Object)"**************Client Orders Summary View*******************");
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite content = new Composite((Composite)sc, 0);
        GridLayoutFactory.swtDefaults().numColumns(8).equalWidth(false).applyTo(content);
        GridData gdSingleSpan = new GridData(4, 1024, true, false);
        gdSingleSpan.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)20);
        this.lblExchange = new Label(content, 0);
        this.lblExchange.setText("Exchange");
        this.cmbExchange = new Combo(content, 2056);
        this.cmbExchange.setLayoutData((Object)gdSingleSpan);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            this.cmbExchange.add("All");
            int i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.lblClientCode = new Label(content, 0);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text(content, 2048);
        this.txtClientCode.setLayoutData((Object)gdSingleSpan);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    OrdersSummaryView.this.sendReportRequest();
                }
            }
        });
        this.lblSymbol = new Label(content, 0);
        this.lblSymbol.setText("Symbol");
        this.txtSymbol = new Text(content, 2048);
        this.txtSymbol.setLayoutData((Object)gdSingleSpan);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    OrdersSummaryView.this.sendReportRequest();
                }
            }
        });
        this.btnFetch = new Button(content, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OrdersSummaryView.this.sendReportRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnCancelAll = new Button(content, 8);
        this.btnCancelAll.setText("Cancel All");
        this.btnCancelAll.setEnabled(Resources.cancelOrderOption);
        this.btnCancelAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Order[] selection = OrdersSummaryView.this.getAllOrders();
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    if (selection.length > 0 && TradingPlugin.getDefault().pinCodeValidation("Are you sure you want to cancel selected " + selection.length + " order(s) ?", null)) {
                        try {
                            int i = 0;
                            while (i < selection.length) {
                                selection[i].cancelRequest();
                                ++i;
                            }
                        }
                        catch (Exception ee) {
                            MessageDialog.openError(null, (String)"Error in Order Cancellation", (String)ee.getMessage());
                        }
                    }
                } else {
                    OrdersSummaryView.this.clearFields();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblReferenceNo = new Label(content, 0);
        this.lblReferenceNo.setText("Reference No");
        this.txtReferenceNo = new Text(content, 2048);
        this.txtReferenceNo.setLayoutData((Object)gdSingleSpan);
        this.lblSubCode = new Label(content, 0);
        this.lblSubCode.setText("Sub Code");
        this.lblSubCode.setVisible(Resources.isMemberTerminal());
        this.txtSubCode = new Text(content, 2048);
        this.txtSubCode.setLayoutData((Object)gdSingleSpan);
        this.txtSubCode.setVisible(Resources.isMemberTerminal());
        this.txtSubCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        new Label(content, 0);
        new Label(content, 0);
        new Label(content, 0);
        this.table = new Table(content, 67586);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getVerticalBar().setEnabled(true);
        GridData gdTable = new GridData(4, 4, true, true, 8, 1);
        this.table.setLayoutData((Object)gdTable);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrdersSummaryView.this.logger.info((Object)"Table Selection Listener");
                OrdersSummaryView.this.updateActionsEnablement();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (OrdersSummaryView.this.table.getItem(new Point(e.x, e.y)) == null) {
                    OrdersSummaryView.this.logger.info((Object)"Mouse Down Listener");
                    OrdersSummaryView.this.table.deselectAll();
                    OrdersSummaryView.this.updateActionsEnablement();
                }
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.gc.setBackground(((TableItem)event.item).getBackground());
                event.gc.fillRectangle(event.getBounds());
            }
        });
        int i = 0;
        while (i < this.columns.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(this.columns[i]);
            column.addControlListener(this.columnControlListener);
            ++i;
        }
        MenuManager menuMgr = new MenuManager("#popupMenu", "popupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.add((IContributionItem)new Separator("top"));
                if (Resources.cancelOrderOption) {
                    menuManager.add((IAction)OrdersSummaryView.this.cancelRequest);
                }
                menuManager.add((IContributionItem)new Separator("additions"));
                if (Resources.modifyOrderOption) {
                    menuManager.add((IAction)OrdersSummaryView.this.modifyRequest);
                }
                menuManager.add((IContributionItem)new Separator("bottom"));
            }
        });
        this.table.setMenu(menuMgr.createContextMenu((Control)this.table));
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
        String[] sizes = TradingPlugin.getDefault().getPreferenceStore().getString(PREFS_ORDERS_SUMMARY_VIEW_COLUMNS_SIZE).split(";");
        int i2 = 0;
        while (i2 < this.table.getColumnCount()) {
            if (i2 < sizes.length && sizes[i2].length() != 0) {
                this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
            } else {
                this.table.getColumn(i2).setWidth(100);
            }
            ++i2;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            this.table.getColumn(this.table.getColumnCount() - 1).pack();
        }
        sc.setContent((Control)content);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinSize(content.computeSize(-1, -1));
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator("top"));
        manager.add((IAction)new ResizeColumnsAction(this.table));
        manager.add((IContributionItem)new Separator("group0"));
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IContributionItem)new Separator("group3"));
        manager.add((IContributionItem)new Separator("group4"));
        manager.add((IContributionItem)new Separator("group5"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
    }

    public void sendReportRequest() {
        block7: {
            if (Resources.isServerConnected((String)this.txtClientCode.getText().trim(), (boolean)false, (boolean)false)) {
                try {
                    String exCode = this.cmbExchange.getText().equals("All") ? Utility.getClientExchanges((Vector)Resources.exchangeCodes) : Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(this.cmbExchange.getText())).toString();
                    String clientCode = this.txtClientCode.getText();
                    String symbol = this.txtSymbol.getText();
                    String sub_code = this.txtSubCode.getText();
                    String ref_number = this.txtReferenceNo.getText();
                    if (exCode == null) {
                        MessageDialog.openError(null, (String)"Invalid Parameters", (String)"Invalid exchange code.");
                        break block7;
                    }
                    PendingOrderRequest req = new PendingOrderRequest(clientCode, symbol, exCode, ref_number, 1, false, false, sub_code);
                    req.setStExCode(Utility.getClientExchanges((Vector)Resources.exchangeCodes));
                    try {
                        if (Resources.getServerLink((String)clientCode, (boolean)false, (boolean)false).writeData((Object)req)) {
                            this.logger.info((Object)"sending OrderSummaryRequest.summary request");
                            this.btnFetch.setEnabled(false);
                            this.refreshAction.setEnabled(false);
                        }
                    }
                    catch (Exception e) {
                        CorePlugin.logException((Exception)e);
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError(null, (String)"Invalid Parameters", (String)("Error occurs while sending request : " + e.getMessage()));
                }
            }
        }
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof PendingOrderResponse) {
                        PendingOrderResponse rsp = (PendingOrderResponse)o;
                        OrdersSummaryView.this.recieveReportResponse(rsp);
                        OrdersSummaryView.this.refreshAction.setEnabled(true);
                        OrdersSummaryView.this.btnFetch.setEnabled(true);
                        OrdersSummaryView.this.logger.info((Object)"OrderSummaryResponse.summary recieved");
                    }
                    if (o instanceof LoginConfirmation) {
                        OrdersSummaryView.this.btnCancelAll.setEnabled(Resources.cancelOrderOption);
                        OrdersSummaryView.this.txtClientCode.setText(Resources.clientId);
                        OrdersSummaryView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        OrdersSummaryView.this.lblSubCode.setVisible(Resources.isMemberTerminal());
                        OrdersSummaryView.this.txtSubCode.setVisible(Resources.isMemberTerminal());
                        if (Resources.exchangeNames != null) {
                            OrdersSummaryView.this.cmbExchange.removeAll();
                            OrdersSummaryView.this.cmbExchange.add("All");
                            int i = 0;
                            while (i < Resources.exchangeNames.size()) {
                                OrdersSummaryView.this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                                ++i;
                            }
                            OrdersSummaryView.this.cmbExchange.select(0);
                        }
                    }
                }
            });
        }
    }

    public void recieveReportResponse(final PendingOrderResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OrdersSummaryView.this.table.removeAll();
                    if (resp.getrows() != null) {
                        try {
                            OrdersSummaryView.this.logger.debug((Object)("Orders vector size in OrderSummary view = " + resp.getFilled()));
                            Vector v = OrdersSummaryView.this.createOrdersVector(resp);
                            int i = 0;
                            while (i < v.size()) {
                                Vector tempVector = (Vector)v.get(i);
                                String vectorVal = (String)tempVector.get(1);
                                TableItem item = new TableItem(OrdersSummaryView.this.table, 0);
                                int j = 0;
                                while (j < OrdersSummaryView.this.table.getColumnCount()) {
                                    String temp = (String)tempVector.get(j);
                                    if (temp == null) {
                                        temp = "";
                                    }
                                    if (j == SIDE && temp.equals("BUY")) {
                                        item.setBackground(WidgetFactory.color_registry.get("COLOR_GREEN_LIGHT"));
                                    } else if (vectorVal.equals("TOTAL")) {
                                        item.setBackground(WidgetFactory.color_registry.get("COLOR_YELLO"));
                                    } else if (j == SIDE && temp.equals("SELL")) {
                                        item.setBackground(WidgetFactory.color_registry.get("COLOR_RED_LIGHT"));
                                    } else {
                                        System.out.println((String)tempVector.get(15));
                                    }
                                    if (j == ORDER_ID && ((String)tempVector.get(15)).equals("1")) {
                                        item.setData((Object)temp);
                                    }
                                    item.setText(j, temp);
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            OrdersSummaryView.this.logger.debug((Object)"Exception in adding rows in Account Summary");
                        }
                    }
                }
            });
        }
    }

    private Vector<Vector<String>> createOrdersVector(PendingOrderResponse resp) {
        OrderData[] data = resp.getrows();
        long totalBuyVolume = 0L;
        long totalSellVolume = 0L;
        double totalBuyPrice = 0.0;
        double totalSellPrice = 0.0;
        Vector<Vector<String>> orderRows = new Vector<Vector<String>>();
        String prevSymbol = null;
        boolean secondSummaryRow = false;
        int i = 0;
        while (i < data.length) {
            Vector<String> tempVector = new Vector<String>(16);
            int temp = data[i].getNumber();
            if (temp == 2) {
                if (secondSummaryRow) {
                    tempVector.add(" ");
                    tempVector.add(" ");
                } else {
                    tempVector.add(" ");
                    tempVector.add("TOTAL");
                }
                String side = OrderMessage.sideNames[data[i].getSide()];
                tempVector.add(side);
                tempVector.add(this.nf.format(data[i].getVolume()));
                tempVector.add("AMOUNT");
                tempVector.add(this.pf.format(data[i].getPrice()));
                tempVector.add(data[i].getRefNumber());
                tempVector.add("");
                tempVector.add("");
                tempVector.add(data[i].getOrderSource());
                tempVector.add(data[i].getUserId());
                tempVector.add(String.valueOf(OrderMessage.propertyNames[data[i].getOrderType()]));
                tempVector.add(this.pf.format(data[i].getTriggerPrice()));
                tempVector.add(OrderMessage.propertyNames[data[i].getOrderType()]);
                tempVector.add(OrderMessage.propertyNames[data[i].getProperty()]);
                tempVector.add(Integer.toString(temp));
                tempVector.add(data[i].getclientUIN());
                tempVector.add(this.nf.format(data[i].getExecutedVolume()));
                tempVector.add(Integer.toString(data[i].getAfterHourOrder()));
                if (side.equalsIgnoreCase("BUY")) {
                    totalBuyVolume += (long)data[i].getVolume();
                    totalBuyPrice += (double)data[i].getPrice();
                } else {
                    totalSellVolume += (long)data[i].getVolume();
                    totalSellPrice += (double)data[i].getPrice();
                }
                secondSummaryRow = true;
            } else {
                secondSummaryRow = false;
                String newSymbol = data[i].getSymbol();
                if (prevSymbol != null && !newSymbol.equals(prevSymbol)) {
                    int j = 0;
                    while (j < 17) {
                        tempVector.add(" ");
                        ++j;
                    }
                    orderRows.add(tempVector);
                    tempVector = new Vector(17);
                }
                String side = OrderMessage.sideNames[data[i].getSide()];
                tempVector.add(data[i].getExchange());
                prevSymbol = newSymbol;
                tempVector.add(newSymbol);
                tempVector.add(side);
                tempVector.add(this.nf.format(data[i].getVolume()));
                tempVector.add(this.pf.format(data[i].getPrice()));
                tempVector.add(data[i].getBuyClient());
                tempVector.add(data[i].getRefNumber());
                tempVector.add(data[i].getclientUIN());
                if (side.equalsIgnoreCase("BUY")) {
                    tempVector.add(String.valueOf(data[i].getBuyOrderNumber()));
                } else {
                    tempVector.add(String.valueOf(data[i].getSellOrderNumber()));
                }
                tempVector.add(data[i].getOrderSource());
                tempVector.add(data[i].getUserId());
                tempVector.add(String.valueOf(OrderMessage.propertyNames[data[i].getOrderType()]));
                System.out.println("Trigger price **** : " + this.pf.format(data[i].getTriggerPrice()));
                tempVector.add(this.pf.format(data[i].getTriggerPrice()));
                tempVector.add(OrderMessage.propertyNames[data[i].getOrderType()]);
                tempVector.add(OrderMessage.propertyNames[data[i].getProperty()]);
                tempVector.add(Integer.toString(temp));
                tempVector.add(data[i].getclientUIN());
                tempVector.add(this.nf.format(data[i].getExecutedVolume()));
                tempVector.add(Integer.toString(data[i].getAfterHourOrder()));
            }
            orderRows.add(tempVector);
            ++i;
        }
        Vector<String> grandTotalBuy = new Vector<String>();
        grandTotalBuy.add(" ");
        grandTotalBuy.add("GRAND TOTAL");
        grandTotalBuy.add("BUY");
        grandTotalBuy.add(this.nf.format(totalBuyVolume));
        grandTotalBuy.add(this.pf.format(totalBuyPrice));
        int j = 0;
        while (j < 13) {
            grandTotalBuy.add("");
            ++j;
        }
        Vector<String> grandTotalSell = new Vector<String>();
        grandTotalSell.add(" ");
        grandTotalSell.add(" ");
        grandTotalSell.add("SELL");
        grandTotalSell.add(this.nf.format(totalSellVolume));
        grandTotalSell.add(this.pf.format(totalSellPrice));
        int j2 = 0;
        while (j2 < 13) {
            grandTotalSell.add("");
            ++j2;
        }
        Vector<String> emptyVector = new Vector<String>(17);
        int j3 = 0;
        while (j3 < 17) {
            emptyVector.add(" ");
            ++j3;
        }
        orderRows.add(emptyVector);
        orderRows.add(grandTotalBuy);
        orderRows.add(grandTotalSell);
        return orderRows;
    }

    void updateActionsEnablement() {
        this.logger.info((Object)"Update Action Enablement");
        boolean cancelEnable = false;
        Order[] selection = this.getSelectedOrders();
        this.logger.info((Object)("No of Selected Orders : " + selection.length));
        int i = 0;
        while (i < selection.length) {
            if (this.validCancelOrder(selection[i])) {
                this.logger.info((Object)"Valid Cancel Order");
                cancelEnable = true;
            } else {
                this.logger.info((Object)"Invalid Cancel Order");
                cancelEnable = false;
            }
            ++i;
        }
        this.logger.info((Object)("Cancel Enable : " + cancelEnable));
        this.cancelRequest.setEnabled(cancelEnable);
        this.modifyRequest.setEnabled(false);
        if (selection.length == 1 && (OrderStatus.PARTIAL.equals((Object)selection[0].getStatus()) || OrderStatus.QUEUED.equals((Object)selection[0].getStatus()) || OrderStatus.AFTER_HOUR.equals((Object)selection[0].getStatus())) && !"KATS".equalsIgnoreCase(selection[0].getOrderSource())) {
            this.logger.info((Object)"Modify Enable : true ");
            this.modifyRequest.setEnabled(true);
        }
    }

    private boolean validCancelOrder(Order selection) {
        this.logger.info((Object)("Selection Status " + selection.getStatus()));
        return !OrderStatus.CANCELED.equals((Object)selection.getStatus()) && !OrderStatus.FILLED.equals((Object)selection.getStatus()) && !OrderStatus.REJECTED.equals((Object)selection.getStatus()) && !"KATS".equalsIgnoreCase(selection.getOrderSource());
    }

    private Order[] getSelectedOrders() {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (this.table != null) {
            int[] selection = this.table.getSelectionIndices();
            int i = 0;
            while (i < selection.length) {
                Order ord;
                String temp = (String)this.table.getItem(selection[i]).getData();
                if (temp != null && (ord = CorePlugin.getRepository().getOrderById(temp)) != null) {
                    orders.add(ord);
                }
                ++i;
            }
        }
        this.logger.info((Object)("Get Selected Orders : " + orders.size()));
        return orders.toArray(new Order[orders.size()]);
    }

    private Order[] getAllOrders() {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (this.table != null) {
            int i = 0;
            while (i < this.table.getItemCount()) {
                String temp = (String)this.table.getItem(i).getData();
                Order ord = CorePlugin.getRepository().getOrderById(temp);
                if (ord != null && this.validCancelOrder(ord)) {
                    orders.add(ord);
                }
                ++i;
            }
        }
        return orders.toArray(new Order[orders.size()]);
    }

    private void clearFields() {
        this.table.removeAll();
    }

    public void setFocus() {
        this.txtClientCode.forceFocus();
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    public void itemRemoved(Object o) {
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    OrdersSummaryView.this.txtClientCode.setText(Resources.clientId);
                    OrdersSummaryView.this.sendReportRequest();
                }
            });
        }
    }
}

