/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.MarketSummaryRequest;
import pk.com.softech.messages.MarketSummaryResponse;
import pk.com.softech.messages.TopSymbolData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;
import pk.com.softech.tradingterminal.core.ui.actions.EditColumnsAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.ColumnsOptionDialog;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.views.QuoteRequestView;

public class MarketSummaryView
extends ViewPart
implements IPropertyChangeListener,
ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.marketSummary";
    public static final String PREFS_MARKETSUMMARY_COLUMNS = "MARKET_SUMMARY_VIEW_COLUMNS";
    public static final String PREFS_MARKETSUMMARY_COLUMNS_SIZE = "MARKET_SUMMARY_VIEW_COLUMNS_SIZE";
    Button btnFetch;
    Combo cmbExchange;
    Composite parent;
    CTabFolder tabFolder;
    MarketSummaryTable gainers;
    MarketSummaryTable loosers;
    MarketSummaryTable volumeLeaders;
    MarketSummaryTable marketMovers;
    MarketSummaryTable marketShakers;
    LabelProvidersRegistry registry = new LabelProvidersRegistry("pk.com.softech.tradingterminal.trading.marketSummary");
    String topGainersText = "Top Gainers";
    String topLoosersText = "Top Losers";
    String volumeLeadersText = "Volume Leaders";
    String marketMoversText = "Market Movers";
    String marketShakersText = "Market Shakers";
    private IAction editColumnsAction;
    IPreferenceStore preferences;
    private Action refreshAction;
    Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public MarketSummaryView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, true));
        Label lblExchange = new Label(composite, 0);
        lblExchange.setText("Exchange");
        this.cmbExchange = new Combo(composite, 8);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            int i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.btnFetch = new Button(composite, 0);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarketSummaryView.this.fetchMarketData();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder = new CTabFolder(content, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.topGainersText);
        this.gainers = new MarketSummaryTable((Composite)this.tabFolder, 1);
        tabItem.setControl(this.gainers.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.topLoosersText);
        this.loosers = new MarketSummaryTable((Composite)this.tabFolder, 2);
        tabItem.setControl(this.loosers.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.volumeLeadersText);
        this.volumeLeaders = new MarketSummaryTable((Composite)this.tabFolder, 3);
        tabItem.setControl(this.volumeLeaders.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.marketMoversText);
        this.marketMovers = new MarketSummaryTable((Composite)this.tabFolder, 4);
        tabItem.setControl(this.marketMovers.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.marketShakersText);
        this.marketShakers = new MarketSummaryTable((Composite)this.tabFolder, 5);
        tabItem.setControl(this.marketShakers.getControl());
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolder folder = (CTabFolder)e.getSource();
                Control control = folder.getSelection().getControl();
                MarketSummaryTable table = (MarketSummaryTable)control.getData();
                table.updateTable();
            }
        });
        this.tabFolder.setSelection(0);
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.makeViewActions();
        this.contributeToActionBars();
    }

    private void fetchMarketData() {
        if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
            String exchange = this.cmbExchange.getText();
            System.out.println(exchange);
            if (exchange == null || exchange.length() <= 0) {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Invalid Parameters", (String)"Invalid Exchange");
            }
            MarketSummaryRequest request = new MarketSummaryRequest();
            String exCode = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(exchange)).toString();
            System.out.println(exCode);
            if (exCode != null) {
                request.setStExCode(exCode);
                Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
            } else {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Messege", (String)"Invalid Exchange");
            }
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        this.preferences.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(PREFS_MARKETSUMMARY_COLUMNS) && this.parent != null && !this.parent.isDisposed()) {
            this.gainers.updateTable();
            this.loosers.updateTable();
            this.volumeLeaders.updateTable();
            this.marketMovers.updateTable();
            this.marketShakers.updateTable();
        }
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                MarketSummaryView.this.fetchMarketData();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
        this.editColumnsAction = new EditColumnsAction((Dialog)new ColumnsOptionDialog((IViewPart)this, PREFS_MARKETSUMMARY_COLUMNS, PREFS_MARKETSUMMARY_COLUMNS_SIZE, this.preferences));
    }

    private void contributeToActionBars() {
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)this.refreshAction);
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add(this.editColumnsAction);
        Action resizeColumns = new Action(){

            public void run() {
                Table table = (Table)MarketSummaryView.this.tabFolder.getSelection().getControl();
                if (table != null) {
                    TableColumn[] column = table.getColumns();
                    int i = 0;
                    while (i < column.length) {
                        if (column[i].getResizable()) {
                            column[i].pack();
                        }
                        ++i;
                    }
                }
            }
        };
        manager.add((IAction)resizeColumns);
        resizeColumns.setId("resizeColumns");
        resizeColumns.setText("Resize columns");
        resizeColumns.setToolTipText("Edit Columns");
        resizeColumns.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        try {
                            if (Resources.exchangeNames != null) {
                                MarketSummaryView.this.cmbExchange.removeAll();
                                int i = 0;
                                while (i < Resources.exchangeNames.size()) {
                                    MarketSummaryView.this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                                    ++i;
                                }
                                MarketSummaryView.this.cmbExchange.select(0);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (o instanceof MarketSummaryResponse) {
                        MarketSummaryView.this.gainers.refresh();
                        MarketSummaryView.this.loosers.refresh();
                        MarketSummaryView.this.volumeLeaders.refresh();
                        MarketSummaryView.this.marketMovers.refresh();
                        MarketSummaryView.this.marketShakers.refresh();
                        Control control = MarketSummaryView.this.tabFolder.getSelection().getControl();
                        MarketSummaryTable table = (MarketSummaryTable)control.getData();
                        table.updateTable();
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private class MarketSummaryTable
    implements ICollectionObserver {
        Table table;
        boolean columnMove = false;
        private int filter;
        List<TopSymbolData> list = new ArrayList<TopSymbolData>();
        int sortColumn = -1;
        int sortDirection;
        private ControlListener columnControlListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                StringBuffer sizes = new StringBuffer();
                int i = 0;
                while (i < MarketSummaryTable.this.table.getColumnCount()) {
                    sizes.append(String.valueOf(String.valueOf(MarketSummaryTable.this.table.getColumn(i).getWidth())) + ";");
                    ++i;
                }
                ((MarketSummaryTable)MarketSummaryTable.this).MarketSummaryView.this.preferences.setValue(MarketSummaryView.PREFS_MARKETSUMMARY_COLUMNS_SIZE, sizes.toString());
            }

            public void controlMoved(ControlEvent e) {
                if (!MarketSummaryTable.this.columnMove) {
                    return;
                }
                int[] ord = MarketSummaryTable.this.table.getColumnOrder();
                int[] newOrd = new int[ord.length];
                StringBuffer ids = new StringBuffer();
                int i = 0;
                while (i < MarketSummaryTable.this.table.getColumnCount()) {
                    newOrd[i] = i;
                    TableColumn col = MarketSummaryTable.this.table.getColumn(ord[i]);
                    ids.append(col.getData("columnId") + ";");
                    ++i;
                }
                MarketSummaryTable.this.table.setColumnOrder(newOrd);
                ((MarketSummaryTable)MarketSummaryTable.this).MarketSummaryView.this.preferences.setValue(MarketSummaryView.PREFS_MARKETSUMMARY_COLUMNS, ids.toString());
            }
        };
        SelectionListener columnSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = MarketSummaryTable.this.table.indexOf((TableColumn)e.widget);
                if (MarketSummaryTable.this.sortColumn == index) {
                    MarketSummaryTable.this.sortDirection = MarketSummaryTable.this.sortDirection == 0 ? 1 : 0;
                } else {
                    MarketSummaryTable.this.sortColumn = index;
                    MarketSummaryTable.this.sortDirection = 0;
                }
                MarketSummaryTable.this.updateTable();
            }
        };
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Object provider;
                if (MarketSummaryTable.this.sortColumn < MarketSummaryTable.this.table.getColumnCount() && (provider = MarketSummaryTable.this.table.getColumn(MarketSummaryTable.this.sortColumn).getData("labelProvider")) instanceof Comparator) {
                    if (MarketSummaryTable.this.sortDirection == 0) {
                        return ((Comparator)provider).compare(arg0, arg1);
                    }
                    return ((Comparator)provider).compare(arg1, arg0);
                }
                return 0;
            }
        };

        public MarketSummaryTable(Composite parent, int filter) {
            this.filter = filter;
            this.table = new Table(parent, 65538);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.table.setData((Object)this);
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (MarketSummaryTable.this.table.getItem(new Point(e.x, e.y)) == null) {
                        MarketSummaryTable.this.table.deselectAll();
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                    try {
                        TopSymbolData data;
                        TableColumn column = MarketSummaryTable.this.getColumn(e);
                        if (column != null && column.getText().equalsIgnoreCase("Symbol") && (data = MarketSummaryTable.this.getSelectedItem()) != null) {
                            Security security = CorePlugin.getRepository().getSecurity(data.getSymbol());
                            if (security != null) {
                                try {
                                    QuoteRequestView view = (QuoteRequestView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.quoteRequest");
                                    view.setSecurity(security);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    ((MarketSummaryTable)MarketSummaryTable.this).MarketSummaryView.this.logger.info((Object)("Exception in QuoteRequest : " + ex.getMessage()));
                                }
                            } else {
                                ((MarketSummaryTable)MarketSummaryTable.this).MarketSummaryView.this.logger.info((Object)"Security is null");
                            }
                        }
                    }
                    catch (Exception exx) {
                        exx.printStackTrace();
                        ((MarketSummaryTable)MarketSummaryTable.this).MarketSummaryView.this.logger.info((Object)("Exception in MouseDoubleClick " + exx.getMessage()));
                    }
                }
            });
            this.table.addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    event.gc.setBackground(((TableItem)event.item).getBackground());
                    event.gc.fillRectangle(event.getBounds());
                }
            });
            TopSymbolData[] topSymbols = Resources.marketSummary;
            if (topSymbols != null) {
                int i = 0;
                while (i < topSymbols.length) {
                    if (topSymbols[i].getDataType() == filter) {
                        this.list.add(topSymbols[i]);
                    }
                    ++i;
                }
            }
            this.updateTable();
        }

        protected TableColumn getColumn(MouseEvent e) {
            try {
                Point p = new Point(e.x, e.y);
                TableItem item = this.table.getItem(p);
                if (item != null) {
                    int i = 0;
                    while (i < this.table.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(p)) {
                            TableColumn column = this.table.getColumn(i);
                            return column;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                MarketSummaryView.this.logger.info((Object)("Exception in getColumn : " + ex.getMessage()));
            }
            return null;
        }

        public TopSymbolData getSelectedItem() {
            try {
                CTabItem item = MarketSummaryView.this.tabFolder.getSelection();
                if (item != null) {
                    Table table = (Table)item.getControl();
                    int[] selection = table.getSelectionIndices();
                    MarketSummaryTable marketTable = (MarketSummaryTable)table.getData();
                    int i = 0;
                    if (i < selection.length) {
                        TopSymbolData selected = marketTable.list.get(selection[i]);
                        return selected;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MarketSummaryView.this.logger.info((Object)("Exception in getSelectedItem : " + e.getMessage()));
            }
            return null;
        }

        public Control getControl() {
            return this.table;
        }

        public void updateTable() {
            this.columnMove = false;
            if (this.table != null && !this.table.isDisposed()) {
                int index = 0;
                String[] id = MarketSummaryView.this.preferences.getString(MarketSummaryView.PREFS_MARKETSUMMARY_COLUMNS).split(";");
                int i = 0;
                while (i < id.length) {
                    TableColumn tableColumn;
                    String name = "";
                    int style = 16384;
                    Image image = null;
                    ILabelProvider provider = MarketSummaryView.this.registry.createLabelProvider(id[i]);
                    if (provider != null) {
                        name = MarketSummaryView.this.registry.getName(id[i]);
                        style = MarketSummaryView.this.registry.getOrientation(id[i]);
                        if (provider instanceof ITableLabelProvider) {
                            name = ((ITableLabelProvider)provider).getColumnText(null, i);
                            image = ((ITableLabelProvider)provider).getColumnImage(null, i);
                        }
                    }
                    if (index < this.table.getColumnCount()) {
                        tableColumn = this.table.getColumn(index);
                        if (tableColumn.getData("labelProvider") != null) {
                            ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                        }
                    } else {
                        tableColumn = new TableColumn(this.table, style);
                        tableColumn.addControlListener(this.columnControlListener);
                        tableColumn.addSelectionListener(this.columnSelectionListener);
                        tableColumn.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (e.widget.getData("labelProvider") != null) {
                                    ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                                }
                            }
                        });
                    }
                    tableColumn.setText(name);
                    tableColumn.setAlignment(style);
                    tableColumn.setImage(image);
                    tableColumn.setMoveable(true);
                    tableColumn.setData("labelProvider", (Object)provider);
                    tableColumn.setData("columnId", (Object)id[i]);
                    ++index;
                    ++i;
                }
                while (index < this.table.getColumnCount()) {
                    this.table.getColumn(index).dispose();
                }
                if (this.sortColumn >= 0 && this.sortColumn < this.table.getColumnCount()) {
                    this.table.setSortColumn(this.table.getColumn(this.sortColumn));
                    this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                    Collections.sort(this.list, this.comparator);
                } else {
                    this.table.setSortColumn(null);
                    this.sortColumn = -1;
                    this.sortDirection = 0;
                }
                this.table.removeAll();
                try {
                    for (TopSymbolData data : this.list) {
                        TableItem tableItem = new TableItem(this.table, 0);
                        this.update(tableItem, data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String[] sizes = MarketSummaryView.this.preferences.getString(MarketSummaryView.PREFS_MARKETSUMMARY_COLUMNS_SIZE).split(";");
                int i2 = 0;
                while (i2 < this.table.getColumnCount()) {
                    if (i2 < sizes.length && sizes[i2].length() != 0) {
                        this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
                    } else {
                        this.table.getColumn(i2).setWidth(100);
                    }
                    ++i2;
                }
                if ("gtk".equals(SWT.getPlatform())) {
                    this.table.getColumn(this.table.getColumnCount() - 1).pack();
                }
            }
            this.columnMove = true;
        }

        void update(TableItem tableItem, TopSymbolData data) {
            int i = 0;
            while (i < this.table.getColumnCount()) {
                TableColumn tableColumn = this.table.getColumn(i);
                ILabelProvider label = (ILabelProvider)tableColumn.getData("labelProvider");
                if (label != null) {
                    tableItem.setText(i, label.getText((Object)data));
                    Image image = label.getImage((Object)data);
                    if (image != tableItem.getImage(i)) {
                        tableItem.setImage(image);
                    }
                }
                ++i;
            }
        }

        public void itemAdded(Object o) {
        }

        public void refresh() {
            this.list.clear();
            TopSymbolData[] data = Resources.marketSummary;
            int i = 0;
            while (i < data.length) {
                if (data[i].getDataType() == this.filter) {
                    this.list.add(data[i]);
                }
                ++i;
            }
        }

        public void itemRemoved(Object o) {
        }

        public int indexOf(TopSymbolData data) {
            return this.list.indexOf(data);
        }
    }
}

