/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.AccountDetailsData;
import pk.com.softech.messages.CombinedAccountRequest;
import pk.com.softech.messages.CombinedAccountResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.EditColumnsAction;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.ColumnsOptionDialog;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.ProductNames;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.views.Messages;

public class MarginDetailView
extends ViewPart
implements IPropertyChangeListener,
ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.marginDetail";
    public static final String PREFS_MARGIN_DETAIL_COLUMNS = "MARGIN_DETAIL_VIEW_COLUMNS";
    public static final String PREFS_MARGIN_DETAIL_COLUMNS_SIZE = "MARGIN_DETAIL_VIEW_COLUMNS_SIZE";
    private static final int REFRESH_DELAY = 180000;
    private boolean requestPending = false;
    RefreshThread thread;
    ScrolledComposite sc;
    private Text txtEquityCashBalance;
    private Text txtEquityLedgerCash;
    private Text txtMarketValueOfEquity;
    private Text txtReducedCashBalance;
    private Text txtTotalWorth;
    private Text txtWorkingCapital;
    private Text txtNetLiquidityKSE;
    private Text txtOpenPositionKSE;
    private Text txtMarginRequiredKSE;
    private Text txtMarginRequiredCashKSE;
    private Text txtFreeMarginKSE;
    private Text txtReadyBuyingPowKSE;
    private Text txtMarginPercentageKSE;
    private Text txtTodaysLoanKSE;
    private Text txtPendingCashWithdrawalKSE;
    private Text txtCashWithdrawalLimitKSE;
    private Text txtCashMarginCallKSE;
    private Text txtNetMarginCallKSE;
    private Text txtMarkToMarketKSE;
    private Text txtBlockedMarkToMarketKSE;
    private Label lblMarginCallKSE;
    private Label lblMarginCallKSE1;
    Button btnFetch = null;
    Button btnPrint;
    Text txtClientCode = null;
    Text txtClientName;
    Text txtTraderCode;
    Label dateLabel = null;
    Composite content;
    Composite parent;
    LabelProvidersRegistry registry = new LabelProvidersRegistry("pk.com.softech.tradingterminal.trading.marginDetail");
    Table table;
    int sortColumn = 0;
    int sortDirection = 0;
    public static final int COLUMNS_COUNT = 23;
    Font font_bold;
    Font font_small;
    Composite content1;
    GridData data;
    public static boolean isPMEXEnable = false;
    Group cmpNorth;
    Group cmpCenterTop;
    Group cmpCenterBottom;
    Group cmpSouth;
    private Log logger = LogFactory.getLog(this.getClass());
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    Action refreshAction;
    private IAction editColumnsAction;
    List list = new ArrayList();
    IPreferenceStore preferences;
    boolean columnMove = false;
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < MarginDetailView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(MarginDetailView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            MarginDetailView.this.preferences.setValue(MarginDetailView.PREFS_MARGIN_DETAIL_COLUMNS_SIZE, sizes.toString());
        }

        public void controlMoved(ControlEvent e) {
            if (!MarginDetailView.this.columnMove) {
                return;
            }
            int[] ord = MarginDetailView.this.table.getColumnOrder();
            int[] newOrd = new int[ord.length];
            StringBuffer ids = new StringBuffer();
            int i = 0;
            while (i < MarginDetailView.this.table.getColumnCount()) {
                newOrd[i] = i;
                TableColumn col = MarginDetailView.this.table.getColumn(ord[i]);
                ids.append(col.getData("columnId") + ";");
                ++i;
            }
            MarginDetailView.this.table.setColumnOrder(newOrd);
            MarginDetailView.this.preferences.setValue(MarginDetailView.PREFS_MARGIN_DETAIL_COLUMNS, ids.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = MarginDetailView.this.table.indexOf((TableColumn)e.widget);
            if (MarginDetailView.this.sortColumn == index) {
                MarginDetailView.this.sortDirection = MarginDetailView.this.sortDirection == 0 ? 1 : 0;
            } else {
                MarginDetailView.this.sortColumn = index;
                MarginDetailView.this.sortDirection = 0;
            }
            MarginDetailView.this.updateTable(MarginDetailView.this.list);
        }
    };
    Comparator comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Object provider = MarginDetailView.this.table.getColumn(MarginDetailView.this.sortColumn).getData("labelProvider");
            if (provider instanceof Comparator) {
                if (MarginDetailView.this.sortDirection == 0) {
                    return ((Comparator)provider).compare(arg0, arg1);
                }
                return ((Comparator)provider).compare(arg1, arg0);
            }
            return 0;
        }
    };
    private FontMetrics fontMetrics;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        this.font_small = WidgetFactory.font_registry.get("FONT_8_NORMAL");
        this.sc = new ScrolledComposite(parent, 2816);
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)this.sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createLabel(composite, Messages.MarginDetailView_clientCode, this.font_bold);
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.forceFocus();
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    if (Resources.isServerConnected((String)MarginDetailView.this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                        MarginDetailView.this.sendMarginDetailRequest();
                    } else {
                        MarginDetailView.this.clearFields();
                    }
                }
            }
        });
        this.btnFetch = new Button(composite, 0);
        this.btnFetch.setText(Messages.MarginDetailView_btnFechText);
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)MarginDetailView.this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                    MarginDetailView.this.sendMarginDetailRequest();
                } else {
                    MarginDetailView.this.clearFields();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group dateGroup = new Group(this.content, 16);
        dateGroup.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(6).equalWidth(true).applyTo((Composite)dateGroup);
        GridDataFactory.fillDefaults().align(1, 4).minSize(995, -1).grab(true, false).applyTo((Control)dateGroup);
        this.createLabel((Composite)dateGroup, Messages.MarginDetailView_clientName, this.font_bold);
        this.txtClientName = this.createText((Composite)dateGroup, 131072);
        Color clr = new Color((Device)parent.getDisplay(), 0, 0, 0);
        this.txtClientName.setForeground(clr);
        this.txtClientName.setEnabled(true);
        this.txtClientName.setEditable(false);
        this.createLabel((Composite)dateGroup, Messages.MarginDetailView_traderCode, this.font_bold);
        this.txtTraderCode = this.createText((Composite)dateGroup, 131072);
        this.txtTraderCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)30), -1));
        this.txtTraderCode.setForeground(clr);
        this.txtTraderCode.setEnabled(true);
        this.txtTraderCode.setEditable(false);
        this.dateLabel = this.createLabel((Composite)dateGroup, "", this.font_bold);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.dateLabel);
        this.cmpNorth = new Group(this.content, 16);
        this.cmpNorth.setText(Messages.MarginDetailView_account_summary);
        this.cmpNorth.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(6).equalWidth(true).applyTo((Composite)this.cmpNorth);
        GridDataFactory.fillDefaults().align(1, 4).minSize(995, -1).grab(true, false).applyTo((Control)this.cmpNorth);
        Color blue = parent.getDisplay().getSystemColor(9);
        if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
            this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Equity_Cash_Balance);
        } else {
            this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Equity_Cash_Balance).setForeground(blue);
        }
        this.txtEquityCashBalance = this.createText((Composite)this.cmpNorth, 131072, this.font_small);
        this.txtEquityCashBalance.setForeground(clr);
        this.txtEquityCashBalance.setEnabled(true);
        this.txtEquityCashBalance.setEditable(false);
        this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Market_Value_of_Equity);
        this.txtMarketValueOfEquity = this.createText((Composite)this.cmpNorth, 131072, this.font_small);
        this.txtMarketValueOfEquity.setForeground(clr);
        this.txtMarketValueOfEquity.setEnabled(true);
        this.txtMarketValueOfEquity.setEditable(false);
        this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Reduced_Equity);
        this.txtReducedCashBalance = this.createText((Composite)this.cmpNorth, 131072, this.font_small);
        this.txtReducedCashBalance.setForeground(clr);
        this.txtReducedCashBalance.setEnabled(true);
        this.txtReducedCashBalance.setEditable(false);
        Color red = parent.getDisplay().getSystemColor(3);
        if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
            this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Equity_Ledger_Balance);
        } else {
            this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Equity_Cash_Book_Balance).setForeground(red);
        }
        this.txtEquityLedgerCash = this.createText((Composite)this.cmpNorth, 131072, this.font_small);
        this.txtEquityLedgerCash.setForeground(clr);
        this.txtEquityLedgerCash.setEnabled(true);
        this.txtEquityLedgerCash.setEditable(false);
        this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Total_Worth);
        this.txtTotalWorth = this.createText((Composite)this.cmpNorth, 131072, this.font_small);
        this.txtTotalWorth.setForeground(clr);
        this.txtTotalWorth.setEnabled(true);
        this.txtTotalWorth.setEditable(false);
        this.createLabel((Composite)this.cmpNorth, Messages.MarginDetailView_Total_Net_Worth);
        this.txtWorkingCapital = this.createText((Composite)this.cmpNorth, 131072, this.font_small);
        this.txtWorkingCapital.setForeground(clr);
        this.txtWorkingCapital.setEnabled(true);
        this.txtWorkingCapital.setEditable(false);
        this.cmpCenterTop = new Group(this.content, 16);
        this.cmpCenterTop.setText(Messages.MarginDetailView_Account_Liquidity_KSE);
        this.cmpCenterTop.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(8).equalWidth(true).applyTo((Composite)this.cmpCenterTop);
        GridDataFactory.fillDefaults().align(1, 4).minSize(995, -1).grab(true, false).applyTo((Control)this.cmpCenterTop);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Net_Liquidity_Margin, this.font_small);
        this.txtNetLiquidityKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtNetLiquidityKSE.setForeground(clr);
        this.txtNetLiquidityKSE.setEnabled(true);
        this.txtNetLiquidityKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Open_Position_Exposure, this.font_small);
        this.txtOpenPositionKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtOpenPositionKSE.setForeground(clr);
        this.txtOpenPositionKSE.setEnabled(true);
        this.txtOpenPositionKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Margin_Required, this.font_small);
        this.txtMarginRequiredKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtMarginRequiredKSE.setForeground(clr);
        this.txtMarginRequiredKSE.setEnabled(true);
        this.txtMarginRequiredKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Margin_Required_cash, this.font_small);
        this.txtMarginRequiredCashKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtMarginRequiredCashKSE.setForeground(clr);
        this.txtMarginRequiredCashKSE.setEnabled(true);
        this.txtMarginRequiredCashKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Free_Margin, this.font_small);
        this.txtFreeMarginKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtFreeMarginKSE.setForeground(clr);
        this.txtFreeMarginKSE.setEnabled(true);
        this.txtFreeMarginKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Ready_Buying_Power, this.font_small);
        this.txtReadyBuyingPowKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtReadyBuyingPowKSE.setForeground(clr);
        this.txtReadyBuyingPowKSE.setEnabled(true);
        this.txtReadyBuyingPowKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Mark_To_Market, this.font_small);
        this.txtMarkToMarketKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtMarkToMarketKSE.setForeground(clr);
        this.txtMarkToMarketKSE.setEnabled(true);
        this.txtMarkToMarketKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Blocked_MTM_Profit, this.font_small);
        this.txtBlockedMarkToMarketKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtBlockedMarkToMarketKSE.setForeground(clr);
        this.txtBlockedMarkToMarketKSE.setEnabled(true);
        this.txtBlockedMarkToMarketKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Pending_Cash_Withdrawl, this.font_small);
        this.txtPendingCashWithdrawalKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtPendingCashWithdrawalKSE.setForeground(clr);
        this.txtPendingCashWithdrawalKSE.setEnabled(true);
        this.txtPendingCashWithdrawalKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Cash_Withdrawl_Limit, this.font_small);
        this.txtCashWithdrawalLimitKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtCashWithdrawalLimitKSE.setForeground(clr);
        this.txtCashWithdrawalLimitKSE.setEnabled(true);
        this.txtCashWithdrawalLimitKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Cash_Margin_Call, this.font_small);
        this.txtCashMarginCallKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtCashMarginCallKSE.setForeground(clr);
        this.txtCashMarginCallKSE.setEnabled(true);
        this.txtCashMarginCallKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Net_Margin_Call, this.font_small);
        this.txtNetMarginCallKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtNetMarginCallKSE.setForeground(clr);
        this.txtNetMarginCallKSE.setEnabled(true);
        this.txtNetMarginCallKSE.setEditable(false);
        this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Margin_Percentage, this.font_small);
        this.txtMarginPercentageKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
        this.txtMarginPercentageKSE.setForeground(clr);
        this.txtMarginPercentageKSE.setEnabled(true);
        this.txtMarginPercentageKSE.setEditable(false);
        if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
            this.createLabel((Composite)this.cmpCenterTop, Messages.MarginDetailView_Todays_Loan, this.font_small);
            this.txtTodaysLoanKSE = this.createText((Composite)this.cmpCenterTop, 131072, this.font_small);
            this.txtTodaysLoanKSE.setForeground(clr);
            this.txtTodaysLoanKSE.setEnabled(true);
            this.txtTodaysLoanKSE.setEditable(false);
        }
        this.lblMarginCallKSE = this.createLabel((Composite)this.cmpCenterTop, "Account Status", this.font_small);
        this.lblMarginCallKSE.setVisible(false);
        this.lblMarginCallKSE1 = this.createLabel((Composite)this.cmpCenterTop, "MARGIN CALL", this.font_small);
        this.lblMarginCallKSE1.setFont(this.font_bold);
        this.lblMarginCallKSE1.setBackground(WidgetFactory.color_registry.get("COLOR_RED"));
        this.lblMarginCallKSE1.setForeground(WidgetFactory.color_registry.get("COLOR_WHITE"));
        this.lblMarginCallKSE1.setVisible(false);
        this.cmpSouth = new Group(this.content, 16);
        this.cmpSouth.setText(Messages.MarginDetailView_Porfolio_Details);
        this.cmpSouth.setFont(this.font_bold);
        this.cmpSouth.setLayoutData((Object)new GridData(4, 4, true, true));
        this.cmpSouth.setLayout((Layout)new GridLayout(1, false));
        this.table = new Table((Composite)this.cmpSouth, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getVerticalBar().setEnabled(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sc.setContent((Control)this.content);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(this.content.computeSize(-1, -1));
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.updateTable(new ArrayList());
        this.makeViewActions();
        this.contributeToActionBars();
        if (Resources.loginStatus && Resources.refDataComplete) {
            this.startRefreshThread();
        }
        this.txtClientCode.forceFocus();
    }

    private Label createLabel(Composite parent, String label, Font font) {
        Label temp = new Label(parent, 0);
        temp.setFont(font);
        temp.setText(label);
        return temp;
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment, Font font) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setFont(font);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(false);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(false);
        return temp;
    }

    protected void sendMarginDetailRequest() {
        block6: {
            try {
                if (this.txtClientCode.getText().length() > 0) {
                    CombinedAccountRequest req = new CombinedAccountRequest(this.txtClientCode.getText().trim(), 0, Boolean.valueOf(Resources.userType == 3));
                    try {
                        if (!this.btnFetch.isEnabled()) break block6;
                        if (Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)req)) {
                            this.logger.info((Object)("Sending Combine Margin Request for client " + this.txtClientCode.getText()));
                            this.requestPending = true;
                            this.btnFetch.setEnabled(false);
                            this.refreshAction.setEnabled(false);
                            this.txtClientCode.forceFocus();
                            break block6;
                        }
                        this.clearFields();
                    }
                    catch (Exception e) {
                        CorePlugin.logException((Exception)e);
                    }
                    break block6;
                }
                this.clearFields();
            }
            catch (Exception e) {
                this.logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public void recieveMarginDetailResponse(final CombinedAccountResponse response) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (response != null) {
                        try {
                            if (response.getClientName() != null) {
                                MarginDetailView.this.txtClientName.setText(response.getClientName());
                            } else {
                                MarginDetailView.this.txtClientName.setText("");
                            }
                            if (response.getTraderCode() != null) {
                                MarginDetailView.this.txtTraderCode.setText(String.valueOf(response.getTraderName()) + "(" + response.getTraderCode() + ")");
                            } else {
                                MarginDetailView.this.txtTraderCode.setText("");
                            }
                            MarginDetailView.this.txtEquityCashBalance.setText(MarginDetailView.this.pf.format(response.getEquityCashBalance()));
                            MarginDetailView.this.txtEquityLedgerCash.setText(MarginDetailView.this.pf.format(response.getEquityLedgerCash()));
                            MarginDetailView.this.txtMarketValueOfEquity.setText(MarginDetailView.this.pf.format(response.getEquityPortfolioValue()));
                            MarginDetailView.this.txtReducedCashBalance.setText(MarginDetailView.this.pf.format(response.getEquityReducedValue()));
                            MarginDetailView.this.txtTotalWorth.setText(MarginDetailView.this.pf.format(response.getEquityCashBalance() + response.getEquityPortfolioValue()));
                            MarginDetailView.this.txtWorkingCapital.setText(MarginDetailView.this.pf.format(response.getEquityCashBalance() + response.getEquityReducedValue()));
                            MarginDetailView.this.txtNetLiquidityKSE.setText(MarginDetailView.this.pf.format(response.getNetLiquidityEquity()));
                            MarginDetailView.this.txtOpenPositionKSE.setText(MarginDetailView.this.pf.format(response.getOpenPositionEquity()));
                            MarginDetailView.this.txtMarginRequiredKSE.setText(MarginDetailView.this.pf.format(response.getEquityMarginRequired()));
                            if (response.getEquityFreeMargin() > 0.0) {
                                MarginDetailView.this.txtFreeMarginKSE.setText(MarginDetailView.this.pf.format(response.getEquityFreeMargin()));
                            } else {
                                MarginDetailView.this.txtFreeMarginKSE.setText("0.00");
                            }
                            if (response.getEquityFreeCash() > 0.0) {
                                MarginDetailView.this.txtReadyBuyingPowKSE.setText(MarginDetailView.this.pf.format(response.getEquityFreeCash()));
                            } else {
                                MarginDetailView.this.txtReadyBuyingPowKSE.setText("0.00");
                            }
                            MarginDetailView.this.txtMarkToMarketKSE.setText(MarginDetailView.this.pf.format(response.getEquityProfitLos()));
                            MarginDetailView.this.txtBlockedMarkToMarketKSE.setText(MarginDetailView.this.pf.format(response.getEquityBlockedMTMProfit()));
                            MarginDetailView.this.txtPendingCashWithdrawalKSE.setText(MarginDetailView.this.pf.format(response.getEquityCashWithdrawalinProcess()));
                            MarginDetailView.this.txtCashWithdrawalLimitKSE.setText(MarginDetailView.this.pf.format(response.getEquityCashWithdrawal()));
                            MarginDetailView.this.txtCashMarginCallKSE.setText(MarginDetailView.this.pf.format(response.getEquityCashMarginCall()));
                            MarginDetailView.this.txtNetMarginCallKSE.setText(MarginDetailView.this.pf.format(response.getEquityNetMarginCall()));
                            MarginDetailView.this.txtMarginPercentageKSE.setText(MarginDetailView.this.pf.format(response.getEquityMarginPerc()));
                            if (Resources.PRODUCT_NAME == ProductNames.IMTRADE) {
                                MarginDetailView.this.txtTodaysLoanKSE.setText(MarginDetailView.this.pf.format(response.getEquityTodaysLoan()));
                            }
                            if (response.getEquityCashMarginCall() < 0.0 || response.getEquityNetMarginCall() < 0.0) {
                                MarginDetailView.this.lblMarginCallKSE.setVisible(true);
                                MarginDetailView.this.lblMarginCallKSE1.setVisible(true);
                            } else {
                                MarginDetailView.this.lblMarginCallKSE.setVisible(false);
                                MarginDetailView.this.lblMarginCallKSE1.setVisible(false);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            Hashtable<String, Double> cashRequired = new Hashtable<String, Double>();
                            int i = 0;
                            while (i < Resources.exchangeNames.size()) {
                                cashRequired.put((String)Resources.exchangeNames.get(i), 0.0);
                                ++i;
                            }
                            String kse = Resources.exchangeNames.get(Resources.exchangeCodes.indexOf(Resources.defaultStExCode)).toString();
                            if (response.getrows() != null) {
                                ArrayList<AccountDetailsData> dataList = new ArrayList<AccountDetailsData>();
                                AccountDetailsData[] rows = response.getrows();
                                MarginDetailView.this.logger.info((Object)"Account Detail Data object received :  ");
                                int i2 = 0;
                                while (i2 < rows.length) {
                                    dataList.add(rows[i2]);
                                    MarginDetailView.this.logger.info((Object)"retrieving Data from AccountDetailData Object :  ");
                                    MarginDetailView.this.logger.info((Object)("Getting Trading Cash  :  " + rows[i2].getCashTrading()));
                                    MarginDetailView.this.logger.info((Object)("Getting Exchange  :  " + rows[i2].getExchange()));
                                    MarginDetailView.this.logger.info((Object)("Getting Cash Required  :  " + rows[i2].getCashReq()));
                                    if (rows[i2].getCashTrading() == 0 && cashRequired.containsKey(rows[i2].getExchange())) {
                                        double oldValue = (Double)cashRequired.get(rows[i2].getExchange());
                                        MarginDetailView.this.logger.info((Object)("Value to Store in oldValue when i is :  " + i2));
                                        MarginDetailView.this.logger.info((Object)("oldValue when i is " + i2 + " : is " + oldValue));
                                        cashRequired.put(rows[i2].getExchange(), rows[i2].getCashReq() + oldValue);
                                    }
                                    ++i2;
                                }
                                MarginDetailView.this.updateTable(dataList);
                            }
                            MarginDetailView.this.logger.info((Object)("Final Value that will set in cash required is" + (Double)cashRequired.get(kse) + "and The Exchange is KSE"));
                            MarginDetailView.this.txtMarginRequiredCashKSE.setText(MarginDetailView.this.pf.format((Double)cashRequired.get(kse)));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e);
                        }
                    } else {
                        MarginDetailView.this.clearFields();
                    }
                    MarginDetailView.this.dateLabel.setText(MarginDetailView.this.getServerDateTime());
                }
            });
        }
    }

    private void clearFields() {
        this.txtEquityCashBalance.setText("");
        this.txtEquityLedgerCash.setText("");
        this.txtMarketValueOfEquity.setText("");
        this.txtReducedCashBalance.setText("");
        this.txtWorkingCapital.setText("");
        this.txtTotalWorth.setText("");
        this.txtNetLiquidityKSE.setText("");
        this.txtOpenPositionKSE.setText("");
        this.txtMarginRequiredKSE.setText("");
        this.txtMarginRequiredCashKSE.setText("");
        this.txtFreeMarginKSE.setText("");
        this.txtReadyBuyingPowKSE.setText("");
        this.txtMarginPercentageKSE.setText("");
        this.txtPendingCashWithdrawalKSE.setText("");
        this.txtCashWithdrawalLimitKSE.setText("");
        this.txtCashMarginCallKSE.setText("");
        this.txtNetMarginCallKSE.setText("");
        this.txtMarkToMarketKSE.setText("");
        this.txtBlockedMarkToMarketKSE.setText("");
        this.txtTraderCode.setText("");
        this.txtClientName.setText("");
        this.txtClientCode.forceFocus();
        this.updateTable(new ArrayList());
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                if (Resources.isServerConnected((String)MarginDetailView.this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                    MarginDetailView.this.sendMarginDetailRequest();
                } else {
                    MarginDetailView.this.clearFields();
                }
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
        this.editColumnsAction = new EditColumnsAction((Dialog)new ColumnsOptionDialog((IViewPart)this, PREFS_MARGIN_DETAIL_COLUMNS, PREFS_MARGIN_DETAIL_COLUMNS_SIZE, this.preferences));
        this.txtClientCode.forceFocus();
    }

    private void contributeToActionBars() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator("top"));
        manager.add(this.editColumnsAction);
        manager.add((IAction)new ResizeColumnsAction(this.table));
        manager.add((IContributionItem)new Separator("group0"));
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IContributionItem)new Separator("group3"));
        manager.add((IContributionItem)new Separator("group4"));
        manager.add((IContributionItem)new Separator("group5"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
    }

    public void updateTable(List lst) {
        this.columnMove = false;
        if (this.table != null && !this.table.isDisposed()) {
            this.list = lst;
            int index = 0;
            String[] id = this.preferences.getString(PREFS_MARGIN_DETAIL_COLUMNS).split(";");
            int i = 0;
            while (i < id.length) {
                TableColumn tableColumn;
                String name = "";
                int style = 16384;
                Image image = null;
                ILabelProvider provider = this.registry.createLabelProvider(id[i]);
                if (provider != null) {
                    name = this.registry.getName(id[i]);
                    style = this.registry.getOrientation(id[i]);
                    if (provider instanceof ITableLabelProvider) {
                        name = ((ITableLabelProvider)provider).getColumnText(null, i);
                        image = ((ITableLabelProvider)provider).getColumnImage(null, i);
                    }
                } else {
                    LogFactory.getLog(this.getClass()).warn((Object)("Missing column [" + id[i] + "]"));
                }
                if (index < this.table.getColumnCount()) {
                    tableColumn = this.table.getColumn(index);
                    if (tableColumn.getData("labelProvider") != null) {
                        ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                    }
                } else {
                    tableColumn = new TableColumn(this.table, style);
                    tableColumn.addControlListener(this.columnControlListener);
                    tableColumn.addSelectionListener(this.columnSelectionListener);
                    tableColumn.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (e.widget.getData("labelProvider") != null) {
                                ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                            }
                        }
                    });
                }
                tableColumn.setText(name);
                tableColumn.setAlignment(style);
                tableColumn.setImage(image);
                tableColumn.setMoveable(true);
                tableColumn.setData("labelProvider", (Object)provider);
                tableColumn.setData("columnId", (Object)id[i]);
                ++index;
                ++i;
            }
            while (index < this.table.getColumnCount()) {
                this.table.getColumn(index).dispose();
            }
            if (this.sortColumn >= 0 && this.sortColumn < this.table.getColumnCount()) {
                this.table.setSortColumn(this.table.getColumn(this.sortColumn));
                this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                Collections.sort(this.list, this.comparator);
            } else {
                this.table.setSortColumn(null);
                this.sortColumn = -1;
                this.sortDirection = 0;
            }
            this.table.removeAll();
            for (AccountDetailsData data : this.list) {
                TableItem tableItem = new TableItem(this.table, 0);
                this.update(tableItem, data);
            }
            String[] sizes = this.preferences.getString(PREFS_MARGIN_DETAIL_COLUMNS_SIZE).split(";");
            int i2 = 0;
            while (i2 < this.table.getColumnCount()) {
                if (i2 < sizes.length && sizes[i2].length() != 0) {
                    this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
                } else {
                    this.table.getColumn(i2).setWidth(100);
                }
                ++i2;
            }
            if ("gtk".equals(SWT.getPlatform())) {
                this.table.getColumn(this.table.getColumnCount() - 1).pack();
            }
        }
        this.columnMove = true;
        this.txtClientCode.forceFocus();
    }

    void update(TableItem tableItem, AccountDetailsData data) {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(i);
            ILabelProvider label = (ILabelProvider)tableColumn.getData("labelProvider");
            if (label != null) {
                String getData1 = label.getText((Object)data);
                if (getData1 == "" || getData1 == null) {
                    tableItem.setText(i, "");
                } else {
                    tableItem.setText(i, label.getText((Object)data));
                }
                Image image = label.getImage((Object)data);
                if (image != tableItem.getImage(i)) {
                    tableItem.setImage(image);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
        catch (Exception exception) {}
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof CombinedAccountResponse && ((CombinedAccountResponse)o).getResponseType() == 0) {
                        MarginDetailView.this.recieveMarginDetailResponse((CombinedAccountResponse)o);
                        MarginDetailView.this.requestPending = false;
                        MarginDetailView.this.btnFetch.setEnabled(true);
                        MarginDetailView.this.refreshAction.setEnabled(true);
                    }
                    if (o instanceof LoginConfirmation && Resources.trnCode.contains("OA07")) {
                        MarginDetailView.this.txtClientCode.setText(Resources.clientId);
                        MarginDetailView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        MarginDetailView.this.txtClientCode.forceFocus();
                        MarginDetailView.this.startRefreshThread();
                    }
                }
            });
        }
    }

    private void startRefreshThread() {
    }

    public void itemRemoved(Object o) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(PREFS_MARGIN_DETAIL_COLUMNS)) {
            this.updateTable(this.list);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MarginDetailView.this.txtClientCode.setText(Resources.clientId);
                    MarginDetailView.this.sendMarginDetailRequest();
                }
            });
        }
        this.txtClientCode.forceFocus();
    }

    public String getServerDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy");
        try {
            String d = format.format(Resources.systemDate);
            return "Date : " + d + "  :  " + Resources.getServerTime();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void isPMEXEnable() {
        System.out.println("Exchange Names : " + Resources.exchangeNames);
        if (Resources.exchangeNames.size() > 1 && Resources.exchangeNames.contains("PMEX")) {
            isPMEXEnable = true;
        }
        if (!isPMEXEnable) {
            System.out.println("PMEX Not Enable");
            this.data.exclude = !this.data.exclude;
            this.content1.setVisible(!this.data.exclude);
            this.content1.getParent().pack();
        }
    }

    private class RefreshThread
    extends Thread {
        private RefreshThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (!MarginDetailView.this.requestPending && MarginDetailView.this.parent != null && !MarginDetailView.this.parent.isDisposed()) {
                    MarginDetailView.this.parent.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MarginDetailView.this.sendMarginDetailRequest();
                        }
                    });
                }
                try {
                    Thread.sleep(180000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

