/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.MarketData;
import pk.com.softech.messages.MarketResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.FeedMonitor;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Level2FeedMonitor;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.db.Level2;
import pk.com.softech.tradingterminal.core.db.Level2Ask;
import pk.com.softech.tradingterminal.core.db.Level2Bid;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.transfers.SecurityTransfer;
import pk.com.softech.tradingterminal.core.ui.SecuritySelection;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.actions.ToggleFollowSelectionAction;
import pk.com.softech.tradingterminal.trading.actions.ToggleLevelColorsAction;
import pk.com.softech.tradingterminal.trading.internal.CellTicker;
import pk.com.softech.tradingterminal.trading.internal.Trendbar;
import pk.com.softech.tradingterminal.trading.views.Level2QuickTradeDecorator;

public class Level2View
extends ViewPart
implements Observer,
ICollectionObserver,
ISelectionListener {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.level2view";
    public static final String PREFS_SECURITY = "PREFS_SECURITY";
    public static final String PREFS_COLOR_LEVELS = "COLOR-LEVELS";
    public static final String PREFS_HIDE_SUMMARY = "HIDE_SUMMARY";
    public static final String PREFS_FOLLOW_SELECTION = "FOLLOW_SELECTION";
    public static final String TRENDBAR_INDICATOR = "MBO_TRENDBAR_INDICATOR";
    public static final String LEVEL_1_BACKGROUND = "MBO_LEVEL_1_BACKGROUND";
    public static final String LEVEL_2_BACKGROUND = "MBO_LEVEL_2_BACKGROUND";
    public static final String LEVEL_3_BACKGROUND = "MBO_LEVEL_3_BACKGROUND";
    public static final String LEVEL_4_BACKGROUND = "MBO_LEVEL_4_BACKGROUND";
    public static final String LEVEL_5_BACKGROUND = "MBO_LEVEL_5_BACKGROUND";
    public static final String LEVEL_1_FOREGROUND = "MBO_LEVEL_1_FOREGROUND";
    public static final String LEVEL_2_FOREGROUND = "MBO_LEVEL_2_FOREGROUND";
    public static final String LEVEL_3_FOREGROUND = "MBO_LEVEL_3_FOREGROUND";
    public static final String LEVEL_4_FOREGROUND = "MBO_LEVEL_4_FOREGROUND";
    public static final String LEVEL_5_FOREGROUND = "MBO_LEVEL_5_FOREGROUND";
    public static final String TABLE_LEVEL2_FONT = "TABLE_LEVEL2_FONT";
    private static final int MIN_SIZE = 100;
    private static final int COMBO_HEIGHT = 25;
    private static final int COMBO_WIDTH = 100;
    static boolean DEFAULT_GROUP_PRICES = false;
    static boolean DEFAULT_COLOR_LEVELS = true;
    static boolean DEFAULT_TOGGLE_SUMMARY = true;
    static boolean DEFAULT_FOLLOW_SELECTION = false;
    static int UPDATE_DELAY = 20;
    Security security;
    Composite info;
    Composite content;
    Composite content2;
    Composite tblAContent;
    Label time;
    Label volume;
    Label last;
    Label high;
    Label change;
    Label low;
    Label lblMarket;
    Label lblSymbol;
    Label lblExchange;
    Text txtSymbol;
    Combo cmbExchange;
    Combo cmbMarket;
    Label lblTotalBidVol;
    Label lblTotalAskVol;
    Label lblTotalBidValue;
    Label lblTotalAskValue;
    Trendbar trendbar;
    TableViewer viewer;
    Table table;
    boolean colorLevels = DEFAULT_COLOR_LEVELS;
    boolean followSelection = DEFAULT_FOLLOW_SELECTION;
    private NumberFormat numberFormatter = CorePlugin.getNumberFormatter();
    private NumberFormat numberFormatterTwoDecimal = CorePlugin.getNumberFormattrTwoDecimal();
    private NumberFormat priceFormatter = CorePlugin.getPriceFormatter();
    private NumberFormat percentFormatter = CorePlugin.getPercentageFormatter();
    private SimpleDateFormat dateFormatter = CorePlugin.getTimeFormat();
    private Color background;
    private Color emptyBackground;
    private Color negativeForeground = new Color(null, 224, 0, 0);
    private Color positiveForeground = new Color(null, 0, 224, 0);
    private Color[] bandBackground = new Color[5];
    private Color[] bandForeground = new Color[5];
    public Color BuyBg;
    public Color BuyFg;
    public Color SellBg;
    public Color SellFg;
    FontMetrics fontMetrics;
    private Font tableFont;
    private ITheme theme;
    private Composite parent;
    public static final String MBO = "MBO-";
    public static final String MBP = "MBP-";
    private String viewType = "";
    private static boolean autoresize = false;
    int marketComboIndex = 0;
    IPreferenceStore preferences;
    Action toggleLevelColorsAction;
    Action toggleSummaryAreaAction;
    Action toggleFollowSelectionAction;
    private IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals(Level2View.TABLE_LEVEL2_FONT)) {
                Level2View.this.tableFont = Level2View.this.theme.getFontRegistry().get(event.getProperty());
            } else if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                Level2View.this.setTheme((ITheme)event.getNewValue());
            } else {
                if (event.getProperty().equals(Level2View.LEVEL_1_BACKGROUND)) {
                    ((Level2View)Level2View.this).bandBackground[0] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_1_BACKGROUND);
                    Level2View.this.trendbar.setBandColor(0, Level2View.this.bandBackground[0]);
                } else if (event.getProperty().equals(Level2View.LEVEL_1_FOREGROUND)) {
                    ((Level2View)Level2View.this).bandForeground[0] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_1_FOREGROUND);
                } else if (event.getProperty().equals(Level2View.LEVEL_2_BACKGROUND)) {
                    ((Level2View)Level2View.this).bandBackground[1] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_2_BACKGROUND);
                    Level2View.this.trendbar.setBandColor(1, Level2View.this.bandBackground[1]);
                } else if (event.getProperty().equals(Level2View.LEVEL_2_FOREGROUND)) {
                    ((Level2View)Level2View.this).bandForeground[1] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_2_FOREGROUND);
                } else if (event.getProperty().equals(Level2View.LEVEL_3_BACKGROUND)) {
                    ((Level2View)Level2View.this).bandBackground[2] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_3_BACKGROUND);
                    Level2View.this.trendbar.setBandColor(2, Level2View.this.bandBackground[2]);
                } else if (event.getProperty().equals(Level2View.LEVEL_3_FOREGROUND)) {
                    ((Level2View)Level2View.this).bandForeground[2] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_3_FOREGROUND);
                } else if (event.getProperty().equals(Level2View.LEVEL_4_BACKGROUND)) {
                    ((Level2View)Level2View.this).bandBackground[3] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_4_BACKGROUND);
                    Level2View.this.trendbar.setBandColor(3, Level2View.this.bandBackground[3]);
                } else if (event.getProperty().equals(Level2View.LEVEL_4_FOREGROUND)) {
                    ((Level2View)Level2View.this).bandForeground[3] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_4_FOREGROUND);
                } else if (event.getProperty().equals(Level2View.LEVEL_5_BACKGROUND)) {
                    ((Level2View)Level2View.this).bandBackground[4] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_5_BACKGROUND);
                    Level2View.this.trendbar.setBandColor(4, Level2View.this.bandBackground[4]);
                } else if (event.getProperty().equals(Level2View.LEVEL_5_FOREGROUND)) {
                    ((Level2View)Level2View.this).bandForeground[4] = Level2View.this.theme.getColorRegistry().get(Level2View.LEVEL_5_FOREGROUND);
                } else if (event.getProperty().equals(Level2View.TRENDBAR_INDICATOR)) {
                    Level2View.this.trendbar.setIndicatorColor(Level2View.this.theme.getColorRegistry().get(Level2View.TRENDBAR_INDICATOR));
                }
                Level2View.this.updateTable();
            }
            Level2View.this.updateTableLayout();
        }
    };
    DropTargetListener dropTargetListener = new DropTargetListener(){

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
            event.currentDataType = null;
            TransferData[] data = event.dataTypes;
            if (event.currentDataType == null) {
                int i = 0;
                while (i < data.length) {
                    if (SecurityTransfer.getInstance().isSupportedType(data[i])) {
                        event.currentDataType = data[i];
                        break;
                    }
                    ++i;
                }
            }
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 9;
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (SecurityTransfer.getInstance().isSupportedType(event.currentDataType)) {
                Security[] securities = (Security[])event.data;
                Level2View.this.setSecurity(securities[0]);
            }
        }
    };
    boolean tableUpdaterScheduled = false;
    Runnable tableUpdater = new Runnable(){

        @Override
        public void run() {
            Level2View.this.tableUpdaterScheduled = false;
            if (!Level2View.this.table.isDisposed()) {
                Level2View.this.updateTable();
            }
        }
    };
    boolean infoUpdaterScheduled = false;
    Runnable infoUpdater = new Runnable(){

        @Override
        public void run() {
            Level2View.this.infoUpdaterScheduled = false;
            if (!Level2View.this.info.isDisposed()) {
                Level2View.this.updateInfo();
            }
        }
    };
    private Font font_bold;

    protected void setTheme(ITheme theme) {
        if (theme != null) {
            this.theme = theme;
            this.tableFont = theme.getFontRegistry().get(TABLE_LEVEL2_FONT);
            this.bandBackground[0] = theme.getColorRegistry().get(LEVEL_1_BACKGROUND);
            this.trendbar.setBandColor(0, this.bandBackground[0]);
            this.bandForeground[0] = theme.getColorRegistry().get(LEVEL_1_FOREGROUND);
            this.bandBackground[1] = theme.getColorRegistry().get(LEVEL_2_BACKGROUND);
            this.trendbar.setBandColor(1, this.bandBackground[1]);
            this.bandForeground[1] = theme.getColorRegistry().get(LEVEL_2_FOREGROUND);
            this.bandBackground[2] = theme.getColorRegistry().get(LEVEL_3_BACKGROUND);
            this.trendbar.setBandColor(2, this.bandBackground[2]);
            this.bandForeground[2] = theme.getColorRegistry().get(LEVEL_3_FOREGROUND);
            this.bandBackground[3] = theme.getColorRegistry().get(LEVEL_4_BACKGROUND);
            this.trendbar.setBandColor(3, this.bandBackground[3]);
            this.bandForeground[3] = theme.getColorRegistry().get(LEVEL_4_FOREGROUND);
            this.bandBackground[4] = theme.getColorRegistry().get(LEVEL_5_BACKGROUND);
            this.trendbar.setBandColor(4, this.bandBackground[4]);
            this.bandForeground[4] = theme.getColorRegistry().get(LEVEL_5_FOREGROUND);
            this.trendbar.setIndicatorColor(theme.getColorRegistry().get(TRENDBAR_INDICATOR));
            theme.addPropertyChangeListener(this.themeChangeListener);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.viewType = this.getViewSite().getSecondaryId();
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
        this.preferences.setDefault(String.valueOf(this.viewType) + PREFS_COLOR_LEVELS, true);
        this.preferences.setDefault(String.valueOf(this.viewType) + PREFS_FOLLOW_SELECTION, true);
        this.preferences.setDefault(String.valueOf(this.viewType) + PREFS_HIDE_SUMMARY, true);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().addCollectionObserver((ICollectionObserver)this);
        this.toggleLevelColorsAction = new ToggleLevelColorsAction(this);
        this.colorLevels = this.preferences.getBoolean(String.valueOf(this.viewType) + PREFS_COLOR_LEVELS);
        this.toggleLevelColorsAction.setChecked(this.colorLevels);
        this.toggleSummaryAreaAction = new Action("Hide Summary", 2){

            public void run() {
                Level2View.this.info.setVisible(!this.isChecked());
                ((GridData)Level2View.this.info.getLayoutData()).exclude = this.isChecked();
                Level2View.this.content.layout();
            }
        };
        this.toggleSummaryAreaAction.setChecked(this.preferences.getBoolean(String.valueOf(this.viewType) + PREFS_HIDE_SUMMARY));
        this.toggleFollowSelectionAction = new ToggleFollowSelectionAction(this);
        this.followSelection = this.preferences.getBoolean(String.valueOf(this.viewType) + PREFS_FOLLOW_SELECTION);
        this.toggleFollowSelectionAction.setChecked(this.followSelection);
        String id = null;
        if (memento != null) {
            id = memento.getString(String.valueOf(this.viewType) + PREFS_SECURITY);
        }
        if (id != null) {
            this.security = (Security)CorePlugin.getRepository().load(Security.class, id);
        }
    }

    public void saveState(IMemento memento) {
        if (this.security != null) {
            memento.putString(String.valueOf(this.viewType) + PREFS_SECURITY, this.security.getId());
        }
        super.saveState(memento);
    }

    private void securitySelection(boolean selectDefault) {
        int i;
        if (this.txtSymbol.getText().contains("-")) {
            i = 0;
            while (i < Resources.marketTypes.size()) {
                String Value = (String)Resources.marketTypes.get(i);
                if (Value.equalsIgnoreCase("FUT")) {
                    this.cmbMarket.select(i);
                    break;
                }
                ++i;
            }
        } else if (this.cmbMarket.getText().equalsIgnoreCase("FUT")) {
            i = 0;
            while (i < Resources.marketTypes.size()) {
                String Value = (String)Resources.marketTypes.get(i);
                if (Value.equalsIgnoreCase("REG")) {
                    this.cmbMarket.select(i);
                    break;
                }
                ++i;
            }
        }
        Security security = CorePlugin.getRepository().getSecurity(this.cmbExchange.getText(), this.cmbMarket.getText(), this.txtSymbol.getText());
        if (selectDefault) {
            if (security != null) {
                this.setSecurity(security);
            } else {
                MessageDialog.openInformation(null, (String)"Info", (String)"Invalid symbol");
            }
        } else {
            this.setSecurity(security);
        }
    }

    public void createPartControl(final Composite parent) {
        int i;
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        DropTarget target = new DropTarget((Control)parent, 3);
        target.setTransfer(new Transfer[]{SecurityTransfer.getInstance()});
        target.addDropListener(this.dropTargetListener);
        this.content = new Composite(parent, 0);
        this.BuyBg = new Color(null, 255, 205, 201);
        this.BuyFg = new Color(null, 217, 48, 37);
        this.SellBg = new Color(null, 212, 255, 236);
        this.SellFg = new Color(null, 66, 185, 131);
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.content.setLayout((Layout)gridLayout);
        this.content2 = new Composite(this.content, 0);
        this.content2.setLayout((Layout)new GridLayout(3, true));
        this.content2.setLayoutData((Object)new GridData(4, 0, true, false));
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme theme = themeManager.getCurrentTheme();
        this.bandBackground[0] = theme.getColorRegistry().get(LEVEL_1_BACKGROUND);
        this.bandForeground[0] = theme.getColorRegistry().get(LEVEL_1_FOREGROUND);
        this.bandBackground[1] = theme.getColorRegistry().get(LEVEL_2_BACKGROUND);
        this.bandForeground[1] = theme.getColorRegistry().get(LEVEL_2_FOREGROUND);
        this.bandBackground[2] = theme.getColorRegistry().get(LEVEL_3_BACKGROUND);
        this.bandForeground[2] = theme.getColorRegistry().get(LEVEL_3_FOREGROUND);
        this.bandBackground[3] = theme.getColorRegistry().get(LEVEL_4_BACKGROUND);
        this.bandForeground[3] = theme.getColorRegistry().get(LEVEL_4_FOREGROUND);
        this.bandBackground[4] = theme.getColorRegistry().get(LEVEL_5_BACKGROUND);
        this.bandForeground[4] = theme.getColorRegistry().get(LEVEL_5_FOREGROUND);
        this.tableFont = theme.getFontRegistry().get(TABLE_LEVEL2_FONT);
        this.info = new Composite(this.content, 0);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 3;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 10;
        this.info.setLayout((Layout)gridLayout);
        this.info.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.info.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle r = Level2View.this.info.getClientArea();
                e.gc.setForeground(Level2View.this.info.getDisplay().getSystemColor(15));
                e.gc.drawLine(0, r.height - 1, r.width, r.height - 1);
            }
        });
        GridData gdText = new GridData(4, 1024, true, false);
        gdText.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)20);
        this.lblSymbol = new Label(this.content2, 0);
        this.lblSymbol.setText(" Symbol");
        this.lblExchange = new Label(this.content2, 0);
        this.lblExchange.setText(" Exchange");
        this.lblMarket = new Label(this.content2, 0);
        this.lblMarket.setText(" Market");
        this.txtSymbol = new Text(this.content2, 2048);
        this.txtSymbol.setLayoutData((Object)gdText);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Level2View.this.cmbMarket.forceFocus();
            }

            public void focusGained(FocusEvent e) {
                Level2View.this.txtSymbol.selectAll();
            }
        });
        this.txtSymbol.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    Level2View.this.securitySelection(true);
                    Level2View.this.txtSymbol.selectAll();
                }
            }
        });
        this.cmbExchange = new Combo(this.content2, 8);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, 25).applyTo((Control)this.cmbExchange);
        this.cmbExchange.select(0);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.cmbExchange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Level2View.this.securitySelection(false);
                Level2View.this.cmbExchange.forceFocus();
            }
        });
        this.cmbMarket = new Combo(this.content2, 8);
        GridDataFactory.fillDefaults().grab(true, false).hint(100, 25).applyTo((Control)this.cmbMarket);
        if (Resources.marketTypes != null) {
            this.cmbMarket.removeAll();
            i = 0;
            while (i < Resources.marketTypes.size()) {
                this.cmbMarket.add((String)Resources.marketTypes.get(i));
                ++i;
            }
            try {
                this.cmbMarket.setText(MarketData.marketNames[MarketData.REGULAR]);
            }
            catch (Exception exception) {
                this.cmbMarket.select(0);
            }
        }
        this.cmbMarket.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Level2View.this.securitySelection(false);
                Level2View.this.cmbMarket.forceFocus();
            }
        });
        Label label = new Label(this.info, 0);
        label.setText(" Time");
        this.time = new Label(this.info, 131072);
        this.time.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(this.info, 0);
        label.setText("Volume");
        this.volume = new Label(this.info, 131072);
        this.volume.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(this.info, 0);
        label.setText(" Last Price");
        this.last = new Label(this.info, 0);
        this.last.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        label = new Label(this.info, 0);
        label.setText("High");
        this.high = new Label(this.info, 0);
        this.high.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        label = new Label(this.info, 0);
        label.setText(" Change");
        this.change = new Label(this.info, 0);
        this.change.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        label = new Label(this.info, 0);
        label.setText("Low");
        this.low = new Label(this.info, 0);
        this.low.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Group cmpCenter = new Group(this.info, 16);
        cmpCenter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 3;
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 10;
        cmpCenter.setLayout((Layout)gridLayout);
        label = new Label((Composite)cmpCenter, 0);
        label.setText("Total Bid Vol");
        this.lblTotalBidVol = new Label((Composite)cmpCenter, 0);
        this.lblTotalBidVol.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        label = new Label((Composite)cmpCenter, 0);
        label.setText("Total Ask Vol");
        this.lblTotalAskVol = new Label((Composite)cmpCenter, 0);
        this.lblTotalAskVol.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        label = new Label((Composite)cmpCenter, 0);
        label.setText("Total Bid Value");
        this.lblTotalBidValue = new Label((Composite)cmpCenter, 0);
        this.lblTotalBidValue.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        label = new Label((Composite)cmpCenter, 0);
        label.setText("Total Ask Value");
        this.lblTotalAskValue = new Label((Composite)cmpCenter, 0);
        this.lblTotalAskValue.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        if (this.toggleSummaryAreaAction != null) {
            this.info.setVisible(!this.toggleSummaryAreaAction.isChecked());
            ((GridData)this.info.getLayoutData()).exclude = this.toggleSummaryAreaAction.isChecked();
            this.content.layout();
        }
        this.trendbar = new Trendbar(this.content, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 16;
        this.trendbar.setLayoutData(gridData);
        this.trendbar.setBandColors(this.bandBackground);
        this.trendbar.setIndicatorColor(theme.getColorRegistry().get(TRENDBAR_INDICATOR));
        this.setTheme(theme);
        this.tblAContent = new Composite(this.content, 4);
        this.tblAContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tblAContent.setLayout((Layout)new GridLayout(1, false));
        this.table = new Table(this.tblAContent, 98308);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.background = this.table.getBackground();
        this.emptyBackground = parent.getBackground();
        this.table.setBackground(this.emptyBackground);
        TableColumn column = new TableColumn(this.table, 0);
        column.setWidth(0);
        column.setResizable(false);
        column = new TableColumn(this.table, 0x1000000);
        column.setText("No.");
        column = new TableColumn(this.table, 0x1000000);
        column.setText("Qty");
        column = new TableColumn(this.table, 0x1000000);
        column.setText("Bid");
        column = new TableColumn(this.table, 0x1000000);
        column.setText("Ask");
        column = new TableColumn(this.table, 0x1000000);
        column.setText("Qty");
        column = new TableColumn(this.table, 0x1000000);
        column.setText("No.");
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Level2View.this.table.deselectAll();
            }
        });
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                block8: {
                    if (autoresize) {
                        return;
                    }
                    autoresize = true;
                    try {
                        if (Level2View.this.table.isDisposed() || Level2View.this.table == null || parent.getBounds().height <= 100) break block8;
                        try {
                            if (Resources.refDataComplete) {
                                Level2View.this.table.setRedraw(false);
                                Level2View.this.updateColumnWidthTableUpper();
                                Level2View.this.table.setRedraw(true);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    finally {
                        autoresize = false;
                    }
                }
            }
        });
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Table)e.widget).deselectAll();
                Level2View.this.info.getParent().setFocus();
            }
        });
        new Level2QuickTradeDecorator(this.table, null, null);
        this.updateTableLayout();
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.toggleLevelColorsAction);
        menuManager.add((IAction)this.toggleSummaryAreaAction);
        menuManager.add((IAction)this.toggleFollowSelectionAction);
        this.getViewSite().getActionBars().updateActionBars();
        if (this.security != null) {
            if (this.viewType.equals(MBO)) {
                this.setPartName("Market By Order");
            } else if (this.viewType.equals(MBP)) {
                this.setPartName("Market By Price");
            }
            this.setSecurity(this.security);
        }
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void setFocus() {
        this.info.getParent().setFocus();
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().removeCollectionObserver((ICollectionObserver)this);
        if (this.security != null) {
            this.security.deleteObserver((Observer)this);
            this.security.getQuoteMonitor().deleteObserver((Observer)this);
            FeedMonitor.cancelMonitor((Security)this.security);
            this.security.getLevel2Monitor().deleteObserver((Observer)this);
            Level2FeedMonitor.cancelMonitor((Security)this.security);
            this.savePreferences();
        }
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        if (theme != null) {
            theme.removePropertyChangeListener(this.themeChangeListener);
        }
        this.background.dispose();
        this.negativeForeground.dispose();
        this.positiveForeground.dispose();
        this.emptyBackground.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    protected void savePreferences() {
        this.preferences.setValue(String.valueOf(this.viewType) + PREFS_COLOR_LEVELS, this.colorLevels);
        this.preferences.setValue(String.valueOf(this.viewType) + PREFS_HIDE_SUMMARY, this.toggleSummaryAreaAction.isChecked());
        this.preferences.setValue(String.valueOf(this.viewType) + PREFS_FOLLOW_SELECTION, this.followSelection);
    }

    public void setSecurity(Security newSecurity) {
        if (this.security == null) {
            this.security = newSecurity;
        } else {
            this.security.deleteObserver((Observer)this);
            this.security.getQuoteMonitor().deleteObserver((Observer)this);
            FeedMonitor.cancelMonitor((Security)this.security);
            this.security.getLevel2Monitor().deleteObserver((Observer)this);
            Level2FeedMonitor.cancelMonitor((Security)this.security);
            this.security = newSecurity;
        }
        this.updateInfo();
        this.updateTable();
        if (this.security != null) {
            this.security.addObserver((Observer)this);
            this.security.getQuoteMonitor().addObserver((Observer)this);
            FeedMonitor.monitor((Security)this.security);
            this.security.getLevel2Monitor().addObserver((Observer)this);
            Level2FeedMonitor.monitor((Security)this.security);
            this.cmbExchange.setText(this.security.getExchange());
            System.out.println("Market:  " + this.security.getMarket());
            this.cmbMarket.setText(this.security.getMarket());
            this.txtSymbol.setText(this.security.getSymbol());
            try {
                int i = 0;
                while (i < Resources.marketTypes.size()) {
                    String Value = (String)Resources.marketTypes.get(i);
                    if (Value.equalsIgnoreCase(newSecurity.getMarket())) {
                        this.cmbMarket.select(i);
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            if (Resources.refDataComplete && Resources.level2feed && Resources.level2feedLink != null) {
                if (this.viewType.equals(MBO)) {
                    Resources.level2feedLink.sendSubLevel2FeedServerMBOReq(this.security.getExchange(), this.security.getMarket(), this.security.getSymbol());
                } else {
                    Resources.level2feedLink.sendSubLevel2FeedServerMBPReq(this.security.getExchange(), this.security.getMarket(), this.security.getSymbol());
                }
            } else if (Resources.isProfilingEnabled && Resources.refDataComplete && Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                Resources.FEED_SUB_HANDLER.itemAddedByType((Object)this.security, this.viewType);
            }
        }
    }

    void updateInfo() {
        if (this.parent != null && !this.parent.isDisposed()) {
            if (this.viewType.equals(MBO)) {
                this.setPartName("Market By Order");
            } else if (this.viewType.equals(MBP)) {
                this.setPartName("Market By Price");
            }
            if (this.security != null) {
                if (this.security.getQuote() != null) {
                    if (this.security.getQuote().getDate() != null) {
                        this.time.setText(this.dateFormatter.format(this.security.getQuote().getDate()));
                    }
                    this.volume.setText(this.numberFormatter.format(this.security.getQuote().getVolume()));
                    this.last.setText(this.priceFormatter.format(this.security.getQuote().getLast()));
                    double chg = this.security.getChange();
                    double percentage = this.security.getChangePerc();
                    String changeStr = "";
                    if (chg > 0.0) {
                        changeStr = "+" + this.priceFormatter.format(chg) + " (+" + this.percentFormatter.format(percentage) + ")";
                        this.change.setText(changeStr);
                        this.change.setForeground(this.positiveForeground);
                    } else if (chg < 0.0) {
                        changeStr = String.valueOf(this.priceFormatter.format(chg)) + " (" + this.percentFormatter.format(percentage) + ")";
                        this.change.setText(changeStr);
                        this.change.setForeground(this.negativeForeground);
                    } else {
                        changeStr = String.valueOf(this.priceFormatter.format(chg)) + " (" + this.percentFormatter.format(percentage) + ")";
                        this.change.setText(changeStr);
                        this.change.setForeground(null);
                    }
                }
                if (this.security.getHigh() != null) {
                    this.high.setText(this.priceFormatter.format(this.security.getHigh()));
                }
                if (this.security.getLow() != null) {
                    this.low.setText(this.priceFormatter.format(this.security.getLow()));
                }
                this.info.layout(true, true);
            } else {
                this.time.setText("00:00:00");
                this.volume.setText("0");
                this.last.setText("0.00");
                this.change.setText("0");
                this.high.setText("0.00");
                this.low.setText("0.00");
                this.info.layout(true, true);
                this.lblTotalBidVol.setText("0");
                this.lblTotalAskVol.setText("0");
                this.lblTotalBidValue.setText("0");
                this.lblTotalAskValue.setText("0");
            }
        }
    }

    void updateTableLayout() {
        this.table.setFont(this.tableFont);
    }

    void updateTable() {
        if (this.parent != null && !this.parent.isDisposed()) {
            if (this.security != null) {
                int bidLevel = -1;
                int askLevel = -1;
                String bidValue = "";
                String askValue = "";
                Level2TableItem tableItem = null;
                List bid = new ArrayList();
                List ask = new ArrayList();
                if (this.viewType.equals(MBO)) {
                    if (this.security.getLevel2BidMBO() != null) {
                        bid = this.security.getLevel2BidMBO().getList();
                    }
                    if (this.security.getLevel2AskMBO() != null) {
                        ask = this.security.getLevel2AskMBO().getList();
                    }
                    if (this.security.getLevel2BidMBO() != null && this.security.getLevel2AskMBO() != null) {
                        this.trendbar.setData(this.security.getLevel2BidMBO(), this.security.getLevel2AskMBO());
                    }
                } else if (this.viewType.equals(MBP)) {
                    if (this.security.getLevel2BidMBP() != null) {
                        bid = this.security.getLevel2BidMBP().getList();
                    }
                    if (this.security.getLevel2AskMBP() != null) {
                        ask = this.security.getLevel2AskMBP().getList();
                    }
                    if (this.security.getLevel2BidMBP() != null && this.security.getLevel2AskMBP() != null) {
                        this.trendbar.setData(this.security.getLevel2BidMBP(), this.security.getLevel2AskMBP());
                    }
                }
                int totalItems = Math.max(bid.size(), ask.size());
                int totalBid = 0;
                int totalAsk = 0;
                double totalBidValue = 0.0;
                double totalAskValue = 0.0;
                int index = 0;
                while (index < totalItems) {
                    Level2.Item item;
                    tableItem = index < this.table.getItemCount() ? (Level2TableItem)this.table.getItem(index) : new Level2TableItem(this.table, 0);
                    tableItem.setData("id", this.security.getId());
                    if (index < bid.size()) {
                        item = (Level2.Item)bid.get(index);
                        String price = this.priceFormatter.format(item.price);
                        String number = String.valueOf(item.number);
                        String quantity = this.numberFormatter.format(item.quantity);
                        String flag = String.valueOf(item.id);
                        if (Resources.isGhanaClient()) {
                            if (this.viewType.equals(MBO)) {
                                tableItem.setText(1, "1");
                                tableItem.setText(2, "1");
                                tableItem.setText(3, quantity);
                                tableItem.setText(4, price);
                            } else {
                                tableItem.setText(1, "1");
                                tableItem.setText(2, quantity);
                                tableItem.setText(3, price);
                            }
                        } else if (this.viewType.equals(MBO)) {
                            tableItem.setText(1, flag);
                            tableItem.setText(2, quantity);
                            tableItem.setText(3, price);
                        } else {
                            tableItem.setText(1, number);
                            tableItem.setText(2, quantity);
                            tableItem.setText(3, price);
                        }
                        tableItem.setData("bid", item);
                        totalBid += item.quantity;
                        totalBidValue += item.price * (double)item.quantity;
                        if (this.viewType.equals(MBO)) {
                            if (!tableItem.getText(3).equals(bidValue)) {
                                ++bidLevel;
                                bidValue = tableItem.getText(3);
                            }
                        } else if (!tableItem.getText(3).equals(bidValue)) {
                            ++bidLevel;
                            bidValue = tableItem.getText(3);
                        }
                        if (this.viewType.equals(MBO)) {
                            if (this.colorLevels && bidLevel < this.bandBackground.length && bidLevel != -1) {
                                tableItem.setForeground(1, this.bandForeground[bidLevel]);
                                tableItem.setBackground(1, this.bandBackground[bidLevel]);
                                tableItem.setForeground(2, this.bandForeground[bidLevel]);
                                tableItem.setBackground(2, this.bandBackground[bidLevel]);
                                tableItem.setForeground(3, this.bandForeground[bidLevel]);
                                tableItem.setBackground(3, this.bandBackground[bidLevel]);
                                tableItem.setForeground(4, this.bandForeground[bidLevel]);
                                tableItem.setBackground(4, this.bandBackground[bidLevel]);
                            } else {
                                tableItem.setForeground(1, null);
                                tableItem.setBackground(1, this.background);
                                tableItem.setForeground(2, null);
                                tableItem.setBackground(2, this.background);
                                tableItem.setForeground(3, null);
                                tableItem.setBackground(3, this.background);
                                tableItem.setForeground(4, null);
                                tableItem.setBackground(4, this.background);
                            }
                        } else if (this.colorLevels && bidLevel < this.bandBackground.length && bidLevel != -1) {
                            tableItem.setForeground(1, this.bandForeground[bidLevel]);
                            tableItem.setBackground(1, this.bandBackground[bidLevel]);
                            tableItem.setForeground(2, this.bandForeground[bidLevel]);
                            tableItem.setBackground(2, this.bandBackground[bidLevel]);
                            tableItem.setForeground(3, this.bandForeground[bidLevel]);
                            tableItem.setBackground(3, this.bandBackground[bidLevel]);
                        } else {
                            tableItem.setForeground(1, null);
                            tableItem.setBackground(1, this.background);
                            tableItem.setForeground(2, null);
                            tableItem.setBackground(2, this.background);
                            tableItem.setForeground(3, null);
                            tableItem.setBackground(3, this.background);
                        }
                    } else if (this.viewType.equals(MBO)) {
                        tableItem.setText(1, "");
                        tableItem.setText(2, "");
                        tableItem.setText(3, "");
                        tableItem.setBackground(1, this.emptyBackground);
                        tableItem.setBackground(2, this.emptyBackground);
                        tableItem.setBackground(3, this.emptyBackground);
                    } else {
                        tableItem.setText(1, "");
                        tableItem.setText(2, "");
                        tableItem.setText(3, "");
                        tableItem.setBackground(1, this.emptyBackground);
                        tableItem.setBackground(2, this.emptyBackground);
                        tableItem.setBackground(3, this.emptyBackground);
                    }
                    if (index < ask.size()) {
                        item = (Level2.Item)ask.get(index);
                        if (Resources.isGhanaClient()) {
                            if (this.viewType.equals(MBO)) {
                                tableItem.setText(5, this.priceFormatter.format(item.price));
                                tableItem.setText(6, this.numberFormatter.format(item.quantity));
                                tableItem.setText(7, "1");
                                tableItem.setText(8, "1");
                            } else {
                                tableItem.setText(4, this.priceFormatter.format(item.price));
                                tableItem.setText(5, this.numberFormatter.format(item.quantity));
                                tableItem.setText(6, "1");
                            }
                        } else if (this.viewType.equals(MBO)) {
                            tableItem.setText(4, this.priceFormatter.format(item.price));
                            tableItem.setText(5, this.numberFormatter.format(item.quantity));
                            tableItem.setText(6, String.valueOf(item.id));
                        } else {
                            tableItem.setText(4, this.priceFormatter.format(item.price));
                            tableItem.setText(5, this.numberFormatter.format(item.quantity));
                            tableItem.setText(6, String.valueOf(item.number));
                        }
                        tableItem.setData("ask", item);
                        totalAsk += item.quantity;
                        totalAskValue += item.price * (double)item.quantity;
                        if (this.viewType.equals(MBO)) {
                            if (!tableItem.getText(5).equals(askValue)) {
                                ++askLevel;
                                askValue = tableItem.getText(5);
                            }
                        } else if (!tableItem.getText(4).equals(askValue)) {
                            ++askLevel;
                            askValue = tableItem.getText(4);
                        }
                        if (this.colorLevels && askLevel < this.bandBackground.length) {
                            if (this.viewType.equals(MBO)) {
                                tableItem.setForeground(4, this.bandForeground[askLevel]);
                                tableItem.setBackground(5, this.bandBackground[askLevel]);
                                tableItem.setForeground(5, this.bandForeground[askLevel]);
                                tableItem.setBackground(5, this.bandBackground[askLevel]);
                                tableItem.setForeground(6, this.bandForeground[askLevel]);
                                tableItem.setBackground(6, this.bandBackground[askLevel]);
                            } else {
                                tableItem.setForeground(4, this.bandForeground[askLevel]);
                                tableItem.setBackground(4, this.bandBackground[askLevel]);
                                tableItem.setForeground(5, this.bandForeground[askLevel]);
                                tableItem.setBackground(5, this.bandBackground[askLevel]);
                                tableItem.setForeground(6, this.bandForeground[askLevel]);
                                tableItem.setBackground(6, this.bandBackground[askLevel]);
                            }
                        } else if (this.viewType.equals(MBO)) {
                            tableItem.setForeground(4, null);
                            tableItem.setBackground(4, this.background);
                            tableItem.setForeground(5, null);
                            tableItem.setBackground(5, this.background);
                            tableItem.setForeground(6, null);
                            tableItem.setBackground(6, this.background);
                        } else {
                            tableItem.setForeground(4, null);
                            tableItem.setBackground(4, this.background);
                            tableItem.setForeground(5, null);
                            tableItem.setBackground(5, this.background);
                            tableItem.setForeground(6, null);
                            tableItem.setBackground(6, this.background);
                        }
                    } else if (this.viewType.equals(MBO)) {
                        tableItem.setText(4, "");
                        tableItem.setText(5, "");
                        tableItem.setText(6, "");
                        tableItem.setText(8, "");
                        tableItem.setBackground(4, this.emptyBackground);
                        tableItem.setBackground(5, this.emptyBackground);
                        tableItem.setBackground(6, this.emptyBackground);
                    } else {
                        tableItem.setText(4, "");
                        tableItem.setText(5, "");
                        tableItem.setText(6, "");
                        tableItem.setBackground(4, this.emptyBackground);
                        tableItem.setBackground(5, this.emptyBackground);
                        tableItem.setBackground(6, this.emptyBackground);
                    }
                    ++index;
                }
                this.lblTotalBidVol.setText(this.numberFormatter.format(totalBid));
                this.lblTotalAskVol.setText(this.numberFormatter.format(totalAsk));
                this.lblTotalBidValue.setText(Utility.getMillionString((double)totalBidValue, (NumberFormat)this.priceFormatter));
                this.lblTotalAskValue.setText(Utility.getMillionString((double)totalAskValue, (NumberFormat)this.priceFormatter));
                this.info.layout(true, true);
                while (this.table.getItemCount() > totalItems) {
                    this.table.getItem(totalItems).dispose();
                }
                this.updateColumnWidthTableUpper();
                this.updateLowerTable(this.security, totalBid, totalBidValue, totalAsk, totalAskValue);
            } else {
                this.table.removeAll();
                this.trendbar.setData((Level2)new Level2Bid(), (Level2)new Level2Ask());
            }
        }
    }

    private void updateLowerTable(Security security, int totalBidVol, double totalBidPrice, int totalAskVol, double totalAskPrice) {
        Level2TableItem tblRowThs = null;
        new Level2TableItem(this.table, 0);
        Level2TableItem tblRowTds = new Level2TableItem(this.table, 0);
        tblRowThs = new Level2TableItem(this.table, 0);
        double avgBid = 0.0;
        double avgAsk = 0.0;
        if (totalBidVol > 0 && totalAskVol > 0) {
            avgBid = totalBidPrice / (double)totalBidVol;
            avgAsk = totalAskPrice / (double)totalAskVol;
        }
        tblRowTds.setFont(this.font_bold);
        tblRowTds.setText(1, String.valueOf(this.numberFormatterTwoDecimal.format(security.getLowerLimit())));
        tblRowTds.setText(2, String.valueOf(this.numberFormatter.format(totalBidVol)));
        tblRowTds.setText(3, String.valueOf(Utility.getMillionString((double)avgBid, (NumberFormat)this.priceFormatter)));
        tblRowTds.setText(4, String.valueOf(Utility.getMillionString((double)avgAsk, (NumberFormat)this.priceFormatter)));
        tblRowTds.setText(5, String.valueOf(this.numberFormatter.format(totalAskVol)));
        tblRowTds.setText(6, String.valueOf(this.numberFormatterTwoDecimal.format(security.getUpperLimit())));
        tblRowThs.setText(1, "Lower");
        tblRowThs.setText(2, "Total");
        tblRowThs.setText(3, "Avg.");
        tblRowThs.setText(4, "Avg.");
        tblRowThs.setText(5, "Total");
        tblRowThs.setText(6, "Upper");
        tblRowThs.setBackground(1, this.BuyBg);
        tblRowThs.setBackground(2, this.BuyBg);
        tblRowThs.setBackground(3, this.BuyBg);
        tblRowThs.setForeground(1, this.BuyFg);
        tblRowThs.setForeground(2, this.BuyFg);
        tblRowThs.setForeground(3, this.BuyFg);
        tblRowThs.setBackground(4, this.SellBg);
        tblRowThs.setBackground(5, this.SellBg);
        tblRowThs.setBackground(6, this.SellBg);
        tblRowThs.setForeground(4, this.SellFg);
        tblRowThs.setForeground(5, this.SellFg);
        tblRowThs.setForeground(6, this.SellFg);
        tblRowTds.setBackground(1, this.BuyBg);
        tblRowTds.setBackground(2, this.BuyBg);
        tblRowTds.setBackground(3, this.BuyBg);
        tblRowTds.setForeground(1, this.BuyFg);
        tblRowTds.setForeground(2, this.BuyFg);
        tblRowTds.setForeground(3, this.BuyFg);
        tblRowTds.setBackground(4, this.SellBg);
        tblRowTds.setBackground(5, this.SellBg);
        tblRowTds.setBackground(6, this.SellBg);
        tblRowTds.setForeground(4, this.SellFg);
        tblRowTds.setForeground(5, this.SellFg);
        tblRowTds.setForeground(6, this.SellFg);
    }

    void resetDefaultColumnWidth() {
        Integer i = 1;
        while (i < this.table.getColumnCount()) {
            Integer width = this.table.getColumn(i.intValue()).getWidth();
            if ((i == 1 || i == 6) && width < 50) {
                this.table.getColumn(i.intValue()).setWidth(50);
            } else if (width < 75) {
                this.table.getColumn(i.intValue()).setWidth(75);
            }
            i = i + 1;
        }
    }

    void updateColumnWidthTableUpper() {
        GC gc = new GC((Drawable)this.table);
        int c1 = Math.max(gc.textExtent((String)this.table.getColumn((int)1).getText()).x, gc.textExtent((String)this.table.getColumn((int)6).getText()).x);
        int c2 = Math.max(gc.textExtent((String)this.table.getColumn((int)2).getText()).x, gc.textExtent((String)this.table.getColumn((int)5).getText()).x);
        int c3 = Math.max(gc.textExtent((String)this.table.getColumn((int)3).getText()).x, gc.textExtent((String)this.table.getColumn((int)4).getText()).x);
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            c1 = Math.max(c1, Math.max(gc.textExtent((String)items[i].getText((int)1)).x, gc.textExtent((String)items[i].getText((int)6)).x));
            c2 = Math.max(c2, Math.max(gc.textExtent((String)items[i].getText((int)2)).x, gc.textExtent((String)items[i].getText((int)5)).x));
            c3 = Math.max(c3, Math.max(gc.textExtent((String)items[i].getText((int)3)).x, gc.textExtent((String)items[i].getText((int)4)).x));
            ++i;
        }
        gc.dispose();
        double columnsWidth = (c1 += 24) + (c2 += 12) + (c3 += 12);
        double r1 = (double)c1 / columnsWidth;
        double r2 = (double)c2 / columnsWidth;
        int width = this.table.getClientArea().width;
        c1 = (int)((double)(width / 2) * r1);
        c2 = (int)((double)(width / 2) * r2);
        int c3a = width / 2 - c1 - c2;
        int c3b = width - (c1 + c2 + c3a + c2 + c1);
        if (this.table.getColumn(1).getWidth() != c1) {
            this.table.getColumn(1).setWidth(c1);
        }
        if (this.table.getColumn(2).getWidth() != c2) {
            this.table.getColumn(2).setWidth(c2);
        }
        if (this.table.getColumn(3).getWidth() != c3a) {
            this.table.getColumn(3).setWidth(c3a);
        }
        if (this.table.getColumn(4).getWidth() != c3b) {
            this.table.getColumn(4).setWidth(c3b);
        }
        if (this.table.getColumn(5).getWidth() != c2) {
            this.table.getColumn(5).setWidth(c2);
        }
        if (this.table.getColumn(6).getWidth() != c1) {
            this.table.getColumn(6).setWidth(c1);
        }
    }

    public boolean getColorLevels() {
        return this.colorLevels;
    }

    public void setColorLevels(boolean colorLevels) {
        this.colorLevels = colorLevels;
        this.updateTable();
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            if (o == this.security.getLevel2Monitor()) {
                if (this.parent != null && !this.parent.isDisposed() && !this.tableUpdaterScheduled) {
                    this.parent.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Level2View.this.tableUpdaterScheduled = true;
                                Level2View.this.updateTable();
                                Level2View.this.tableUpdaterScheduled = false;
                            }
                            catch (Exception exception) {}
                        }
                    });
                }
            } else if (this.parent != null && !this.parent.isDisposed() && !this.infoUpdaterScheduled) {
                this.parent.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Level2View.this.infoUpdaterScheduled = true;
                        Level2View.this.updateInfo();
                        Level2View.this.infoUpdaterScheduled = false;
                    }
                });
            }
        }
        catch (Exception exception) {}
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.followSelection && selection instanceof SecuritySelection) {
            this.setSecurity(((SecuritySelection)selection).getSecurity());
        }
    }

    public boolean isFollowSelection() {
        return this.followSelection;
    }

    public void setFollowSelection(boolean followSelection) {
        this.followSelection = followSelection;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (o instanceof LoginConfirmation) {
                            if (Resources.exchangeNames != null) {
                                Level2View.this.cmbExchange.removeAll();
                                int i = 0;
                                while (i < Resources.exchangeNames.size()) {
                                    Level2View.this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                                    ++i;
                                }
                                Level2View.this.cmbExchange.select(0);
                            }
                        } else if (o instanceof MarketResponse && Resources.marketTypes != null) {
                            Level2View.this.cmbMarket.removeAll();
                            int i = 0;
                            while (i < Resources.marketTypes.size()) {
                                Level2View.this.cmbMarket.add((String)Resources.marketTypes.get(i));
                                ++i;
                            }
                            try {
                                Level2View.this.cmbMarket.setText(MarketData.marketNames[MarketData.REGULAR]);
                            }
                            catch (Exception exception) {
                                Level2View.this.cmbMarket.select(0);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private class Level2TableItem
    extends TableItem
    implements DisposeListener {
        private CellTicker ticker;

        public Level2TableItem(Table parent, int style, int index) {
            super(parent, style, index);
            this.ticker = new CellTicker(this, 3);
            this.addDisposeListener(this);
        }

        public Level2TableItem(Table parent, int style) {
            super(parent, style);
            this.ticker = new CellTicker(this, 3);
            this.addDisposeListener(this);
        }

        protected void checkSubclass() {
        }

        public CellTicker getCellTicker() {
            return this.ticker;
        }

        public void widgetDisposed(DisposeEvent e) {
            this.ticker.dispose();
        }
    }
}

