/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Level2;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.trading.TradingPlugin;
import pk.com.softech.tradingterminal.trading.views.OrderFormView;

public class Level2QuickTradeDecorator
implements MouseTrackListener,
MouseMoveListener,
SelectionListener {
    Table table;
    Cursor buyCursor;
    Cursor sellCursor;
    boolean entered;

    public Level2QuickTradeDecorator(Table table, ICommandService commandService, IHandlerService handlerService) {
        this.table = table;
        this.initializeCursors();
        table.addMouseTrackListener((MouseTrackListener)this);
        table.addMouseMoveListener((MouseMoveListener)this);
        table.addSelectionListener((SelectionListener)this);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Level2QuickTradeDecorator.this.buyCursor.dispose();
                Level2QuickTradeDecorator.this.sellCursor.dispose();
            }
        });
    }

    void initializeCursors() {
        ImageDescriptor sourceDescriptor = TradingPlugin.getImageDescriptor("icons/pointers/buysell-source.bmp");
        ImageDescriptor buyMaskDescriptor = TradingPlugin.getImageDescriptor("icons/pointers/buy-mask.bmp");
        ImageDescriptor sellMaskDescriptor = TradingPlugin.getImageDescriptor("icons/pointers/sell-mask.bmp");
        this.buyCursor = new Cursor((Device)Display.getCurrent(), sourceDescriptor.getImageData(), buyMaskDescriptor.getImageData(), 15, 7);
        this.sellCursor = new Cursor((Device)Display.getCurrent(), sourceDescriptor.getImageData(), sellMaskDescriptor.getImageData(), 15, 7);
    }

    public void mouseEnter(MouseEvent e) {
        this.entered = true;
    }

    public void mouseMove(MouseEvent e) {
        int x = 0;
        if (!this.entered) {
            return;
        }
        if (this.table.getItem(new Point(e.x, e.y)) == null) {
            this.table.setCursor(null);
            return;
        }
        TableColumn[] column = this.table.getColumns();
        int i = 0;
        while (i <= column.length / 2) {
            if (e.x >= x && e.x <= x + column[i].getWidth()) {
                if (this.table.getCursor() != this.sellCursor) {
                    this.table.setCursor(this.sellCursor);
                }
                return;
            }
            x += column[i].getWidth();
            ++i;
        }
        while (i < column.length) {
            if (e.x >= x && e.x <= x + column[i].getWidth()) {
                if (this.table.getCursor() != this.buyCursor) {
                    this.table.setCursor(this.buyCursor);
                }
                return;
            }
            x += column[i].getWidth();
            ++i;
        }
    }

    public void mouseExit(MouseEvent e) {
        if (this.entered) {
            this.table.setCursor(null);
        }
        this.entered = false;
    }

    public void mouseHover(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Level2.Item entry = null;
        boolean side = false;
        if (this.table.getCursor() == this.sellCursor) {
            entry = (Level2.Item)e.item.getData("bid");
            side = true;
        } else if (this.table.getCursor() == this.buyCursor) {
            entry = (Level2.Item)e.item.getData("ask");
            side = false;
        }
        if (entry == null) {
            return;
        }
        String id = (String)e.item.getData("id");
        Security security = CorePlugin.getRepository().getSecurityById(id);
        if (security != null) {
            try {
                OrderFormView view = null;
                if (!side && Resources.buyOrderOption) {
                    view = (OrderFormView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.buytrade");
                    view.setFormTitle("Buy Order Form");
                } else if (side && Resources.sellOrderOption) {
                    view = (OrderFormView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("pk.com.softech.tradingterminal.trading.buytrade");
                    view.setFormTitle("Sell Order Form");
                } else {
                    System.out.println("not allowed");
                    return;
                }
                if (security != null && view != null) {
                    view.setSecurity(security);
                    view.setQuickOrder(entry.quantity, entry.price);
                }
            }
            catch (PartInitException e1) {
                e1.printStackTrace();
            }
        }
    }
}

