/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.TransferCashRequest;
import pk.com.softech.messages.TransferCashResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.core.util.PriceVerifyListener;

public class FundMovementView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.fundMovement";
    private Text txtClientCode;
    private Text txtCashAmnt;
    private Label lblClientCode;
    private Label lblCashAmnt;
    private Combo cmbFrom;
    private Combo cmbTo;
    private Button btnTransfer;
    private Button btnWithdrawl;
    private Button btnSubmit;
    private Button btnCancel;
    Composite parent;
    FontMetrics fontMetrics;
    Log logger = LogFactory.getLog(this.getClass());
    final PriceVerifyListener numberVerifyListener = new PriceVerifyListener(){

        public void verifyText(VerifyEvent e) {
            super.verifyText(e);
            FundMovementView.this.buttonEnablement();
        }
    };

    public FundMovementView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        Group mainGroup = new Group(parent, 16);
        mainGroup.setText("");
        mainGroup.setLayout((Layout)new GridLayout(1, true));
        mainGroup.setLayoutData((Object)new GridData(768, 2, false, false, 2, 1));
        Group fundMovementGrp = new Group((Composite)mainGroup, 16);
        fundMovementGrp.setText("Client Details");
        fundMovementGrp.setLayout((Layout)new GridLayout(2, true));
        fundMovementGrp.setLayoutData((Object)new GridData(768, 1, false, false, 2, 1));
        fundMovementGrp.setFont(WidgetFactory.font_registry.get("FONT_9_BOLD"));
        this.lblClientCode = new Label((Composite)fundMovementGrp, 0);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text((Composite)fundMovementGrp, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)17), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FundMovementView.this.buttonEnablement();
            }
        });
        Group trnsModGrp = new Group((Composite)fundMovementGrp, 16);
        trnsModGrp.setText("Transaction Mode:");
        trnsModGrp.setLayout((Layout)new GridLayout(2, true));
        trnsModGrp.setLayoutData((Object)new GridData(1, 0x1000000, true, true, 2, 1));
        this.btnWithdrawl = new Button((Composite)trnsModGrp, 16);
        this.btnWithdrawl.setText("Withdrawal");
        this.btnWithdrawl.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        this.btnWithdrawl.setSelection(true);
        this.btnWithdrawl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FundMovementView.this.selectDefaultExchange();
                FundMovementView.this.cmbFrom.setEnabled(false);
                FundMovementView.this.cmbTo.setEnabled(false);
            }
        });
        this.btnTransfer = new Button((Composite)trnsModGrp, 16);
        this.btnTransfer.setText("Transfer");
        this.btnTransfer.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        this.btnTransfer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FundMovementView.this.cmbFrom.setEnabled(true);
                FundMovementView.this.cmbTo.setEnabled(true);
            }
        });
        new Label((Composite)fundMovementGrp, 0).setText("From");
        this.cmbFrom = new Combo((Composite)fundMovementGrp, 8);
        this.cmbFrom.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        this.cmbFrom.setEnabled(this.btnTransfer.getSelection());
        new Label((Composite)fundMovementGrp, 0).setText("To");
        this.cmbTo = new Combo((Composite)fundMovementGrp, 8);
        this.cmbTo.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        this.cmbTo.setEnabled(this.btnTransfer.getSelection());
        if (Resources.exchangeNames != null) {
            this.cmbFrom.removeAll();
            this.cmbTo.removeAll();
            int i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbFrom.add((String)Resources.exchangeNames.get(i));
                this.cmbTo.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbFrom.select(0);
            this.cmbTo.select(0);
        }
        this.lblCashAmnt = new Label((Composite)fundMovementGrp, 0);
        this.lblCashAmnt.setText("Cash Amount");
        this.txtCashAmnt = new Text((Composite)fundMovementGrp, 2048);
        this.txtCashAmnt.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)17), -1));
        this.txtCashAmnt.addVerifyListener((VerifyListener)this.numberVerifyListener);
        this.txtCashAmnt.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r' && Resources.isServerConnected((String)FundMovementView.this.txtClientCode.getText(), (boolean)true, (boolean)true)) {
                    if (FundMovementView.this.btnWithdrawl.getSelection()) {
                        FundMovementView.this.sendCashWithdrawRequest();
                    } else if (FundMovementView.this.btnTransfer.getSelection()) {
                        FundMovementView.this.sendCashTransferRequest();
                    }
                }
            }
        });
        this.txtCashAmnt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FundMovementView.this.buttonEnablement();
            }
        });
        this.btnSubmit = new Button((Composite)fundMovementGrp, 8);
        this.btnSubmit.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        this.btnSubmit.setText("Submit");
        this.btnSubmit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)FundMovementView.this.txtClientCode.getText(), (boolean)true, (boolean)true)) {
                    if (FundMovementView.this.btnWithdrawl.getSelection()) {
                        FundMovementView.this.sendCashWithdrawRequest();
                    } else if (FundMovementView.this.btnTransfer.getSelection()) {
                        FundMovementView.this.sendCashTransferRequest();
                    }
                }
            }
        });
        this.btnCancel = new Button((Composite)fundMovementGrp, 8);
        this.btnCancel.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)17), -1));
        this.btnCancel.setText("Clear");
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Resources.isClientType()) {
                    FundMovementView.this.txtClientCode.setText("");
                }
                FundMovementView.this.txtCashAmnt.setText("");
                FundMovementView.this.cmbFrom.select(0);
                FundMovementView.this.cmbTo.select(0);
                FundMovementView.this.buttonEnablement();
            }
        });
        this.buttonEnablement();
    }

    public void itemAdded(final Object o) {
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        FundMovementView.this.txtClientCode.setText(Resources.clientId);
                        FundMovementView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        if (Resources.exchangeNames != null) {
                            FundMovementView.this.cmbFrom.removeAll();
                            FundMovementView.this.cmbTo.removeAll();
                            int i = 0;
                            while (i < Resources.exchangeNames.size()) {
                                FundMovementView.this.cmbFrom.add((String)Resources.exchangeNames.get(i));
                                FundMovementView.this.cmbTo.add((String)Resources.exchangeNames.get(i));
                                ++i;
                            }
                            FundMovementView.this.cmbFrom.select(0);
                            FundMovementView.this.cmbTo.select(0);
                        }
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private void sendCashWithdrawRequest() {
        try {
            if (!this.txtClientCode.getText().trim().equals("")) {
                if (this.txtCashAmnt.getText().equals("") || Float.parseFloat(this.txtCashAmnt.getText()) == 0.0f) {
                    MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Withdrawal", (String)"Invalid Request: Cash amount has not been entered.");
                } else if (MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)"Cash Withdrawal Request", (String)"Do you want to continue with the online cash withdrawal transaction?")) {
                    String fromEx = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(this.cmbFrom.getText())).toString();
                    if (fromEx.equals(Resources.defaultStExCode)) {
                        TransferCashRequest req = new TransferCashRequest(this.txtClientCode.getText().trim(), (double)Float.parseFloat(this.txtCashAmnt.getText()), "W", fromEx);
                        Resources.respCashTransffer = null;
                        if (Resources.getServerLink((String)this.txtClientCode.getText().trim(), (boolean)true, (boolean)true).writeData((Object)req)) {
                            this.logger.info((Object)("cash withdraw request sent for " + this.txtClientCode.getText().trim()));
                            this.txtCashAmnt.setText("");
                            this.btnSubmit.setEnabled(false);
                            BusyIndicator.showWhile((Display)this.parent.getDisplay(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    while (Resources.respCashTransffer == null) {
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            });
                            this.receiveResponse(Resources.respCashTransffer);
                        }
                    } else {
                        MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Withdrawal", (String)"Please select your default exchange.");
                    }
                }
            } else {
                MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Withdrawal", (String)"Invalid Request: Please enter client code.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void selectDefaultExchange() {
        try {
            String fromEx = Resources.exchangeNames.get(Resources.exchangeCodes.indexOf(Resources.defaultStExCode.toString())).toString();
            if (fromEx != null) {
                this.cmbFrom.setText(fromEx);
            }
        }
        catch (Exception exception) {}
    }

    private void sendCashTransferRequest() {
        try {
            if (!this.cmbFrom.getText().equals(this.cmbTo.getText())) {
                if (!this.txtClientCode.getText().trim().equals("")) {
                    if (this.txtCashAmnt.getText().equals("") || Float.parseFloat(this.txtCashAmnt.getText()) == 0.0f) {
                        MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Transfer", (String)"Invalid Request: Cash amount has not been entered.");
                    } else if (MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)"Cash Transfer Request", (String)"Do you want to continue with the online cash transfer transaction?")) {
                        String fromEx = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(this.cmbFrom.getText())).toString();
                        String toEx = Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(this.cmbTo.getText())).toString();
                        TransferCashRequest req = new TransferCashRequest(this.txtClientCode.getText().trim(), (double)Float.parseFloat(this.txtCashAmnt.getText()), "T", fromEx, toEx);
                        Resources.respCashTransffer = null;
                        if (Resources.getServerLink((String)this.txtClientCode.getText().trim(), (boolean)true, (boolean)true).writeData((Object)req)) {
                            this.logger.info((Object)("cash transffer request sent for " + this.txtClientCode.getText().trim()));
                            this.txtCashAmnt.setText("");
                            this.btnSubmit.setEnabled(false);
                            BusyIndicator.showWhile((Display)this.parent.getDisplay(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    while (Resources.respCashTransffer == null) {
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            });
                            this.receiveResponse(Resources.respCashTransffer);
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Transfer", (String)"Invalid Request: Please enter client code.");
                }
            } else {
                MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Transfer", (String)"Cash can't be transfered in same exchange");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Cash Transfer", (String)"Invalid Data");
        }
    }

    protected void receiveResponse(final TransferCashResponse response) {
        this.logger.info((Object)"cash transffer response recieved ");
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        int action = response.getAction();
                        if (action == 1) {
                            MessageDialog.openInformation((Shell)FundMovementView.this.getViewSite().getShell(), (String)"Cash Withdrawal", (String)response.getRemarks());
                        } else if (action == 2) {
                            MessageDialog.openError((Shell)FundMovementView.this.getViewSite().getShell(), (String)"Cash Withdrawal", (String)response.getRemarks());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void buttonEnablement() {
        boolean enable = true;
        if (this.txtClientCode.getText().trim().equals("")) {
            enable = false;
        }
        if (this.cmbFrom.getItemCount() < 1) {
            enable = false;
        }
        this.btnSubmit.setEnabled(enable && this.numberVerifyListener.isValid());
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    FundMovementView.this.txtClientCode.setText(Resources.clientId);
                }
            });
        }
    }
}

