/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ImportUserResponse;
import pk.com.softech.messages.ProgramsRequest;
import pk.com.softech.messages.StudentPortfolioData;
import pk.com.softech.messages.StudentPortfolioRequest;
import pk.com.softech.messages.StudentPortfolioResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.util.SaveFileDialog;

public class ExportPortfolioDataView
extends ViewPart
implements ICollectionObserver {
    org.eclipse.swt.graphics.Font font_bold;
    Combo cmbProgm;
    Combo cmbClients;
    Text txtOpening;
    Text txtTo;
    Text txtFrom;
    Text txtUserId;
    Button btnFetch;
    Button btnClear;
    Button btnExport;
    private Composite parent;
    private TableViewer viewer;
    Table table_acc = null;
    public static final int tradeDate = 0;
    public static final int clientCode = 1;
    public static final int symbol = 2;
    public static final int quantity = 3;
    public static final int costPerUnit = 4;
    public static final int totalCost = 5;
    public static final int currentPrice = 6;
    public static final int currentValue = 7;
    public static final int capGainLoss = 8;
    public static final int invResults = 9;
    public static final int retOnInvPerc = 10;
    public static final int pfWeightPerc = 11;
    public static final int actCostPerUnit = 12;
    private static String[] COLUMN_NAMES = new String[]{"Trade Date", "Client Code", "Symbol", "Quantity", "Cost Per Unit", "Total Cost", "Current Price", "Current Value", "Cap Gain Loss", "Inv Result", "Ret On Inv %", "PF Weight %", "Act Cost Per Unit"};
    private static final int LABEL_WIDTH = 50;
    public Date toDate;
    public Date fromDate;
    public String actProgram;
    private String[] lstProgram = null;
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    List<StudentPortfolioData> dataList = new ArrayList<StudentPortfolioData>();
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.views.ExportPortfolioDataView";
    public static final String PREFS_EXPORT_STUDENT_DATA_VIEW_COLUMNS_SIZE = "PREFS_EXPORT_STUDENT_DATA_VIEW_COLUMNS_SIZE";
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ExportPortfolioDataView.this.viewer.getTable().getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ExportPortfolioDataView.this.viewer.getTable().getColumn(i).getWidth())) + ";");
                ++i;
            }
            CorePlugin.getDefault().getPreferenceStore().setValue(ExportPortfolioDataView.PREFS_EXPORT_STUDENT_DATA_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    private boolean programFetched = false;
    private FontMetrics fontMetrics;

    public ExportPortfolioDataView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    private void clear() {
        this.dataList.clear();
        this.table_acc.clearAll();
        this.txtFrom.clearSelection();
        this.txtTo.clearSelection();
        this.txtUserId.setText("");
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        ScrolledComposite mainComposite = new ScrolledComposite(parent, 2816);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout grid = new GridLayout();
        grid.marginTop = 10;
        mainComposite.setLayout((Layout)grid);
        Composite composite = new Composite((Composite)mainComposite, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group mainGroup = new Group(composite, 16);
        mainGroup.setText("");
        mainGroup.setLayoutData((Object)new GridData(768, 1, false, false, 1, 1));
        mainGroup.setLayout((Layout)new GridLayout(1, true));
        Group grpFilter = new Group((Composite)mainGroup, 0);
        grpFilter.setText("Student Filter");
        grpFilter.setFont(this.font_bold);
        GridLayout grplayout = new GridLayout(10, false);
        grpFilter.setLayout((Layout)grplayout);
        this.txtFrom = this.createText((Composite)grpFilter, 16384);
        this.txtFrom.setEnabled(false);
        Button setFromDate = new Button((Composite)grpFilter, 8);
        setFromDate.setText("From Date");
        setFromDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = ExportPortfolioDataView.this.covertStringToDate(currentDate);
                        Date sDate = ExportPortfolioDataView.this.covertStringToDate(dateString);
                        if (sDate.compareTo(cDate) < 1 && sDate.compareTo(cDate) != 0) {
                            (this).ExportPortfolioDataView.this.txtFrom.setText(dateString);
                            (this).ExportPortfolioDataView.this.fromDate = sDate;
                            dialog.close();
                        } else {
                            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"From date filter is not allowed to the current date");
                            (this).ExportPortfolioDataView.this.txtFrom.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        this.txtTo = this.createText((Composite)grpFilter, 16384);
        this.txtTo.setEnabled(false);
        Button setToDate = new Button((Composite)grpFilter, 8);
        setToDate.setText("To Date");
        setToDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Shell dialog = new Shell(Display.getDefault().getActiveShell());
                dialog.setLayout((Layout)new GridLayout(1, true));
                dialog.setActive();
                dialog.setText("Calendar");
                dialog.setLocation(520, 250);
                final DateTime calendar = new DateTime((Composite)dialog, 3072);
                final String currentDate = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                new Label((Composite)dialog, 0);
                new Label((Composite)dialog, 0);
                Button ok = new Button((Composite)dialog, 8);
                ok.setText("OK");
                ok.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String dateString = String.valueOf(calendar.getMonth() + 1) + "/" + calendar.getDay() + "/" + calendar.getYear();
                        Date cDate = ExportPortfolioDataView.this.covertStringToDate(currentDate);
                        Date tDate = ExportPortfolioDataView.this.covertStringToDate(dateString);
                        if (tDate.compareTo(cDate) < 1 || tDate.compareTo(cDate) == 0) {
                            if ((this).ExportPortfolioDataView.this.fromDate != null) {
                                if (tDate.compareTo((this).ExportPortfolioDataView.this.fromDate) >= 0) {
                                    (this).ExportPortfolioDataView.this.txtTo.setText(dateString);
                                    (this).ExportPortfolioDataView.this.toDate = tDate;
                                    dialog.close();
                                } else {
                                    MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid date selection , To date filter must be greater then from date filter.");
                                    (this).ExportPortfolioDataView.this.txtTo.setText("");
                                }
                            } else {
                                MessageDialog.openInformation(null, (String)"Information", (String)"Please select from date filter first.");
                                (this).ExportPortfolioDataView.this.txtTo.setText("");
                                dialog.close();
                            }
                        } else {
                            MessageDialog.openInformation(null, (String)"Not Allowed", (String)"Invalid date selection , To date filter less then the current date");
                            (this).ExportPortfolioDataView.this.txtTo.setText("");
                        }
                    }
                });
                dialog.setDefaultButton(ok);
                dialog.pack();
                dialog.open();
            }
        });
        this.createLabel((Composite)grpFilter, "Student");
        this.txtUserId = this.createText((Composite)grpFilter, 16384);
        this.txtUserId.addVerifyListener((VerifyListener)new CapitalTextListener());
        Group grpFilter2 = new Group((Composite)mainGroup, 0);
        grpFilter2.setText("Actions");
        grpFilter2.setFont(this.font_bold);
        grpFilter2.setLayoutData((Object)new GridData(768));
        grpFilter2.setLayout((Layout)new GridLayout(3, true));
        this.btnFetch = this.createButton((Composite)grpFilter2, "Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                block3: {
                    try {
                        if (!Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) break block3;
                        String userId = ExportPortfolioDataView.this.txtUserId.getText();
                        if (userId != null && !"".equalsIgnoreCase(userId) && ExportPortfolioDataView.this.toDate != null && ExportPortfolioDataView.this.fromDate != null) {
                            ExportPortfolioDataView.this.btnFetch.setEnabled(false);
                            ExportPortfolioDataView.this.requestPortfolioData(userId);
                            break block3;
                        }
                        ExportPortfolioDataView.this.btnFetch.setEnabled(true);
                        MessageDialog.openError(null, (String)"Export Portfolio Detail", (String)"Please Fill Filter Data Properly.");
                        ExportPortfolioDataView.this.txtUserId.setFocus();
                        return;
                    }
                    catch (Exception exception) {}
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnClear = this.createButton((Composite)grpFilter2, "Clear");
        this.btnExport = this.createButton((Composite)grpFilter2, "Export");
        this.btnExport.setEnabled(false);
        this.btnClear.setEnabled(false);
        this.btnClear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExportPortfolioDataView.this.clear();
                ExportPortfolioDataView.this.btnFetch.setEnabled(true);
                ExportPortfolioDataView.this.btnExport.setEnabled(false);
                ExportPortfolioDataView.this.btnClear.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnExport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ExportPortfolioDataView.this.dataList != null && ExportPortfolioDataView.this.dataList.size() > 0) {
                        ExportPortfolioDataView.this.btnExport.setEnabled(false);
                        HSSFWorkbook workbook = new HSSFWorkbook();
                        HSSFSheet sheet = workbook.createSheet("Student Portfolio Data");
                        workbook.createCellStyle();
                        HSSFFont font = workbook.createFont();
                        font.setFontName("Arial");
                        font.setFontHeightInPoints((short)11);
                        font.setColor(IndexedColors.BLUE.getIndex());
                        HSSFCellStyle headerStyle = workbook.createCellStyle();
                        headerStyle.setFont((Font)font);
                        headerStyle.setAlignment((short)2);
                        int rownum = 0;
                        ExportPortfolioDataView.this.createHeadRow((CellStyle)headerStyle, sheet, (Row)sheet.createRow(rownum++));
                        for (StudentPortfolioData stdObj : ExportPortfolioDataView.this.dataList) {
                            HSSFRow row = sheet.createRow(rownum++);
                            ExportPortfolioDataView.createList(stdObj, (Row)row);
                        }
                        Shell shell = new Shell(Display.getDefault());
                        SaveFileDialog saveFileDlgObj = new SaveFileDialog(shell);
                        saveFileDlgObj.setFilterNames(new String[]{"Excel Files", "All Files (*.*)"});
                        saveFileDlgObj.setFilterExtensions(new String[]{"*.xls", "*.*"});
                        saveFileDlgObj.setFilterPath(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                        saveFileDlgObj.setFileName("PortfolioStudent_" + ExportPortfolioDataView.this.txtUserId.getText() + ".xls");
                        saveFileDlgObj.open();
                        String path = String.valueOf(saveFileDlgObj.getFilterPath()) + "/" + saveFileDlgObj.getFileName();
                        FileOutputStream out = new FileOutputStream(new File(path));
                        workbook.write((OutputStream)out);
                        out.close();
                        ExportPortfolioDataView.this.btnExport.setEnabled(true);
                        MessageDialog.openInformation((Shell)shell, (String)"Success", (String)("Data is export at this path " + path));
                    }
                }
                catch (Exception exception) {
                    ExportPortfolioDataView.this.btnExport.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer(composite);
        mainComposite.setContent((Control)composite);
        mainComposite.setExpandHorizontal(true);
        mainComposite.setExpandVertical(true);
        mainComposite.setMinSize(composite.computeSize(-1, -1));
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)new ResizeColumnsAction(this.table_acc));
    }

    private static void createList(StudentPortfolioData stdObj, Row row) {
        Cell cell_13 = row.createCell(0);
        cell_13.setCellValue("" + stdObj.getTradeDate());
        Cell cell_1 = row.createCell(1);
        cell_1.setCellValue(stdObj.getClient_code());
        Cell cell_2 = row.createCell(2);
        cell_2.setCellValue(stdObj.getSymbol());
        Cell cell_3 = row.createCell(3);
        cell_3.setCellValue((double)stdObj.getQuantity());
        Cell cell_4 = row.createCell(4);
        cell_4.setCellValue(stdObj.getCost_per_unit());
        Cell cell_5 = row.createCell(5);
        cell_5.setCellValue(stdObj.getTotal_cost());
        Cell cell_6 = row.createCell(6);
        cell_6.setCellValue(stdObj.getCurrent_price());
        Cell cell_7 = row.createCell(7);
        cell_7.setCellValue(stdObj.getCurrent_value());
        Cell cell_8 = row.createCell(8);
        cell_8.setCellValue(stdObj.getCap_gain_loss());
        Cell cell_9 = row.createCell(9);
        cell_9.setCellValue(stdObj.getInv_results());
        Cell cell_10 = row.createCell(10);
        cell_10.setCellValue(stdObj.getRet_on_inv_perc());
        Cell cell_11 = row.createCell(11);
        cell_11.setCellValue(stdObj.getPf_wght_perc());
        Cell cell_12 = row.createCell(12);
        cell_12.setCellValue(stdObj.getAct_cost_per_unit());
    }

    private void createHeadRow(CellStyle headerStyle, HSSFSheet sheet, Row row) {
        row.setHeightInPoints(30.0f);
        Cell cell_1 = row.createCell(0);
        cell_1.setCellValue(COLUMN_NAMES[0]);
        cell_1.setCellStyle(headerStyle);
        Cell cell_2 = row.createCell(1);
        cell_2.setCellValue(COLUMN_NAMES[1]);
        cell_2.setCellStyle(headerStyle);
        Cell cell_3 = row.createCell(2);
        cell_3.setCellValue(COLUMN_NAMES[2]);
        cell_3.setCellStyle(headerStyle);
        Cell cell_4 = row.createCell(3);
        cell_4.setCellValue(COLUMN_NAMES[3]);
        cell_4.setCellStyle(headerStyle);
        Cell cell_5 = row.createCell(4);
        cell_5.setCellValue(COLUMN_NAMES[4]);
        cell_5.setCellStyle(headerStyle);
        Cell cell_6 = row.createCell(5);
        cell_6.setCellValue(COLUMN_NAMES[5]);
        cell_6.setCellStyle(headerStyle);
        Cell cell_7 = row.createCell(6);
        cell_7.setCellValue(COLUMN_NAMES[6]);
        cell_7.setCellStyle(headerStyle);
        Cell cell_8 = row.createCell(7);
        cell_8.setCellValue(COLUMN_NAMES[7]);
        cell_8.setCellStyle(headerStyle);
        Cell cell_9 = row.createCell(8);
        cell_9.setCellValue(COLUMN_NAMES[8]);
        cell_9.setCellStyle(headerStyle);
        Cell cell_10 = row.createCell(9);
        cell_10.setCellValue(COLUMN_NAMES[9]);
        cell_10.setCellStyle(headerStyle);
        Cell cell_11 = row.createCell(10);
        cell_11.setCellValue(COLUMN_NAMES[10]);
        cell_11.setCellStyle(headerStyle);
        Cell cell_12 = row.createCell(11);
        cell_12.setCellValue(COLUMN_NAMES[11]);
        cell_12.setCellStyle(headerStyle);
        Cell cell_13 = row.createCell(12);
        cell_13.setCellValue(COLUMN_NAMES[12]);
        cell_13.setCellStyle(headerStyle);
        int i = 0;
        while (i <= 12) {
            sheet.setColumnWidth(i, 3840);
            ++i;
        }
    }

    private void createViewer(Composite content2) {
        this.viewer = new TableViewer(content2, 68354);
        this.createColumns(content2, this.viewer);
        this.table_acc = this.viewer.getTable();
        this.table_acc.setHeaderVisible(true);
        this.table_acc.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData lblTblGridData = new GridData(4, 4, true, true, 1, 1);
        this.viewer.getControl().setLayoutData((Object)lblTblGridData);
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        this.createTableViewerColumn(0);
        this.createTableViewerColumn(1);
        this.createTableViewerColumn(2);
        this.createTableViewerColumn(3);
        this.createTableViewerColumn(4);
        this.createTableViewerColumn(5);
        this.createTableViewerColumn(6);
        this.createTableViewerColumn(7);
        this.createTableViewerColumn(8);
        this.createTableViewerColumn(9);
        this.createTableViewerColumn(10);
        this.createTableViewerColumn(11);
        this.createTableViewerColumn(12);
        String[] sizes = CorePlugin.getDefault().getPreferenceStore().getString(PREFS_EXPORT_STUDENT_DATA_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                viewer.getTable().getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                viewer.getTable().getColumn(i).pack();
                if (viewer.getTable().getColumn(i).getWidth() == 0) {
                    viewer.getTable().getColumn(i).setWidth(100);
                }
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            viewer.getTable().getColumn(viewer.getTable().getColumnCount() - 1).pack();
        }
    }

    private TableViewerColumn createTableViewerColumn(final int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 131072);
        TableColumn column = viewerColumn.getColumn();
        column.setText(COLUMN_NAMES[colNumber]);
        column.setResizable(true);
        column.setMoveable(true);
        column.addControlListener(this.columnControlListener);
        viewerColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                switch (colNumber) {
                    case 0: {
                        cell.setText("" + ((StudentPortfolioData)cell.getElement()).getTradeDate());
                        break;
                    }
                    case 1: {
                        cell.setText(((StudentPortfolioData)cell.getElement()).getClient_code());
                        break;
                    }
                    case 2: {
                        cell.setText(((StudentPortfolioData)cell.getElement()).getSymbol());
                        break;
                    }
                    case 3: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getQuantity()));
                        break;
                    }
                    case 4: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getCost_per_unit()));
                        break;
                    }
                    case 5: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getTotal_cost()));
                        break;
                    }
                    case 6: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getCurrent_price()));
                        break;
                    }
                    case 7: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getCurrent_value()));
                        break;
                    }
                    case 8: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getCap_gain_loss()));
                        break;
                    }
                    case 9: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getInv_results()));
                        break;
                    }
                    case 10: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getRet_on_inv_perc()));
                        break;
                    }
                    case 11: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getPf_wght_perc()));
                        break;
                    }
                    case 12: {
                        cell.setText(String.valueOf(((StudentPortfolioData)cell.getElement()).getAct_cost_per_unit()));
                        break;
                    }
                }
            }

            public String getToolTipText(Object element) {
                StudentPortfolioData sec = (StudentPortfolioData)element;
                return sec.getSymbol();
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
        return viewerColumn;
    }

    public boolean fieldValidation() {
        return true;
    }

    public void showScreen() {
        if (Resources.progResponse == null || Resources.progResponse.length == 0) {
            return;
        }
        try {
            this.lstProgram = new String[Resources.progResponse.length];
            String[] traderCodes = new String[Resources.progResponse.length];
            String traderProgram = "";
            int i = 0;
            while (i < Resources.progResponse.length) {
                int loggedInTrader;
                int traderCode;
                this.lstProgram[i] = Resources.progResponse[i].getProgramName();
                traderCodes[i] = Resources.progResponse[i].getTraderCode();
                if (Resources.userType == 3 && (traderCode = Integer.parseInt(traderCodes[i])) == (loggedInTrader = Integer.parseInt(Resources.traderId))) {
                    traderProgram = this.lstProgram[i];
                    break;
                }
                ++i;
            }
            this.cmbProgm.removeAll();
            if (Resources.userType == 3) {
                this.cmbProgm.add(traderProgram);
            } else if (Resources.userType == 0) {
                i = 0;
                while (i < this.lstProgram.length) {
                    this.cmbProgm.add(this.lstProgram[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cmbProgm.select(0);
    }

    private void requestProgramClients(String actProgram) {
    }

    public void requestProgramsList() {
        try {
            if (!this.programFetched) {
                return;
            }
            String traderCode = Resources.traderId;
            String userId = Resources.userId;
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)new ProgramsRequest(traderCode, userId));
                    this.programFetched = true;
                }
            } else {
                this.programFetched = false;
                this.logger.info((Object)"No Program Fetched, Because server is not connected");
            }
        }
        catch (Exception e) {
            System.out.println("requestUserListing():" + e);
            e.printStackTrace();
        }
    }

    private String getTraderCode(String program) {
        String traderCode = "";
        int i = 0;
        while (i < Resources.progResponse.length) {
            String program1 = Resources.progResponse[i].getProgramName();
            if (program1.equals(program)) {
                traderCode = Resources.progResponse[i].getTraderCode();
                break;
            }
            ++i;
        }
        return traderCode;
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 1);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent, int allignment) {
        Text temp = new Text(parent, 0x800 | allignment);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(true);
        return temp;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        button.setText(label);
        return button;
    }

    private Combo createCombo(Composite parent, String[] arrCombo) {
        Combo cmbUserType = new Combo(parent, 2048);
        int i = 0;
        while (i < arrCombo.length) {
            cmbUserType.add(arrCombo[i]);
            ++i;
        }
        cmbUserType.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        return cmbUserType;
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ImportUserResponse) {
                        ImportUserResponse response = (ImportUserResponse)o;
                        if (response.isUserImported()) {
                            MessageDialog.openInformation(null, (String)"User Creation", (String)"New User has been created Successfully");
                        } else {
                            MessageDialog.openInformation(null, (String)"User Creation", (String)("User could not be created. " + response.getError()));
                        }
                    } else if (o instanceof StudentPortfolioResponse) {
                        StudentPortfolioResponse rsp = (StudentPortfolioResponse)o;
                        ExportPortfolioDataView.this.recievePortfolioDetailResponse(rsp);
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    private void recievePortfolioDetailResponse(final StudentPortfolioResponse resp) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExportPortfolioDataView.this.table_acc.clearAll();
                ExportPortfolioDataView.this.dataList.clear();
                if (resp.getRows() != null && resp.getRows().length > 0) {
                    int i = 0;
                    while (i < resp.getRows().length) {
                        StudentPortfolioData temp = resp.getRows()[i];
                        ExportPortfolioDataView.this.dataList.add(new StudentPortfolioData(temp.getClient_code().toUpperCase(), temp.getSymbol().toUpperCase(), temp.getQuantity(), temp.getCost_per_unit(), temp.getTotal_cost(), temp.getCurrent_price(), temp.getCurrent_value(), temp.getCap_gain_loss(), temp.getInv_results(), temp.getRet_on_inv_perc(), temp.getPf_wght_perc(), temp.getAct_cost_per_unit(), temp.getTradeDate()));
                        ++i;
                    }
                    ExportPortfolioDataView.this.viewer.setInput(ExportPortfolioDataView.this.dataList);
                    ExportPortfolioDataView.this.btnFetch.setEnabled(false);
                    ExportPortfolioDataView.this.btnExport.setEnabled(true);
                    ExportPortfolioDataView.this.btnClear.setEnabled(true);
                } else {
                    MessageDialog.openInformation(null, (String)"Information", (String)"No Data Available To Export");
                    ExportPortfolioDataView.this.btnFetch.setEnabled(true);
                    ExportPortfolioDataView.this.btnExport.setEnabled(false);
                    ExportPortfolioDataView.this.btnClear.setEnabled(false);
                }
            }
        });
    }

    public void requestPortfolioData(String userId) {
        try {
            if (Resources.isServerConnected((String)"", (boolean)false, (boolean)true)) {
                if (Resources.userType == 0 || Resources.userType == 3) {
                    StudentPortfolioRequest request = new StudentPortfolioRequest(userId, this.fromDate, this.toDate);
                    Resources.getServerLink((String)"", (boolean)false, (boolean)true).writeData((Object)request);
                } else {
                    MessageDialog.openError(null, (String)"Error", (String)"Invalid user access!");
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            MessageDialog.openError(null, (String)"Error", (String)"No Request is sent for this client!");
            this.btnClear.setEnabled(true);
            this.btnFetch.setEnabled(true);
            this.btnExport.setEnabled(false);
        }
    }

    public Date covertStringToDate(String str) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date date = df.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setFocus() {
    }
}

