/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.db.PersistentObject;
import pk.com.softech.tradingterminal.core.db.PopupEvent;
import pk.com.softech.tradingterminal.core.ui.actions.DeleteAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.EventDetailsDialog;
import pk.com.softech.tradingterminal.core.ui.internal.Messages;

public class EventsViewKASB
extends ViewPart
implements ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.eventsViewKasb";
    private static final String BUY_BG = "EVENT_BUY_BG";
    private static final String BUY_FG = "EVENT_BUY_FG";
    private static final String SELL_BG = "EVENT_SELL_BG";
    private static final String SELL_FG = "EVENT_SELL_FG";
    private static final String REJECTED_BG = "EVENT_REJECTED_BG";
    private static final String REJECTED_FG = "EVENT_REJECTED_FG";
    private static final String CANCELLED_BG = "EVENT_CANCELLED_BG";
    private static final String CANCELLED_FG = "EVENT_CANCELLED_FG";
    private static final String BUY_TRADE_BG = "EVENT_BUY_TRADE_BG";
    private static final String BUY_TRADE_FG = "EVENT_BUY_TRADE_FG";
    private static final String SELL_TRADE_BG = "EVENT_SELL_TRADE_BG";
    private static final String SELL_TRADE_FG = "EVENT_SELL_TRADE_FG";
    private static final String UPPER_LOCK_BG = "EVENT_UPPER_LOCK_BG";
    private static final String UPPER_LOCK_FG = "EVENT_UPPER_LOCK_FG";
    private static final String LOWER_LOCK_BG = "EVENT_LOWER_LOCK_BG";
    private static final String LOWER_LOCK_FG = "EVENT_LOWER_LOCK_FG";
    private static final String NORMAL_LOCK_BG = "EVENT_NORMAL_LOCK_BG";
    private static final String NORMAL_LOCK_FG = "EVENT_NORMAL_LOCK_FG";
    private static final String DEFAULT_BG = "EVENT_DEFAULT_BG";
    private static final String DEFAULT_FG = "EVENT_DEFAULT_FG";
    private static final String EVENT_TABLE_FONT = "EVENT_TABLE_FONT";
    private static final String EVENT_TABLE_BG = "EVENTS_TABLE_BG";
    ITheme theme;
    CTabFolder tabFolder;
    EventsTable messages;
    EventsTable orders;
    EventsTable trades;
    EventsTable news;
    EventsTable broker;
    String messageTabText = "All Messages";
    String ordersTabText = "Orders";
    String tradesTabText = "Trades";
    String newsTabText = "News";
    String brokerTabText = "Broker Messages";
    Map<Integer, String> message_Type = new HashMap<Integer, String>();
    Composite parent;
    DeleteAction removeSelectedAction;
    Action removeAllAction;
    SimpleDateFormat dateFormatter = CorePlugin.getDateFormat();
    SimpleDateFormat timeFormatter = CorePlugin.getTimeFormat();
    ViewEventDetailsDialog dialog;
    private Comparator<pk.com.softech.tradingterminal.core.db.Event> comparator = new Comparator<pk.com.softech.tradingterminal.core.db.Event>(){

        @Override
        public int compare(pk.com.softech.tradingterminal.core.db.Event arg0, pk.com.softech.tradingterminal.core.db.Event arg1) {
            int index = arg1.getDate().compareTo(arg0.getDate());
            try {
                if (index == 0) {
                    Integer a0 = new Integer(arg0.getId());
                    Integer a1 = new Integer(arg1.getId());
                    index = a1.compareTo(a0);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return index;
        }
    };
    private DisposeListener dialogDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            EventsViewKASB.this.dialog = null;
        }
    };
    IPropertyChangeListener themeChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String prop = event.getProperty();
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                ((ITheme)event.getOldValue()).removePropertyChangeListener((IPropertyChangeListener)this);
                EventsViewKASB.this.setTheme((ITheme)event.getNewValue());
            } else if (prop.equals(EventsViewKASB.EVENT_TABLE_FONT)) {
                EventsViewKASB.this.tabFolder.setFont(EventsViewKASB.this.theme.getFontRegistry().get(EventsViewKASB.EVENT_TABLE_FONT));
            } else if (prop.equals(EventsViewKASB.EVENT_TABLE_BG)) {
                EventsViewKASB.this.tabFolder.setBackground(EventsViewKASB.this.theme.getColorRegistry().get(EventsViewKASB.EVENT_TABLE_BG));
            } else {
                EventsViewKASB.this.updateView();
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        this.message_Type.put(11, "All Messages");
        this.message_Type.put(12, "Orders");
        this.message_Type.put(13, "Trades");
        this.message_Type.put(14, "News");
        this.message_Type.put(15, "Broker Messages");
        this.removeSelectedAction = new DeleteAction(){

            public void run() {
                Table table = (Table)EventsViewKASB.this.tabFolder.getSelection().getControl();
                TableItem[] selection = table.getSelection();
                int i = 0;
                while (i < selection.length) {
                    CorePlugin.getRepository().delete((PersistentObject)((pk.com.softech.tradingterminal.core.db.Event)selection[i].getData()));
                    ++i;
                }
            }
        };
        this.removeSelectedAction.setToolTipText(Messages.EventsView_RemoveActionTooltip);
        this.removeSelectedAction.setImageDescriptor(CorePlugin.getImageDescriptor((String)"icons/elcl16/search_rem.gif"));
        this.removeSelectedAction.setDisabledImageDescriptor(CorePlugin.getImageDescriptor((String)"icons/dlcl16/search_rem.gif"));
        this.removeSelectedAction.setEnabled(false);
        this.removeAllAction = new Action(){

            public void run() {
                CorePlugin.getRepository().allEvents().clear();
            }
        };
        this.removeAllAction.setToolTipText(Messages.EventsView_RemoveAllActionTooltip);
        this.removeAllAction.setImageDescriptor(CorePlugin.getImageDescriptor((String)"icons/elcl16/search_remall.gif"));
        this.removeAllAction.setDisabledImageDescriptor(CorePlugin.getImageDescriptor((String)"icons/dlcl16/search_remall.gif"));
        this.removeAllAction.setEnabled(false);
        super.init(site);
    }

    protected void setTheme(ITheme theme) {
        if (theme != null) {
            this.theme = theme;
            this.tabFolder.setFont(theme.getFontRegistry().get(EVENT_TABLE_FONT));
            this.tabFolder.setBackground(theme.getColorRegistry().get(EVENT_TABLE_BG));
            this.updateView();
            theme.addPropertyChangeListener(this.themeChangeListener);
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        content.setLayout((Layout)gridLayout);
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder = new CTabFolder(content, 1024);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.messageTabText);
        this.messages = new EventsTable((Composite)this.tabFolder);
        tabItem.setControl(this.messages.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.ordersTabText);
        this.orders = new EventsTable((Composite)this.tabFolder);
        tabItem.setControl(this.orders.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.tradesTabText);
        this.trades = new EventsTable((Composite)this.tabFolder);
        tabItem.setControl(this.trades.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.newsTabText);
        this.news = new EventsTable((Composite)this.tabFolder);
        tabItem.setControl(this.news.getControl());
        tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(this.brokerTabText);
        this.broker = new EventsTable((Composite)this.tabFolder);
        tabItem.setControl(this.broker.getControl());
        this.tabFolder.setSelection(0);
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EventsViewKASB.this.updateView();
            }
        });
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        if (themeManager != null) {
            this.theme = themeManager.getCurrentTheme();
            if (this.theme != null) {
                this.setTheme(this.theme);
            }
        }
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(this.removeSelectedAction.getId(), (IAction)this.removeSelectedAction);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("begin"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("end"));
        toolBarManager.appendToGroup("group5", (IAction)this.removeSelectedAction);
        toolBarManager.appendToGroup("group5", (IAction)this.removeAllAction);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("begin"));
        menuManager.add((IContributionItem)new Separator("group0"));
        menuManager.add((IContributionItem)new Separator("group1"));
        menuManager.add((IContributionItem)new Separator("group2"));
        menuManager.add((IContributionItem)new Separator("group3"));
        menuManager.add((IContributionItem)new Separator("group4"));
        menuManager.add((IContributionItem)new Separator("group5"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("end"));
    }

    public void setFocus() {
    }

    public void dispose() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        themeManager.removePropertyChangeListener(this.themeChangeListener);
        ITheme theme = themeManager.getCurrentTheme();
        if (theme != null) {
            theme.removePropertyChangeListener(this.themeChangeListener);
        }
        CorePlugin.getRepository().allEvents().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    private void updateView() {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.tabFolder.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Table table = null;
                    ArrayList list = new ArrayList(CorePlugin.getRepository().allEvents());
                    Collections.sort(list, EventsViewKASB.this.comparator);
                    for (pk.com.softech.tradingterminal.core.db.Event event : list) {
                        CTabItem[] items;
                        CTabItem[] cTabItemArray = items = EventsViewKASB.this.tabFolder.getItems();
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            CTabItem item = cTabItemArray[n2];
                            if (item.getText().equalsIgnoreCase(EventsViewKASB.this.message_Type.get(event.getMessage_Type()))) {
                                table = (Table)item.getControl();
                                table.removeAll();
                                EventsViewKASB.this.tabFolder.setSelection(item);
                                break;
                            }
                            ++n2;
                        }
                        TableItem tableItem = new TableItem(table, 0);
                        tableItem.setText(0, EventsViewKASB.this.dateFormatter.format(event.getDate()));
                        tableItem.setText(1, EventsViewKASB.this.timeFormatter.format(event.getDate()));
                        tableItem.setText(2, event.getSecurity() != null ? event.getSecurity().getId() : "");
                        tableItem.setText(3, event.getMessage());
                        tableItem.setData((Object)event);
                        EventsViewKASB.this.setColor(tableItem, event.getEvent_type());
                    }
                    int i = 0;
                    while (i < table.getColumnCount()) {
                        table.getColumn(i).pack();
                        ++i;
                    }
                    EventsViewKASB.this.removeSelectedAction.setEnabled(table.getSelectionIndex() != -1);
                    EventsViewKASB.this.removeAllAction.setEnabled(table.getItemCount() != 0);
                }
            });
        }
        CorePlugin.getRepository().allEvents().addCollectionObserver((ICollectionObserver)this);
    }

    public void itemAdded(Object o) {
        final pk.com.softech.tradingterminal.core.db.Event event = (pk.com.softech.tradingterminal.core.db.Event)o;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.tabFolder.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CTabItem[] items;
                    Table table = null;
                    CTabItem[] cTabItemArray = items = EventsViewKASB.this.tabFolder.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CTabItem item = cTabItemArray[n2];
                        if (item.getText().equalsIgnoreCase(EventsViewKASB.this.message_Type.get(event.getMessage_Type()))) {
                            table = (Table)item.getControl();
                            EventsViewKASB.this.tabFolder.setSelection(item);
                            break;
                        }
                        ++n2;
                    }
                    TableItem tableItem = new TableItem(table, 0, 0);
                    tableItem.setText(0, EventsViewKASB.this.dateFormatter.format(event.getDate()));
                    tableItem.setText(1, EventsViewKASB.this.timeFormatter.format(event.getDate()));
                    tableItem.setText(2, event.getSecurity() != null ? event.getSecurity().getId() : "");
                    tableItem.setText(3, event.getMessage());
                    tableItem.setData((Object)event);
                    EventsViewKASB.this.setColor(tableItem, event.getEvent_type());
                    EventsViewKASB.this.removeSelectedAction.setEnabled(table.getSelectionIndex() != -1);
                    EventsViewKASB.this.removeAllAction.setEnabled(table.getItemCount() != 0);
                    if (event instanceof PopupEvent && EventsViewKASB.this.dialog == null) {
                        EventsViewKASB.this.dialog = new ViewEventDetailsDialog(event, EventsViewKASB.this.getViewSite().getShell());
                        EventsViewKASB.this.dialog.open();
                    }
                    if (EventsViewKASB.this.dialog != null) {
                        EventsViewKASB.this.dialog.updateButtonStatus();
                    }
                }
            });
        }
    }

    private void setColor(TableItem tableItem, int type) {
        if (type == 0) {
            tableItem.setBackground(this.theme.getColorRegistry().get(BUY_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(BUY_FG));
        } else if (type == 1) {
            tableItem.setBackground(this.theme.getColorRegistry().get(SELL_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(SELL_FG));
        } else if (type == 2) {
            tableItem.setBackground(this.theme.getColorRegistry().get(BUY_TRADE_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(BUY_TRADE_FG));
        } else if (type == 3) {
            tableItem.setBackground(this.theme.getColorRegistry().get(SELL_TRADE_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(SELL_TRADE_FG));
        } else if (type == 4) {
            tableItem.setBackground(this.theme.getColorRegistry().get(REJECTED_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(REJECTED_FG));
        } else if (type == 5) {
            tableItem.setBackground(this.theme.getColorRegistry().get(CANCELLED_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(CANCELLED_FG));
        } else if (type == 6) {
            tableItem.setBackground(this.theme.getColorRegistry().get(UPPER_LOCK_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(UPPER_LOCK_FG));
        } else if (type == 7) {
            tableItem.setBackground(this.theme.getColorRegistry().get(LOWER_LOCK_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(LOWER_LOCK_FG));
        } else if (type == 8) {
            tableItem.setBackground(this.theme.getColorRegistry().get(NORMAL_LOCK_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(NORMAL_LOCK_FG));
        } else {
            tableItem.setBackground(this.theme.getColorRegistry().get(DEFAULT_BG));
            tableItem.setForeground(this.theme.getColorRegistry().get(DEFAULT_FG));
        }
    }

    public void itemRemoved(final Object o) {
        final pk.com.softech.tradingterminal.core.db.Event event = (pk.com.softech.tradingterminal.core.db.Event)o;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.tabFolder.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CTabItem[] tabs;
                    Table table = null;
                    CTabItem[] cTabItemArray = tabs = EventsViewKASB.this.tabFolder.getItems();
                    int n = tabs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CTabItem item = cTabItemArray[n2];
                        if (item.getText().equalsIgnoreCase(EventsViewKASB.this.message_Type.get(event.getMessage_Type()))) {
                            table = (Table)item.getControl();
                            break;
                        }
                        ++n2;
                    }
                    TableItem[] items = table.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (((pk.com.softech.tradingterminal.core.db.Event)items[i].getData()).getId().equals(((pk.com.softech.tradingterminal.core.db.Event)o).getId())) {
                            items[i].dispose();
                        }
                        ++i;
                    }
                    EventsViewKASB.this.removeSelectedAction.setEnabled(table.getSelectionIndex() != -1);
                    EventsViewKASB.this.removeAllAction.setEnabled(table.getItemCount() != 0);
                    if (EventsViewKASB.this.dialog != null) {
                        EventsViewKASB.this.dialog.updateButtonStatus();
                    }
                }
            });
        }
    }

    private class EventsTable
    implements ICollectionObserver {
        Table table;
        TableColumn column;

        public EventsTable(Composite parent) {
            this.table = new Table(parent, 68354);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(false);
            this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (EventsTable.this.table.getItem(new Point(e.x, e.y)) == null) {
                        EventsTable.this.table.deselectAll();
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (EventsTable.this.table.getSelectionIndex() != -1 && ((EventsTable)EventsTable.this).EventsViewKASB.this.dialog == null) {
                        pk.com.softech.tradingterminal.core.db.Event event = (pk.com.softech.tradingterminal.core.db.Event)EventsTable.this.table.getItem(EventsTable.this.table.getSelectionIndex()).getData();
                        ((EventsTable)EventsTable.this).EventsViewKASB.this.dialog = new ViewEventDetailsDialog(event, EventsViewKASB.this.getViewSite().getShell());
                        ((EventsTable)EventsTable.this).EventsViewKASB.this.dialog.open();
                    }
                }
            });
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((EventsTable)EventsTable.this).EventsViewKASB.this.removeSelectedAction.setEnabled(EventsTable.this.table.getSelectionIndex() != -1);
                }
            });
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (EventsTable.this.table.getItem(new Point(e.x, e.y)) == null) {
                        EventsTable.this.table.deselectAll();
                    }
                }
            });
            this.table.addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    event.gc.setBackground(((TableItem)event.item).getBackground());
                    event.gc.fillRectangle(event.getBounds());
                }
            });
            this.column = new TableColumn(this.table, 0);
            this.column.setText(Messages.EventsView_Date);
            this.column.setWidth(100);
            this.column = new TableColumn(this.table, 0);
            this.column.setText(Messages.EventsView_Time);
            this.column.setWidth(100);
            this.column = new TableColumn(this.table, 0);
            this.column.setText(Messages.EventsView_Security);
            this.column.setWidth(100);
            this.column = new TableColumn(this.table, 0);
            this.column.setText(Messages.EventsView_Message);
            this.column.setWidth(400);
        }

        public Control getControl() {
            return this.table;
        }

        public void itemAdded(Object o) {
        }

        public void itemRemoved(Object o) {
        }
    }

    class ViewEventDetailsDialog
    extends EventDetailsDialog {
        public ViewEventDetailsDialog(pk.com.softech.tradingterminal.core.db.Event event, Shell parentShell) {
            super(event, parentShell, true);
        }

        protected void updateEvent() {
            CTabItem[] tabs;
            pk.com.softech.tradingterminal.core.db.Event event = this.getEvent();
            Table table = null;
            CTabItem[] cTabItemArray = tabs = EventsViewKASB.this.tabFolder.getItems();
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                if (item.getText().equalsIgnoreCase(EventsViewKASB.this.message_Type.get(event.getMessage_Type()))) {
                    table = (Table)item.getControl();
                    break;
                }
                ++n2;
            }
            TableItem[] items = table.getItems();
            table.deselectAll();
            int i = 0;
            while (i < items.length) {
                if (this.getEvent().equals(items[i].getData())) {
                    table.select(i);
                }
                ++i;
            }
            super.updateEvent();
        }

        public int open() {
            EventsViewKASB.this.dialog.setBlockOnOpen(false);
            int result = super.open();
            EventsViewKASB.this.dialog.getShell().addDisposeListener(EventsViewKASB.this.dialogDisposeListener);
            return result;
        }

        public void updateButtonStatus() {
            super.updateButtonStatus();
        }
    }
}

