/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.COTConfirmation;
import pk.com.softech.messages.COTData;
import pk.com.softech.messages.COTPositionRequest;
import pk.com.softech.messages.COTPositionResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.Security;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.views.DeliveryVolumeEditingSupport;

public class DeliveryRequestView
extends ViewPart
implements ICollectionObserver {
    private Composite parent;
    private Text txtClientCode;
    private Button btnFetch;
    private Button btnUpdate;
    private Button btnClear;
    private TableViewer viewer;
    FontMetrics fontMetrics;
    public static String VIEW_ID = "pk.com.softech.tradingterminal.trading.DeliveryRequestView";
    private ArrayList<COTData> list;
    NumberFormat pf = CorePlugin.getPriceFormatter();
    NumberFormat nf = CorePlugin.getNumberFormatter();

    public DeliveryRequestView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, false));
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.list = new ArrayList();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, false));
        Label lbl = new Label(composite, 0);
        lbl.setText("Client code: ");
        new GridData(120, 15);
        new GridData(100, 25);
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    DeliveryRequestView.this.sendRequest();
                }
            }
        });
        this.btnFetch = new Button(composite, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeliveryRequestView.this.sendRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnUpdate = new Button(composite, 8);
        this.btnUpdate.setText("Update");
        this.btnUpdate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DeliveryRequestView.this.list.size() > 0) {
                    COTData[] data = new COTData[DeliveryRequestView.this.list.size()];
                    int i = 0;
                    while (i < data.length) {
                        COTData d;
                        COTData temp = (COTData)DeliveryRequestView.this.list.get(i);
                        data[i] = d = new COTData(temp.getSymbol(), temp.getClient(), temp.getSettlementDate(), temp.getTotalVolume(), temp.getDeliveryVolume());
                        ++i;
                    }
                    COTPositionResponse cotPositionResponse = new COTPositionResponse(data);
                    cotPositionResponse.setUserId(Resources.clientId);
                    if (Resources.isServerConnected((String)DeliveryRequestView.this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                        try {
                            Resources.getServerLink((String)DeliveryRequestView.this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)cotPositionResponse);
                        }
                        catch (Exception ex) {
                            CorePlugin.logException((Exception)ex);
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnClear = new Button(composite, 8);
        this.btnClear.setText("Clear");
        this.btnClear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeliveryRequestView.this.requestCOTClear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createViewer(parent);
    }

    private void requestCOTClear() {
        if (Resources.isServerConnected((String)this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
            COTPositionRequest req = new COTPositionRequest(2, this.txtClientCode.getText());
            try {
                Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)req);
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    public void sendRequest() {
        String clientCode = this.txtClientCode.getText().trim();
        if (Resources.isServerConnected((String)clientCode, (boolean)true, (boolean)false)) {
            COTPositionRequest req = new COTPositionRequest(1, clientCode);
            try {
                if (this.btnFetch.isEnabled() && Resources.getServerLink((String)clientCode, (boolean)true, (boolean)false).writeData((Object)req)) {
                    this.btnFetch.setEnabled(false);
                }
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = colNumber > 2 ? new TableViewerColumn(this.viewer, 131072) : new TableViewerColumn(this.viewer, 16384);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(false);
        return viewerColumn;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Sett. Date", "Client", "Symbol", "Buy Volume", "Market Value", "CFS", "Delivery"};
        int[] bounds = new int[]{100, 100, 100, 100, 100, 100, 100, 100, 100};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                COTData cotData = (COTData)element;
                return "" + cotData.getSettlementDate();
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                COTData cotData = (COTData)element;
                return cotData.getClient();
            }
        });
        col = this.createTableViewerColumn(titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                COTData cotData = (COTData)element;
                return cotData.getSymbol();
            }
        });
        col = this.createTableViewerColumn(titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                COTData cotData = (COTData)element;
                return DeliveryRequestView.this.nf.format(cotData.getTotalVolume());
            }
        });
        col = this.createTableViewerColumn(titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                COTData cotData = (COTData)element;
                Security sec = CorePlugin.getRepository().getSecurity(cotData.getSymbol());
                if (sec != null) {
                    return DeliveryRequestView.this.pf.format((double)cotData.getTotalVolume() * sec.getQuote().getLast());
                }
                return "0";
            }
        });
        col = this.createTableViewerColumn(titles[5], bounds[5], 5);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                COTData cotData = (COTData)element;
                return DeliveryRequestView.this.nf.format(cotData.getTotalVolume() - cotData.getDeliveryVolume());
            }
        });
        col = this.createTableViewerColumn(titles[6], bounds[6], 6);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                COTData cotData = (COTData)element;
                return DeliveryRequestView.this.nf.format(cotData.getDeliveryVolume());
            }
        });
        col.setEditingSupport((EditingSupport)new DeliveryVolumeEditingSupport(viewer));
    }

    private void createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 20;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.list);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.verticalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    public void setFocus() {
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        DeliveryRequestView.this.txtClientCode.setText(Resources.clientId);
                        DeliveryRequestView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    } else if (o instanceof COTPositionResponse) {
                        COTPositionResponse resp = (COTPositionResponse)o;
                        DeliveryRequestView.this.recieveResponse(resp);
                        DeliveryRequestView.this.btnFetch.setEnabled(true);
                    } else if (o instanceof COTConfirmation) {
                        COTConfirmation resp = (COTConfirmation)o;
                        MessageDialog.openInformation(null, (String)"COT Confirmation", (String)resp.getRemarks());
                        if (resp.getAction() == COTConfirmation.REJECT) {
                            DeliveryRequestView.this.sendRequest();
                        }
                    }
                }
            });
        }
    }

    protected void recieveResponse(COTPositionResponse resp) {
        COTData[] rows = resp.getRows();
        this.list.removeAll(this.list);
        if (rows != null) {
            this.list.addAll(Arrays.asList(rows));
            this.viewer.setInput(this.list);
            this.viewer.refresh();
        } else {
            this.viewer.remove(this.list);
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }
}

