/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class CounterPanel
extends Composite {
    protected Text fNumberOfGains;
    protected Text fNumberOfLosses;
    protected Text fNumberOfRuns;
    protected int fTotal;
    private final Image fSuccessIcon = TradingPlugin.getImageDescriptor("icons/ovr16/success_ovr.gif").createImage();
    private final Image fFailureIcon = TradingPlugin.getImageDescriptor("icons/ovr16/error_ovr.gif").createImage();

    public CounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel("Signals:", null, " 0 ");
        this.fNumberOfGains = this.createLabel("Gains:", this.fSuccessIcon, " 0 ");
        this.fNumberOfLosses = this.createLabel("Losses:", this.fFailureIcon, " 0 ");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        this.fSuccessIcon.dispose();
        this.fFailureIcon.dispose();
    }

    private Text createLabel(String name, Image image, String init) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text((Composite)this, 8);
        value.setText(init);
        value.setBackground(this.getDisplay().getSystemColor(22));
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void reset() {
        this.setGainsValue(0);
        this.setLossesValue(0);
        this.setRunValue(0);
        this.fTotal = 0;
    }

    public void setTotal(int value) {
        this.fTotal = value;
    }

    public int getTotal() {
        return this.fTotal;
    }

    public void setRunValue(int value) {
        this.fNumberOfRuns.setText(Integer.toString(value));
        this.fNumberOfRuns.redraw();
        this.redraw();
    }

    public void setGainsValue(int value) {
        this.fNumberOfGains.setText(Integer.toString(value));
        this.redraw();
    }

    public void setLossesValue(int value) {
        this.fNumberOfLosses.setText(Integer.toString(value));
        this.redraw();
    }
}

