/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.AccountDetailsData;
import pk.com.softech.messages.CombinedAccountRequest;
import pk.com.softech.messages.CombinedAccountResponse;
import pk.com.softech.messages.CombinedAccountSummaryData;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.EditColumnsAction;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.ColumnsOptionDialog;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class CombinedMarginView
extends ViewPart
implements IPropertyChangeListener,
ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.combinedMargin";
    public static final String PREFS_COMBINED_MARGIN_VIEW_COLUMNS = "COMBINED_MARGIN_VIEW_COLUMNS";
    public static final String PREFS_COMBINED_MARGIN_VIEW_COLUMNS_SIZE = "COMBINED_MARGIN_VIEW_COLUMNS_SIZE";
    Label lblClient;
    Text txtClientCode;
    Button btnFetch;
    Table table_acc_liquidity;
    Table table_acc_summ;
    Font font_bold;
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 23;
    Composite content;
    Composite parent;
    LabelProvidersRegistry registry = new LabelProvidersRegistry("pk.com.softech.tradingterminal.trading.combinedMargin");
    Table table;
    int sortColumn = 0;
    int sortDirection = 0;
    String[] accSummaryColumns = new String[]{"Exchange", "Cash Balance", "Market Value of Custody", "Custody Reduced Value"};
    String[] accLiquidityColumns = new String[]{"Exchange", "Net Liquidity(Margin)", "Open Position(Exposure)", "Margin Required", "Cash Margin Required", "Free Margin", "Ready Buying Power", "MTM", "Blocked MTM Profit", "Pending Cash Withdrawal", "Cash Withdrawl Limit", "Cash Margin Call", "Net Margin Call", "Margin Percentage", "Account Status"};
    private Log logger = LogFactory.getLog(this.getClass());
    Group cmpNorth;
    Group cmpCenter;
    Group cmpSouth;
    private NumberFormat pf = CorePlugin.getPriceFormatter();
    Action refreshAction;
    private IAction editColumnsAction;
    List list = new ArrayList();
    IPreferenceStore preferences;
    boolean columnMove = false;
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < CombinedMarginView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(CombinedMarginView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            CombinedMarginView.this.preferences.setValue(CombinedMarginView.PREFS_COMBINED_MARGIN_VIEW_COLUMNS_SIZE, sizes.toString());
        }

        public void controlMoved(ControlEvent e) {
            if (!CombinedMarginView.this.columnMove) {
                return;
            }
            int[] ord = CombinedMarginView.this.table.getColumnOrder();
            int[] newOrd = new int[ord.length];
            StringBuffer ids = new StringBuffer();
            int i = 0;
            while (i < CombinedMarginView.this.table.getColumnCount()) {
                newOrd[i] = i;
                TableColumn col = CombinedMarginView.this.table.getColumn(ord[i]);
                ids.append(col.getData("columnId") + ";");
                ++i;
            }
            CombinedMarginView.this.table.setColumnOrder(newOrd);
            CombinedMarginView.this.preferences.setValue(CombinedMarginView.PREFS_COMBINED_MARGIN_VIEW_COLUMNS, ids.toString());
        }
    };
    SelectionListener columnSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            int index = CombinedMarginView.this.table.indexOf((TableColumn)e.widget);
            if (CombinedMarginView.this.sortColumn == index) {
                CombinedMarginView.this.sortDirection = CombinedMarginView.this.sortDirection == 0 ? 1 : 0;
            } else {
                CombinedMarginView.this.sortColumn = index;
                CombinedMarginView.this.sortDirection = 0;
            }
            CombinedMarginView.this.updateTable(CombinedMarginView.this.list);
        }
    };
    Comparator comparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            Object provider = CombinedMarginView.this.table.getColumn(CombinedMarginView.this.sortColumn).getData("labelProvider");
            if (provider instanceof Comparator) {
                if (CombinedMarginView.this.sortDirection == 0) {
                    return ((Comparator)provider).compare(arg0, arg1);
                }
                return ((Comparator)provider).compare(arg1, arg0);
            }
            return 0;
        }
    };
    private FontMetrics fontMetrics;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
    }

    public void createPartControl(Composite parent) {
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        this.parent = parent;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        this.content.setLayout((Layout)layout);
        this.content.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, true));
        this.lblClient = new Label(composite, 0);
        this.lblClient.setText("Client Code");
        this.lblClient.setFont(this.font_bold);
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    if (Resources.isServerConnected((String)CombinedMarginView.this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                        CombinedMarginView.this.sendMarginDetailRequest();
                    } else {
                        CombinedMarginView.this.clearFields();
                    }
                }
            }
        });
        this.btnFetch = new Button(composite, 0);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (Resources.isServerConnected((String)CombinedMarginView.this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                    CombinedMarginView.this.sendMarginDetailRequest();
                } else {
                    CombinedMarginView.this.clearFields();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cmpNorth = new Group(this.content, 16);
        this.cmpNorth.setText("Account Summary");
        this.cmpNorth.setFont(this.font_bold);
        layout = new GridLayout(1, true);
        layout.verticalSpacing = 0;
        this.cmpNorth.setLayout((Layout)layout);
        this.cmpNorth.setLayoutData((Object)new GridData(4, 4, true, false));
        this.table_acc_summ = new Table((Composite)this.cmpNorth, 2816);
        this.table_acc_summ.setHeaderVisible(true);
        this.table_acc_summ.setLinesVisible(true);
        this.table_acc_summ.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < this.accSummaryColumns.length) {
            TableColumn column0 = new TableColumn(this.table_acc_summ, 0);
            column0.setText(this.accSummaryColumns[i]);
            ++i;
        }
        i = 0;
        while (i < this.accSummaryColumns.length) {
            this.table_acc_summ.getColumn(i).pack();
            ++i;
        }
        this.cmpCenter = new Group(this.content, 16);
        this.cmpCenter.setText("Account Liquidity");
        this.cmpCenter.setFont(this.font_bold);
        layout = new GridLayout(1, true);
        layout.verticalSpacing = 0;
        this.cmpCenter.setLayout((Layout)layout);
        this.cmpCenter.setLayoutData((Object)new GridData(4, 4, true, false));
        this.table_acc_liquidity = new Table((Composite)this.cmpCenter, 2816);
        this.table_acc_liquidity.setHeaderVisible(true);
        this.table_acc_liquidity.setLinesVisible(true);
        this.table_acc_liquidity.setLayoutData((Object)new GridData(1808));
        i = 0;
        while (i < this.accLiquidityColumns.length) {
            TableColumn column = new TableColumn(this.table_acc_liquidity, 0);
            column.setText(this.accLiquidityColumns[i]);
            ++i;
        }
        i = 0;
        while (i < this.accLiquidityColumns.length) {
            this.table_acc_liquidity.getColumn(i).pack();
            ++i;
        }
        this.cmpSouth = new Group(this.content, 16);
        this.cmpSouth.setText("Porfolio Details");
        this.cmpSouth.setFont(this.font_bold);
        this.cmpSouth.setLayout((Layout)new GridLayout(1, true));
        this.cmpSouth.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table((Composite)this.cmpSouth, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.makeViewActions();
        this.contributeToActionBars();
        if (Resources.loginStatus && Resources.refDataComplete) {
            this.sendMarginDetailRequest();
        }
    }

    protected void sendMarginDetailRequest() {
        block6: {
            try {
                if (!this.txtClientCode.getText().equals("")) {
                    CombinedAccountRequest req = new CombinedAccountRequest(this.txtClientCode.getText().trim(), 1, Boolean.valueOf(Resources.userType == 3));
                    try {
                        if (this.btnFetch.isEnabled() && Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false) != null && Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)req)) {
                            this.logger.info((Object)("Sending combined margin request for Client = " + this.txtClientCode.getText()));
                            this.btnFetch.setEnabled(false);
                            this.refreshAction.setEnabled(false);
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        CorePlugin.logException((Exception)e);
                    }
                    break block6;
                }
                this.clearFields();
            }
            catch (Exception e) {
                this.logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public void receiveMarginDetailResponse(final CombinedAccountResponse response) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (response != null) {
                    try {
                        CombinedMarginView.this.table_acc_summ.removeAll();
                        CombinedMarginView.this.table_acc_liquidity.removeAll();
                        double totalWorth = 0.0;
                        double workingCapital = 0.0;
                        CombinedAccountSummaryData[] data = response.getSummaryRows();
                        int i = 0;
                        while (i < data.length) {
                            block19: {
                                String exchange = "";
                                try {
                                    exchange = Resources.exchangeNames.get(Resources.exchangeCodes.indexOf(data[i].getStExCode())).toString();
                                }
                                catch (Exception exception) {
                                    CombinedMarginView.this.logger.info((Object)("Exch code not found : " + data[i].getStExCode()));
                                    break block19;
                                }
                                TableItem item = new TableItem(CombinedMarginView.this.table_acc_summ, 0);
                                item.setText(0, exchange);
                                item.setText(1, CombinedMarginView.this.pf.format(data[i].getCashBalance()));
                                item.setText(2, CombinedMarginView.this.pf.format(data[i].getPortfolioValue()));
                                item.setText(3, CombinedMarginView.this.pf.format(data[i].getReducedValue()));
                                totalWorth += data[i].getCashBalance() + data[i].getPortfolioValue();
                                workingCapital += data[i].getCashBalance() + data[i].getReducedValue();
                                TableItem item1 = new TableItem(CombinedMarginView.this.table_acc_liquidity, 0);
                                item1.setText(0, exchange);
                                item1.setText(1, CombinedMarginView.this.pf.format(data[i].getNetLiquidity()));
                                item1.setText(2, CombinedMarginView.this.pf.format(data[i].getOpenPosition()));
                                item1.setText(3, CombinedMarginView.this.pf.format(data[i].getMarginRequired()));
                                item1.setText(4, CombinedMarginView.this.pf.format(data[i].getMarginRequiredAsCash()));
                                item1.setText(5, CombinedMarginView.this.pf.format(data[i].getFreeMargin() > 0.0 ? data[i].getFreeMargin() : 0.0));
                                item1.setText(6, CombinedMarginView.this.pf.format(data[i].getFreeCash() > 0.0 ? data[i].getFreeCash() : 0.0));
                                item1.setText(7, CombinedMarginView.this.pf.format(data[i].getProfitLos()));
                                item1.setText(8, CombinedMarginView.this.pf.format(data[i].getBlockedMTMProfit()));
                                item1.setText(9, CombinedMarginView.this.pf.format(data[i].getCashWithdrawalinProcess()));
                                item1.setText(10, CombinedMarginView.this.pf.format(data[i].getCashWithdrawal()));
                                item1.setText(11, CombinedMarginView.this.pf.format(data[i].getCashMarginCall()));
                                item1.setText(12, CombinedMarginView.this.pf.format(data[i].getNetMarginCall()));
                                item1.setText(13, CombinedMarginView.this.pf.format(data[i].getMarginPerc()));
                                if (data[i].getCashMarginCall() < 0.0 || data[i].getNetMarginCall() < 0.0) {
                                    item1.setText(14, "MARGIN CALL");
                                    item1.setBackground(14, WidgetFactory.color_registry.get("COLOR_RED"));
                                } else {
                                    item1.setText(14, "");
                                    item1.setBackground(14, WidgetFactory.color_registry.get("COLOR_WHITE"));
                                }
                            }
                            ++i;
                        }
                        if (data != null && data.length > 0) {
                            TableItem item = new TableItem(CombinedMarginView.this.table_acc_summ, 0);
                            item.setText(0, "Total Equity");
                            item.setText(2, CombinedMarginView.this.pf.format(totalWorth));
                            item.setText(3, CombinedMarginView.this.pf.format(workingCapital));
                            item.setFont(CombinedMarginView.this.font_bold);
                        }
                        i = 0;
                        while (i < CombinedMarginView.this.accSummaryColumns.length) {
                            CombinedMarginView.this.table_acc_summ.getColumn(i).pack();
                            ++i;
                        }
                        i = 0;
                        while (i < CombinedMarginView.this.accLiquidityColumns.length) {
                            CombinedMarginView.this.table_acc_liquidity.getColumn(i).pack();
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        CombinedMarginView.this.logger.debug((Object)"Exception in adding rows in Account Summary");
                        e.printStackTrace();
                    }
                    if (response.getrows() != null) {
                        ArrayList<AccountDetailsData> dataList = new ArrayList<AccountDetailsData>();
                        AccountDetailsData[] rows = response.getrows();
                        Hashtable<String, Double> cashRequired = new Hashtable<String, Double>();
                        int i = 0;
                        while (i < Resources.exchangeNames.size()) {
                            cashRequired.put((String)Resources.exchangeNames.get(i), 0.0);
                            ++i;
                        }
                        Resources.exchangeNames.get(Resources.exchangeCodes.indexOf(Resources.defaultStExCode)).toString();
                        i = 0;
                        while (i < rows.length) {
                            dataList.add(rows[i]);
                            if (rows[i].getCashTrading() == 0) {
                                double oldValue = (Double)cashRequired.get(rows[i].getExchange());
                                cashRequired.put(rows[i].getExchange(), rows[i].getCashReq() + oldValue);
                            }
                            ++i;
                        }
                        CombinedMarginView.this.updateTable(dataList);
                        i = 0;
                        while (i < cashRequired.size() && i < CombinedMarginView.this.table_acc_liquidity.getItemCount()) {
                            TableItem item = CombinedMarginView.this.table_acc_liquidity.getItem(i);
                            String exch = item.getText(0);
                            double cash = cashRequired.get(exch) == null ? 0.0 : (Double)cashRequired.get(exch);
                            item.setText(4, CombinedMarginView.this.pf.format(cash));
                            ++i;
                        }
                    }
                    try {
                        CombinedMarginView.this.table_acc_summ.getParent().layout();
                        CombinedMarginView.this.table_acc_liquidity.getParent().layout();
                        CombinedMarginView.this.table.getParent().getParent().layout();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    CombinedMarginView.this.clearFields();
                }
            }
        });
    }

    private void clearFields() {
        int j;
        TableItem item;
        int i = 0;
        while (i < this.table_acc_summ.getItemCount()) {
            item = this.table_acc_summ.getItem(i);
            j = 0;
            while (j < this.accSummaryColumns.length) {
                item.setText(j, "");
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.table_acc_liquidity.getItemCount()) {
            item = this.table_acc_liquidity.getItem(i);
            j = 0;
            while (j < this.accLiquidityColumns.length) {
                item.setText(j, "");
                ++j;
            }
            ++i;
        }
        this.updateTable(new ArrayList());
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                if (Resources.isServerConnected((String)CombinedMarginView.this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
                    CombinedMarginView.this.sendMarginDetailRequest();
                } else {
                    CombinedMarginView.this.clearFields();
                }
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
        this.editColumnsAction = new EditColumnsAction((Dialog)new ColumnsOptionDialog((IViewPart)this, PREFS_COMBINED_MARGIN_VIEW_COLUMNS, PREFS_COMBINED_MARGIN_VIEW_COLUMNS_SIZE, this.preferences));
    }

    private void contributeToActionBars() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator("top"));
        manager.add(this.editColumnsAction);
        manager.add((IAction)new ResizeColumnsAction(this.table));
        manager.add((IContributionItem)new Separator("group0"));
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IContributionItem)new Separator("group3"));
        manager.add((IContributionItem)new Separator("group4"));
        manager.add((IContributionItem)new Separator("group5"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
    }

    public void updateTable(List lst) {
        this.columnMove = false;
        if (this.table != null && !this.table.isDisposed()) {
            this.list = lst;
            int index = 0;
            String[] id = this.preferences.getString(PREFS_COMBINED_MARGIN_VIEW_COLUMNS).split(";");
            int i = 0;
            while (i < id.length) {
                TableColumn tableColumn;
                String name = "";
                int style = 16384;
                Image image = null;
                ILabelProvider provider = this.registry.createLabelProvider(id[i]);
                if (provider != null) {
                    name = this.registry.getName(id[i]);
                    style = this.registry.getOrientation(id[i]);
                    if (provider instanceof ITableLabelProvider) {
                        name = ((ITableLabelProvider)provider).getColumnText(null, i);
                        image = ((ITableLabelProvider)provider).getColumnImage(null, i);
                    }
                } else {
                    LogFactory.getLog(this.getClass()).warn((Object)("Missing column [" + id[i] + "]"));
                }
                if (index < this.table.getColumnCount()) {
                    tableColumn = this.table.getColumn(index);
                    if (tableColumn.getData("labelProvider") != null) {
                        ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                    }
                } else {
                    tableColumn = new TableColumn(this.table, style);
                    tableColumn.addControlListener(this.columnControlListener);
                    tableColumn.addSelectionListener(this.columnSelectionListener);
                    tableColumn.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (e.widget.getData("labelProvider") != null) {
                                ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                            }
                        }
                    });
                }
                tableColumn.setText(name);
                tableColumn.setAlignment(style);
                tableColumn.setImage(image);
                tableColumn.setMoveable(true);
                tableColumn.setData("labelProvider", (Object)provider);
                tableColumn.setData("columnId", (Object)id[i]);
                ++index;
                ++i;
            }
            while (index < this.table.getColumnCount()) {
                this.table.getColumn(index).dispose();
            }
            if (this.sortColumn >= 0 && this.sortColumn < this.table.getColumnCount()) {
                this.table.setSortColumn(this.table.getColumn(this.sortColumn));
                this.table.setSortDirection(this.sortDirection == 0 ? 128 : 1024);
                Collections.sort(this.list, this.comparator);
            } else {
                this.table.setSortColumn(null);
                this.sortColumn = -1;
                this.sortDirection = 0;
            }
            this.table.removeAll();
            for (AccountDetailsData data : this.list) {
                TableItem tableItem = new TableItem(this.table, 0);
                this.update(tableItem, data);
            }
            String[] sizes = this.preferences.getString(PREFS_COMBINED_MARGIN_VIEW_COLUMNS_SIZE).split(";");
            int i2 = 0;
            while (i2 < this.table.getColumnCount()) {
                if (i2 < sizes.length && sizes[i2].length() != 0) {
                    this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
                } else {
                    this.table.getColumn(i2).setWidth(100);
                }
                ++i2;
            }
            if ("gtk".equals(SWT.getPlatform())) {
                this.table.getColumn(this.table.getColumnCount() - 1).pack();
            }
        }
        this.columnMove = true;
    }

    void update(TableItem tableItem, AccountDetailsData data) {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(i);
            ILabelProvider label = (ILabelProvider)tableColumn.getData("labelProvider");
            if (label != null) {
                tableItem.setText(i, label.getText((Object)data));
                Image image = label.getImage((Object)data);
                if (image != tableItem.getImage(i)) {
                    tableItem.setImage(image);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof CombinedAccountResponse && ((CombinedAccountResponse)o).getResponseType() == 1) {
                        CombinedMarginView.this.receiveMarginDetailResponse((CombinedAccountResponse)o);
                        CombinedMarginView.this.btnFetch.setEnabled(true);
                        CombinedMarginView.this.refreshAction.setEnabled(true);
                    }
                    if (o instanceof LoginConfirmation && Resources.trnCode.contains("OA06")) {
                        CombinedMarginView.this.txtClientCode.setText(Resources.clientId);
                        CombinedMarginView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        CombinedMarginView.this.sendMarginDetailRequest();
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(PREFS_COMBINED_MARGIN_VIEW_COLUMNS)) {
            this.updateTable(this.list);
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CombinedMarginView.this.txtClientCode.setText(Resources.clientId);
                    CombinedMarginView.this.sendMarginDetailRequest();
                }
            });
        }
    }
}

