/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.TradeSummaryRequest;
import pk.com.softech.messages.TradeSummaryResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.db.ClientCode;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class ClientTradesSummaryView
extends ViewPart
implements ICollectionObserver,
Observer {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.clientTradesSummary";
    public static final String PREFS_TRADES_SUMMARY_VIEW_COLUMNS_SIZE = "TRADES_SUMMARY_VIEW_COLUMNS_SIZE";
    private static final String TIME_PATTERN = "(\\d{2}:\\d{2}:\\d{2})|";
    private Combo cmbExchange;
    private Text txtClientCode;
    private Text txtSubCode;
    private Text txtSymbol;
    private Text txtReferenceNo;
    private Text txtFromTime;
    private Text txtToTime;
    private Label lblExchange;
    private Label lblClientCode;
    private Label lblSubCode;
    private Label lblSymbol;
    private Label lblReferenceNo;
    private Label lblFromTime;
    private Label lblToTime;
    private Button btnFetch;
    Table table = null;
    protected Log logger = LogFactory.getLog(this.getClass());
    Composite parent;
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ClientTradesSummaryView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientTradesSummaryView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            TradingPlugin.getDefault().getPreferenceStore().setValue(ClientTradesSummaryView.PREFS_TRADES_SUMMARY_VIEW_COLUMNS_SIZE, sizes.toString());
        }
    };
    private Action refreshAction;

    public ClientTradesSummaryView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.addObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite content = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(8).equalWidth(false).applyTo(content);
        GridData lblGridData = GridDataFactory.swtDefaults().hint(60, -1).grab(false, false).create();
        this.lblExchange = new Label(content, 0);
        this.lblExchange.setText("Exchange");
        this.cmbExchange = new Combo(content, 2056);
        if (Resources.exchangeNames != null) {
            this.cmbExchange.removeAll();
            this.cmbExchange.add("All");
            int i = 0;
            while (i < Resources.exchangeNames.size()) {
                this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                ++i;
            }
            this.cmbExchange.select(0);
        }
        this.lblClientCode = new Label(content, 0);
        this.lblClientCode.setText("Client Code");
        this.txtClientCode = new Text(content, 2048);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    ClientTradesSummaryView.this.sendReportRequest();
                }
            }
        });
        this.lblSymbol = new Label(content, 0);
        this.lblSymbol.setText("Symbol");
        this.txtSymbol = new Text(content, 2048);
        this.txtSymbol.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtSymbol.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    ClientTradesSummaryView.this.sendReportRequest();
                }
            }
        });
        new Label(content, 0);
        this.btnFetch = new Button(content, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClientTradesSummaryView.this.sendReportRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.lblReferenceNo = new Label(content, 0);
        this.lblReferenceNo.setText("Reference No");
        this.txtReferenceNo = new Text(content, 2048);
        this.lblFromTime = new Label(content, 0);
        this.lblFromTime.setText("From Time");
        this.txtFromTime = new Text(content, 2048);
        this.txtFromTime.setText("09:00:00");
        this.lblToTime = new Label(content, 0);
        this.lblToTime.setText("To Time");
        this.txtToTime = new Text(content, 2048);
        this.lblSubCode = new Label(content, 0);
        this.lblSubCode.setText("Sub Code");
        this.lblSubCode.setVisible(Resources.isMemberTerminal());
        this.txtSubCode = new Text(content, 2048);
        this.txtSubCode.setVisible(Resources.isMemberTerminal());
        this.txtSubCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.table = new Table(parent, 68354);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        lblGridData = new GridData(4, 4, true, true, 8, 1);
        this.table.setLayoutData((Object)lblGridData);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ClientTradesSummaryView.this.table.getItem(new Point(e.x, e.y)) == null) {
                    ClientTradesSummaryView.this.table.deselectAll();
                }
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.gc.setBackground(((TableItem)event.item).getBackground());
                event.gc.fillRectangle(event.getBounds());
            }
        });
        TableColumn column = new TableColumn(this.table, 0);
        column.setText("Exchange");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Symbol");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Side");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Volume");
        column.setAlignment(131072);
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Unit Price");
        column.setAlignment(131072);
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Client");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Ref Number");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Sub Code");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Trade Time");
        column.addControlListener(this.columnControlListener);
        column = new TableColumn(this.table, 0);
        column.setText("Unit/Vol");
        column.addControlListener(this.columnControlListener);
        column.setText("Order Nature");
        column.addControlListener(this.columnControlListener);
        String[] sizes = TradingPlugin.getDefault().getPreferenceStore().getString(PREFS_TRADES_SUMMARY_VIEW_COLUMNS_SIZE).split(";");
        int i = 0;
        while (i < this.table.getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                this.table.getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                this.table.getColumn(i).setWidth(100);
            }
            ++i;
        }
        if ("gtk".equals(SWT.getPlatform())) {
            this.table.getColumn(this.table.getColumnCount() - 1).pack();
        }
        this.makeViewActions();
        this.contributeToActionBars();
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                ClientTradesSummaryView.this.sendReportRequest();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
    }

    private void contributeToActionBars() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator("top"));
        manager.add((IAction)new ResizeColumnsAction(this.table));
        manager.add((IContributionItem)new Separator("group0"));
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IContributionItem)new Separator("group3"));
        manager.add((IContributionItem)new Separator("group4"));
        manager.add((IContributionItem)new Separator("group5"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
    }

    public void sendReportRequest() {
        block9: {
            if (Resources.isServerConnected((String)this.txtClientCode.getText().trim(), (boolean)false, (boolean)false)) {
                try {
                    String exCode = this.cmbExchange.getText().equals("All") ? Utility.getClientExchanges((Vector)Resources.exchangeCodes) : Resources.exchangeCodes.get(Resources.exchangeNames.indexOf(this.cmbExchange.getText())).toString();
                    String clientCode = this.txtClientCode.getText();
                    String symbol = this.txtSymbol.getText();
                    String sub_code = this.txtSubCode.getText();
                    String ref_number = this.txtReferenceNo.getText();
                    String fDate = this.txtFromTime.getText();
                    String tDate = this.txtToTime.getText();
                    if (exCode == null) {
                        MessageDialog.openError(null, (String)"Invalid Parameters", (String)"Invalid exchange code.");
                        break block9;
                    }
                    if (!fDate.matches(TIME_PATTERN)) {
                        MessageDialog.openError(null, (String)"Invalid Parameters", (String)"Invalid from date, expected formate is (HH:mm:ss).");
                        break block9;
                    }
                    if (!tDate.matches(TIME_PATTERN)) {
                        MessageDialog.openError(null, (String)"Invalid Parameters", (String)"Invalid to date, expected formate is (HH:mm:ss).");
                        break block9;
                    }
                    TradeSummaryRequest req = new TradeSummaryRequest(clientCode, symbol, ref_number, false, false, sub_code, fDate, tDate);
                    req.setStExCode(exCode);
                    try {
                        if (Resources.getServerLink((String)clientCode, (boolean)false, (boolean)false).writeData((Object)req)) {
                            this.logger.info((Object)"sending TradeSummaryRequest.summary request");
                            this.btnFetch.setEnabled(false);
                            this.refreshAction.setEnabled(false);
                        }
                    }
                    catch (Exception e) {
                        CorePlugin.logException((Exception)e);
                    }
                }
                catch (Exception e) {
                    MessageDialog.openError(null, (String)"Invalid Parameters", (String)("Error occurs while sending request : " + e.getMessage()));
                }
            }
        }
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof TradeSummaryResponse) {
                        TradeSummaryResponse rsp = (TradeSummaryResponse)o;
                        ClientTradesSummaryView.this.recieveReportResponse(rsp);
                        ClientTradesSummaryView.this.btnFetch.setEnabled(true);
                        ClientTradesSummaryView.this.refreshAction.setEnabled(true);
                        ClientTradesSummaryView.this.logger.debug((Object)"TradeSummaryResponse.summary recieved");
                    }
                    if (o instanceof LoginConfirmation) {
                        ClientTradesSummaryView.this.txtClientCode.setText(Resources.clientId);
                        ClientTradesSummaryView.this.txtClientCode.setEnabled(!Resources.isClientType());
                        ClientTradesSummaryView.this.lblSubCode.setVisible(Resources.isMemberTerminal());
                        ClientTradesSummaryView.this.txtSubCode.setVisible(Resources.isMemberTerminal());
                        if (Resources.exchangeNames != null) {
                            ClientTradesSummaryView.this.cmbExchange.removeAll();
                            ClientTradesSummaryView.this.cmbExchange.add("All");
                            int i = 0;
                            while (i < Resources.exchangeNames.size()) {
                                ClientTradesSummaryView.this.cmbExchange.add((String)Resources.exchangeNames.get(i));
                                ++i;
                            }
                            ClientTradesSummaryView.this.cmbExchange.select(0);
                        }
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void recieveReportResponse(final TradeSummaryResponse resp) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientTradesSummaryView.this.table.removeAll();
                        ClientTradesSummaryView.this.logger.debug((Object)("Trades vector size in TradeSummary view = " + resp.getTradesVector().size()));
                        int i = 0;
                        while (i < resp.getTradesVector().size()) {
                            Vector tempVector = (Vector)resp.getTradesVector().get(i);
                            TableItem item = new TableItem(ClientTradesSummaryView.this.table, 0);
                            int j = 0;
                            while (j < ClientTradesSummaryView.this.table.getColumnCount()) {
                                String temp = "";
                                if (tempVector.get(j) != null) {
                                    temp = "" + tempVector.get(j);
                                }
                                if (j == 2 && temp.equals("BUY")) {
                                    item.setBackground(WidgetFactory.color_registry.get("COLOR_GREEN_LIGHT"));
                                }
                                if (j == 2 && temp.equals("SELL")) {
                                    item.setBackground(WidgetFactory.color_registry.get("COLOR_RED_LIGHT"));
                                }
                                item.setText(j, temp);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (Exception exception) {
                        ClientTradesSummaryView.this.logger.debug((Object)"Exception in adding rows in Account Summary");
                    }
                }
            });
        }
    }

    private void clearFields() {
        this.table.removeAll();
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        Resources.supportServerMessage.deleteObserver((Observer)this);
        super.dispose();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (arg0 instanceof ClientCode && this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ClientTradesSummaryView.this.txtClientCode.setText(Resources.clientId);
                    ClientTradesSummaryView.this.sendReportRequest();
                }
            });
        }
    }
}

