/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ClearingTypeResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.PortfolioData;
import pk.com.softech.messages.PortfolioRequest;
import pk.com.softech.messages.PortfolioResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.ui.LabelProvidersRegistry;
import pk.com.softech.tradingterminal.core.ui.actions.EditColumnsAction;
import pk.com.softech.tradingterminal.core.ui.dialogs.ColumnsOptionDialog;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class ClientPortfolioView
extends ViewPart
implements IPropertyChangeListener,
ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.clientPortfolio";
    public static final String PREFS_CLIENTPORTFOLIO_COLUMNS = "CLIENT_PORTFOLIO_VIEW_COLUMNS";
    public static final String PREFS_CLIENTPORTFOLIO_COLUMNS_SIZE = "CLIENT_PORTFOLIO_VIEW_COLUMNS_SIZE";
    Composite parent;
    Text txtClientCode;
    Button btnFetch;
    Combo cmbClearingType;
    LabelProvidersRegistry registry = new LabelProvidersRegistry("pk.com.softech.tradingterminal.trading.clientPortfolio");
    private IAction editColumnsAction;
    IPreferenceStore preferences;
    private Action refreshAction;
    Table table;
    List<PortfolioData> list = new ArrayList<PortfolioData>();
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            int i = 0;
            while (i < ClientPortfolioView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientPortfolioView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            ClientPortfolioView.this.preferences.setValue(ClientPortfolioView.PREFS_CLIENTPORTFOLIO_COLUMNS_SIZE, sizes.toString());
        }
    };

    public ClientPortfolioView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().addCollectionObserver((ICollectionObserver)this);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.preferences = TradingPlugin.getDefault().getPreferenceStore();
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(5, false));
        Label lblClientCode = new Label(composite, 0);
        lblClientCode.setText("Client Code: ");
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    ClientPortfolioView.this.sendReportRequest();
                }
            }
        });
        Label lblClearingType = new Label(composite, 0);
        lblClearingType.setText("Clearing Type: ");
        this.cmbClearingType = new Combo(composite, 2056);
        GridDataFactory.fillDefaults().hint(120, 20).applyTo((Control)this.cmbClearingType);
        this.cmbClearingType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClientPortfolioView.this.sendReportRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (Resources.clearingTypes != null) {
            this.cmbClearingType.removeAll();
            int i = 0;
            while (i < Resources.clearingTypes.size()) {
                this.cmbClearingType.add((String)Resources.clearingTypes.get(i));
                ++i;
            }
            this.cmbClearingType.select(0);
        }
        this.btnFetch = new Button(composite, 8);
        this.btnFetch.setText("Fetch");
        this.btnFetch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ClientPortfolioView.this.sendReportRequest();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table = new Table(parent, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.preferences.addPropertyChangeListener((IPropertyChangeListener)this);
        this.makeViewActions();
        this.contributeToActionBars();
        this.updateTable();
    }

    private void sendReportRequest() {
        String clearingType = (String)Resources.clearingTypeCodes.get(this.cmbClearingType.getSelectionIndex());
        PortfolioRequest pr = new PortfolioRequest(this.txtClientCode.getText(), clearingType, true);
        String clientCode = this.txtClientCode.getText().trim();
        if (Resources.isServerConnected((String)clientCode, (boolean)true, (boolean)true) && this.btnFetch.isEnabled()) {
            Resources.getServerLink((String)clientCode, (boolean)true, (boolean)true).writeData((Object)pr);
            this.btnFetch.setEnabled(false);
            this.refreshAction.setEnabled(false);
        }
    }

    public void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(PREFS_CLIENTPORTFOLIO_COLUMNS) && this.parent != null && !this.parent.isDisposed()) {
            this.updateTable();
        }
    }

    public void updateTable() {
        if (this.table != null && !this.table.isDisposed()) {
            int index = 0;
            String[] id = this.preferences.getString(PREFS_CLIENTPORTFOLIO_COLUMNS).split(";");
            int i = 0;
            while (i < id.length) {
                TableColumn tableColumn;
                String name = "";
                int style = 16384;
                Image image = null;
                ILabelProvider provider = this.registry.createLabelProvider(id[i]);
                if (provider != null) {
                    name = this.registry.getName(id[i]);
                    style = this.registry.getOrientation(id[i]);
                    if (provider instanceof ITableLabelProvider) {
                        name = ((ITableLabelProvider)provider).getColumnText(null, i);
                        image = ((ITableLabelProvider)provider).getColumnImage(null, i);
                    }
                }
                if (index < this.table.getColumnCount()) {
                    tableColumn = this.table.getColumn(index);
                    if (tableColumn.getData("labelProvider") != null) {
                        ((ILabelProvider)tableColumn.getData("labelProvider")).dispose();
                    }
                } else {
                    tableColumn = new TableColumn(this.table, style);
                    tableColumn.addControlListener(this.columnControlListener);
                    tableColumn.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (e.widget.getData("labelProvider") != null) {
                                ((ILabelProvider)e.widget.getData("labelProvider")).dispose();
                            }
                        }
                    });
                }
                tableColumn.setText(name);
                tableColumn.setAlignment(style);
                tableColumn.setImage(image);
                tableColumn.setMoveable(false);
                tableColumn.setData("labelProvider", (Object)provider);
                tableColumn.setData("columnId", (Object)id[i]);
                ++index;
                ++i;
            }
            while (index < this.table.getColumnCount()) {
                this.table.getColumn(index).dispose();
            }
            this.table.removeAll();
            try {
                for (PortfolioData data : this.list) {
                    TableItem tableItem = new TableItem(this.table, 0);
                    this.update(tableItem, data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String[] sizes = this.preferences.getString(PREFS_CLIENTPORTFOLIO_COLUMNS_SIZE).split(";");
            int i2 = 0;
            while (i2 < this.table.getColumnCount()) {
                if (i2 < sizes.length && sizes[i2].length() != 0) {
                    this.table.getColumn(i2).setWidth(Integer.parseInt(sizes[i2]));
                } else {
                    this.table.getColumn(i2).setWidth(100);
                }
                ++i2;
            }
            if ("gtk".equals(SWT.getPlatform())) {
                this.table.getColumn(this.table.getColumnCount() - 1).pack();
            }
        }
    }

    void update(TableItem tableItem, PortfolioData data) {
        int i = 0;
        while (i < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(i);
            ILabelProvider provider = (ILabelProvider)tableColumn.getData("labelProvider");
            if (provider != null && provider.getText((Object)provider) != null) {
                tableItem.setText(i, provider.getText((Object)data));
            }
            ++i;
        }
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                ClientPortfolioView.this.sendReportRequest();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
        this.editColumnsAction = new EditColumnsAction((Dialog)new ColumnsOptionDialog((IViewPart)this, PREFS_CLIENTPORTFOLIO_COLUMNS, PREFS_CLIENTPORTFOLIO_COLUMNS_SIZE, this.preferences));
    }

    private void contributeToActionBars() {
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)this.refreshAction);
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add(this.editColumnsAction);
        Action resizeColumns = new Action(){

            public void run() {
                if (ClientPortfolioView.this.table != null) {
                    TableColumn[] column = ClientPortfolioView.this.table.getColumns();
                    int i = 0;
                    while (i < column.length) {
                        if (column[i].getResizable()) {
                            column[i].pack();
                        }
                        ++i;
                    }
                }
            }
        };
        manager.add((IAction)resizeColumns);
        resizeColumns.setId("resizeColumns");
        resizeColumns.setText("Resize columns");
        resizeColumns.setToolTipText("Edit Columns");
        resizeColumns.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_SYNCED"));
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof LoginConfirmation) {
                        ClientPortfolioView.this.txtClientCode.setText(Resources.clientId);
                        ClientPortfolioView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                    if (o instanceof ClearingTypeResponse && Resources.clearingTypes != null) {
                        ClientPortfolioView.this.cmbClearingType.removeAll();
                        int i = 0;
                        while (i < Resources.clearingTypes.size()) {
                            ClientPortfolioView.this.cmbClearingType.add((String)Resources.clearingTypes.get(i));
                            ++i;
                        }
                        ClientPortfolioView.this.cmbClearingType.select(0);
                    }
                    if (o instanceof PortfolioResponse) {
                        ClientPortfolioView.this.list.clear();
                        ClientPortfolioView.this.btnFetch.setEnabled(true);
                        ClientPortfolioView.this.refreshAction.setEnabled(true);
                        PortfolioResponse resp = (PortfolioResponse)o;
                        if (resp != null) {
                            PortfolioData[] data;
                            if (resp.getResponseMessage() != null && resp.getResponseMessage().length() > 0) {
                                MessageDialog.openError(null, (String)"Invalid Request", (String)resp.getResponseMessage());
                            }
                            if ((data = resp.getrows()) != null) {
                                ClientPortfolioView.this.list.addAll(Arrays.asList(data));
                            }
                            if (ClientPortfolioView.this.table != null && !ClientPortfolioView.this.table.isDisposed()) {
                                ClientPortfolioView.this.table.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ClientPortfolioView.this.updateTable();
                                    }
                                });
                            }
                        }
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    public void dispose() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allOrderFormList().removeCollectionObserver((ICollectionObserver)this);
        this.preferences.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }
}

