/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.MarginData;
import pk.com.softech.messages.MarginRequest;
import pk.com.softech.messages.MarginResponse;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class ClientMarginView
extends ViewPart
implements IPropertyChangeListener,
ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.clientMarginView";
    private static final String[] COLUMN_NAMES_SYMBOL = new String[]{"Symbol", " Day Trade", " Custody", "Pending Orders", "CFS", "Future", "Provisional", "Available Bal.", "Blocked Bal.", "Market Rate", "Value"};
    private static final String[] COLUMN_NAMES_SYMBOL_BMA = new String[]{"Symbol", " Day Trade", " Custody", "Pending Orders", "CFS", "Future", "Provisional", "Available Bal.", "Blocked Bal.", "Bank Pledge", "Market Rate", "Value"};
    private static final int[] COLUMN_ORIENTATION = new int[]{16384, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072};
    private static final int[] COLUMN_ORIENTATION_BMA = new int[]{16384, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072};
    public static final String PREFS_CLIENT_MARGIN_COLUMNS_SIZE_SYM = "CLIENT_MARGIN_COLUMNS_SIZE_SYM";
    static final int VIEW_WIDTH = 995;
    static final int VIEW_HIEGHT = 100;
    private Text txtClientCode;
    private Text txtCashblnc;
    private Text txtMtm;
    private Text txtCustody;
    private Text txtBlocked;
    private Text txtUnblk;
    private Text txtAvalbl;
    private Text txtAvalbl2;
    private Text txtExpAllo;
    private Text txtCfs;
    private Text txtFuture;
    private Text txtProv;
    private Text txtPending;
    private Text txtTotal;
    private Text txtfutureBlockProfit;
    private Button btnRefresh;
    private Button btnPrint;
    private static final int LABEL_WIDTH = 115;
    private static final int LABEL_HEIGHT = 15;
    private static final int TEXT_WIDTH = 90;
    private static final int TEXT_HEIGHT = 15;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 22;
    private Table table;
    TableItem item_symbol;
    MarginRequest rt = null;
    ScrolledComposite sc;
    Composite content;
    Composite parent;
    Composite cmpositeUpper;
    Text txtClientName;
    Text txtTraderName;
    Text txtTraderCode;
    String[] cashListData;
    Label dateLabel = null;
    MarginData[] marginData;
    long sumOfValue;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    NumberFormat pf = CorePlugin.getPriceFormatter();
    NumberFormat nf = CorePlugin.getNumberFormatter();
    Action refreshAction;
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            sizes = new StringBuffer();
            int i = 0;
            while (i < ClientMarginView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientMarginView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            TradingPlugin.getDefault().getPreferenceStore().setValue(ClientMarginView.PREFS_CLIENT_MARGIN_COLUMNS_SIZE_SYM, sizes.toString());
        }
    };
    private Font font_bold;
    private FontMetrics fontMetrics;

    public ClientMarginView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allReportList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.sc = new ScrolledComposite(parent, 2816);
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)this.sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createLabel(composite, "Client Code:", this.font_bold);
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    ClientMarginView.this.sendReportRequest();
                }
            }
        });
        this.btnRefresh = new Button(composite, 8);
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientMarginView.this.sendReportRequest();
            }
        });
        this.btnPrint = new Button(composite, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Utility.print((Composite)ClientMarginView.this.content, (String)ClientMarginView.this.getPartName(), (Table)ClientMarginView.this.table, (int)1015);
            }
        });
        Label lbl1 = this.createLabel(composite, "");
        lbl1.setLayoutData((Object)new GridData(80, 15));
        Label lbl2 = this.createLabel(composite, "");
        lbl2.setLayoutData((Object)new GridData(80, 15));
        new GridData(110, 15);
        new GridData(155, 15);
        Group dateGroup = new Group(this.content, 16);
        dateGroup.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(6).equalWidth(true).applyTo((Composite)dateGroup);
        GridDataFactory.fillDefaults().align(1, 4).minSize(995, -1).grab(true, false).applyTo((Control)dateGroup);
        this.createLabel((Composite)dateGroup, "Client Name:", this.font_bold);
        this.txtClientName = new Text((Composite)dateGroup, 2048);
        this.txtClientName.setEditable(false);
        this.txtClientName.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        this.createLabel((Composite)dateGroup, "Trader Code: ", this.font_bold);
        this.txtTraderCode = new Text((Composite)dateGroup, 2048);
        this.txtTraderCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)15), -1));
        Color clr = new Color((Device)parent.getDisplay(), 0, 0, 0);
        this.txtTraderCode.setForeground(clr);
        this.txtTraderCode.setEnabled(true);
        this.txtTraderCode.setEditable(false);
        this.dateLabel = this.createLabel((Composite)dateGroup, "", this.font_bold);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.dateLabel);
        this.cmpositeUpper = new Composite(this.content, 0);
        this.cmpositeUpper.setLayout((Layout)new GridLayout(4, true));
        GridDataFactory.fillDefaults().align(1, 4).minSize(995, -1).grab(true, false).applyTo((Control)this.cmpositeUpper);
        Group gpSummary = new Group(this.cmpositeUpper, 1);
        GridLayout layout = new GridLayout(6, false);
        layout.horizontalSpacing = 10;
        gpSummary.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(1, 4).span(3, 1).grab(true, false).applyTo((Control)gpSummary);
        gpSummary.setText("Account Summary");
        gpSummary.setFont(this.font_bold);
        this.createLabel((Composite)gpSummary, "Cash Bal");
        this.txtCashblnc = this.createText((Composite)gpSummary);
        this.txtCashblnc.setForeground(clr);
        this.txtCashblnc.setEnabled(true);
        this.txtCashblnc.setEditable(false);
        this.createLabel((Composite)gpSummary, "Mark-To-Mark");
        this.txtMtm = this.createText((Composite)gpSummary);
        this.txtMtm.setForeground(clr);
        this.txtMtm.setEnabled(true);
        this.txtMtm.setEditable(false);
        this.createLabel((Composite)gpSummary, "Custody Reduced Value");
        this.txtCustody = this.createText((Composite)gpSummary);
        this.txtCustody.setForeground(clr);
        this.txtCustody.setEnabled(true);
        this.txtCustody.setEditable(false);
        this.createLabel((Composite)gpSummary, "Blocked");
        this.txtBlocked = this.createText((Composite)gpSummary);
        this.txtBlocked.setForeground(clr);
        this.txtBlocked.setEnabled(true);
        this.txtBlocked.setEditable(false);
        this.createLabel((Composite)gpSummary, "Un.Blocked");
        this.txtUnblk = this.createText((Composite)gpSummary);
        this.txtUnblk.setForeground(clr);
        this.txtUnblk.setEnabled(true);
        this.txtUnblk.setEditable(false);
        this.createLabel((Composite)gpSummary, "Avail.Margin");
        this.txtAvalbl = this.createText((Composite)gpSummary);
        this.txtAvalbl.setForeground(clr);
        this.txtAvalbl.setEnabled(true);
        this.txtAvalbl.setEditable(false);
        Group gpExposure = new Group(this.cmpositeUpper, 1);
        gpExposure.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().align(1, 4).span(1, 1).grab(true, false).applyTo((Control)gpExposure);
        gpExposure.setText("Exposure");
        gpExposure.setFont(this.font_bold);
        this.createLabel((Composite)gpExposure, "Allowed");
        this.txtExpAllo = this.createText((Composite)gpExposure);
        this.txtExpAllo.setForeground(clr);
        this.txtExpAllo.setEnabled(true);
        this.txtExpAllo.setEditable(false);
        this.createLabel((Composite)gpExposure, "Available %");
        this.txtAvalbl2 = this.createText((Composite)gpExposure);
        this.txtAvalbl2.setForeground(clr);
        this.txtAvalbl2.setEnabled(true);
        this.txtAvalbl2.setEditable(false);
        Group grp3 = new Group(this.cmpositeUpper, 1);
        GridLayout layout1 = new GridLayout(6, false);
        layout.horizontalSpacing = 10;
        grp3.setLayout((Layout)layout1);
        GridDataFactory.fillDefaults().align(1, 4).span(3, 1).grab(true, false).applyTo((Control)grp3);
        grp3.setText("");
        this.createLabel((Composite)grp3, "CFS");
        this.txtCfs = this.createText((Composite)grp3);
        this.txtCfs.setForeground(clr);
        this.txtCfs.setEnabled(true);
        this.txtCfs.setEditable(false);
        this.createLabel((Composite)grp3, "Future");
        this.txtFuture = this.createText((Composite)grp3);
        this.txtFuture.setForeground(clr);
        this.txtFuture.setEnabled(true);
        this.txtFuture.setEditable(false);
        this.createLabel((Composite)grp3, "Future Block");
        this.txtfutureBlockProfit = this.createText((Composite)grp3);
        this.txtfutureBlockProfit.setForeground(clr);
        this.txtfutureBlockProfit.setEnabled(true);
        this.txtfutureBlockProfit.setEditable(false);
        this.createLabel((Composite)grp3, "Provisional");
        this.txtProv = this.createText((Composite)grp3);
        this.txtProv.setForeground(clr);
        this.txtProv.setEnabled(true);
        this.txtProv.setEditable(false);
        this.createLabel((Composite)grp3, "Pending Orders");
        this.txtPending = this.createText((Composite)grp3);
        this.txtPending.setForeground(clr);
        this.txtPending.setEnabled(true);
        this.txtPending.setEditable(false);
        this.createLabel((Composite)grp3, "Total");
        this.txtTotal = this.createText((Composite)grp3);
        this.txtTotal.setForeground(clr);
        this.txtTotal.setEnabled(true);
        this.txtTotal.setEditable(false);
        Group grpPortfolioDetail = new Group(this.content, 0);
        grpPortfolioDetail.setText("Portfolio Details");
        grpPortfolioDetail.setFont(this.font_bold);
        grpPortfolioDetail.setLayoutData((Object)new GridData(4, 4, true, true));
        grpPortfolioDetail.setLayout((Layout)new GridLayout(1, false));
        this.table = new Table((Composite)grpPortfolioDetail, 65538);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        if (Resources.systemClient == 9) {
            int i = 0;
            while (i < COLUMN_NAMES_SYMBOL_BMA.length) {
                TableColumn col = this.createTableColumn(this.table, COLUMN_ORIENTATION_BMA[i], COLUMN_NAMES_SYMBOL_BMA[i], 90);
                col.addControlListener(this.columnControlListener);
                ++i;
            }
        } else {
            int i = 0;
            while (i < COLUMN_NAMES_SYMBOL.length) {
                TableColumn col = this.createTableColumn(this.table, COLUMN_ORIENTATION[i], COLUMN_NAMES_SYMBOL[i], 90);
                col.addControlListener(this.columnControlListener);
                ++i;
            }
        }
        this.setColumnsSizes(this.table, PREFS_CLIENT_MARGIN_COLUMNS_SIZE_SYM);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getVerticalBar().setEnabled(true);
        this.sc.setContent((Control)this.content);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(this.content.computeSize(-1, -1));
        this.makeViewActions();
        this.contributeToActionBars();
    }

    private void setColumnsSizes(Table table, String pref) {
        String[] sizes = TradingPlugin.getDefault().getPreferenceStore().getString(pref).split(";");
        int i = 0;
        while (i < table.getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                table.getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                table.getColumn(i).setWidth(90);
            }
            ++i;
        }
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                ClientMarginView.this.sendReportRequest();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
    }

    private void contributeToActionBars() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator("top"));
        manager.add((IAction)new ResizeColumnsAction(this.table));
        manager.add((IContributionItem)new Separator("group0"));
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IContributionItem)new Separator("group3"));
        manager.add((IContributionItem)new Separator("group4"));
        manager.add((IContributionItem)new Separator("group5"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
    }

    protected TableColumn createTableColumn(Table table, int style, String title, int size) {
        TableColumn column = new TableColumn(table, style);
        column.setText(title);
        column.setResizable(true);
        column.setWidth(size);
        return column;
    }

    public void sendReportRequest() {
        if (Resources.isServerConnected((String)this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
            this.rt = new MarginRequest(1, this.txtClientCode.getText(), 1);
            try {
                if (this.btnRefresh.isEnabled()) {
                    if (Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false) != null) {
                        if (Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)this.rt)) {
                            this.btnRefresh.setEnabled(false);
                            this.refreshAction.setEnabled(false);
                            this.logger.info((Object)"Sending Client Report Request");
                        } else {
                            this.logger.info((Object)"Unable to send Client Report Request");
                        }
                    } else {
                        this.logger.info((Object)"TradeLink is null");
                    }
                }
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    public void recieveMarginResponse(MarginResponse mrp) {
        if (mrp != null) {
            if (mrp.getClientName() != null) {
                this.txtClientName.setText(mrp.getClientName());
            } else {
                this.txtClientName.setText("");
            }
            if (mrp.getTraderCode() != null) {
                this.txtTraderCode.setText(String.valueOf(mrp.getTraderName()) + "(" + mrp.getTraderCode() + ")");
            } else {
                this.txtTraderCode.setText("");
            }
            this.txtCashblnc.setText(this.pf.format(mrp.getCashBalance()));
            this.txtMtm.setText(this.pf.format(mrp.getMarkTomark()));
            this.txtCustody.setText(this.pf.format(mrp.getCustody()));
            this.txtBlocked.setText(this.pf.format(mrp.getCashBlocked()));
            this.txtUnblk.setText(this.pf.format(mrp.getCashUnblocked()));
            this.txtAvalbl.setText(this.pf.format(mrp.getAvailableMargin()));
            this.txtCfs.setText(this.pf.format(mrp.getCOT()));
            this.txtFuture.setText(this.pf.format(mrp.getFuture()));
            this.txtfutureBlockProfit.setText(this.pf.format(mrp.getFutureBlockProfit()));
            this.txtProv.setText(this.pf.format(mrp.getProvisional()));
            this.txtPending.setText(this.pf.format(mrp.getPendingOrders()));
            this.txtTotal.setText(this.pf.format(mrp.getTotalOpen()));
            this.txtExpAllo.setText(this.pf.format(mrp.getExposureAllowed()));
            this.txtAvalbl2.setText(String.valueOf(mrp.getMarginPercentage()));
            this.marginData = mrp.getrows();
            this.table.removeAll();
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    double sumOfValue = 0.0;
                    if (ClientMarginView.this.marginData != null) {
                        int i = 0;
                        while (i < ClientMarginView.this.marginData.length) {
                            ClientMarginView.this.item_symbol = new TableItem(ClientMarginView.this.table, 131072);
                            ClientMarginView.this.item_symbol.setBackground(ClientMarginView.this.content.getDisplay().getSystemColor(1));
                            if (ClientMarginView.this.marginData[i] != null) {
                                ClientMarginView.this.item_symbol.setText(0, String.valueOf(ClientMarginView.this.marginData[i].getSymbol()));
                                ClientMarginView.this.item_symbol.setText(1, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getTodayReceivedDelivery()));
                                ClientMarginView.this.item_symbol.setText(2, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getBilledBalance()));
                                ClientMarginView.this.item_symbol.setText(3, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getPendingOrdersBalance()));
                                ClientMarginView.this.item_symbol.setText(4, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getUnbilledBalance()));
                                ClientMarginView.this.item_symbol.setText(5, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getFutureBalance()));
                                ClientMarginView.this.item_symbol.setText(6, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getProvisionalBalance()));
                                ClientMarginView.this.item_symbol.setText(7, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getAvailableBalance()));
                                ClientMarginView.this.item_symbol.setText(8, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getBlockedBalance()));
                                if (Resources.systemClient == 9) {
                                    ClientMarginView.this.item_symbol.setText(9, ClientMarginView.this.nf.format(ClientMarginView.this.marginData[i].getBankPledgeShares()));
                                    ClientMarginView.this.item_symbol.setText(10, ClientMarginView.this.pf.format(ClientMarginView.this.marginData[i].getCloseRate()));
                                    ClientMarginView.this.item_symbol.setText(11, ClientMarginView.this.pf.format(ClientMarginView.this.marginData[i].getValue()));
                                } else {
                                    ClientMarginView.this.item_symbol.setText(9, ClientMarginView.this.pf.format(ClientMarginView.this.marginData[i].getCloseRate()));
                                    ClientMarginView.this.item_symbol.setText(10, ClientMarginView.this.pf.format(ClientMarginView.this.marginData[i].getValue()));
                                }
                                sumOfValue += (double)ClientMarginView.this.marginData[i].getValue();
                            }
                            ++i;
                        }
                        ClientMarginView.this.item_symbol = new TableItem(ClientMarginView.this.table, 131072);
                        ClientMarginView.this.item_symbol.setBackground(ClientMarginView.this.content.getDisplay().getSystemColor(1));
                        ClientMarginView.this.item_symbol.setText(0, "");
                        ClientMarginView.this.item_symbol.setText(1, "");
                        ClientMarginView.this.item_symbol.setText(2, "");
                        ClientMarginView.this.item_symbol.setText(3, "");
                        ClientMarginView.this.item_symbol.setText(4, "");
                        ClientMarginView.this.item_symbol.setText(5, "");
                        ClientMarginView.this.item_symbol.setText(6, "");
                        ClientMarginView.this.item_symbol.setText(7, "");
                        ClientMarginView.this.item_symbol.setText(8, "");
                        if (Resources.systemClient == 9) {
                            ClientMarginView.this.item_symbol.setText(9, "");
                            ClientMarginView.this.item_symbol.setText(10, "Total Value");
                            ClientMarginView.this.item_symbol.setText(11, ClientMarginView.this.pf.format(sumOfValue));
                        } else {
                            ClientMarginView.this.item_symbol.setText(9, "Total Value");
                            ClientMarginView.this.item_symbol.setText(10, ClientMarginView.this.pf.format(sumOfValue));
                        }
                        ClientMarginView.this.sc.setMinSize(ClientMarginView.this.content.computeSize((int)-1, (int)-1).x, ClientMarginView.this.table.getItemHeight() * ClientMarginView.this.marginData.length + 250);
                    }
                }
            });
        }
        this.dateLabel.setText(this.getServerDateTime());
    }

    private void refreshHeader() {
        while (this.table.getColumnCount() > 0) {
            this.table.getColumn(0).dispose();
        }
        this.table.clearAll();
        if (Resources.systemClient == 9) {
            int i = 0;
            while (i < COLUMN_NAMES_SYMBOL_BMA.length) {
                TableColumn col = this.createTableColumn(this.table, COLUMN_ORIENTATION_BMA[i], COLUMN_NAMES_SYMBOL_BMA[i], 90);
                col.addControlListener(this.columnControlListener);
                ++i;
            }
        } else {
            int i = 0;
            while (i < COLUMN_NAMES_SYMBOL.length) {
                TableColumn col = this.createTableColumn(this.table, COLUMN_ORIENTATION[i], COLUMN_NAMES_SYMBOL[i], 90);
                col.addControlListener(this.columnControlListener);
                ++i;
            }
        }
        this.setColumnsSizes(this.table, PREFS_CLIENT_MARGIN_COLUMNS_SIZE_SYM);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getVerticalBar().setEnabled(true);
        this.sc.setContent((Control)this.content);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(this.content.computeSize(-1, -1));
        this.makeViewActions();
        this.contributeToActionBars();
    }

    private void clearFields() {
        this.table.clearAll();
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof MarginResponse) {
                        MarginResponse mrp = (MarginResponse)o;
                        ClientMarginView.this.recieveMarginResponse(mrp);
                        ClientMarginView.this.btnRefresh.setEnabled(true);
                        ClientMarginView.this.refreshAction.setEnabled(true);
                    }
                    if (o instanceof LoginConfirmation && Resources.trnCode.contains("OA02")) {
                        ClientMarginView.this.txtClientCode.setText(Resources.clientId);
                        ClientMarginView.this.refreshHeader();
                        ClientMarginView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Label createLabel(Composite parent, String label, Font font) {
        Label temp = new Label(parent, 0);
        temp.setFont(font);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent) {
        Text temp = new Text(parent, 133120);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(false);
        return temp;
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().allReportList().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public String getServerDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy");
        try {
            String d = format.format(Resources.systemDate);
            return "Date : " + d + "  :  " + Resources.getServerTime();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

