/*
 * Decompiled with CFR 0.152.
 */
package pk.com.softech.tradingterminal.trading.views;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import pk.com.softech.messages.ExposureRequest;
import pk.com.softech.messages.ExposureResponse;
import pk.com.softech.messages.LoginConfirmation;
import pk.com.softech.messages.MarginData;
import pk.com.softech.tradingterminal.core.CorePlugin;
import pk.com.softech.tradingterminal.core.ICollectionObserver;
import pk.com.softech.tradingterminal.core.Resources;
import pk.com.softech.tradingterminal.core.Utility;
import pk.com.softech.tradingterminal.core.ui.WidgetFactory;
import pk.com.softech.tradingterminal.core.ui.actions.ResizeColumnsAction;
import pk.com.softech.tradingterminal.core.util.CapitalTextListener;
import pk.com.softech.tradingterminal.trading.TradingPlugin;

public class ClientExposureView
extends ViewPart
implements IPropertyChangeListener,
ICollectionObserver {
    public static final String VIEW_ID = "pk.com.softech.tradingterminal.trading.clientExposureView";
    private static final String[] COLUMN_NAMES_SYMBOL = new String[]{"Symbol", " Day Trade", " Custody", "Pending Orders", "CFS", "Future", "Provisional", "Available Bal.", "Blocked Bal.", "Market Rate", "Value"};
    private static final int[] COLUMN_ORIENTATION = new int[]{16384, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072, 131072};
    public static final String PREFS_CLIENT_MARGIN_COLUMNS_SIZE_SYM = "CLIENT_MARGIN_COLUMNS_SIZE_SYM";
    static final int VIEW_WIDTH = 995;
    static final int VIEW_HIEGHT = 100;
    private Text txtClientCode;
    private Text txtExposureAllowed;
    private Text txtExposureUtilized;
    private Text txtAvailable;
    private Button btnRefresh;
    private Button btnPrint;
    private static final int LABEL_WIDTH = 115;
    private static final int LABEL_HEIGHT = 15;
    private static final int TEXT_WIDTH = 120;
    private static final int TEXT_HEIGHT = 15;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_HEIGHT = 22;
    private Table table;
    TableItem item_symbol;
    ExposureRequest rt = null;
    ScrolledComposite sc;
    Composite content;
    Composite parent;
    Composite cmpositeUpper;
    MarginData[] marginData;
    long sumOfValue;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    NumberFormat pf = CorePlugin.getPriceFormatter();
    NumberFormat nf = CorePlugin.getNumberFormatter();
    Action refreshAction;
    private ControlListener columnControlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            StringBuffer sizes = new StringBuffer();
            sizes = new StringBuffer();
            int i = 0;
            while (i < ClientExposureView.this.table.getColumnCount()) {
                sizes.append(String.valueOf(String.valueOf(ClientExposureView.this.table.getColumn(i).getWidth())) + ";");
                ++i;
            }
            TradingPlugin.getDefault().getPreferenceStore().setValue(ClientExposureView.PREFS_CLIENT_MARGIN_COLUMNS_SIZE_SYM, sizes.toString());
        }
    };
    private Font font_bold;
    private FontMetrics fontMetrics;

    public ClientExposureView() {
        CorePlugin.getRepository().miscMessagesList().addCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().allReportList().addCollectionObserver((ICollectionObserver)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        this.font_bold = WidgetFactory.font_registry.get("FONT_9_BOLD");
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
        this.sc = new ScrolledComposite(parent, 2816);
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.content = new Composite((Composite)this.sc, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite(this.content, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createLabel(composite, "Client Code:", this.font_bold);
        this.txtClientCode = new Text(composite, 2048);
        this.txtClientCode.setText(Resources.clientId);
        this.txtClientCode.setEnabled(!Resources.isClientType());
        this.txtClientCode.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        this.txtClientCode.addVerifyListener((VerifyListener)new CapitalTextListener());
        this.txtClientCode.addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\r') {
                    ClientExposureView.this.sendReportRequest();
                }
            }
        });
        this.btnRefresh = new Button(composite, 8);
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClientExposureView.this.sendReportRequest();
            }
        });
        this.btnPrint = new Button(composite, 8);
        this.btnPrint.setText("Print");
        this.btnPrint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Utility.print((Composite)ClientExposureView.this.content, (String)ClientExposureView.this.getPartName(), (Table)ClientExposureView.this.table, (int)1015);
            }
        });
        Label lbl1 = this.createLabel(composite, "");
        lbl1.setLayoutData((Object)new GridData(80, 15));
        Label lbl2 = this.createLabel(composite, "");
        lbl2.setLayoutData((Object)new GridData(80, 15));
        Color clr = new Color((Device)parent.getDisplay(), 0, 0, 0);
        this.cmpositeUpper = new Composite(this.content, 0);
        this.cmpositeUpper.setLayout((Layout)new GridLayout(4, true));
        GridDataFactory.fillDefaults().align(1, 4).minSize(995, -1).grab(true, false).applyTo((Control)this.cmpositeUpper);
        Group gpSummary = new Group(this.cmpositeUpper, 1);
        GridLayout layout = new GridLayout(8, false);
        layout.horizontalSpacing = 10;
        gpSummary.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(1, 4).span(3, 1).grab(true, false).applyTo((Control)gpSummary);
        gpSummary.setText("Account Summary");
        gpSummary.setFont(this.font_bold);
        this.createLabel((Composite)gpSummary, "Exposure Allowed").setFont(this.font_bold);
        this.txtExposureAllowed = this.createText((Composite)gpSummary);
        this.txtExposureAllowed.setForeground(clr);
        this.txtExposureAllowed.setEnabled(true);
        this.txtExposureAllowed.setEditable(false);
        this.createLabel((Composite)gpSummary, "Exposure Utilized").setFont(this.font_bold);
        this.txtExposureUtilized = this.createText((Composite)gpSummary);
        this.txtExposureUtilized.setForeground(clr);
        this.txtExposureUtilized.setEnabled(true);
        this.txtExposureUtilized.setEditable(false);
        this.createLabel((Composite)gpSummary, "Available").setFont(this.font_bold);
        this.txtAvailable = this.createText((Composite)gpSummary);
        this.txtAvailable.setForeground(clr);
        this.txtAvailable.setEnabled(true);
        this.txtAvailable.setEditable(false);
        Group grpPortfolioDetail = new Group(this.content, 0);
        grpPortfolioDetail.setText("Portfolio Details");
        grpPortfolioDetail.setFont(this.font_bold);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)grpPortfolioDetail);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)grpPortfolioDetail);
        this.table = new Table((Composite)grpPortfolioDetail, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        while (i < COLUMN_NAMES_SYMBOL.length) {
            TableColumn col = this.createTableColumn(this.table, COLUMN_ORIENTATION[i], COLUMN_NAMES_SYMBOL[i], 90);
            col.addControlListener(this.columnControlListener);
            ++i;
        }
        this.setColumnsSizes(this.table, PREFS_CLIENT_MARGIN_COLUMNS_SIZE_SYM);
        this.table.getHorizontalBar().setEnabled(true);
        this.table.getVerticalBar().setEnabled(true);
        this.sc.setContent((Control)this.content);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(this.content.computeSize(-1, -1));
        this.makeViewActions();
        this.contributeToActionBars();
    }

    private void setColumnsSizes(Table table, String pref) {
        String[] sizes = TradingPlugin.getDefault().getPreferenceStore().getString(pref).split(";");
        int i = 0;
        while (i < table.getColumnCount()) {
            if (i < sizes.length && sizes[i].length() != 0) {
                table.getColumn(i).setWidth(Integer.parseInt(sizes[i]));
            } else {
                table.getColumn(i).setWidth(90);
            }
            ++i;
        }
    }

    private void makeViewActions() {
        this.refreshAction = new Action(){

            public void run() {
                ClientExposureView.this.sendReportRequest();
            }
        };
        this.refreshAction.setText("Refresh");
        this.refreshAction.setToolTipText("Refresh");
        this.refreshAction.setImageDescriptor(TradingPlugin.getImageDescriptor("icons/etool16/refresh.gif"));
        this.refreshAction.setDisabledImageDescriptor(TradingPlugin.getImageDescriptor("icons/dtool16/refresh.gif"));
        this.refreshAction.setEnabled(true);
    }

    private void contributeToActionBars() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IContributionItem)new Separator("top"));
        manager.add((IAction)new ResizeColumnsAction(this.table));
        manager.add((IContributionItem)new Separator("group0"));
        manager.add((IContributionItem)new Separator("group1"));
        manager.add((IContributionItem)new Separator("group2"));
        manager.add((IContributionItem)new Separator("group3"));
        manager.add((IContributionItem)new Separator("group4"));
        manager.add((IContributionItem)new Separator("group5"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("bottom"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("top"));
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IContributionItem)new Separator("group0"));
        toolBarManager.add((IContributionItem)new Separator("group1"));
        toolBarManager.add((IContributionItem)new Separator("group2"));
        toolBarManager.add((IContributionItem)new Separator("group3"));
        toolBarManager.add((IContributionItem)new Separator("group4"));
        toolBarManager.add((IContributionItem)new Separator("group5"));
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IContributionItem)new Separator("bottom"));
    }

    protected TableColumn createTableColumn(Table table, int style, String title, int size) {
        TableColumn column = new TableColumn(table, style);
        column.setText(title);
        column.setResizable(true);
        column.setWidth(size);
        return column;
    }

    public void sendReportRequest() {
        if (Resources.isServerConnected((String)this.txtClientCode.getText(), (boolean)true, (boolean)false)) {
            this.rt = new ExposureRequest(this.txtClientCode.getText());
            try {
                if (this.btnRefresh.isEnabled()) {
                    if (Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false) != null) {
                        if (Resources.getServerLink((String)this.txtClientCode.getText(), (boolean)true, (boolean)false).writeData((Object)this.rt)) {
                            this.btnRefresh.setEnabled(false);
                            this.refreshAction.setEnabled(false);
                            this.logger.info((Object)"Sending Client Exposure Request");
                        } else {
                            this.logger.info((Object)"Unable to send Client Exposure Request");
                        }
                    } else {
                        this.logger.info((Object)"TradeLink is null");
                    }
                }
            }
            catch (Exception e) {
                CorePlugin.logException((Exception)e);
            }
        }
    }

    public void recieveMarginResponse(ExposureResponse mrp) {
        if (mrp != null) {
            this.txtExposureAllowed.setText(this.pf.format(mrp.getExposureAllowed()));
            this.txtExposureUtilized.setText(this.pf.format(mrp.getNetExposure()));
            this.txtAvailable.setText(this.pf.format(mrp.getExposureAllowed() - mrp.getNetExposure()));
            this.marginData = mrp.getrows();
            this.table.removeAll();
            this.table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    double sumOfValue = 0.0;
                    if (ClientExposureView.this.marginData != null) {
                        int i = 0;
                        while (i < ClientExposureView.this.marginData.length) {
                            ClientExposureView.this.item_symbol = new TableItem(ClientExposureView.this.table, 131072);
                            ClientExposureView.this.item_symbol.setBackground(ClientExposureView.this.content.getDisplay().getSystemColor(1));
                            if (ClientExposureView.this.marginData[i] != null) {
                                ClientExposureView.this.item_symbol.setText(0, String.valueOf(ClientExposureView.this.marginData[i].getSymbol()));
                                ClientExposureView.this.item_symbol.setText(1, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getTodayReceivedDelivery()));
                                ClientExposureView.this.item_symbol.setText(2, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getBilledBalance()));
                                ClientExposureView.this.item_symbol.setText(3, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getPendingOrdersBalance()));
                                ClientExposureView.this.item_symbol.setText(4, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getUnbilledBalance()));
                                ClientExposureView.this.item_symbol.setText(5, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getFutureBalance()));
                                ClientExposureView.this.item_symbol.setText(6, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getProvisionalBalance()));
                                ClientExposureView.this.item_symbol.setText(7, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getAvailableBalance()));
                                ClientExposureView.this.item_symbol.setText(8, ClientExposureView.this.nf.format(ClientExposureView.this.marginData[i].getBlockedBalance()));
                                ClientExposureView.this.item_symbol.setText(9, ClientExposureView.this.pf.format(ClientExposureView.this.marginData[i].getCloseRate()));
                                ClientExposureView.this.item_symbol.setText(10, ClientExposureView.this.pf.format(ClientExposureView.this.marginData[i].getValue()));
                                sumOfValue += (double)ClientExposureView.this.marginData[i].getValue();
                            }
                            ++i;
                        }
                        ClientExposureView.this.item_symbol = new TableItem(ClientExposureView.this.table, 131072);
                        ClientExposureView.this.item_symbol.setBackground(ClientExposureView.this.content.getDisplay().getSystemColor(1));
                        ClientExposureView.this.item_symbol.setText(0, "");
                        ClientExposureView.this.item_symbol.setText(1, "");
                        ClientExposureView.this.item_symbol.setText(2, "");
                        ClientExposureView.this.item_symbol.setText(3, "");
                        ClientExposureView.this.item_symbol.setText(4, "");
                        ClientExposureView.this.item_symbol.setText(5, "");
                        ClientExposureView.this.item_symbol.setText(6, "");
                        ClientExposureView.this.item_symbol.setText(7, "");
                        ClientExposureView.this.item_symbol.setText(8, "");
                        ClientExposureView.this.item_symbol.setText(9, "Total Value");
                        ClientExposureView.this.item_symbol.setText(10, ClientExposureView.this.pf.format(sumOfValue));
                        ClientExposureView.this.sc.setMinSize(ClientExposureView.this.content.computeSize((int)-1, (int)-1).x, ClientExposureView.this.table.getItemHeight() * ClientExposureView.this.marginData.length + 250);
                    }
                }
            });
        }
    }

    private void clearFields() {
        this.table.clearAll();
    }

    public void itemAdded(final Object o) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (o instanceof ExposureResponse) {
                        ExposureResponse mrp = (ExposureResponse)o;
                        ClientExposureView.this.recieveMarginResponse(mrp);
                        ClientExposureView.this.btnRefresh.setEnabled(true);
                        ClientExposureView.this.refreshAction.setEnabled(true);
                    }
                    if (o instanceof LoginConfirmation && Resources.trnCode.contains("OA02")) {
                        ClientExposureView.this.txtClientCode.setText(Resources.clientId);
                        ClientExposureView.this.txtClientCode.setEnabled(!Resources.isClientType());
                    }
                }
            });
        }
    }

    public void itemRemoved(Object o) {
    }

    private Label createLabel(Composite parent, String label) {
        Label temp = new Label(parent, 0);
        temp.setText(label);
        return temp;
    }

    private Label createLabel(Composite parent, String label, Font font) {
        Label temp = new Label(parent, 0);
        temp.setFont(font);
        temp.setText(label);
        return temp;
    }

    private Text createText(Composite parent) {
        Text temp = new Text(parent, 133120);
        temp.setLayoutData((Object)new GridData(Dialog.convertWidthInCharsToPixels((FontMetrics)this.fontMetrics, (int)10), -1));
        temp.setEnabled(false);
        return temp;
    }

    public void setFocus() {
    }

    public void dispose() {
        CorePlugin.getRepository().allReportList().removeCollectionObserver((ICollectionObserver)this);
        CorePlugin.getRepository().miscMessagesList().removeCollectionObserver((ICollectionObserver)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public String getServerDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("dd MMM yyyy");
        try {
            String d = format.format(Resources.systemDate);
            return "Date : " + d + "  :  " + Resources.getServerTime();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

